/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.services.internal.processmodel.impl;

import com.oracle.bpel.client.ServerException;
import java.util.LinkedList;
import java.util.Locale;
import oracle.bpel.services.bpm.common.IBPMContext;
import oracle.bpm.bpmn.engine.service.ejb.interfaces.IBPMNProcessManagerLocalBean;
import oracle.bpm.collections.Sequence;
import oracle.bpm.project.model.Project;
import oracle.bpm.project.model.processes.Process;
import oracle.bpm.project.model.util.ModelUtils;
import oracle.bpm.services.common.exception.BPMException;
import oracle.bpm.services.common.logger.BPMLogger;
import oracle.bpm.services.common.logger.LoggerComponent;
import oracle.bpm.services.common.logger.Severity;
import oracle.bpm.services.internal.processmodel.impl.IProcessModelServiceExt;
import oracle.bpm.services.internal.processmodel.model.IProcessModelPackage;
import oracle.bpm.services.internal.processmodel.model.impl.ProcessModelPackageImpl;
import oracle.bpm.services.internal.processmodel.model.impl.ProcessModelSerializer;
import oracle.soa.management.ComponentDN;

public class ProcessModelService
implements IProcessModelServiceExt {
    private IBPMNProcessManagerLocalBean bpmnProcessManager;

    public IBPMNProcessManagerLocalBean getBpmnProcessManager() {
        return this.bpmnProcessManager;
    }

    public void setBpmnProcessManager(IBPMNProcessManagerLocalBean bpmnProcessManager) {
        this.bpmnProcessManager = bpmnProcessManager;
    }

    public IProcessModelPackage getProcessModel(IBPMContext context, String compositeDN, String componentName) throws BPMException {
        ComponentDN componentDN = new ComponentDN(compositeDN, componentName);
        try {
            return this.buildProcessModelPackage(componentDN);
        }
        catch (ServerException e) {
            BPMLogger.log((LoggerComponent)LoggerComponent.COMPONENT_INSTANCE_MANAGEMENT_SERVICE, (Severity)Severity.ERRORS, (String)("Process model for process '" + componentName + "' from deployed project '" + compositeDN + "' could not be retrieved."));
            throw new BPMException(71201, new Object[]{compositeDN, componentName}, (Throwable)e);
        }
    }

    @Override
    public byte[] getProcessModelXML(IBPMContext context, String projectId, String processName) throws BPMException {
        try {
            ComponentDN componentDN = new ComponentDN(projectId, processName);
            IProcessModelPackage modelPackage = this.buildProcessModelPackage(componentDN);
            String xmlString = ProcessModelSerializer.create().marshall(modelPackage);
            byte[] processModelXML = xmlString.getBytes("UTF-8");
            return processModelXML;
        }
        catch (Exception e) {
            BPMLogger.log((LoggerComponent)LoggerComponent.COMPONENT_INSTANCE_MANAGEMENT_SERVICE, (Severity)Severity.ERRORS, (String)("Process model for process '" + processName + "' from deployed project '" + projectId + "' could not be retrieved."));
            throw new BPMException(71201, new Object[]{projectId, processName}, (Throwable)e);
        }
    }

    private IProcessModelPackage buildProcessModelPackage(ComponentDN componentDN) throws ServerException {
        Process bpmnProcessModel = this.getBpmnProcessManager().getBPMNProcessModel(componentDN);
        if (bpmnProcessModel != null) {
            Project project = bpmnProcessModel.getProject();
            Sequence callees = ModelUtils.getCalledProcesses((Process)bpmnProcessModel);
            LinkedList calleeList = new LinkedList();
            callees.addAllTo(calleeList);
            return ProcessModelPackageImpl.create((Process)project.getProjectModel(), (String)project.getName(), (Locale)project.getPreferences().getDefaultLanguage(), (Process)bpmnProcessModel, calleeList);
        }
        return null;
    }
}

