/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.services.instancequery.impl;

import java.io.IOException;
import java.io.Serializable;
import java.io.StringWriter;
import java.io.Writer;
import java.lang.reflect.Field;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collection;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.logging.ConsoleHandler;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import java.util.logging.Logger;
import java.util.logging.SimpleFormatter;
import javax.xml.namespace.QName;
import oracle.bpel.services.bpm.common.IBPMContext;
import oracle.bpel.services.common.util.XMLUtil;
import oracle.bpel.services.workflow.WorkflowException;
import oracle.bpel.services.workflow.query.ITaskQueryService;
import oracle.bpel.services.workflow.query.impl.PagingObject;
import oracle.bpel.services.workflow.query.impl.QueryUtil;
import oracle.bpel.services.workflow.query.impl.TaskQueryService;
import oracle.bpel.services.workflow.query.model.PredicateType;
import oracle.bpel.services.workflow.query.model.TaskOrderingType;
import oracle.bpel.services.workflow.query.model.TaskPredicateType;
import oracle.bpel.services.workflow.repos.Column;
import oracle.bpel.services.workflow.repos.IPersistencyService;
import oracle.bpel.services.workflow.repos.Ordering;
import oracle.bpel.services.workflow.repos.PersistencyDriver;
import oracle.bpel.services.workflow.repos.Predicate;
import oracle.bpel.services.workflow.repos.PredicateImpl;
import oracle.bpel.services.workflow.repos.TableConstants;
import oracle.bpel.services.workflow.task.impl.TaskUtil;
import oracle.bpel.services.workflow.task.impl.WorkflowUtil;
import oracle.bpel.services.workflow.task.model.ActionType;
import oracle.bpel.services.workflow.task.model.AttachmentType;
import oracle.bpel.services.workflow.task.model.CommentType;
import oracle.bpel.services.workflow.task.model.ObjectFactory;
import oracle.bpel.services.workflow.task.model.SystemAttributesType;
import oracle.bpel.services.workflow.task.model.Task;
import oracle.bpel.services.workflow.user.IUserMetadataService;
import oracle.bpel.services.workflow.user.impl.StandardViewLoaderUtil;
import oracle.bpel.services.workflow.user.model.ColumnListType;
import oracle.bpel.services.workflow.user.model.ColumnType;
import oracle.bpel.services.workflow.user.model.PresentationType;
import oracle.bpel.services.workflow.user.model.UserViewDetail;
import oracle.bpel.services.workflow.user.model.UserViewDetailType;
import oracle.bpel.services.workflow.verification.ITaskActionPermission;
import oracle.bpel.services.workflow.verification.IWorkflowContext;
import oracle.bpel.services.workflow.verification.impl.VerificationService;
import oracle.bpm.bpmn.engine.instancemanagement.impl.InternalInstanceManagementService;
import oracle.bpm.bpmn.engine.model.runtime.instancehandling.Activity;
import oracle.bpm.bpmn.engine.model.runtime.instancehandling.ActivityPath;
import oracle.bpm.bpmn.engine.model.runtime.instancehandling.CorrelationKey;
import oracle.bpm.bpmn.engine.model.runtime.instancehandling.CorrelationProperty;
import oracle.bpm.bpmn.engine.model.runtime.instancehandling.InstanceContextNode;
import oracle.bpm.bpmn.engine.model.runtime.instancehandling.InstanceHandlingException;
import oracle.bpm.bpmn.engine.model.runtime.instancehandling.InstanceVariableContainer;
import oracle.bpm.bpmn.engine.model.runtime.instancehandling.Variable;
import oracle.bpm.bpmn.engine.service.BPMNServiceEngine;
import oracle.bpm.bpmn.engine.service.audit.AuditServiceFactory;
import oracle.bpm.bpmn.engine.service.audit.IAuditService;
import oracle.bpm.bpmn.engine.service.ejb.interfaces.IBPMNCubeInstanceManagerLocalBean;
import oracle.bpm.client.internal.processmodel.marshalling.ProcessModelLoader;
import oracle.bpm.collections.CollectionUtils;
import oracle.bpm.collections.Sequence;
import oracle.bpm.collections.Tuple3;
import oracle.bpm.draw.diagram.AuditProcessDiagrammer;
import oracle.bpm.draw.diagram.DiagramEvent;
import oracle.bpm.draw.diagram.ProcessDiagrammer;
import oracle.bpm.project.model.Project;
import oracle.bpm.project.model.processes.BpmnType;
import oracle.bpm.project.model.processes.FlowNode;
import oracle.bpm.project.model.processes.Process;
import oracle.bpm.project.model.processes.SequenceFlow;
import oracle.bpm.project.model.processes.Subprocess;
import oracle.bpm.project.model.util.ModelUtils;
import oracle.bpm.services.common.AbstractBPMService;
import oracle.bpm.services.common.exception.BPMException;
import oracle.bpm.services.common.logger.BPMLogger;
import oracle.bpm.services.common.logger.LoggerComponent;
import oracle.bpm.services.common.logger.Severity;
import oracle.bpm.services.instancemanagement.impl.internal.InstanceManagementService;
import oracle.bpm.services.instancemanagement.model.IActivityInfo;
import oracle.bpm.services.instancemanagement.model.ICorrelationKeyItem;
import oracle.bpm.services.instancemanagement.model.IFlowChangeItem;
import oracle.bpm.services.instancemanagement.model.IGrabInstanceContext;
import oracle.bpm.services.instancemanagement.model.IGrabInstanceContextRequest;
import oracle.bpm.services.instancemanagement.model.IGrabInstanceContextResponse;
import oracle.bpm.services.instancemanagement.model.IGrabMultipleInstancesContextRequest;
import oracle.bpm.services.instancemanagement.model.IGrabMultipleInstancesContextResponse;
import oracle.bpm.services.instancemanagement.model.IInstanceContextConfiguration;
import oracle.bpm.services.instancemanagement.model.ILocationInfo;
import oracle.bpm.services.instancemanagement.model.IMigrateInstanceContextRequest;
import oracle.bpm.services.instancemanagement.model.IMigrateInstanceContextResponse;
import oracle.bpm.services.instancemanagement.model.IMigrateMultipleInstancesContextRequest;
import oracle.bpm.services.instancemanagement.model.IMigrateMultipleInstancesContextResponse;
import oracle.bpm.services.instancemanagement.model.IOpenActivityInfo;
import oracle.bpm.services.instancemanagement.model.IProcessAttachment;
import oracle.bpm.services.instancemanagement.model.IProcessComment;
import oracle.bpm.services.instancemanagement.model.IProcessInstance;
import oracle.bpm.services.instancemanagement.model.IProcessInstanceUser;
import oracle.bpm.services.instancemanagement.model.IVariableItem;
import oracle.bpm.services.instancemanagement.model.impl.IdentityType;
import oracle.bpm.services.instancemanagement.model.impl.ProcessAttachment;
import oracle.bpm.services.instancemanagement.model.impl.ProcessComment;
import oracle.bpm.services.instancemanagement.model.impl.ProcessInstance;
import oracle.bpm.services.instancemanagement.model.impl.ProcessInstanceUser;
import oracle.bpm.services.instancemanagement.model.impl.alterflow.ActivityInfo;
import oracle.bpm.services.instancemanagement.model.impl.alterflow.ActivityPathInfo;
import oracle.bpm.services.instancemanagement.model.impl.alterflow.CorrelationKeyItem;
import oracle.bpm.services.instancemanagement.model.impl.alterflow.CorrelationKeyProperty;
import oracle.bpm.services.instancemanagement.model.impl.alterflow.FlowChangeItem;
import oracle.bpm.services.instancemanagement.model.impl.alterflow.GrabInstanceContext;
import oracle.bpm.services.instancemanagement.model.impl.alterflow.GrabInstanceContextResponse;
import oracle.bpm.services.instancemanagement.model.impl.alterflow.GrabMultipleInstancesContextResponse;
import oracle.bpm.services.instancemanagement.model.impl.alterflow.GrabMultipleTreeInstancesContextResponse;
import oracle.bpm.services.instancemanagement.model.impl.alterflow.GrabTreeInstanceContextResponse;
import oracle.bpm.services.instancemanagement.model.impl.alterflow.LocationInfo;
import oracle.bpm.services.instancemanagement.model.impl.alterflow.MigrateInstanceContextResponse;
import oracle.bpm.services.instancemanagement.model.impl.alterflow.MigrateMultipleInstancesContextResponse;
import oracle.bpm.services.instancemanagement.model.impl.alterflow.MigrateMultipleTreeInstancesContextResponse;
import oracle.bpm.services.instancemanagement.model.impl.alterflow.MigrateTreeInstanceContextResponse;
import oracle.bpm.services.instancemanagement.model.impl.alterflow.OpenActivityInfo;
import oracle.bpm.services.instancemanagement.model.impl.alterflow.ProcessInstanceInfo;
import oracle.bpm.services.instancemanagement.model.impl.alterflow.VariableItem;
import oracle.bpm.services.instancequery.AuditInstanceOperation;
import oracle.bpm.services.instancequery.IAuditInstance;
import oracle.bpm.services.instancequery.IColumnConstants;
import oracle.bpm.services.instancequery.IInstanceQueryInput;
import oracle.bpm.services.instancequery.IInstanceQueryService;
import oracle.bpm.services.instancequery.impl.InstanceQueryInput;
import oracle.bpm.services.internal.processmodel.model.IProcessModelPackage;
import oracle.bpm.services.permissions.IPermissionsService;
import oracle.bpm.services.permissions.impl.PermissionsService;
import oracle.bpm.services.processmetadata.IProcessMetadataService;
import oracle.bpm.services.processmetadata.ProcessMetadataSummary;
import oracle.bpm.services.processmetadata.StatusEnum;
import oracle.bpm.services.tools.ProcessInstanceValidationHelper;
import oracle.bpm.services.util.AuditTrail;
import oracle.fabric.blocks.mesh.FabricMesh;
import oracle.fabric.composite.model.CompositeModel;
import oracle.soa.common.util.CXCompressUtils;
import oracle.soa.management.ComponentDN;
import oracle.soa.management.CompositeDN;
import oracle.soa.management.facade.LocatorFactory;
import oracle.soa.management.internal.facade.Locator;
import oracle.soa.management.util.SOAUtil;
import org.jetbrains.annotations.NotNull;
import org.w3c.dom.Node;

public class InstanceQueryService
extends AbstractBPMService
implements IInstanceQueryService {
    private IBPMNCubeInstanceManagerLocalBean bpmnInstanceManager;
    private IProcessMetadataService processMetadataService;
    private static final String PROCESSHISTORY_PROCESSID_COMPOSITE_COL_NAME = IColumnConstants.PROCESSHISTORY_INSTANCEID_COLUMN.getName() + "||'-'||" + IColumnConstants.PROCESSHISTORY_THREAD_COLUMN.getName() + "||'-'||" + IColumnConstants.PROCESSHISTORY_PARENTTHREAD_COLUMN.getName();
    private static final Column PROCESSHISTORY_PROCESSID_COMPOSITE_COL = new Column(PROCESSHISTORY_PROCESSID_COMPOSITE_COL_NAME, 2, IColumnConstants.PROCESS_HISTORY_TABLE);
    private static final String logClassName = InstanceQueryService.class.getName();
    private static final String ACTION_VIEW_AUDIT_INFO = "VIEW_AUDIT_INFO";
    private static final String STANDARD_PROCESS_VIEWS_FILE = "oracle/bpm/services/config/StandardProcessViews.xml";
    private static final String STANDARD_TASK_VIEWS_FILE = "oracle/bpel/services/workflow/user/config/StandardTaskViews.xml";
    private static List<Column> sColumnList = null;
    private static List<Column> sDefaultProcessInstanceColumns = null;
    private static Logger logger;
    private static List<String> PROCESS_STATES_PENDING_MIGRATION;

    public IBPMNCubeInstanceManagerLocalBean getBpmnInstanceManager() {
        return this.bpmnInstanceManager;
    }

    public void setBpmnInstanceManager(IBPMNCubeInstanceManagerLocalBean instanceManagerBean) {
        this.bpmnInstanceManager = instanceManagerBean;
    }

    public IProcessMetadataService getProcessMetadataService() {
        return this.processMetadataService;
    }

    public void setProcessMetadataService(IProcessMetadataService processMetadataService) {
        this.processMetadataService = processMetadataService;
    }

    public List<IProcessInstance> queryParallelInstances(IBPMContext context, IProcessInstance instance, List<Column> displayColumns) throws BPMException {
        ArrayList<IProcessInstance> arrayList;
        IPersistencyService service = null;
        try {
            String instanceId = instance.getSystemAttributes().getProcessInstanceId();
            BPMLogger.log((LoggerComponent)LoggerComponent.COMPONENT_INSTANCE_QUERY_SERVICE, (Severity)Severity.DEBUG, (String)"oracle.bpmn.process.query.impl.InstanceQueryService", (String)"queryParallelInstances", (String)("Start of queryParallelInstances based on id " + instanceId));
            String state = instance.getSystemAttributes().getState();
            PredicateImpl predicate = new PredicateImpl(IColumnConstants.PROCESS_INSTANCEID_COLUMN, 0, (Object)instanceId);
            predicate.addClause(7, IColumnConstants.PROCESS_STATE_COLUMN, 0, (Object)state);
            predicate.addClause(7, IColumnConstants.PROCESS_THREAD_COLUMN, 1, (Object)Integer.parseInt("0"));
            predicate.addClause(7, IColumnConstants.PROCESS_COMPONENTTYPE_COLUMN, 0, (Object)"BPMN");
            this.addManadatoryColumns(displayColumns);
            service = PersistencyDriver.getInstance();
            List taskList = service.getWFTask((IWorkflowContext)context, displayColumns, (Predicate)predicate, null, 0, 0);
            ArrayList<IProcessInstance> processInstances = new ArrayList<IProcessInstance>(taskList.size());
            for (Object object : taskList) {
                Task itask = (Task)object;
                ProcessInstance pInstance = new ProcessInstance(itask);
                processInstances.add((IProcessInstance)pInstance);
            }
            BPMLogger.log((LoggerComponent)LoggerComponent.COMPONENT_INSTANCE_QUERY_SERVICE, (Severity)Severity.DEBUG, (String)logClassName, (String)"queryParallelInstances", (String)("End of queryParallelInstances based on id " + instanceId));
            arrayList = processInstances;
        }
        catch (Exception exc) {
            try {
                BPMLogger.log((LoggerComponent)LoggerComponent.COMPONENT_INSTANCE_QUERY_SERVICE, (Severity)Severity.ERRORS, (Throwable)exc);
                Object[] obj = new String[]{instance.getSystemAttributes().getProcessInstanceId()};
                throw new BPMException(70403, obj, (Throwable)exc);
            }
            catch (Throwable throwable) {
                InstanceQueryService.closeService(service);
                throw throwable;
            }
        }
        InstanceQueryService.closeService(service);
        return arrayList;
    }

    public List<IProcessInstance> queryProcessInstances(IBPMContext context, List<Column> displayColumns, Predicate predicate, Ordering ordering, IInstanceQueryInput queryInput) throws BPMException {
        BPMLogger.log((LoggerComponent)LoggerComponent.COMPONENT_INSTANCE_QUERY_SERVICE, (Severity)Severity.DEBUG, (String)logClassName, (String)"queryProcessInstances", (String)"Start of queryProcessInstances");
        return this.queryInstances(context, displayColumns, predicate, ordering, queryInput, false);
    }

    public List<IProcessInstance> queryInstances(IBPMContext context, List<Column> displayColumns, Predicate predicate, Ordering ordering, IInstanceQueryInput queryInput) throws BPMException {
        BPMLogger.log((LoggerComponent)LoggerComponent.COMPONENT_INSTANCE_QUERY_SERVICE, (Severity)Severity.DEBUG, (String)logClassName, (String)"queryInstances", (String)"Start of queryInstances");
        return this.queryInstances(context, displayColumns, predicate, ordering, queryInput, true);
    }

    public List<IProcessInstance> queryViewProcessInstances(IBPMContext context, String viewId, Predicate extraPredicate, Ordering ordering, int startRow, int endRow) throws BPMException {
        BPMLogger.log((LoggerComponent)LoggerComponent.COMPONENT_INSTANCE_QUERY_SERVICE, (Severity)Severity.DEBUG, (String)logClassName, (String)"queryViewProcessInstances", (String)("Start of queryViewInstances for view id " + viewId));
        return this.queryViewInstances(context, viewId, extraPredicate, ordering, startRow, endRow, false);
    }

    public List<IProcessInstance> queryViewInstances(IBPMContext context, String viewId, Predicate extraPredicate, Ordering ordering, int startRow, int endRow) throws BPMException {
        BPMLogger.log((LoggerComponent)LoggerComponent.COMPONENT_INSTANCE_QUERY_SERVICE, (Severity)Severity.DEBUG, (String)logClassName, (String)"queryViewInstances", (String)("Start of queryViewInstances for view id " + viewId));
        return this.queryViewInstances(context, viewId, extraPredicate, ordering, startRow, endRow, true);
    }

    public IProcessInstance getProcessInstance(IBPMContext context, int processNumber) throws BPMException {
        BPMLogger.log((LoggerComponent)LoggerComponent.COMPONENT_INSTANCE_QUERY_SERVICE, (Severity)Severity.DEBUG, (String)logClassName, (String)"getProcessInstance", (String)("Start of getProcessInstance for instance id " + processNumber));
        IPersistencyService service = null;
        ProcessInstance pInstance = null;
        Locale locale = context.getLocale();
        try {
            service = PersistencyDriver.getInstance();
            PredicateImpl predicate = new PredicateImpl(IColumnConstants.PROCESS_NUMBER_COLUMN, 0, (Object)processNumber);
            context.setLocale(Locale.getDefault());
            List taskLists = service.getWFTask((IWorkflowContext)context, sColumnList, (Predicate)predicate, null);
            if (taskLists.size() > 0) {
                Task task = (Task)taskLists.get(0);
                pInstance = new ProcessInstance(task);
                this.performPermissionsCheck(context, (IProcessInstance)pInstance, IPermissionsService.InstanceAction.VIEW);
                this.addOtherInfo(context, service, pInstance);
            }
            BPMLogger.log((LoggerComponent)LoggerComponent.COMPONENT_INSTANCE_QUERY_SERVICE, (Severity)Severity.DEBUG, (String)logClassName, (String)"getProcessInstance", (String)("End of getProcessInstance for instance id " + processNumber));
            ProcessInstance processInstance = pInstance;
            return processInstance;
        }
        catch (Exception exc) {
            BPMLogger.log((LoggerComponent)LoggerComponent.COMPONENT_INSTANCE_QUERY_SERVICE, (Severity)Severity.ERRORS, (Throwable)exc);
            Object[] objs = new String[]{processNumber + ""};
            throw new BPMException(70402, objs, (Throwable)exc);
        }
        finally {
            InstanceQueryService.closeService(service);
            context.setLocale(locale);
        }
    }

    public IProcessInstance getInstance(IBPMContext context, int processNumber, int threadId) throws BPMException {
        BPMLogger.log((LoggerComponent)LoggerComponent.COMPONENT_INSTANCE_QUERY_SERVICE, (Severity)Severity.DEBUG, (String)logClassName, (String)"getInstance", (String)("Start of getInstance for instance id " + processNumber + ", thread id " + threadId));
        IPersistencyService service = null;
        ProcessInstance pInstance = null;
        Locale locale = context.getLocale();
        try {
            service = PersistencyDriver.getInstance();
            PredicateImpl predicate = new PredicateImpl(IColumnConstants.PROCESS_NUMBER_COLUMN, 0, (Object)processNumber);
            predicate.addClause(7, IColumnConstants.PROCESS_THREAD_COLUMN, 0, (Object)threadId);
            context.setLocale(Locale.getDefault());
            List taskLists = service.getWFTask((IWorkflowContext)context, sColumnList, (Predicate)predicate, null);
            if (taskLists.size() > 0) {
                Task task = (Task)taskLists.get(0);
                pInstance = new ProcessInstance(task);
                this.performPermissionsCheck(context, (IProcessInstance)pInstance, IPermissionsService.InstanceAction.VIEW);
                this.addOtherInfo(context, service, pInstance);
            }
            BPMLogger.log((LoggerComponent)LoggerComponent.COMPONENT_INSTANCE_QUERY_SERVICE, (Severity)Severity.DEBUG, (String)logClassName, (String)"getInstance", (String)("End of getInstance for instance id " + processNumber + ", thread id " + threadId));
            ProcessInstance processInstance = pInstance;
            return processInstance;
        }
        catch (Exception exc) {
            BPMLogger.log((LoggerComponent)LoggerComponent.COMPONENT_INSTANCE_QUERY_SERVICE, (Severity)Severity.ERRORS, (Throwable)exc);
            Object[] objs = new String[]{processNumber + ""};
            throw new BPMException(70402, objs, (Throwable)exc);
        }
        finally {
            InstanceQueryService.closeService(service);
            context.setLocale(locale);
        }
    }

    public IProcessInstance getProcessInstance(IBPMContext context, String processId) throws BPMException {
        BPMLogger.log((LoggerComponent)LoggerComponent.COMPONENT_INSTANCE_QUERY_SERVICE, (Severity)Severity.DEBUG, (String)logClassName, (String)"getProcessInstance", (String)("Start of getProcessInstance for instance id " + processId));
        IPersistencyService service = null;
        ProcessInstance pInstance = null;
        Locale locale = context.getLocale();
        try {
            service = PersistencyDriver.getInstance();
            PredicateImpl predicate = new PredicateImpl(IColumnConstants.PROCESS_ID_COLUMN, 0, (Object)processId);
            context.setLocale(Locale.getDefault());
            List taskLists = service.getWFTask((IWorkflowContext)context, sColumnList, (Predicate)predicate, null);
            if (taskLists.size() > 0) {
                Task task = (Task)taskLists.get(0);
                pInstance = new ProcessInstance(task);
                this.performPermissionsCheck(context, (IProcessInstance)pInstance, IPermissionsService.InstanceAction.VIEW);
                this.addOtherInfo(context, service, pInstance);
            }
            BPMLogger.log((LoggerComponent)LoggerComponent.COMPONENT_INSTANCE_QUERY_SERVICE, (Severity)Severity.DEBUG, (String)logClassName, (String)"getProcessInstance", (String)("End of getProcessInstance for instance id " + processId));
            ProcessInstance processInstance = pInstance;
            return processInstance;
        }
        catch (Exception exc) {
            BPMLogger.log((LoggerComponent)LoggerComponent.COMPONENT_INSTANCE_QUERY_SERVICE, (Severity)Severity.ERRORS, (Throwable)exc);
            Object[] objs = new String[]{processId + ""};
            throw new BPMException(70401, objs, (Throwable)exc);
        }
        finally {
            InstanceQueryService.closeService(service);
            context.setLocale(locale);
        }
    }

    public IProcessInstance getInstance(IBPMContext context, String processId, int threadId) throws BPMException {
        BPMLogger.log((LoggerComponent)LoggerComponent.COMPONENT_INSTANCE_QUERY_SERVICE, (Severity)Severity.DEBUG, (String)logClassName, (String)"getInstance", (String)("Start of getProcessInstance for instance id " + processId + ", thread id " + threadId));
        IPersistencyService service = null;
        ProcessInstance pInstance = null;
        Locale locale = context.getLocale();
        try {
            service = PersistencyDriver.getInstance();
            PredicateImpl predicate = new PredicateImpl(IColumnConstants.PROCESS_ID_COLUMN, 0, (Object)processId);
            predicate.addClause(7, IColumnConstants.PROCESS_THREAD_COLUMN, 0, (Object)threadId);
            context.setLocale(Locale.getDefault());
            List taskLists = service.getWFTask((IWorkflowContext)context, sColumnList, (Predicate)predicate, null);
            if (taskLists.size() > 0) {
                Task task = (Task)taskLists.get(0);
                pInstance = new ProcessInstance(task);
                this.performPermissionsCheck(context, (IProcessInstance)pInstance, IPermissionsService.InstanceAction.VIEW);
                this.addOtherInfo(context, service, pInstance);
            }
            BPMLogger.log((LoggerComponent)LoggerComponent.COMPONENT_INSTANCE_QUERY_SERVICE, (Severity)Severity.DEBUG, (String)logClassName, (String)"getInstance", (String)("End of getInstance for instance id " + processId + ", thread id " + threadId));
            ProcessInstance processInstance = pInstance;
            return processInstance;
        }
        catch (Exception exc) {
            BPMLogger.log((LoggerComponent)LoggerComponent.COMPONENT_INSTANCE_QUERY_SERVICE, (Severity)Severity.ERRORS, (Throwable)exc);
            Object[] objs = new String[]{processId + ""};
            throw new BPMException(70401, objs, (Throwable)exc);
        }
        finally {
            InstanceQueryService.closeService(service);
            context.setLocale(locale);
        }
    }

    public List<IProcessInstanceUser> getInstanceUpdatedUserHistoryByInstanceId(IBPMContext context, String instanceId) throws BPMException {
        BPMLogger.log((LoggerComponent)LoggerComponent.COMPONENT_INSTANCE_QUERY_SERVICE, (Severity)Severity.DEBUG, (String)logClassName, (String)"getProcessInstance", (String)("Start of getInstanceUpdatedUserHistoryByInstanceId for instance id " + instanceId));
        IPersistencyService service = null;
        try {
            service = PersistencyDriver.getInstance();
            PredicateImpl predicate = new PredicateImpl(IColumnConstants.PROCESSHISTORY_INSTANCEID_COLUMN, 0, (Object)instanceId);
            List taskUpdateHistory = service.getProcessInstanceStakeHolders((IWorkflowContext)context, (Predicate)predicate);
            ArrayList<IProcessInstanceUser> convertedHistory = new ArrayList();
            if (taskUpdateHistory != null) {
                convertedHistory = this.convertMapToProcessIdentityType(taskUpdateHistory);
            }
            BPMLogger.log((LoggerComponent)LoggerComponent.COMPONENT_INSTANCE_QUERY_SERVICE, (Severity)Severity.DEBUG, (String)logClassName, (String)"getProcessInstance", (String)("End of getProcessInstance for instance id " + instanceId));
            ArrayList<IProcessInstanceUser> arrayList = convertedHistory;
            return arrayList;
        }
        catch (Exception exc) {
            BPMLogger.log((LoggerComponent)LoggerComponent.COMPONENT_INSTANCE_QUERY_SERVICE, (Severity)Severity.ERRORS, (Throwable)exc);
            Object[] objs = new String[]{instanceId + ""};
            throw new BPMException(70406, objs, (Throwable)exc);
        }
        finally {
            InstanceQueryService.closeService(service);
        }
    }

    public List<IProcessInstanceUser> getInstanceUpdatedUserHistoryByTaskNumber(IBPMContext context, int taskNumber) throws BPMException {
        ArrayList<IProcessInstanceUser> arrayList;
        BPMLogger.log((LoggerComponent)LoggerComponent.COMPONENT_INSTANCE_QUERY_SERVICE, (Severity)Severity.DEBUG, (String)logClassName, (String)"getInstanceUpdatedUserHistoryByTaskNumber", (String)("Start of getInstanceUpdatedUserHistoryByTaskNumber for taskNumber " + taskNumber));
        IPersistencyService service = null;
        PreparedStatement pStmt = null;
        try {
            service = PersistencyDriver.getInstance();
            StringBuilder buffer = new StringBuilder();
            buffer.append("SELECT ").append(IColumnConstants.PROCESS_INSTANCEID_COLUMN.getName()).append(" FROM ").append(IColumnConstants.PROCESS_TABLE.getName()).append(" WHERE ").append(IColumnConstants.PROCESS_NUMBER_COLUMN.getName()).append(" = " + taskNumber);
            pStmt = service.getPreparedStatement(buffer.toString());
            ResultSet rset = pStmt.executeQuery();
            String instanceId = null;
            if (rset.next()) {
                instanceId = rset.getString(1);
            }
            rset.close();
            ArrayList<IProcessInstanceUser> assigneeHistory = new ArrayList();
            if (instanceId != null) {
                assigneeHistory = this.getInstanceUpdatedUserHistoryByInstanceId(context, instanceId);
            }
            BPMLogger.log((LoggerComponent)LoggerComponent.COMPONENT_INSTANCE_QUERY_SERVICE, (Severity)Severity.DEBUG, (String)logClassName, (String)"getInstanceUpdatedUserHistoryByTaskNumber", (String)("End of getProcessInstance for instance id " + instanceId));
            arrayList = assigneeHistory;
        }
        catch (Exception exc) {
            try {
                BPMLogger.log((LoggerComponent)LoggerComponent.COMPONENT_INSTANCE_QUERY_SERVICE, (Severity)Severity.ERRORS, (Throwable)exc);
                Object[] objs = new String[]{taskNumber + ""};
                throw new BPMException(70406, objs, (Throwable)exc);
            }
            catch (Throwable throwable) {
                InstanceQueryService.closeService(service);
                InstanceQueryService.closePreparedStatement(pStmt);
                throw throwable;
            }
        }
        InstanceQueryService.closeService(service);
        InstanceQueryService.closePreparedStatement(pStmt);
        return arrayList;
    }

    public List<String> getInstancesActedByAssignee(IBPMContext context, Calendar startDate, Calendar endDate) throws BPMException {
        String userName = context.getUser();
        String identityContext = context.getIdentityContext();
        BPMLogger.log((LoggerComponent)LoggerComponent.COMPONENT_INSTANCE_QUERY_SERVICE, (Severity)Severity.DEBUG, (String)logClassName, (String)"getInstancesActedByAssignee", (String)("Start of getInstancesActedByAssignee for assignee id " + userName));
        IPersistencyService service = null;
        try {
            service = PersistencyDriver.getInstance();
            oracle.bpel.services.workflow.task.model.IdentityType identityType = new ObjectFactory().createIdentityType();
            identityType.setId(userName);
            identityType.setType("user");
            PredicateImpl predicate = new PredicateImpl(IColumnConstants.PROCESSHISTORY_UPDATEDBY_COLUMN, 0, identityType);
            predicate.addClause(7, IColumnConstants.PROCESSHISTORY_IDENTITYCONTEXT_COLUMN, 0, (Object)identityContext);
            predicate.addClause(7, IColumnConstants.PROCESSHISTORY_UPDATEDDATE_COLUMN, 3, (Object)startDate);
            predicate.addClause(7, IColumnConstants.PROCESSHISTORY_UPDATEDDATE_COLUMN, 5, (Object)endDate);
            List instanceIds = service.getProcessInstanceIdsUpdatedByUser((IWorkflowContext)context, (Predicate)predicate);
            BPMLogger.log((LoggerComponent)LoggerComponent.COMPONENT_INSTANCE_QUERY_SERVICE, (Severity)Severity.DEBUG, (String)logClassName, (String)"getInstancesActedByAssignee", (String)("Start of getInstancesActedByAssignee for assignee id " + userName));
            List list = instanceIds;
            return list;
        }
        catch (Exception exc) {
            BPMLogger.log((LoggerComponent)LoggerComponent.COMPONENT_INSTANCE_QUERY_SERVICE, (Severity)Severity.ERRORS, (Throwable)exc);
            Object[] objs = new String[]{userName};
            throw new BPMException(70405, objs, (Throwable)exc);
        }
        finally {
            InstanceQueryService.closeService(service);
        }
    }

    public List<IProcessComment> getProcessComments(IBPMContext context, IProcessInstance instance) throws BPMException {
        IPersistencyService service = null;
        String taskId = instance.getSystemAttributes().getProcessInstanceId();
        BPMLogger.log((LoggerComponent)LoggerComponent.COMPONENT_INSTANCE_QUERY_SERVICE, (Severity)Severity.DEBUG, (String)logClassName, (String)"getProcessComments", (String)("Start of getProcessComments for instance id " + taskId));
        try {
            service = PersistencyDriver.getInstance();
            Task task = ((ProcessInstance)instance).getTask();
            List comments = service.getProcessInstanceComments((IWorkflowContext)context, task);
            ArrayList<IProcessComment> processComments = new ArrayList<IProcessComment>();
            for (int i = 0; i < comments.size(); ++i) {
                ProcessComment pComment = new ProcessComment((CommentType)comments.get(i));
                processComments.add((IProcessComment)pComment);
            }
            BPMLogger.log((LoggerComponent)LoggerComponent.COMPONENT_INSTANCE_QUERY_SERVICE, (Severity)Severity.DEBUG, (String)logClassName, (String)"getProcessComments", (String)("End of getProcessComments for instance id " + taskId));
            ArrayList<IProcessComment> arrayList = processComments;
            return arrayList;
        }
        catch (Exception exc) {
            BPMLogger.log((LoggerComponent)LoggerComponent.COMPONENT_INSTANCE_QUERY_SERVICE, (Severity)Severity.ERRORS, (Throwable)exc);
            Object[] objs = new String[]{taskId + ""};
            throw new BPMException(70401, objs, (Throwable)exc);
        }
        finally {
            InstanceQueryService.closeService(service);
        }
    }

    public List<IProcessAttachment> getProcessAttachments(IBPMContext context, IProcessInstance instance) throws BPMException {
        IPersistencyService service = null;
        String taskId = instance.getSystemAttributes().getProcessInstanceId();
        BPMLogger.log((LoggerComponent)LoggerComponent.COMPONENT_INSTANCE_QUERY_SERVICE, (Severity)Severity.DEBUG, (String)logClassName, (String)"getProcessComments", (String)("Start of getProcessComments for instance id " + taskId));
        try {
            service = PersistencyDriver.getInstance();
            Task task = ((ProcessInstance)instance).getTask();
            List attacments = service.getProcessInstanceAttachments((IWorkflowContext)context, task);
            ArrayList<IProcessAttachment> processAttachment = new ArrayList<IProcessAttachment>();
            for (int i = 0; i < attacments.size(); ++i) {
                ProcessAttachment pAttachment = new ProcessAttachment((AttachmentType)attacments.get(i));
                processAttachment.add((IProcessAttachment)pAttachment);
            }
            BPMLogger.log((LoggerComponent)LoggerComponent.COMPONENT_INSTANCE_QUERY_SERVICE, (Severity)Severity.DEBUG, (String)logClassName, (String)"getProcessComments", (String)("End of getProcessComments for instance id " + taskId));
            ArrayList<IProcessAttachment> arrayList = processAttachment;
            return arrayList;
        }
        catch (Exception exc) {
            BPMLogger.log((LoggerComponent)LoggerComponent.COMPONENT_INSTANCE_QUERY_SERVICE, (Severity)Severity.ERRORS, (Throwable)exc);
            Object[] objs = new String[]{taskId + ""};
            throw new BPMException(70401, objs, (Throwable)exc);
        }
        finally {
            InstanceQueryService.closeService(service);
        }
    }

    public List<IAuditInstance> queryAuditInstanceByProcessId(IBPMContext context, String instanceId) throws BPMException {
        try {
            IAuditService service = AuditServiceFactory.getInstance().getAuditService();
            return service.queryAuditInstanceByProcessId(instanceId);
        }
        catch (Exception e) {
            BPMLogger.log((LoggerComponent)LoggerComponent.COMPONENT_INSTANCE_QUERY_SERVICE, (Severity)Severity.ERRORS, (Throwable)e);
            Object[] objs = new String[]{instanceId + " "};
            throw new BPMException(70401, objs, (Throwable)e);
        }
    }

    public List<IAuditInstance> queryAuditInstanceByActivityId(IBPMContext context, String processId, String activityId) throws BPMException {
        List<IAuditInstance> auditInstances = this.queryAuditInstanceByProcessId(context, processId);
        return this.queryAuditInstanceByActivityId(context, auditInstances, activityId);
    }

    public List<IAuditInstance> queryAuditInstanceByActivityId(IBPMContext context, List<IAuditInstance> auditInstances, String activityId) throws BPMException {
        AuditTrail auditTrail = AuditTrail.create(auditInstances);
        List callable = auditTrail.getTableNodesForActivity(activityId);
        ArrayList<IAuditInstance> result = new ArrayList<IAuditInstance>();
        for (AuditTrail.Node node : callable) {
            this.populateResult(result, node, 1);
        }
        return result;
    }

    @Deprecated
    public List<IAuditInstance> getActiveInstancesAsOfQueryId(IBPMContext context, long queryId) throws BPMException {
        try {
            IAuditService service = AuditServiceFactory.getInstance().getAuditService();
            return service.getActiveInstancesAsOfQueryId(queryId);
        }
        catch (Exception e) {
            BPMLogger.log((LoggerComponent)LoggerComponent.COMPONENT_INSTANCE_QUERY_SERVICE, (Severity)Severity.ERRORS, (Throwable)e);
            Object[] objs = new String[]{queryId + " "};
            throw new BPMException(70401, objs, (Throwable)e);
        }
    }

    @Deprecated
    public List<IAuditInstance> getAllInstancesAfterQueryId(IBPMContext context, long queryId) throws BPMException {
        try {
            IAuditService service = AuditServiceFactory.getInstance().getAuditService();
            return service.getAllInstancesAfterQueryId(queryId);
        }
        catch (Exception e) {
            BPMLogger.log((LoggerComponent)LoggerComponent.COMPONENT_INSTANCE_QUERY_SERVICE, (Severity)Severity.ERRORS, (Throwable)e);
            Object[] objs = new String[]{queryId + " "};
            throw new BPMException(70401, objs, (Throwable)e);
        }
    }

    @NotNull
    public List<IAuditInstance> queryAuditInstances(IBPMContext context, int firstResult, int resultPageSize, boolean active, int totalResults, Calendar referenceTime, long backTrackTime) throws BPMException {
        try {
            IAuditService service = AuditServiceFactory.getInstance().getAuditService();
            return service.queryAuditInstances(firstResult, resultPageSize, active, totalResults, referenceTime, backTrackTime);
        }
        catch (Exception e) {
            BPMLogger.log((LoggerComponent)LoggerComponent.COMPONENT_INSTANCE_QUERY_SERVICE, (Severity)Severity.ERRORS, (Throwable)e);
            Object[] objs = new String[]{"firstResult=" + firstResult, "masResult=" + resultPageSize, "active=" + active, "rangeSize=" + totalResults, "referenceTime=" + referenceTime, "daysBack=" + backTrackTime};
            throw new BPMException(70401, objs, (Throwable)e);
        }
    }

    public List<IAuditInstance> queryAuditInstances(IBPMContext context, String expression) throws BPMException {
        try {
            IAuditService service = AuditServiceFactory.getInstance().getAuditService();
            return service.queryAuditInstances(expression);
        }
        catch (Exception e) {
            BPMLogger.log((LoggerComponent)LoggerComponent.COMPONENT_INSTANCE_QUERY_SERVICE, (Severity)Severity.ERRORS, (Throwable)e);
            throw new BPMException(70401, null, (Throwable)e);
        }
    }

    public List<IAuditInstance> queryAuditInstances(IBPMContext context, String expression, Map<String, Object> parameters) throws BPMException {
        try {
            IAuditService service = AuditServiceFactory.getInstance().getAuditService();
            return service.queryAuditInstances(expression, parameters);
        }
        catch (Exception e) {
            BPMLogger.log((LoggerComponent)LoggerComponent.COMPONENT_INSTANCE_QUERY_SERVICE, (Severity)Severity.ERRORS, (Throwable)e);
            Object[] objs = new String[]{parameters + " "};
            throw new BPMException(70401, objs, (Throwable)e);
        }
    }

    public List<IAuditInstance> queryAuditInstances(IBPMContext context, String tablePrefix, String expression, String orderBy, Map<String, Object> parameters, int pageStart, int pageSize) throws BPMException {
        try {
            IAuditService service = AuditServiceFactory.getInstance().getAuditService();
            return service.queryAuditInstances(tablePrefix, expression, orderBy, parameters, pageStart, pageSize);
        }
        catch (Exception e) {
            BPMLogger.log((LoggerComponent)LoggerComponent.COMPONENT_INSTANCE_QUERY_SERVICE, (Severity)Severity.ERRORS, (Throwable)e);
            Object[] objs = new String[]{parameters + " "};
            throw new BPMException(70401, objs, (Throwable)e);
        }
    }

    public byte[] getAuditInstancePayload(IBPMContext ctx, long queryId) throws BPMException {
        try {
            IAuditService service = AuditServiceFactory.getInstance().getAuditService();
            return service.getAuditInstancePayload(queryId);
        }
        catch (Exception e) {
            BPMLogger.log((LoggerComponent)LoggerComponent.COMPONENT_INSTANCE_QUERY_SERVICE, (Severity)Severity.ERRORS, (Throwable)e);
            Object[] objs = new String[]{queryId + " "};
            throw new BPMException(70401, objs, (Throwable)e);
        }
    }

    public String getAuditInstancePayloadXML(IBPMContext ctx, long queryId) throws BPMException {
        try {
            IAuditService service = AuditServiceFactory.getInstance().getAuditService();
            byte[] bytes = service.getAuditInstancePayload(queryId);
            if (bytes.length > 0) {
                StringWriter writer = new StringWriter(2000);
                CXCompressUtils.uncompressStream((byte[])bytes, (Writer)writer);
                return writer.toString();
            }
            return "";
        }
        catch (Exception e) {
            BPMLogger.log((LoggerComponent)LoggerComponent.COMPONENT_INSTANCE_QUERY_SERVICE, (Severity)Severity.ERRORS, (Throwable)e);
            Object[] objs = new String[]{queryId + " "};
            throw new BPMException(70401, objs, (Throwable)e);
        }
    }

    public Map<String, String> getActivityTypes(IBPMContext context, String compositeDN, String componentName) throws BPMException {
        String logMethodName = "getActivityTypes";
        try {
            Map<String, String> result = new HashMap<String, String>();
            IProcessModelPackage pkg = this.loadProcessModel(compositeDN, componentName);
            Sequence activities = pkg.getProcessModel().getFlowNodes();
            result = this.traverseActivities((Sequence<FlowNode>)activities, result);
            BPMLogger.log((LoggerComponent)LoggerComponent.COMPONENT_INSTANCE_QUERY_SERVICE, (Severity)Severity.DEBUG, (String)logClassName, (String)"getActivityTypes", (String)String.valueOf(result));
            return result;
        }
        catch (Exception e) {
            BPMLogger.log((LoggerComponent)LoggerComponent.COMPONENT_INSTANCE_QUERY_SERVICE, (Severity)Severity.ERRORS, (Throwable)e);
            Object[] objs = new String[]{compositeDN, componentName};
            throw new BPMException(70401, objs, (Throwable)e);
        }
    }

    public Serializable fetchVariableValue(ILocationInfo location, IVariableItem variable) throws BPMException {
        Variable runtimeVariable = Variable.create((String)variable.getName());
        try {
            return this.getBpmnInstanceManager().getVariableValue(location, runtimeVariable);
        }
        catch (Exception e) {
            Object[] objs = new String[]{"", location.getActivityInfo().getProcessId()};
            throw new BPMException(70411, objs, (Throwable)e);
        }
    }

    public IGrabInstanceContext findGrabInstanceContextForActivity(IBPMContext context, IProcessInstance instance, IOpenActivityInfo openActivity, IInstanceContextConfiguration configuration) throws BPMException {
        GrabInstanceContext grabInstanceContext = GrabInstanceContext.create();
        try {
            this.populateGrabContext(instance, grabInstanceContext, openActivity, context.getLocale(), configuration);
        }
        catch (Exception exc) {
            BPMLogger.log((LoggerComponent)LoggerComponent.COMPONENT_INSTANCE_QUERY_SERVICE, (Severity)Severity.ERRORS, (Throwable)exc);
            throw new BPMException(70415, null, (Throwable)exc);
        }
        return grabInstanceContext;
    }

    public IGrabInstanceContextResponse createGrabInstanceContext(IBPMContext context, IGrabInstanceContextRequest request) throws BPMException {
        logger.info("***** Enter createGrabInstanceContext **********");
        this.requestValidation(request);
        IGrabInstanceContextResponse grabInstGrabContextResponse = request.getInstanceContextConfiguration() == null ? this.createGrabFlattenInstanceContext(context, request) : this.createGrabTreeInstanceContext(context, request);
        logger.info("***** Exit createGrabInstanceContext **********");
        return grabInstGrabContextResponse;
    }

    public IGrabMultipleInstancesContextResponse createGrabMultipleInstancesContext(IBPMContext context, IGrabMultipleInstancesContextRequest grabMultipleInstancesContextRequest) throws BPMException {
        IGrabMultipleInstancesContextResponse response = grabMultipleInstancesContextRequest.getInstanceContextConfiguration() == null ? this.createGrabMultipleFlattenInstancesContext(context, grabMultipleInstancesContextRequest) : this.createGrabMultipleTreeInstancesContext(context, grabMultipleInstancesContextRequest);
        return response;
    }

    public IMigrateInstanceContextResponse createMigrateInstanceContext(IBPMContext context, IMigrateInstanceContextRequest request) throws BPMException {
        logger.info("***** Enter createMigrateInstanceContext **********");
        Object response = request.getInstanceContextConfiguration() == null ? this.createMigrateFlattenInstanceContext(context, request) : this.createMigrateTreeInstanceContext(context, request);
        logger.info("***** Exit createMigrateInstanceContext **********");
        return response;
    }

    public IMigrateMultipleInstancesContextResponse createMigrateMultipleInstancesContext(IBPMContext context, IMigrateMultipleInstancesContextRequest request) throws BPMException {
        Object migrateInstGrabContextResponse = request.getInstanceContextConfiguration() == null ? this.createMigrateMultipleFlattenInstancesContext(context, request) : this.createMigrateMultipleTreeInstancesContext(context, request);
        return migrateInstGrabContextResponse;
    }

    public Iterable<String> getComponentsPendingMigration(IBPMContext context) throws BPMException {
        logger.info("***** Enter getComponentsPendingMigration **********");
        HashSet<String> suspendedComponents = new HashSet<String>();
        List processes = this.getProcessMetadataService().listProcessMetadataSummary(context, null, null, null);
        for (ProcessMetadataSummary process : processes) {
            if (!process.isSetStatus() || process.getStatus() != StatusEnum.SUSPENDED) continue;
            String compositeName = process.getCompositeName();
            if (!PermissionsService.isAdmin(context) && !PermissionsService.isProcessOwner(context, compositeName)) continue;
            suspendedComponents.add(this.getProcessDN(process.getCompositeDN(), process.getProcessName()));
        }
        logger.info("***** Exit getComponentsPendingMigration **********");
        return suspendedComponents;
    }

    public int getCountOfInstancesPendingMigration(IBPMContext context, String processDN) throws BPMException {
        logger.info("***** Enter getCountOfInstancesPendingMigration **********");
        try {
            Predicate pred = new Predicate(IColumnConstants.PROCESS_PROCESSDEFINITIONID_COLUMN, 0, (Object)processDN);
            pred.addClause(7, IColumnConstants.PROCESS_STATE_COLUMN, 9, PROCESS_STATES_PENDING_MIGRATION);
            pred.addClause(7, IColumnConstants.PROCESS_THREAD_COLUMN, 0, (Object)0);
            IPersistencyService service = PersistencyDriver.getInstance();
            logger.info("***** Exit getCountOfInstancesPendingMigration **********");
            return service.countWFTasks((IWorkflowContext)context, pred);
        }
        catch (Exception e) {
            BPMLogger.log((LoggerComponent)LoggerComponent.COMPONENT_INSTANCE_QUERY_SERVICE, (Severity)Severity.ERRORS, (Throwable)e);
            throw new BPMException(70414, null, (Throwable)e);
        }
    }

    public int getCountOfProcessInstances(IBPMContext context, String processDN) throws BPMException {
        logger.info("***** Enter getCountOfProcessInstances **********");
        try {
            Predicate pred = new Predicate(IColumnConstants.PROCESS_PROCESSDEFINITIONID_COLUMN, 0, (Object)processDN);
            pred.addClause(7, IColumnConstants.PROCESS_THREAD_COLUMN, 0, (Object)0);
            IPersistencyService service = PersistencyDriver.getInstance();
            logger.info("***** Exit getCountOfProcessInstances **********");
            return service.countWFTasks((IWorkflowContext)context, pred);
        }
        catch (Exception e) {
            BPMLogger.log((LoggerComponent)LoggerComponent.COMPONENT_INSTANCE_QUERY_SERVICE, (Severity)Severity.ERRORS, (Throwable)e);
            throw new BPMException(70400, null, (Throwable)e);
        }
    }

    public String getProcessAuditDiagram(IBPMContext bpmContext, String instanceId, Locale locale) throws BPMException {
        Process process = this.extractProcess(bpmContext, instanceId);
        AuditProcessDiagrammer auditProcessDiagrammer = this.highlightAuditTrail(bpmContext, instanceId, process);
        try {
            return this.writeImage((ProcessDiagrammer)auditProcessDiagrammer, locale);
        }
        catch (IOException e) {
            BPMLogger.log((LoggerComponent)LoggerComponent.COMPONENT_INSTANCE_QUERY_SERVICE, (Severity)Severity.ERRORS, (Throwable)e);
            throw new BPMException(70418, null, (Throwable)e);
        }
    }

    public String getProcessDiagram(IBPMContext bpmContext, String instanceId, Locale locale) throws BPMException {
        Process process = this.extractProcess(bpmContext, instanceId);
        AuditProcessDiagrammer diagrammer = new AuditProcessDiagrammer(process);
        try {
            return this.writeImage((ProcessDiagrammer)diagrammer, locale);
        }
        catch (IOException e) {
            BPMLogger.log((LoggerComponent)LoggerComponent.COMPONENT_INSTANCE_QUERY_SERVICE, (Severity)Severity.ERRORS, (Throwable)e);
            throw new BPMException(70418, null, (Throwable)e);
        }
    }

    public Iterable<IProcessInstance> getProcessInstancesPendingMigration(IBPMContext context, String processDN, int startRow, int endRow) throws BPMException {
        try {
            Predicate pred = new Predicate(IColumnConstants.PROCESS_PROCESSDEFINITIONID_COLUMN, 0, (Object)processDN);
            pred.addClause(7, IColumnConstants.PROCESS_THREAD_COLUMN, 0, (Object)0);
            InstanceQueryInput input = new InstanceQueryInput();
            input.addState("PENDING_MIGRATION");
            input.addState("PENDING_MIGRATION_SUSPENDED");
            input.setAssignmentFilter(IInstanceQueryInput.AssignmentFilter.ALL);
            input.setStartRow(startRow);
            input.setEndRow(endRow);
            ArrayList<Column> displayColumns = new ArrayList<Column>();
            return this.queryInstances(context, displayColumns, pred, null, (IInstanceQueryInput)input);
        }
        catch (Exception exc) {
            BPMLogger.log((LoggerComponent)LoggerComponent.COMPONENT_INSTANCE_QUERY_SERVICE, (Severity)Severity.ERRORS, (Throwable)exc);
            throw new BPMException(70414, null, (Throwable)exc);
        }
    }

    private static Predicate getAssigneePredicate(IBPMContext context, IInstanceQueryInput.AssignmentFilter filter) throws Exception {
        ITaskQueryService.AssignmentFilter assignmentFilter = null;
        if (filter.equals((Object)IInstanceQueryInput.AssignmentFilter.ADMIN)) {
            assignmentFilter = ITaskQueryService.AssignmentFilter.ADMIN;
        }
        if (filter.equals((Object)IInstanceQueryInput.AssignmentFilter.ALL)) {
            assignmentFilter = ITaskQueryService.AssignmentFilter.ALL;
        } else if (filter.equals((Object)IInstanceQueryInput.AssignmentFilter.GROUP)) {
            assignmentFilter = ITaskQueryService.AssignmentFilter.GROUP;
        } else if (filter.equals((Object)IInstanceQueryInput.AssignmentFilter.MY)) {
            assignmentFilter = ITaskQueryService.AssignmentFilter.MY;
        } else if (filter.equals((Object)IInstanceQueryInput.AssignmentFilter.MY_AND_GROUP)) {
            assignmentFilter = ITaskQueryService.AssignmentFilter.MY_AND_GROUP;
        } else if (filter.equals((Object)IInstanceQueryInput.AssignmentFilter.OWNER)) {
            assignmentFilter = ITaskQueryService.AssignmentFilter.OWNER;
        } else if (filter.equals((Object)IInstanceQueryInput.AssignmentFilter.REPORTEES)) {
            assignmentFilter = ITaskQueryService.AssignmentFilter.REPORTEES;
        } else if (filter.equals((Object)IInstanceQueryInput.AssignmentFilter.PREVIOUS)) {
            return InstanceQueryService.getPreviousAssignmentPredicate(context);
        }
        if (assignmentFilter == null) {
            throw new Exception("Invalid assignment filter " + filter);
        }
        PredicateImpl assigneePredicate = TaskQueryService.getAssignmentFilterPredicate((IWorkflowContext)context, (ITaskQueryService.AssignmentFilter)assignmentFilter);
        return assigneePredicate;
    }

    private static Predicate getPreviousAssignmentPredicate(IBPMContext context) throws Exception {
        PredicateImpl assignmentFilterPred = null;
        if (!context.getIsAdmin()) {
            oracle.bpel.services.workflow.task.model.IdentityType identityType = TaskUtil.createIdentityTypeFromContext((IWorkflowContext)context);
            assignmentFilterPred = new PredicateImpl(TableConstants.WFTASKHISTORY_UPDATEDBY_COLUMN, 0, identityType);
            Map assigneeAppRoles = VerificationService.getAppRoleNamesMap((IWorkflowContext)context);
            if (assigneeAppRoles.size() > 0) {
                String appName = "OracleBPMProcessRolesApp";
                PredicateImpl appCtxPredicate = new PredicateImpl(TableConstants.WFTASK_APPLICATIONCONTEXT_COLUMN, 0, (Object)appName);
                Set roles = (Set)assigneeAppRoles.get(appName);
                ArrayList<String> roleList = new ArrayList<String>();
                if (roles != null && !roles.isEmpty()) {
                    for (String role : roles) {
                        roleList.add(role + ",application_role");
                    }
                    appCtxPredicate.addClause(7, TableConstants.WFTASKHISTORY_ASSIGNEES_COLUMN, 9, roleList);
                }
                PredicateImpl workflowSysPredicate = new PredicateImpl(TableConstants.WFTASKHISTORY_UPDATEDBY_COLUMN, 0, (Object)"workflowsystem");
                PredicateImpl appRoleFilterPredicate = new PredicateImpl((Predicate)workflowSysPredicate, 7, (Predicate)appCtxPredicate);
                assignmentFilterPred = new PredicateImpl((Predicate)assignmentFilterPred, 8, (Predicate)appRoleFilterPredicate);
            }
        }
        PredicateImpl identityContextPredicate = InstanceQueryService.getIdentityContextFilter(context);
        if (assignmentFilterPred == null) {
            assignmentFilterPred = identityContextPredicate;
        } else if (identityContextPredicate != null) {
            assignmentFilterPred = new PredicateImpl((Predicate)assignmentFilterPred, 7, (Predicate)identityContextPredicate);
        }
        return assignmentFilterPred;
    }

    private static PredicateImpl getIdentityContextFilter(IBPMContext context) throws Exception {
        PredicateImpl identityContextFilterPred = null;
        identityContextFilterPred = context.getIdentityContext() != null && !context.getIdentityContext().equals("") ? new PredicateImpl(TableConstants.WFTASKHISTORY_IDENTITYCONTEXT_COLUMN, 0, (Object)context.getIdentityContext()) : new PredicateImpl(TableConstants.WFTASKHISTORY_IDENTITYCONTEXT_COLUMN, 21, (Object)context.getIdentityContext());
        return identityContextFilterPred;
    }

    private static void closeService(IPersistencyService service) {
        if (service != null) {
            try {
                service.close();
            }
            catch (Exception exc) {
                BPMLogger.log((LoggerComponent)LoggerComponent.COMPONENT_INSTANCE_QUERY_SERVICE, (Severity)Severity.WARNING, (String)logClassName, (String)"closeService", (String)("Exception thrown when closing persistency service instance. Ignoring and continuing. Exception was: " + exc.getMessage()));
            }
        }
    }

    private static void closePreparedStatement(PreparedStatement pStmt) {
        if (pStmt != null) {
            try {
                pStmt.close();
            }
            catch (Exception exc) {
                BPMLogger.log((LoggerComponent)LoggerComponent.COMPONENT_INSTANCE_QUERY_SERVICE, (Severity)Severity.WARNING, (String)logClassName, (String)"closeService", (String)("Exception thrown when closing PreparedStatement. Ignoring and continuing. Exception was: " + exc.getMessage()));
            }
        }
    }

    private static IWorkflowContext getInternalWorkflowContext() throws WorkflowException {
        try {
            IWorkflowContext wfCtx = (IWorkflowContext)AccessController.doPrivileged(new PrivilegedExceptionAction(){

                public Object run() throws Exception {
                    return VerificationService.createInternalWorkflowContext();
                }
            });
            return wfCtx;
        }
        catch (PrivilegedActionException pae) {
            Exception orgEx = pae.getException();
            if (orgEx instanceof WorkflowException) {
                throw (WorkflowException)((Object)orgEx);
            }
            throw new WorkflowException((Throwable)pae);
        }
    }

    private void requestValidation(IGrabInstanceContextRequest request) throws BPMException {
        IProcessInstance processInstance = request.getProcessInstance();
        ProcessInstanceValidationHelper.validateErrorState(processInstance);
        ProcessInstanceValidationHelper.validateCompositeState(processInstance);
    }

    private void populateResult(List<IAuditInstance> nodeList, AuditTrail.Node node, int level) {
        if (node.getType() == AuditTrail.NodeType.AUDIT) {
            nodeList.add(node.getAuditInstance());
        }
        for (AuditTrail.Node child : node.getChildren()) {
            this.populateResult(nodeList, child, level + 1);
        }
    }

    @NotNull
    private Process extractProcess(IBPMContext bpmContext, String instanceId) throws BPMException {
        IProcessInstance processInstance = this.getProcessInstance(bpmContext, instanceId);
        IProcessModelPackage processModelPackage = null;
        try {
            processModelPackage = this.loadProcessModel(processInstance.getSca().getCompositeDN(), processInstance.getSca().getComponentName());
        }
        catch (Exception e) {
            BPMLogger.log((LoggerComponent)LoggerComponent.COMPONENT_INSTANCE_QUERY_SERVICE, (Severity)Severity.ERRORS, (Throwable)e);
            throw new BPMException(70416, null, (Throwable)e);
        }
        if (processModelPackage == null) {
            throw new BPMException(70416);
        }
        Process process = processModelPackage.getProcessModel();
        if (process == null) {
            throw new BPMException(70417);
        }
        return process;
    }

    private AuditProcessDiagrammer highlightAuditTrail(IBPMContext bpmContext, String instanceId, Process process) throws BPMException {
        AuditProcessDiagrammer auditProcessDiagrammer = new AuditProcessDiagrammer(process);
        List<IAuditInstance> auditInstances = this.queryAuditInstanceByProcessId(bpmContext, instanceId);
        ArrayList<DiagramEvent> diagramEvents = new ArrayList<DiagramEvent>();
        for (IAuditInstance auditInstance : auditInstances) {
            diagramEvents.addAll(this.getHighlightEvents(process, auditInstance));
        }
        auditProcessDiagrammer.highlight(diagramEvents);
        return auditProcessDiagrammer;
    }

    private String writeImage(ProcessDiagrammer diagrammer, Locale locale) throws IOException {
        if (locale != null) {
            diagrammer.setLocale(locale);
        }
        return diagrammer.getImage();
    }

    private List<DiagramEvent> getHighlightEvents(Process processModel, IAuditInstance auditInstance) {
        ArrayList<DiagramEvent> events;
        block6: {
            FlowNode flowNode;
            boolean cancelled;
            Date eventDate;
            block5: {
                events = new ArrayList<DiagramEvent>();
                String activityId = auditInstance.getActivityId();
                eventDate = auditInstance.getCreateTime().getTime();
                cancelled = auditInstance.getOperation() == AuditInstanceOperation.FLOW_NODE_CANCELLED;
                DiagramEvent nodeEvent = DiagramEvent.create((DiagramEvent.DiagramEventType)DiagramEvent.DiagramEventType.FLOW_NODE_IN, (String)activityId, (Date)eventDate, (boolean)cancelled);
                events.add(nodeEvent);
                if (!auditInstance.getAuditInstanceType().equalsIgnoreCase("START")) break block5;
                FlowNode flowNode2 = (FlowNode)processModel.findDescendant(FlowNode.class, auditInstance.getActivityId());
                if (flowNode2 == null) break block6;
                String sourceActivity = auditInstance.getSourceActivity();
                Sequence incommingSequenceFlows = flowNode2.getIncomingSequenceFlows();
                if (incommingSequenceFlows != null && !incommingSequenceFlows.isEmpty() && sourceActivity != null) {
                    for (SequenceFlow sequenceFlow : incommingSequenceFlows) {
                        if (!sequenceFlow.getSource().getId().equalsIgnoreCase(sourceActivity)) continue;
                        DiagramEvent sequenceEvent = DiagramEvent.create((DiagramEvent.DiagramEventType)DiagramEvent.DiagramEventType.SEQUENCE_FLOW, (String)sequenceFlow.getId(), (Date)eventDate, (boolean)cancelled);
                        events.add(sequenceEvent);
                    }
                }
                break block6;
            }
            if (auditInstance.getAuditInstanceType().equalsIgnoreCase("END") && (flowNode = (FlowNode)processModel.findDescendant(FlowNode.class, auditInstance.getActivityId())) != null) {
                String targetActivity = auditInstance.getTargetActivity();
                Sequence outgoingSequenceFlows = flowNode.getOutgoingSequenceFlows();
                if (outgoingSequenceFlows != null && !outgoingSequenceFlows.isEmpty() && auditInstance.getOperation() != AuditInstanceOperation.FLOW_NODE_CANCELLED && targetActivity != null) {
                    for (SequenceFlow sequenceFlow : outgoingSequenceFlows) {
                        if (!sequenceFlow.getTarget().getId().equalsIgnoreCase(targetActivity)) continue;
                        DiagramEvent sequenceEvent = DiagramEvent.create((DiagramEvent.DiagramEventType)DiagramEvent.DiagramEventType.SEQUENCE_FLOW, (String)sequenceFlow.getId(), (Date)eventDate, (boolean)cancelled);
                        events.add(sequenceEvent);
                    }
                }
            }
        }
        return events;
    }

    private IMigrateInstanceContextResponse createMigrateTreeInstanceContext(IBPMContext context, IMigrateInstanceContextRequest request) throws BPMException {
        TreeSet<IFlowChangeItem> flowChangeItems = new TreeSet<IFlowChangeItem>(FlowChangeItemSingleComparator.getInstance());
        HashSet<IVariableItem> addedDataObjects = new HashSet<IVariableItem>();
        HashSet<IActivityInfo> activitiesInConflict = new HashSet<IActivityInfo>();
        IInstanceContextConfiguration configuration = request.getInstanceContextConfiguration();
        GrabInstanceContext grabInstanceContext = GrabInstanceContext.create();
        try {
            IProcessInstance pInst = request.getProcessInstance();
            this.populateFlowChanges(context, pInst, flowChangeItems, configuration);
            ILocationInfo location = request.getLocation();
            this.populateGrabContext(pInst, grabInstanceContext, location, configuration, context.getLocale());
            this.populateProcessDiff(addedDataObjects, activitiesInConflict);
        }
        catch (Exception exc) {
            BPMLogger.log((LoggerComponent)LoggerComponent.COMPONENT_INSTANCE_QUERY_SERVICE, (Severity)Severity.ERRORS, (Throwable)exc);
            throw new BPMException(70412, null, (Throwable)exc);
        }
        MigrateTreeInstanceContextResponse migrateInstGrabContextResponse = MigrateTreeInstanceContextResponse.create(flowChangeItems, (GrabInstanceContext)grabInstanceContext);
        migrateInstGrabContextResponse.setActivitiesInConflict(activitiesInConflict);
        migrateInstGrabContextResponse.setAddedDataObjects(addedDataObjects);
        return migrateInstGrabContextResponse;
    }

    @Deprecated
    private MigrateInstanceContextResponse createMigrateFlattenInstanceContext(IBPMContext context, IMigrateInstanceContextRequest migrateInstanceContextRequest) throws BPMException {
        HashSet<IFlowChangeItem> flowChangeItems = new HashSet<IFlowChangeItem>();
        HashSet<IVariableItem> availableVariables = new HashSet<IVariableItem>();
        HashSet<IVariableItem> instanceAttributes = new HashSet<IVariableItem>();
        HashSet<IVariableItem> addedDataObjects = new HashSet<IVariableItem>();
        HashSet<ICorrelationKeyItem> correlationKeys = new HashSet<ICorrelationKeyItem>();
        HashSet<IActivityInfo> activitiesInConflict = new HashSet<IActivityInfo>();
        try {
            IProcessInstance pInst = migrateInstanceContextRequest.getProcessInstance();
            this.populateFlowChanges(context, pInst, flowChangeItems);
            this.populateInstanceState(context, pInst, availableVariables, instanceAttributes, correlationKeys);
            this.populateProcessDiff(addedDataObjects, activitiesInConflict);
        }
        catch (Exception exc) {
            BPMLogger.log((LoggerComponent)LoggerComponent.COMPONENT_INSTANCE_QUERY_SERVICE, (Severity)Severity.ERRORS, (Throwable)exc);
            throw new BPMException(70412, null, (Throwable)exc);
        }
        MigrateInstanceContextResponse migrateInstGrabContextResponse = MigrateInstanceContextResponse.create(flowChangeItems, availableVariables, instanceAttributes, correlationKeys);
        migrateInstGrabContextResponse.setActivitiesInConflict(activitiesInConflict);
        migrateInstGrabContextResponse.setAddedDataObjects(addedDataObjects);
        logger.info("***** Exit createMigrateInstanceContext **********");
        return migrateInstGrabContextResponse;
    }

    private IMigrateMultipleInstancesContextResponse createMigrateMultipleTreeInstancesContext(IBPMContext context, IMigrateMultipleInstancesContextRequest request) throws BPMException {
        int locationsSize;
        int instancesSize = CollectionUtils.size((Iterable)request.getProcessInstances());
        if (instancesSize != (locationsSize = CollectionUtils.size((Iterable)request.getLocations()))) {
            throw new IllegalArgumentException("Invalid request: The collections of instances and locations have distinct sizes.");
        }
        TreeSet<IFlowChangeItem> flowChangeItems = new TreeSet<IFlowChangeItem>(FlowChangeItemMultipleComparator.getInstance());
        HashSet<IVariableItem> addedDataObjects = new HashSet<IVariableItem>();
        HashSet<IActivityInfo> activitiesInConflict = new HashSet<IActivityInfo>();
        HashSet<GrabInstanceContext> instanceContexts = new HashSet<GrabInstanceContext>();
        String processDN = request.getProcessDN();
        IInstanceContextConfiguration configuration = request.getInstanceContextConfiguration();
        try {
            Iterator instances = request.getProcessInstances().iterator();
            Iterator locations = request.getLocations().iterator();
            while (instances.hasNext()) {
                IProcessInstance pInst = (IProcessInstance)instances.next();
                ILocationInfo locationInfo = (ILocationInfo)locations.next();
                GrabInstanceContext grabInstanceContext = GrabInstanceContext.create();
                if (pInst.getProcessDN().equals(processDN)) {
                    this.populateFlowChanges(context, pInst, flowChangeItems, configuration);
                    this.populateGrabContext(pInst, grabInstanceContext, locationInfo, configuration, context.getLocale());
                    instanceContexts.add(grabInstanceContext);
                    continue;
                }
                throw new BPMException(70413, null, null);
            }
            this.populateProcessDiff(addedDataObjects, activitiesInConflict);
        }
        catch (Exception exc) {
            BPMLogger.log((LoggerComponent)LoggerComponent.COMPONENT_INSTANCE_QUERY_SERVICE, (Severity)Severity.ERRORS, (Throwable)exc);
            throw new BPMException(70412, null, (Throwable)exc);
        }
        MigrateMultipleTreeInstancesContextResponse migrateInstGrabContextResponse = MigrateMultipleTreeInstancesContextResponse.create(flowChangeItems, instanceContexts);
        migrateInstGrabContextResponse.setActivitiesInConflict(activitiesInConflict);
        migrateInstGrabContextResponse.setAddedDataObjects(addedDataObjects);
        return migrateInstGrabContextResponse;
    }

    @Deprecated
    private MigrateMultipleInstancesContextResponse createMigrateMultipleFlattenInstancesContext(IBPMContext context, IMigrateMultipleInstancesContextRequest migrateMultipleInstancesContextRequest) throws BPMException {
        HashSet<IFlowChangeItem> flowChangeItems = new HashSet<IFlowChangeItem>();
        HashSet<IVariableItem> addedDataObjects = new HashSet<IVariableItem>();
        HashSet<IActivityInfo> activitiesInConflict = new HashSet<IActivityInfo>();
        String processDN = migrateMultipleInstancesContextRequest.getProcessDN();
        try {
            for (IProcessInstance pInst : migrateMultipleInstancesContextRequest.getProcessInstances()) {
                if (pInst.getProcessDN().equals(processDN)) {
                    this.populateFlowChanges(context, pInst, flowChangeItems);
                    continue;
                }
                throw new BPMException(70413, null, null);
            }
            this.populateProcessDiff(addedDataObjects, activitiesInConflict);
        }
        catch (Exception exc) {
            BPMLogger.log((LoggerComponent)LoggerComponent.COMPONENT_INSTANCE_QUERY_SERVICE, (Severity)Severity.ERRORS, (Throwable)exc);
            throw new BPMException(70412, null, (Throwable)exc);
        }
        MigrateMultipleInstancesContextResponse migrateInstGrabContextResponse = MigrateMultipleInstancesContextResponse.create(flowChangeItems);
        migrateInstGrabContextResponse.setActivitiesInConflict(activitiesInConflict);
        migrateInstGrabContextResponse.setAddedDataObjects(addedDataObjects);
        return migrateInstGrabContextResponse;
    }

    private IGrabMultipleInstancesContextResponse createGrabMultipleTreeInstancesContext(IBPMContext context, IGrabMultipleInstancesContextRequest request) throws BPMException {
        int locationsSize;
        int instancesSize = CollectionUtils.size((Iterable)request.getProcessInstances());
        if (instancesSize != (locationsSize = CollectionUtils.size((Iterable)request.getLocations()))) {
            throw new IllegalArgumentException("Invalid request: The collections of instances and locations have distinct sizes.");
        }
        TreeSet<IFlowChangeItem> flowChangeItems = new TreeSet<IFlowChangeItem>(FlowChangeItemMultipleComparator.getInstance());
        ArrayList<GrabInstanceContext> grabInstancesContext = new ArrayList<GrabInstanceContext>();
        ArrayList<Boolean> wereInstancesSuspended = new ArrayList<Boolean>();
        String processDN = request.getProcessDN();
        IInstanceContextConfiguration configuration = request.getInstanceContextConfiguration();
        try {
            Iterator processInstances = request.getProcessInstances().iterator();
            Iterator locations = request.getLocations().iterator();
            while (processInstances.hasNext()) {
                IProcessInstance pInst = (IProcessInstance)processInstances.next();
                ILocationInfo locationInfo = (ILocationInfo)locations.next();
                if (pInst.getProcessDN().equals(processDN)) {
                    boolean wasProcessInstanceSuspended = false;
                    wasProcessInstanceSuspended = this.suspendInstance(request.isSuspendInstancesIfRequired(), wasProcessInstanceSuspended, pInst);
                    wereInstancesSuspended.add(wasProcessInstanceSuspended);
                    this.populateFlowChanges(context, pInst, flowChangeItems, configuration);
                    GrabInstanceContext grabInstanceContext = GrabInstanceContext.create();
                    this.populateGrabContext(pInst, grabInstanceContext, locationInfo, configuration, context.getLocale());
                    grabInstancesContext.add(grabInstanceContext);
                    continue;
                }
                throw new BPMException(70413, null, null);
            }
        }
        catch (Exception exc) {
            BPMLogger.log((LoggerComponent)LoggerComponent.COMPONENT_INSTANCE_QUERY_SERVICE, (Severity)Severity.ERRORS, (Throwable)exc);
            throw new BPMException(70411, null, (Throwable)exc);
        }
        return GrabMultipleTreeInstancesContextResponse.create(flowChangeItems, grabInstancesContext, wereInstancesSuspended);
    }

    @Deprecated
    private IGrabMultipleInstancesContextResponse createGrabMultipleFlattenInstancesContext(IBPMContext context, IGrabMultipleInstancesContextRequest request) throws BPMException {
        HashSet<IFlowChangeItem> flowChangeItems = new HashSet<IFlowChangeItem>();
        ArrayList<Boolean> wasInstanceSuspended = new ArrayList<Boolean>();
        String processDN = request.getProcessDN();
        try {
            for (IProcessInstance pInst : request.getProcessInstances()) {
                if (pInst.getProcessDN().equals(processDN)) {
                    boolean wasProcessInstanceSuspended = false;
                    wasProcessInstanceSuspended = this.suspendInstance(request.isSuspendInstancesIfRequired(), wasProcessInstanceSuspended, pInst);
                    wasInstanceSuspended.add(wasProcessInstanceSuspended);
                    this.populateFlowChanges(context, pInst, flowChangeItems);
                    continue;
                }
                throw new BPMException(70413, null, null);
            }
        }
        catch (Exception exc) {
            BPMLogger.log((LoggerComponent)LoggerComponent.COMPONENT_INSTANCE_QUERY_SERVICE, (Severity)Severity.ERRORS, (Throwable)exc);
            throw new BPMException(70411, null, (Throwable)exc);
        }
        return GrabMultipleInstancesContextResponse.create(flowChangeItems, wasInstanceSuspended);
    }

    private IGrabInstanceContextResponse createGrabTreeInstanceContext(IBPMContext context, IGrabInstanceContextRequest request) throws BPMException {
        boolean suspendInstanceIfRequired = request.isSuspendInstanceIfRequired();
        boolean wasInstanceSuspended = false;
        TreeSet<IFlowChangeItem> flowChangeItems = new TreeSet<IFlowChangeItem>(FlowChangeItemSingleComparator.getInstance());
        GrabInstanceContext grabInstanceContext = GrabInstanceContext.create();
        try {
            IProcessInstance pInst = request.getProcessInstance();
            wasInstanceSuspended = this.suspendInstance(suspendInstanceIfRequired, wasInstanceSuspended, pInst);
            this.populateFlowChanges(context, pInst, flowChangeItems, request.getInstanceContextConfiguration());
            IInstanceContextConfiguration configuration = request.getInstanceContextConfiguration();
            ILocationInfo location = request.getLocation();
            this.populateGrabContext(pInst, grabInstanceContext, location, configuration, context.getLocale());
        }
        catch (Exception exc) {
            BPMLogger.log((LoggerComponent)LoggerComponent.COMPONENT_INSTANCE_QUERY_SERVICE, (Severity)Severity.ERRORS, (Throwable)exc);
            throw new BPMException(70411, null, (Throwable)exc);
        }
        return GrabTreeInstanceContextResponse.create(flowChangeItems, (GrabInstanceContext)grabInstanceContext, (boolean)wasInstanceSuspended);
    }

    private void populateGrabContext(IProcessInstance instance, GrabInstanceContext grabInstanceContext, ILocationInfo location, IInstanceContextConfiguration configuration, Locale locale) throws InstanceHandlingException {
        ArrayList<oracle.bpm.bpmn.engine.model.runtime.instancehandling.ProcessInstance> processInstances = new ArrayList<oracle.bpm.bpmn.engine.model.runtime.instancehandling.ProcessInstance>(1);
        oracle.bpm.bpmn.engine.model.runtime.instancehandling.ProcessInstance processInstance = InstanceManagementService.adaptInstance(instance);
        processInstances.add(processInstance);
        HashMap<Long, String> scopeIds = new HashMap<Long, String>(1);
        scopeIds.put(processInstance.getInstanceId(), ((LocationInfo)location).getAbsoluteScopeId());
        Map instanceContextNodes = this.getBpmnInstanceManager().getInstanceContextNodes(processInstances, scopeIds, configuration, locale);
        assert (instanceContextNodes.size() == 1);
        InstanceContextNode node = (InstanceContextNode)instanceContextNodes.values().iterator().next();
        this._populateGrabContext(grabInstanceContext, node);
    }

    private void populateGrabContext(IProcessInstance instance, GrabInstanceContext grabInstanceContext, IOpenActivityInfo openActivity, Locale locale, IInstanceContextConfiguration configuration) throws InstanceHandlingException {
        ArrayList<oracle.bpm.bpmn.engine.model.runtime.instancehandling.ProcessInstance> processInstances = new ArrayList<oracle.bpm.bpmn.engine.model.runtime.instancehandling.ProcessInstance>(1);
        oracle.bpm.bpmn.engine.model.runtime.instancehandling.ProcessInstance processInstance = InstanceManagementService.adaptInstance(instance);
        processInstances.add(processInstance);
        HashMap<Long, OpenActivityInfo> openActivities = new HashMap<Long, OpenActivityInfo>(1);
        openActivities.put(processInstance.getInstanceId(), (OpenActivityInfo)openActivity);
        Map instanceContextNodes = this.getBpmnInstanceManager().findGrabInstanceContextForActivity(processInstances, openActivities, configuration, locale);
        assert (instanceContextNodes.size() == 1);
        InstanceContextNode node = (InstanceContextNode)instanceContextNodes.values().iterator().next();
        this._populateGrabContext(grabInstanceContext, node);
    }

    private void _populateGrabContext(GrabInstanceContext grabInstanceContext, InstanceContextNode node) {
        this.populateGrabContextVariables(grabInstanceContext, node);
        this.populateGrabContextLocation(grabInstanceContext, node);
        this.populateGrabContextContainerActivities(grabInstanceContext, node);
        this.populateGrabContextChildren(grabInstanceContext, node);
    }

    private void populateGrabContextContainerActivities(GrabInstanceContext grabInstanceContext, InstanceContextNode node) {
        HashSet<IOpenActivityInfo> containers = new HashSet<IOpenActivityInfo>(node.getContainerActivities().size());
        this.populateExistingActivities(containers, node.getContainerActivities());
        grabInstanceContext.setAvailableContainerActivities(containers);
    }

    private void populateExistingActivities(Set<IOpenActivityInfo> containers, Collection<Activity> availableContainerActivities) {
        for (Activity containerActivity : availableContainerActivities) {
            containers.add(this.createOpenActivity(containerActivity));
        }
    }

    private IOpenActivityInfo createOpenActivity(Activity activity) {
        ActivityPathInfo path = this.createActivityPath(activity.getPath());
        HashSet<IVariableItem> attributes = new HashSet<IVariableItem>();
        this.populateExistingVariables(attributes, activity.getAttributes());
        return OpenActivityInfo.create((String)activity.getId(), (String)activity.getDisplayName(), (boolean)activity.isContainer(), (ActivityPathInfo)path, attributes);
    }

    private void populateGrabContextChildren(GrabInstanceContext grabInstanceContext, InstanceContextNode node) {
        for (InstanceContextNode childContextNode : node.getChildren()) {
            GrabInstanceContext child = GrabInstanceContext.create();
            child.setParentGrabInstanceContext((IGrabInstanceContext)grabInstanceContext);
            grabInstanceContext.addChildGrabInstanceContext((IGrabInstanceContext)child);
            this._populateGrabContext(child, childContextNode);
        }
    }

    private void populateGrabContextLocation(GrabInstanceContext grabInstanceContext, InstanceContextNode contextNode) {
        Activity nodeActivity = contextNode.getActivity();
        IActivityInfo nodeActivityInfo = ActivityInfo.create((String)nodeActivity.getId(), (String)nodeActivity.getDisplayName(), (String)nodeActivity.getProcessId());
        HashSet<IVariableItem> attributes = new HashSet<IVariableItem>();
        this.populateExistingVariables(attributes, nodeActivity.getAttributes());
        ProcessInstanceInfo instanceInfo = ProcessInstanceInfo.create((long)contextNode.getProcessInstance().getInstanceId(), (int)contextNode.getProcessInstance().getThread());
        grabInstanceContext.setLocationInfo((ILocationInfo)LocationInfo.create((String)contextNode.getAbsoluteScopeId(), (IActivityInfo)nodeActivityInfo, (Boolean)contextNode.isProcessContext(), attributes, (ProcessInstanceInfo)instanceInfo));
    }

    private void populateGrabContextVariables(GrabInstanceContext grabInstanceContext, InstanceContextNode stateNode) {
        InstanceVariableContainer container = stateNode.getContainer();
        HashSet<IVariableItem> dataObjects = new HashSet<IVariableItem>(container.getDataObjects().size());
        HashSet<IVariableItem> instanceAttributes = new HashSet<IVariableItem>(container.getInstanceAttributes().size());
        HashSet<ICorrelationKeyItem> correlationKeys = new HashSet<ICorrelationKeyItem>(container.getCorrelationKeys().size());
        this.populateExistingVariables(dataObjects, container.getDataObjects());
        this.populateExistingVariables(instanceAttributes, container.getInstanceAttributes());
        this.populateCorrelationKeys(correlationKeys, container.getCorrelationKeys());
        grabInstanceContext.setAvailableVariables(dataObjects);
        grabInstanceContext.setAvailableInstanceAttributes(instanceAttributes);
        grabInstanceContext.setAvailableCorrelationKeys(correlationKeys);
    }

    private void populateFlowChanges(IBPMContext context, IProcessInstance instance, Set<IFlowChangeItem> flowChangeItems, IInstanceContextConfiguration configuration) throws InstanceHandlingException {
        String compositeDN = instance.getSca().getCompositeDN();
        String componentName = instance.getSca().getComponentName();
        ComponentDN componentDN = new ComponentDN(compositeDN, componentName);
        ArrayList<oracle.bpm.bpmn.engine.model.runtime.instancehandling.ProcessInstance> processInstances = new ArrayList<oracle.bpm.bpmn.engine.model.runtime.instancehandling.ProcessInstance>(1);
        processInstances.add(InstanceManagementService.adaptInstance(instance));
        if (configuration.includeOpenActivities().booleanValue()) {
            Map sourcesActivities = this.getBpmnInstanceManager().getOpenActivities(processInstances, configuration, context.getLocale());
            assert (sourcesActivities.size() == 1);
            for (Activity sourceActivity : (Set)sourcesActivities.values().iterator().next()) {
                Activity srcActivity = Activity.create((String)sourceActivity.getProcessId(), (String)sourceActivity.getId(), (String)sourceActivity.getDisplayName());
                Set targets = this.getBpmnInstanceManager().getValidTargets(componentDN, srcActivity, context.getLocale());
                IFlowChangeItem flowChangeItem = this.createFlowChangeItem(sourceActivity, targets);
                flowChangeItems.add(flowChangeItem);
            }
        }
    }

    @Deprecated
    private IGrabInstanceContextResponse createGrabFlattenInstanceContext(IBPMContext context, IGrabInstanceContextRequest request) throws BPMException {
        HashSet<IFlowChangeItem> flowChangeItems = new HashSet<IFlowChangeItem>();
        HashSet<IVariableItem> availableVariables = new HashSet<IVariableItem>();
        HashSet<IVariableItem> instanceAttributes = new HashSet<IVariableItem>();
        HashSet<ICorrelationKeyItem> correlationKeys = new HashSet<ICorrelationKeyItem>();
        boolean suspendInstanceIfRequired = request.isSuspendInstanceIfRequired();
        boolean wasInstanceSuspended = false;
        try {
            IProcessInstance pInst = request.getProcessInstance();
            wasInstanceSuspended = this.suspendInstance(suspendInstanceIfRequired, wasInstanceSuspended, pInst);
            this.populateFlowChanges(context, pInst, flowChangeItems);
            this.populateInstanceState(context, pInst, availableVariables, instanceAttributes, correlationKeys);
        }
        catch (Exception exc) {
            BPMLogger.log((LoggerComponent)LoggerComponent.COMPONENT_INSTANCE_QUERY_SERVICE, (Severity)Severity.ERRORS, (Throwable)exc);
            throw new BPMException(70411, null, (Throwable)exc);
        }
        return GrabInstanceContextResponse.create(flowChangeItems, availableVariables, instanceAttributes, correlationKeys, (boolean)wasInstanceSuspended);
    }

    private boolean suspendInstance(boolean suspendInstanceIfRequired, boolean wasInstanceSuspended, IProcessInstance pInst) throws InstanceHandlingException {
        if (suspendInstanceIfRequired && (wasInstanceSuspended = this.getBpmnInstanceManager().suspendInstance(InternalInstanceManagementService.getCubeInstanceId((IProcessInstance)pInst)))) {
            pInst.getSystemAttributes().setState("SUSPENDED");
        }
        return wasInstanceSuspended;
    }

    private IFlowChangeItem createFlowChangeItem(Activity srcActivity, Set<Activity> targetActivities) {
        IOpenActivityInfo sourceActivityInfo = this.createOpenActivity(srcActivity);
        HashSet<IActivityInfo> validGrabTargetActivities = new HashSet<IActivityInfo>();
        for (Activity target : targetActivities) {
            IActivityInfo targetActivity = ActivityInfo.create((String)target.getId(), (String)target.getDisplayName(), (String)target.getProcessId());
            validGrabTargetActivities.add(targetActivity);
        }
        return FlowChangeItem.create((IOpenActivityInfo)sourceActivityInfo, validGrabTargetActivities);
    }

    private ActivityPathInfo createActivityPath(ActivityPath path) {
        ActivityPathInfo.Builder builder = new ActivityPathInfo.Builder();
        for (Tuple3 tuple : path) {
            Activity activity = (Activity)tuple.getSecond();
            IActivityInfo activityInfo = ActivityInfo.create((String)activity.getId(), (String)activity.getDisplayName(), (String)activity.getProcessId());
            HashSet<IVariableItem> attributes = new HashSet<IVariableItem>();
            this.populateExistingVariables(attributes, activity.getAttributes());
            oracle.bpm.bpmn.engine.model.runtime.instancehandling.ProcessInstance instance = (oracle.bpm.bpmn.engine.model.runtime.instancehandling.ProcessInstance)tuple.getThird();
            ProcessInstanceInfo instanceInfo = ProcessInstanceInfo.create((long)instance.getInstanceId(), (int)instance.getThread());
            builder.addLocationInfo(activityInfo, (String)tuple.getFirst(), attributes, instanceInfo);
        }
        return builder.build();
    }

    private void populateFlowChanges(IBPMContext context, IProcessInstance processInstance, Set<IFlowChangeItem> flowChangeItems) throws Exception {
        String callbackContext;
        String compositeDN = processInstance.getSca().getCompositeDN();
        String componentName = processInstance.getSca().getComponentName();
        ComponentDN componentDN = new ComponentDN(compositeDN, componentName);
        oracle.fabric.composite.CompositeDN compositeDNObj = new oracle.fabric.composite.CompositeDN(compositeDN);
        FabricMesh fabricMesh = this.getMesh();
        CompositeModel compositeModel = fabricMesh.getComposite(compositeDN);
        Project bpmProject = BPMNServiceEngine.getDeployedProjectServiceImpl().findProject(compositeDNObj, compositeModel);
        ArrayList<IProcessInstance> parallelInstances = new ArrayList<IProcessInstance>();
        if (processInstance.getSystemAttributes().getThread() == 0) {
            parallelInstances.addAll(this.queryParallelInstances(context, processInstance, new ArrayList<Column>()));
        }
        if ((callbackContext = processInstance.getCallback().getContext()) != null && !callbackContext.equals("COMPLETED") || callbackContext == null && parallelInstances.isEmpty()) {
            parallelInstances.add(processInstance);
        }
        for (IProcessInstance instance : parallelInstances) {
            String displayName;
            String activityId;
            FlowNode sourceActivity;
            String processName = instance.getProcessName();
            Process bpmProcess = bpmProject.findProcess(processName);
            Process newBPMProcess = null;
            if (compositeModel == null) {
                CompositeModel model = fabricMesh.getComposite(SOAUtil.getCompositeDNWithoutLabel((String)compositeDN));
                Project newBPMProject = BPMNServiceEngine.getDeployedProjectServiceImpl().findProject(new oracle.fabric.composite.CompositeDN(model.getDN()), model);
                newBPMProcess = newBPMProject.findProcess(processName);
            }
            if ((sourceActivity = ModelUtils.findFlowNode((Process)bpmProcess, (String)(activityId = instance.getSystemAttributes().getActivityId()))) == null && newBPMProcess != null) {
                sourceActivity = ModelUtils.findFlowNode(newBPMProcess, (String)activityId);
            }
            Activity srcActivity = Activity.create((String)processName, (String)activityId);
            Set targets = this.getBpmnInstanceManager().getValidTargets(componentDN, srcActivity, context.getLocale());
            if (sourceActivity != null) {
                displayName = sourceActivity.getLabel(context.getLocale());
                if (displayName.isEmpty()) {
                    displayName = sourceActivity.getDefaultLabel();
                }
            } else {
                displayName = sourceActivity.getName();
            }
            IActivityInfo sourceActivityInfo = ActivityInfo.create((String)activityId, (String)displayName, (String)processName);
            HashSet<IActivityInfo> validGrabTargetActivities = new HashSet<IActivityInfo>();
            for (Activity target : targets) {
                IActivityInfo targetActivity = ActivityInfo.create((String)target.getId(), (String)target.getDisplayName(), (String)processName);
                validGrabTargetActivities.add(targetActivity);
            }
            FlowChangeItem item = FlowChangeItem.create((IActivityInfo)sourceActivityInfo, validGrabTargetActivities);
            flowChangeItems.add((IFlowChangeItem)item);
        }
    }

    private FabricMesh getMesh() {
        return BPMNServiceEngine.getInstance().getMesh();
    }

    private void populateInstanceState(IBPMContext context, IProcessInstance processInstance, Set<IVariableItem> dataObjects, Set<IVariableItem> instanceAttributes, Set<ICorrelationKeyItem> correlationKeys) throws Exception {
        Long longObj = new Long(processInstance.getSystemAttributes().getProcessInstanceId());
        ArrayList<oracle.bpm.bpmn.engine.model.runtime.instancehandling.ProcessInstance> parallelInstances = new ArrayList<oracle.bpm.bpmn.engine.model.runtime.instancehandling.ProcessInstance>();
        InstanceManagementService.addParallelInstances(context, processInstance, parallelInstances, this);
        Map map = this.getBpmnInstanceManager().getVariableValue(parallelInstances);
        for (InstanceVariableContainer container : map.values()) {
            this.populateExistingVariables(dataObjects, container.getDataObjects());
            this.populateExistingVariables(instanceAttributes, container.getInstanceAttributes());
            this.populateCorrelationKeys(correlationKeys, container.getCorrelationKeys());
        }
    }

    private void populateExistingVariables(Set<IVariableItem> variablesToFill, Set<Variable> values) {
        for (Variable var : values) {
            String varName = var.getName();
            Object varValue = var.getValue();
            QName type = var.getType();
            String value = this.getStringValue(varValue);
            VariableItem varItem = VariableItem.create((String)varName, (QName)type, (String)value, (boolean)var.isEditable());
            variablesToFill.add((IVariableItem)varItem);
        }
    }

    private void populateCorrelationKeys(Set<ICorrelationKeyItem> correlationKeysToFill, Set<CorrelationKey> values) {
        for (CorrelationKey correlationKey : values) {
            String correlationKeyName = correlationKey.getName();
            HashSet<CorrelationKeyProperty> properties = new HashSet<CorrelationKeyProperty>();
            for (CorrelationProperty correlationProperty : correlationKey.getProperties()) {
                QName name = correlationProperty.getName();
                Object varValue = correlationProperty.getValue();
                String strValue = this.getStringValue(varValue);
                properties.add(CorrelationKeyProperty.create((QName)name, (String)strValue));
            }
            CorrelationKeyItem correlationKeyItem = CorrelationKeyItem.createForRead((String)correlationKeyName, properties, (boolean)correlationKey.isInitiated());
            correlationKeysToFill.add((ICorrelationKeyItem)correlationKeyItem);
        }
    }

    private String getStringValue(Object varValue) {
        String value = varValue instanceof Node ? XMLUtil.toString((Node)((Node)varValue)) : (varValue == null ? "" : varValue.toString());
        return value;
    }

    private Map<String, String> traverseActivities(Sequence<FlowNode> activities, Map<String, String> result) {
        for (FlowNode activity : activities) {
            BpmnType sourceSubType = activity.getBpmnType();
            String activityType = sourceSubType == null ? "PROCESS" : sourceSubType.toString();
            result.put(activity.getId(), activityType);
            if (!"SUBPROCESS".equals(activityType)) continue;
            result = this.traverseActivities((Sequence<FlowNode>)((Subprocess)activity).getFlowNodes(), result);
        }
        return result;
    }

    private IProcessModelPackage loadProcessModel(String compositeDN, String componentName) throws Exception {
        CompositeDN cDn = new CompositeDN(compositeDN);
        Locator locator = (Locator)LocatorFactory.createLocator();
        String processModelXml = (String)locator.executeComponentMethod(cDn, componentName, "getBPMNProcessModel", null);
        return ProcessModelLoader.create().unmarshall(processModelXml);
    }

    private List<IProcessInstance> queryInstances(IBPMContext context, List<Column> displayColumns, Predicate predicate, Ordering ordering, IInstanceQueryInput queryInput, boolean includeParallelThreads) throws BPMException {
        BPMLogger.log((LoggerComponent)LoggerComponent.COMPONENT_INSTANCE_QUERY_SERVICE, (Severity)Severity.DEBUG, (String)logClassName, (String)"queryProcessInstances", (String)"Start of queryProcessInstances");
        try {
            Predicate currentPredicate = this.getCurrentPredicate(context, predicate, queryInput, includeParallelThreads);
            Predicate historicPredicate = this.getHistoricPredicate(context, null, queryInput.getAssignmentFilter());
            int startRow = queryInput.getStartRow();
            int endRow = queryInput.getEndRow();
            List<IProcessInstance> processInstances = this.doPersistencyServiceQuery(context, displayColumns, currentPredicate, historicPredicate, ordering, startRow, endRow, includeParallelThreads);
            BPMLogger.log((LoggerComponent)LoggerComponent.COMPONENT_INSTANCE_QUERY_SERVICE, (Severity)Severity.DEBUG, (String)logClassName, (String)"queryProcessInstances", (String)"End of queryProcessInstances");
            return processInstances;
        }
        catch (Exception exc) {
            BPMLogger.log((LoggerComponent)LoggerComponent.COMPONENT_INSTANCE_QUERY_SERVICE, (Severity)Severity.ERRORS, (Throwable)exc);
            throw new BPMException(70400, null, (Throwable)exc);
        }
    }

    private List<IProcessInstance> queryViewInstances(IBPMContext context, String viewId, Predicate extraPredicate, Ordering ordering, int startRow, int endRow, boolean includeParallelThreads) throws BPMException {
        BPMLogger.log((LoggerComponent)LoggerComponent.COMPONENT_INSTANCE_QUERY_SERVICE, (Severity)Severity.DEBUG, (String)logClassName, (String)"queryViewInstances", (String)("Start of queryViewInstances for view id " + viewId + ", includeParallelThreads: " + includeParallelThreads));
        try {
            UserViewDetailType view = this.getUserViewDetail((IWorkflowContext)context, viewId);
            PresentationType presentation = this.getViewPresentation(view);
            Predicate currentPredicate = this.getCurrentViewPredicate(context, view, includeParallelThreads);
            currentPredicate = this.combinePredicates(currentPredicate, extraPredicate);
            Predicate historicPredicate = this.getHistoricViewPredicate(context, view);
            List<Column> displayColumns = this.getViewDisplayColumns(view, presentation);
            if (ordering == null) {
                ordering = this.getViewOrdering(view, presentation);
            }
            List<IProcessInstance> processInstances = this.doPersistencyServiceQuery(context, displayColumns, currentPredicate, historicPredicate, ordering, startRow, endRow, includeParallelThreads);
            BPMLogger.log((LoggerComponent)LoggerComponent.COMPONENT_INSTANCE_QUERY_SERVICE, (Severity)Severity.DEBUG, (String)logClassName, (String)"queryViewInstances", (String)"End of queryViewInstances");
            return processInstances;
        }
        catch (BPMException bpe) {
            throw bpe;
        }
        catch (Exception exc) {
            BPMLogger.log((LoggerComponent)LoggerComponent.COMPONENT_INSTANCE_QUERY_SERVICE, (Severity)Severity.ERRORS, (Throwable)exc);
            throw new BPMException(70400, null, (Throwable)exc);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<IProcessInstance> doPersistencyServiceQuery(IBPMContext context, List<Column> displayColumns, Predicate currentPredicate, Predicate historicPredicate, Ordering ordering, int startRow, int endRow, boolean includeParallelThreads) throws Exception {
        ArrayList<IProcessInstance> arrayList;
        IPersistencyService service = null;
        Locale locale = context.getLocale();
        try {
            if (ordering == null) {
                ordering = new Ordering(IColumnConstants.PROCESS_NUMBER_COLUMN, true, true);
            }
            this.addManadatoryColumns(displayColumns);
            PagingObject pagingObject = new PagingObject(startRow, endRow);
            startRow = pagingObject.getStartRow();
            endRow = pagingObject.getEndRow();
            service = PersistencyDriver.getInstance();
            context.setLocale(Locale.getDefault());
            Predicate queryPredicate = this.addHistorySubqueries(currentPredicate, historicPredicate, includeParallelThreads);
            List taskList = service.getWFTask((IWorkflowContext)context, displayColumns, queryPredicate, ordering, startRow, endRow);
            ArrayList<IProcessInstance> processInstances = new ArrayList<IProcessInstance>(taskList.size());
            for (Object object : taskList) {
                Task itask = (Task)object;
                ProcessInstance pInstance = new ProcessInstance(itask);
                processInstances.add((IProcessInstance)pInstance);
            }
            arrayList = processInstances;
        }
        catch (Throwable throwable) {
            InstanceQueryService.closeService(service);
            context.setLocale(locale);
            throw throwable;
        }
        InstanceQueryService.closeService(service);
        context.setLocale(locale);
        return arrayList;
    }

    private Predicate getPredicateForOrgUnitBasedVisibility(IBPMContext ctx) throws WorkflowException {
        PredicateImpl predicateForOrgUnitBasedVisibility = null;
        if (!ctx.getIsAdmin()) {
            List organizationalUnitIds;
            predicateForOrgUnitBasedVisibility = new PredicateImpl(TableConstants.WFTASK_ORGANIZATIONALUNITID_COLUMN, 21, (Object)null);
            if (WorkflowUtil.getInternalOrganizationService() != null && (organizationalUnitIds = VerificationService.getOrganizationalUnits((IBPMContext)ctx)) != null && organizationalUnitIds.size() > 0) {
                predicateForOrgUnitBasedVisibility.addClause(8, TableConstants.WFTASK_ORGANIZATIONALUNITID_COLUMN, 9, organizationalUnitIds);
            }
        }
        return predicateForOrgUnitBasedVisibility;
    }

    private List<IProcessInstanceUser> convertMapToProcessIdentityType(List<Task> input) {
        ArrayList<IProcessInstanceUser> output = new ArrayList<IProcessInstanceUser>();
        for (int i = 0; i < input.size(); ++i) {
            Task task = input.get(i);
            SystemAttributesType syAttr = task.getSystemAttributes();
            String userName = null;
            String userDName = null;
            oracle.bpel.services.workflow.task.model.IdentityType updatedBy = syAttr.getUpdatedBy();
            if (updatedBy != null && !updatedBy.getId().equals("workflowsystem")) {
                userName = updatedBy.getId();
                userDName = updatedBy.getDisplayName();
            } else {
                userName = task.getCreator();
            }
            if (userName == null || userName.equals("") || userName.equals("workflowsystem")) continue;
            String appContext = task.getApplicationContext();
            String idContext = task.getIdentityContext();
            ProcessInstanceUser processUser = null;
            for (int k = 0; k < output.size(); ++k) {
                IProcessInstanceUser user = (IProcessInstanceUser)output.get(k);
                if (!user.getName().equals(userName)) continue;
                processUser = user;
                break;
            }
            if (processUser == null) {
                processUser = new ProcessInstanceUser(userName, userDName, appContext, idContext);
                output.add((IProcessInstanceUser)processUser);
            }
            List assignees = syAttr.getAssignees();
            for (int j = 0; j < assignees.size(); ++j) {
                oracle.bpel.services.workflow.task.model.IdentityType identity = (oracle.bpel.services.workflow.task.model.IdentityType)assignees.get(j);
                String type = identity.getType();
                IdentityType cType = new IdentityType(identity);
                if (type.equals("group")) {
                    processUser.getGroups().add(cType);
                    continue;
                }
                if (!type.equals("application_role")) continue;
                processUser.getRoles().add(cType);
            }
        }
        return output;
    }

    private void addManadatoryColumns(List<Column> displayColumns) {
        if (displayColumns.size() == 0) {
            displayColumns.addAll(sColumnList);
            return;
        }
        if (!displayColumns.contains(IColumnConstants.PROCESS_INSTANCEID_COLUMN)) {
            displayColumns.add(IColumnConstants.PROCESS_INSTANCEID_COLUMN);
        }
        if (!displayColumns.contains(IColumnConstants.PROCESS_NUMBER_COLUMN)) {
            displayColumns.add(IColumnConstants.PROCESS_NUMBER_COLUMN);
        }
        if (!displayColumns.contains(IColumnConstants.PROCESS_THREAD_COLUMN)) {
            displayColumns.add(IColumnConstants.PROCESS_THREAD_COLUMN);
        }
        if (!displayColumns.contains(IColumnConstants.PROCESS_PARENTTHREAD_COLUMN)) {
            displayColumns.add(IColumnConstants.PROCESS_PARENTTHREAD_COLUMN);
        }
        if (!displayColumns.contains(IColumnConstants.PROCESS_STEP_COLUMN)) {
            displayColumns.add(IColumnConstants.PROCESS_STEP_COLUMN);
        }
        if (!displayColumns.contains(IColumnConstants.PROCESS_COMPONENTTYPE_COLUMN)) {
            displayColumns.add(IColumnConstants.PROCESS_COMPONENTTYPE_COLUMN);
        }
        if (!displayColumns.contains(IColumnConstants.PROCESS_VERSION_COLUMN)) {
            displayColumns.add(IColumnConstants.PROCESS_VERSION_COLUMN);
        }
        if (!displayColumns.contains(IColumnConstants.PROCESS_PROCESSDEFINITIONID_COLUMN)) {
            displayColumns.add(IColumnConstants.PROCESS_PROCESSDEFINITIONID_COLUMN);
        }
    }

    private Predicate getCurrentPredicate(IBPMContext context, Predicate predicate, IInstanceQueryInput input, boolean includeParallelThreads) throws Exception {
        PredicateImpl statePredicate;
        IInstanceQueryInput.AssignmentFilter filter = input.getAssignmentFilter();
        Predicate currentPredicate = this.getPredicateForOrgUnitBasedVisibility(context);
        List states = input.getStates();
        if (!IInstanceQueryInput.AssignmentFilter.PREVIOUS.equals((Object)filter)) {
            Predicate assigneerPredicate = InstanceQueryService.getAssigneePredicate(context, filter);
            if (!(states == null || states.isEmpty() || IInstanceQueryInput.AssignmentFilter.ALL.equals((Object)filter) || IInstanceQueryInput.AssignmentFilter.OWNER.equals((Object)filter))) {
                statePredicate = new PredicateImpl(IColumnConstants.PROCESS_STATE_COLUMN, 9, states);
                statePredicate.addClause(7, TableConstants.WFTASK_TASKID_COLUMN, 0, TableConstants.ASSIGNEE_TASKID_COLUMN);
                assigneerPredicate = this.combinePredicates(assigneerPredicate, (Predicate)statePredicate);
            }
            currentPredicate = this.combinePredicates(currentPredicate, assigneerPredicate);
        }
        Predicate searchPredicate = this.getSearchPredicate(input.getKeyword());
        currentPredicate = this.combinePredicates(currentPredicate, searchPredicate);
        if ((currentPredicate = this.combinePredicates(currentPredicate, predicate)) == null) {
            currentPredicate = new PredicateImpl(IColumnConstants.PROCESS_COMPONENTTYPE_COLUMN, 0, (Object)"BPMN");
        } else {
            currentPredicate.addClause(7, IColumnConstants.PROCESS_COMPONENTTYPE_COLUMN, 0, (Object)"BPMN");
        }
        if (!includeParallelThreads) {
            currentPredicate.addClause(7, IColumnConstants.PROCESS_THREAD_COLUMN, 0, (Object)Integer.parseInt("0"));
        }
        if (states != null && !states.isEmpty()) {
            statePredicate = new PredicateImpl(IColumnConstants.PROCESS_STATE_COLUMN, 9, states);
            statePredicate.addClause(7, TableConstants.WFTASK_TASKID_COLUMN, 0, TableConstants.WFTASKTL_TASKID_COLUMN);
            currentPredicate = this.combinePredicates(currentPredicate, (Predicate)statePredicate);
        }
        return currentPredicate;
    }

    private Predicate getHistoricPredicate(IBPMContext context, Predicate predicate, IInstanceQueryInput.AssignmentFilter filter) throws Exception {
        Predicate historicPredicate = null;
        if (IInstanceQueryInput.AssignmentFilter.PREVIOUS.equals((Object)filter)) {
            historicPredicate = InstanceQueryService.getAssigneePredicate(context, filter);
        }
        historicPredicate = this.combinePredicates(historicPredicate, predicate);
        return historicPredicate;
    }

    private Predicate getCurrentViewPredicate(IBPMContext context, UserViewDetailType view, boolean includeParallelThreads) throws Exception {
        TaskPredicateType viewQueryInfo = view.getViewPredicate();
        ITaskQueryService.AssignmentFilter filter = QueryUtil.getAssignmentFilterEnum((String)viewQueryInfo.getAssignmentFilter());
        Predicate currentPredicate = this.getPredicateForOrgUnitBasedVisibility(context);
        if (!ITaskQueryService.AssignmentFilter.PREVIOUS.equals((Object)filter)) {
            currentPredicate = TaskQueryService.getAssignmentFilterPredicate((IWorkflowContext)context, (ITaskQueryService.AssignmentFilter)filter);
        }
        Predicate searchPredicate = this.getSearchPredicate(viewQueryInfo.getKeywords());
        currentPredicate = this.combinePredicates(currentPredicate, searchPredicate);
        Predicate viewPredicate = QueryUtil.getPredicateFromPredicateType((TaskPredicateType)viewQueryInfo);
        if ((currentPredicate = this.combinePredicates(currentPredicate, viewPredicate)) != null) {
            currentPredicate.addClause(7, IColumnConstants.PROCESS_COMPONENTTYPE_COLUMN, 0, (Object)"BPMN");
            if (!includeParallelThreads) {
                currentPredicate.addClause(7, IColumnConstants.PROCESS_THREAD_COLUMN, 0, (Object)Integer.parseInt("0"));
            }
        }
        return currentPredicate;
    }

    private Predicate getHistoricViewPredicate(IBPMContext context, UserViewDetailType view) throws Exception {
        TaskPredicateType viewQueryInfo = view.getViewPredicate();
        ITaskQueryService.AssignmentFilter filter = QueryUtil.getAssignmentFilterEnum((String)viewQueryInfo.getAssignmentFilter());
        PredicateImpl historicPredicate = null;
        if (ITaskQueryService.AssignmentFilter.PREVIOUS.equals((Object)filter)) {
            historicPredicate = TaskQueryService.getAssignmentFilterPredicate((IWorkflowContext)context, (ITaskQueryService.AssignmentFilter)filter);
        }
        Predicate viewHistoryPredicate = null;
        PredicateType predicateType = view.getViewHistoryPredicate();
        if (predicateType != null) {
            viewHistoryPredicate = new Predicate(predicateType);
        }
        historicPredicate = this.combinePredicates((Predicate)historicPredicate, viewHistoryPredicate);
        return historicPredicate;
    }

    private Predicate addHistorySubqueries(Predicate currentPredicate, Predicate historyPredicate, boolean includeParallelThreads) throws WorkflowException {
        PredicateImpl mainQuery = PredicateImpl.getPredicateImpl((Predicate)currentPredicate);
        PredicateImpl historyQuery = PredicateImpl.getPredicateImpl((Predicate)historyPredicate);
        if (historyQuery != null) {
            PredicateImpl subQuery = PredicateImpl.wrapAsInSubquery((Column)IColumnConstants.PROCESS_ID_COLUMN, (Column)IColumnConstants.PROCESSHISTORY_INSTANCEID_COLUMN, (Predicate)historyQuery, null);
            if (includeParallelThreads) {
                PredicateImpl parallelThreadPred = new PredicateImpl(IColumnConstants.PROCESSHISTORY_THREAD_COLUMN, 1, (Object)0);
                PredicateImpl parallelThreadQuery = new PredicateImpl((Predicate)historyQuery, 7, (Predicate)parallelThreadPred);
                PredicateImpl parallelThreadSubQuery = PredicateImpl.wrapAsInSubquery((Column)IColumnConstants.PROCESS_ID_COLUMN, (Column)PROCESSHISTORY_PROCESSID_COMPOSITE_COL, (Predicate)parallelThreadQuery, null);
                subQuery = new PredicateImpl((Predicate)subQuery, 8, (Predicate)parallelThreadSubQuery);
            }
            mainQuery = mainQuery != null ? new PredicateImpl((Predicate)mainQuery, 7, (Predicate)subQuery) : subQuery;
        }
        return mainQuery;
    }

    private List<Column> getViewDisplayColumns(UserViewDetailType view, PresentationType presentation) throws Exception {
        List<Column> displayColumns = new ArrayList<Column>();
        ColumnListType columnListType = null;
        columnListType = presentation != null ? presentation.getColumns() : view.getViewColumns();
        if (columnListType != null) {
            List colTypes = columnListType.getColumn();
            for (ColumnType colType : colTypes) {
                Column column = Column.getColumn((String)colType.getColumnName());
                if (column == null) continue;
                displayColumns.add(column);
            }
        }
        displayColumns = this.addDefaultDisplayColumns(displayColumns);
        return displayColumns;
    }

    private List<Column> addDefaultDisplayColumns(List<Column> currentColumns) throws Exception {
        for (Column defalutDisplayColumn : sDefaultProcessInstanceColumns) {
            if (currentColumns.contains(defalutDisplayColumn)) continue;
            currentColumns.add(defalutDisplayColumn);
        }
        return currentColumns;
    }

    private Ordering getViewOrdering(UserViewDetailType view, PresentationType presentation) throws Exception {
        Ordering ordering = null;
        TaskOrderingType orderingType = null;
        orderingType = presentation != null ? presentation.getOrdering() : view.getViewOrdering();
        if (orderingType != null) {
            List orderingClause = orderingType.getClause();
            ordering = QueryUtil.getOrderingFromOrderingClause((List)orderingClause);
        }
        return ordering;
    }

    private Predicate getSearchPredicate(String keywords) throws Exception {
        String textAttribNumber;
        int i;
        String textAttribNumberPrefix;
        String textAttribColumnName;
        PredicateImpl searchPredicate = null;
        if (keywords == null || keywords.trim().equals("")) {
            return searchPredicate;
        }
        String searchTerm = "%" + keywords.trim() + "%";
        searchPredicate = new PredicateImpl(IColumnConstants.PROCESS_TITLE_COLUMN, 6, (Object)searchTerm, true);
        searchPredicate.addClause(8, IColumnConstants.PROCESS_ACTIVITYNAME_COLUMN, 6, (Object)searchTerm, true);
        searchPredicate.addClause(8, IColumnConstants.PROCESS_ACTIVITYID_COLUMN, 6, (Object)searchTerm, true);
        searchPredicate.addClause(8, IColumnConstants.PROCESS_PROCESSNAME_COLUMN, 6, (Object)searchTerm, true);
        String textAttribColumnPrefix = "textAttribute";
        for (int i2 = 1; i2 <= 20; ++i2) {
            textAttribColumnName = textAttribColumnPrefix + i2;
            searchPredicate.addClause(8, Column.getColumn((String)textAttribColumnName), 6, (Object)searchTerm, true);
        }
        try {
            Integer taskNum = Integer.valueOf(keywords);
            searchPredicate.addClause(8, IColumnConstants.PROCESS_NUMBER_COLUMN, 0, (Object)taskNum);
            textAttribNumberPrefix = "numberAttribute";
            for (i = 1; i <= 10; ++i) {
                textAttribNumber = textAttribNumberPrefix + i;
                searchPredicate.addClause(8, Column.getColumn((String)textAttribNumber), 0, (Object)taskNum, true);
            }
        }
        catch (NumberFormatException nfe) {
            // empty catch block
        }
        textAttribColumnPrefix = "protectedTextAttribute";
        for (int i3 = 1; i3 <= 20; ++i3) {
            textAttribColumnName = textAttribColumnPrefix + i3;
            searchPredicate.addClause(8, Column.getColumn((String)textAttribColumnName), 6, (Object)searchTerm, true);
        }
        try {
            Integer taskNum = Integer.valueOf(keywords);
            searchPredicate.addClause(8, IColumnConstants.PROCESS_NUMBER_COLUMN, 0, (Object)taskNum);
            textAttribNumberPrefix = "protectedNumberAttribute";
            for (i = 1; i <= 10; ++i) {
                textAttribNumber = textAttribNumberPrefix + i;
                searchPredicate.addClause(8, Column.getColumn((String)textAttribNumber), 0, (Object)taskNum, true);
            }
        }
        catch (NumberFormatException nfe) {
            // empty catch block
        }
        return searchPredicate;
    }

    private Predicate combinePredicates(Predicate firstPredicate, Predicate secondPredicate) throws WorkflowException {
        PredicateImpl firstPredicateImpl;
        PredicateImpl combinedPredicate = firstPredicateImpl = PredicateImpl.getPredicateImpl((Predicate)firstPredicate);
        if (secondPredicate != null) {
            PredicateImpl secondPredicateImpl = PredicateImpl.getPredicateImpl((Predicate)secondPredicate);
            combinedPredicate = firstPredicateImpl != null ? new PredicateImpl((Predicate)firstPredicateImpl, 7, (Predicate)secondPredicateImpl) : secondPredicateImpl;
        }
        return combinedPredicate;
    }

    private void addOtherInfo(IBPMContext context, IPersistencyService service, ProcessInstance instance) throws Exception {
        Task task = instance.getTask();
        List comments = service.getProcessInstanceComments((IWorkflowContext)context, task);
        for (Object comment : comments) {
            task.addUserComment((CommentType)comment);
        }
        List attachments = service.getProcessInstanceAttachments((IWorkflowContext)context, task);
        for (Object attachment : attachments) {
            task.addAttachment((AttachmentType)attachment);
        }
        this.getPermissionsService().addPermissibleProcessActions(context, (IProcessInstance)instance);
    }

    private List<IAuditInstance> filterAuditInstancesForUser(IBPMContext ctx, List<IAuditInstance> auditList) throws Exception {
        if (PermissionsService.isAdmin(ctx)) {
            return auditList;
        }
        LinkedHashMap<String, List<IAuditInstance>> auditInstCache = new LinkedHashMap<String, List<IAuditInstance>>();
        ArrayList<String> processIds = new ArrayList<String>();
        for (IAuditInstance auditInst : auditList) {
            ArrayList<IAuditInstance> cachedList;
            String processId = auditInst.getCompositeInstanceId();
            if (!processIds.contains(processId)) {
                processIds.add(processId);
            }
            if ((cachedList = (ArrayList<IAuditInstance>)((HashMap)auditInstCache).get(processId)) == null) {
                cachedList = new ArrayList<IAuditInstance>();
                auditInstCache.put(processId, cachedList);
            }
            cachedList.add(auditInst);
        }
        return this.compileAuditInstancesForProcessInstances(ctx, processIds, auditInstCache);
    }

    private List<IAuditInstance> compileAuditInstancesForProcessInstances(IBPMContext ctx, List<String> processIds, HashMap<String, List<IAuditInstance>> auditInstCache) throws Exception {
        BPMLogger.log((LoggerComponent)LoggerComponent.COMPONENT_INSTANCE_QUERY_SERVICE, (Severity)Severity.DEBUG, (String)logClassName, (String)"compileAuditInstancesForProcessInstances", (String)"Start of compileAuditInstancesForProcessInstances ");
        ArrayList returnAuditList = new ArrayList();
        IPersistencyService service = null;
        Locale locale = ctx.getLocale();
        try {
            Object svc;
            if (processIds != null && processIds.size() > 0) {
                svc = this.getPermissionsService();
                ITaskActionPermission permission = null;
                ProcessInstance pInstance = null;
                service = PersistencyDriver.getInstance();
                PredicateImpl predicate = new PredicateImpl(IColumnConstants.PROCESS_ID_COLUMN, 9, processIds);
                ctx.setLocale(Locale.getDefault());
                List taskLists = service.getWFTask((IWorkflowContext)ctx, sColumnList, (Predicate)predicate, null);
                for (int i = 0; i < taskLists.size(); ++i) {
                    Task taskObj = (Task)taskLists.get(i);
                    pInstance = new ProcessInstance(taskObj);
                    permission = svc.canUserPerformProcessAction(ctx, (IProcessInstance)pInstance, ACTION_VIEW_AUDIT_INFO);
                    if (!permission.getHasPermission()) continue;
                    returnAuditList.addAll(auditInstCache.get(taskObj.getProcessInfo().getInstanceId()));
                }
            }
            BPMLogger.log((LoggerComponent)LoggerComponent.COMPONENT_INSTANCE_QUERY_SERVICE, (Severity)Severity.DEBUG, (String)logClassName, (String)"compileAuditInstancesForProcessInstances", (String)"End of compileAuditInstancesForProcessInstances");
            svc = returnAuditList;
            return svc;
        }
        catch (Exception exc) {
            BPMLogger.log((LoggerComponent)LoggerComponent.COMPONENT_INSTANCE_QUERY_SERVICE, (Severity)Severity.ERRORS, (Throwable)exc);
            throw new BPMException(70407, null, (Throwable)exc);
        }
        finally {
            InstanceQueryService.closeService(service);
            ctx.setLocale(locale);
        }
    }

    private boolean canUserSeeAuditForProcessInstance(IBPMContext ctx, String processId) throws Exception {
        IProcessInstance pInstance = this.getProcessInstance(ctx, processId);
        Task task = ((ProcessInstance)pInstance).getTask();
        List systemActions = task.getSystemAttributes().getSystemActions();
        for (int i = 0; i < systemActions.size(); ++i) {
            ActionType actionType = (ActionType)systemActions.get(i);
            if (!actionType.getAction().equals(ACTION_VIEW_AUDIT_INFO)) continue;
            return true;
        }
        return false;
    }

    private UserViewDetailType getUserViewDetail(IWorkflowContext ctx, String viewId) throws BPMException {
        try {
            UserViewDetail userViewDetail = this.getUserMetadataService().getUserTaskViewDetails(ctx, viewId);
            if (userViewDetail == null) {
                throw new BPMException(70408, new Object[]{viewId}, null);
            }
            if (!this.isProcessView((UserViewDetailType)userViewDetail)) {
                Object[] objs = new Object[]{userViewDetail.getName(), userViewDetail.getViewType()};
                throw new BPMException(70409, objs, null);
            }
            return userViewDetail;
        }
        catch (BPMException bpe) {
            throw bpe;
        }
        catch (Exception e) {
            BPMLogger.log((LoggerComponent)LoggerComponent.COMPONENT_INSTANCE_QUERY_SERVICE, (Severity)Severity.ERRORS, (Throwable)e);
            throw new BPMException(70410, new Object[]{e.getLocalizedMessage()}, (Throwable)e);
        }
    }

    private boolean isProcessView(UserViewDetailType view) {
        String viewType = view.getViewType();
        return IUserMetadataService.UserTaskViewType.PROCESS_VIEW.name().equals(viewType) || IUserMetadataService.UserTaskViewType.STDPROCESS_VIEW.name().equals(viewType);
    }

    private PresentationType getViewPresentation(UserViewDetailType view) throws Exception {
        String presentationId = view.getPresentationId();
        PresentationType presentation = null;
        if (presentationId != null && presentationId.length() > 0) {
            presentation = this.getUserMetadataService().getPresentation(InstanceQueryService.getInternalWorkflowContext(), presentationId);
        }
        return presentation;
    }

    private String getProcessDN(String compositeDN, String componentName) {
        return SOAUtil.getCompositeDNWithoutLabel((String)compositeDN) + "*/" + componentName;
    }

    private void populateProcessDiff(Set<IVariableItem> addedDataObjects, Set<IActivityInfo> activitiesInConflict) {
    }

    static {
        sColumnList = new ArrayList<Column>();
        try {
            Field[] constantfields;
            Class<?> tableConstantsClass = Class.forName("oracle.bpm.services.instancequery.IColumnConstants");
            for (Field constantField : constantfields = tableConstantsClass.getFields()) {
                Column colm;
                Class<?> constantClass = constantField.getType();
                String name = constantField.getName();
                if (!constantClass.getName().equals("oracle.bpel.services.workflow.repos.Column") || !name.startsWith("PROCESS_") || !(colm = (Column)constantField.get(null)).getTable().getName().equalsIgnoreCase("WFTask")) continue;
                sColumnList.add((Column)constantField.get(null));
            }
        }
        catch (Exception exc) {
            exc.printStackTrace();
        }
        StandardViewLoaderUtil.loadViewsFromFile((IUserMetadataService.UserTaskViewType)IUserMetadataService.UserTaskViewType.STANDARD_VIEW, (String)STANDARD_TASK_VIEWS_FILE);
        StandardViewLoaderUtil.loadViewsFromFile((IUserMetadataService.UserTaskViewType)IUserMetadataService.UserTaskViewType.STDPROCESS_VIEW, (String)STANDARD_PROCESS_VIEWS_FILE);
        sDefaultProcessInstanceColumns = new ArrayList<Column>();
        sDefaultProcessInstanceColumns.add(IColumnConstants.PROCESS_ACTIVITYID_COLUMN);
        sDefaultProcessInstanceColumns.add(IColumnConstants.PROCESS_ACTIVITYNAME_COLUMN);
        sDefaultProcessInstanceColumns.add(IColumnConstants.PROCESS_APPLICATIONCONTEXT_COLUMN);
        sDefaultProcessInstanceColumns.add(IColumnConstants.PROCESS_APPLICATIONNAME_COLUMN);
        sDefaultProcessInstanceColumns.add(IColumnConstants.PROCESS_ASSIGNMENTCONTEXT_COLUMN);
        sDefaultProcessInstanceColumns.add(IColumnConstants.PROCESS_COMPONENTNAME_COLUMN);
        sDefaultProcessInstanceColumns.add(IColumnConstants.PROCESS_COMPONENTTYPE_COLUMN);
        sDefaultProcessInstanceColumns.add(IColumnConstants.PROCESS_COMPOSITEDN_COLUMN);
        sDefaultProcessInstanceColumns.add(IColumnConstants.PROCESS_COMPOSITEINSTANCEID_COLUMN);
        sDefaultProcessInstanceColumns.add(IColumnConstants.PROCESS_COMPOSITENAME_COLUMN);
        sDefaultProcessInstanceColumns.add(IColumnConstants.PROCESS_COMPOSITEVERSION_COLUMN);
        sDefaultProcessInstanceColumns.add(IColumnConstants.PROCESS_CREATEDDATE_COLUMN);
        sDefaultProcessInstanceColumns.add(IColumnConstants.PROCESS_CREATOR_COLUMN);
        sDefaultProcessInstanceColumns.add(IColumnConstants.PROCESS_DUEDATE_COLUMN);
        sDefaultProcessInstanceColumns.add(IColumnConstants.PROCESS_ENDDATE_COLUMN);
        sDefaultProcessInstanceColumns.add(IColumnConstants.PROCESS_EXPIRATIONDATE_COLUMN);
        sDefaultProcessInstanceColumns.add(IColumnConstants.PROCESS_EXPIRATIONDURATION_COLUMN);
        sDefaultProcessInstanceColumns.add(IColumnConstants.PROCESS_ID_COLUMN);
        sDefaultProcessInstanceColumns.add(IColumnConstants.PROCESS_IDENTITYCONTEXT_COLUMN);
        sDefaultProcessInstanceColumns.add(IColumnConstants.PROCESS_INSTANCEID_COLUMN);
        sDefaultProcessInstanceColumns.add(IColumnConstants.PROCESS_NUMBER_COLUMN);
        sDefaultProcessInstanceColumns.add(IColumnConstants.PROCESS_NUMBEROFTIMESMODIFIED_COLUMN);
        sDefaultProcessInstanceColumns.add(IColumnConstants.PROCESS_OWNERGROUP_COLUMN);
        sDefaultProcessInstanceColumns.add(IColumnConstants.PROCESS_OWNERROLE_COLUMN);
        sDefaultProcessInstanceColumns.add(IColumnConstants.PROCESS_OWNERUSER_COLUMN);
        sDefaultProcessInstanceColumns.add(IColumnConstants.PROCESS_PARENTTHREAD_COLUMN);
        sDefaultProcessInstanceColumns.add(IColumnConstants.PROCESS_PREVIOUS_STATE_COLUMN);
        sDefaultProcessInstanceColumns.add(IColumnConstants.PROCESS_PROCESSDEFINITIONID_COLUMN);
        sDefaultProcessInstanceColumns.add(IColumnConstants.PROCESS_PROCESSDEFINITIONNAME_COLUMN);
        sDefaultProcessInstanceColumns.add(IColumnConstants.PROCESS_PROCESSNAME_COLUMN);
        sDefaultProcessInstanceColumns.add(IColumnConstants.PROCESS_STATE_COLUMN);
        sDefaultProcessInstanceColumns.add(IColumnConstants.PROCESS_THREAD_COLUMN);
        sDefaultProcessInstanceColumns.add(IColumnConstants.PROCESS_TITLE_COLUMN);
        logger = Logger.getAnonymousLogger();
        logger.setLevel(Level.ALL);
        MyConsoleHandler consoleHandler = new MyConsoleHandler();
        consoleHandler.setFormatter(new MySimpleFormatter());
        logger.addHandler(consoleHandler);
        consoleHandler.setLevel(Level.INFO);
        PROCESS_STATES_PENDING_MIGRATION = Arrays.asList("PENDING_MIGRATION", "PENDING_MIGRATION_SUSPENDED");
    }

    private static class MySimpleFormatter
    extends SimpleFormatter {
        private MySimpleFormatter() {
        }

        @Override
        public String format(LogRecord record) {
            return "[" + record.getLevel() + "]: " + record.getMessage() + "\n";
        }
    }

    private static class MyConsoleHandler
    extends ConsoleHandler {
        private MyConsoleHandler() {
        }

        @Override
        public void publish(LogRecord record) {
            super.publish(record);
        }
    }

    private static class FlowChangeItemSingleComparator
    implements Comparator<IFlowChangeItem>,
    Serializable {
        private static final FlowChangeItemSingleComparator ME = new FlowChangeItemSingleComparator();

        private FlowChangeItemSingleComparator() {
        }

        public static FlowChangeItemSingleComparator getInstance() {
            return ME;
        }

        @Override
        public int compare(IFlowChangeItem item1, IFlowChangeItem item2) {
            String id2;
            IOpenActivityInfo sourceActivity1 = item1.getSourceActivity();
            IOpenActivityInfo sourceActivity2 = item2.getSourceActivity();
            String id1 = sourceActivity1.getId();
            if (!id1.equals(id2 = sourceActivity2.getId())) {
                return id1.compareTo(id2);
            }
            Integer thread1 = sourceActivity1.getLocation().getProcessInstanceInfo().getThread();
            Integer thread2 = sourceActivity2.getLocation().getProcessInstanceInfo().getThread();
            return thread1.compareTo(thread2);
        }
    }

    private static class FlowChangeItemMultipleComparator
    implements Comparator<IFlowChangeItem>,
    Serializable {
        private static final FlowChangeItemMultipleComparator ME = new FlowChangeItemMultipleComparator();

        private FlowChangeItemMultipleComparator() {
        }

        public static FlowChangeItemMultipleComparator getInstance() {
            return ME;
        }

        @Override
        public int compare(IFlowChangeItem item1, IFlowChangeItem item2) {
            String id1 = item1.getSourceActivity().getId();
            String id2 = item2.getSourceActivity().getId();
            return id1.compareTo(id2);
        }
    }
}

