/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.services.instancemanagement.impl;

import com.collaxa.cube.persistence.dto.CubeInstanceVO;
import java.io.File;
import java.security.AccessController;
import java.security.PrivilegedExceptionAction;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;
import java.util.Set;
import javax.xml.namespace.QName;
import oracle.bpel.services.bpm.common.IBPMContext;
import oracle.bpel.services.common.util.XMLUtil;
import oracle.bpel.services.workflow.WorkflowException;
import oracle.bpel.services.workflow.query.ITaskQueryService;
import oracle.bpel.services.workflow.repos.IPersistencyService;
import oracle.bpel.services.workflow.repos.Predicate;
import oracle.bpel.services.workflow.repos.TableConstants;
import oracle.bpel.services.workflow.repos.Transaction;
import oracle.bpel.services.workflow.task.model.AttachmentType;
import oracle.bpel.services.workflow.task.model.CommentType;
import oracle.bpel.services.workflow.task.model.SystemAttributesType;
import oracle.bpel.services.workflow.task.model.Task;
import oracle.bpel.services.workflow.verification.IWorkflowContext;
import oracle.bpm.bpmn.engine.instancemanagement.IInternalInstanceManagementService;
import oracle.bpm.bpmn.engine.instancemanagement.impl.InternalInstanceManagementService;
import oracle.bpm.bpmn.engine.model.runtime.instancehandling.Activity;
import oracle.bpm.bpmn.engine.model.runtime.instancehandling.AlterFlowXmlModelHelper;
import oracle.bpm.bpmn.engine.model.runtime.instancehandling.AppliedChangesResult;
import oracle.bpm.bpmn.engine.model.runtime.instancehandling.AppliedChangesSummary;
import oracle.bpm.bpmn.engine.model.runtime.instancehandling.ApplyChangesPlan;
import oracle.bpm.bpmn.engine.model.runtime.instancehandling.CorrelationKey;
import oracle.bpm.bpmn.engine.model.runtime.instancehandling.CorrelationProperty;
import oracle.bpm.bpmn.engine.model.runtime.instancehandling.Expression;
import oracle.bpm.bpmn.engine.model.runtime.instancehandling.InstanceAttributes;
import oracle.bpm.bpmn.engine.model.runtime.instancehandling.InstanceHandlingException;
import oracle.bpm.bpmn.engine.model.runtime.instancehandling.ProcessInstance;
import oracle.bpm.bpmn.engine.model.runtime.instancehandling.ResultInfo;
import oracle.bpm.bpmn.engine.model.runtime.instancehandling.ResumeComponentPlan;
import oracle.bpm.bpmn.engine.model.runtime.instancehandling.ResumeComponentSummary;
import oracle.bpm.bpmn.engine.model.runtime.instancehandling.Variable;
import oracle.bpm.bpmn.engine.model.runtime.instancehandling.model.Alterflow;
import oracle.bpm.bpmn.engine.model.runtime.instancehandling.model.CorrelationKeyUpdate;
import oracle.bpm.bpmn.engine.model.runtime.instancehandling.model.DataUpdate;
import oracle.bpm.bpmn.engine.model.runtime.instancehandling.model.FlowUpdate;
import oracle.bpm.bpmn.engine.model.runtime.instancehandling.model.PropertyUpdate;
import oracle.bpm.bpmn.engine.service.ejb.interfaces.IBPMNCubeInstanceManagerLocalBean;
import oracle.bpm.collections.Sequence;
import oracle.bpm.lang.Str;
import oracle.bpm.project.SubprocessImpl;
import oracle.bpm.project.model.processes.BoundaryEvent;
import oracle.bpm.project.model.processes.FlowNode;
import oracle.bpm.project.model.processes.Process;
import oracle.bpm.project.model.util.ModelUtils;
import oracle.bpm.services.common.AbstractBPMService;
import oracle.bpm.services.common.BPMServiceLocator;
import oracle.bpm.services.common.exception.BPMException;
import oracle.bpm.services.common.logger.BPMLogger;
import oracle.bpm.services.common.logger.LoggerComponent;
import oracle.bpm.services.common.logger.Severity;
import oracle.bpm.services.instancemanagement.IInstanceManagementService;
import oracle.bpm.services.instancemanagement.impl.ErroredInstances;
import oracle.bpm.services.instancemanagement.model.IActivityInfo;
import oracle.bpm.services.instancemanagement.model.IBaseMigrateInstanceRequest;
import oracle.bpm.services.instancemanagement.model.ICorrelationKeyItem;
import oracle.bpm.services.instancemanagement.model.ICorrelationKeyProperty;
import oracle.bpm.services.instancemanagement.model.IFlowChangeItem;
import oracle.bpm.services.instancemanagement.model.IGrabInstanceRequest;
import oracle.bpm.services.instancemanagement.model.IGrabInstanceResponse;
import oracle.bpm.services.instancemanagement.model.IGrabMultipleInstancesRequest;
import oracle.bpm.services.instancemanagement.model.IGrabMultipleInstancesResponse;
import oracle.bpm.services.instancemanagement.model.IInstanceSummary;
import oracle.bpm.services.instancemanagement.model.IMigrateInstanceRequest;
import oracle.bpm.services.instancemanagement.model.IMigrateInstanceResponse;
import oracle.bpm.services.instancemanagement.model.IMigrateInstanceSummary;
import oracle.bpm.services.instancemanagement.model.IMigrateMultipleInstancesRequest;
import oracle.bpm.services.instancemanagement.model.IMigrateMultipleInstancesResponse;
import oracle.bpm.services.instancemanagement.model.IOpenActivityInfo;
import oracle.bpm.services.instancemanagement.model.IProcessAttachment;
import oracle.bpm.services.instancemanagement.model.IProcessComment;
import oracle.bpm.services.instancemanagement.model.IProcessInstance;
import oracle.bpm.services.instancemanagement.model.ITaskUpdateAction;
import oracle.bpm.services.instancemanagement.model.IVariableItem;
import oracle.bpm.services.instancemanagement.model.impl.IdentityType;
import oracle.bpm.services.instancemanagement.model.impl.ProcessAttachment;
import oracle.bpm.services.instancemanagement.model.impl.ProcessComment;
import oracle.bpm.services.instancemanagement.model.impl.alterflow.ActivityInfo;
import oracle.bpm.services.instancemanagement.model.impl.alterflow.CorrelationKeyItem;
import oracle.bpm.services.instancemanagement.model.impl.alterflow.CorrelationKeyProperty;
import oracle.bpm.services.instancemanagement.model.impl.alterflow.FlowChangeItem;
import oracle.bpm.services.instancemanagement.model.impl.alterflow.GrabInstanceResponse;
import oracle.bpm.services.instancemanagement.model.impl.alterflow.GrabMultipleInstancesResponse;
import oracle.bpm.services.instancemanagement.model.impl.alterflow.MigrateInstanceRequest;
import oracle.bpm.services.instancemanagement.model.impl.alterflow.MigrateInstanceResponse;
import oracle.bpm.services.instancemanagement.model.impl.alterflow.MigrateMultipleInstancesRequest;
import oracle.bpm.services.instancemanagement.model.impl.alterflow.MigrateMultipleInstancesResponse;
import oracle.bpm.services.instancemanagement.model.impl.alterflow.UpdateInstanceSummary;
import oracle.bpm.services.instancemanagement.model.impl.alterflow.VariableItem;
import oracle.bpm.services.instancequery.IColumnConstants;
import oracle.bpm.services.instancequery.IInstanceQueryInput;
import oracle.bpm.services.instancequery.IInstanceQueryService;
import oracle.bpm.services.instancequery.impl.InstanceQueryInput;
import oracle.bpm.services.internal.processmodel.IProcessModelService;
import oracle.bpm.services.permissions.IPermissionsService;
import oracle.bpm.services.processmetadata.IProcessMetadataService;
import oracle.bpm.services.processmetadata.ProcessMetadataSummary;
import oracle.bpm.services.tools.ProcessInstanceValidationHelper;
import oracle.integration.platform.common.NMUtil;
import oracle.security.jps.JpsException;
import oracle.security.jps.jaas.AssertionException;
import oracle.security.jps.runtime.ActionExecutor;
import oracle.security.jps.runtime.SubjectSecurity;
import oracle.soa.management.ComponentDN;
import oracle.soa.management.CompositeDN;
import oracle.soa.management.util.SOAUtil;
import oracle.xml.parser.v2.XMLDocument;
import org.jetbrains.annotations.NotNull;

public class InstanceManagementService
extends AbstractBPMService
implements IInstanceManagementService {
    private IBPMNCubeInstanceManagerLocalBean bpmnInstanceManager;
    private IInternalInstanceManagementService internalInstanceManagementService;
    private IProcessMetadataService processMetadataService;
    private ITaskQueryService taskQueryService;
    protected static final boolean SUCCESSFULLY_UPDATED = true;
    public static final int SUMMARY_LIST_INITIAL_CAPACITY = 100;
    private static final String CLASSNAME = InstanceManagementService.class.getName();
    private static final String ADD_COMMENT = "ADD_COMMENT";
    private static final String ADD_ATTACHMENT = "ADD_ATTACHMENT";
    private static final String DELETE_ATTACHMENT = "DELETE_ATTACHMENT";

    public IBPMNCubeInstanceManagerLocalBean getBpmnInstanceManager() {
        return this.bpmnInstanceManager;
    }

    public void setBpmnInstanceManager(IBPMNCubeInstanceManagerLocalBean instanceManagerBean) {
        this.bpmnInstanceManager = instanceManagerBean;
    }

    public ITaskQueryService getTaskQueryService() {
        return this.taskQueryService;
    }

    public void setTaskQueryService(ITaskQueryService taskQueryService) {
        this.taskQueryService = taskQueryService;
    }

    public IInternalInstanceManagementService getInternalInstanceManagementService() {
        return this.internalInstanceManagementService;
    }

    public void setInternalInstanceManagementService(IInternalInstanceManagementService internalInstanceManagementService) {
        this.internalInstanceManagementService = internalInstanceManagementService;
    }

    public IProcessMetadataService getProcessMetadataService() {
        return this.processMetadataService;
    }

    public void setProcessMetadataService(IProcessMetadataService processMetadataService) {
        this.processMetadataService = processMetadataService;
    }

    public String createProcessInstance(IBPMContext context, String processId) throws BPMException {
        CubeInstanceVO instance;
        BPMLogger.log((LoggerComponent)LoggerComponent.COMPONENT_INSTANCE_MANAGEMENT_SERVICE, (Severity)Severity.DEBUG, (String)CLASSNAME, (String)"createProcessInstance()", (String)"Start");
        ComponentDN targetDN = new ComponentDN(processId);
        this.performInitiatePermissionCheck(context, targetDN);
        try {
            Properties invocationProperties = new Properties();
            String conversationId = NMUtil.generateConversationId();
            String name = context.getUser();
            if (name != null) {
                invocationProperties.setProperty("creator", name);
            }
            invocationProperties.setProperty("tracking.conversationId", conversationId);
            invocationProperties.put("START_EVENT_ID_PROPERTY", "START_EVENT_USER_INITIATE");
            this.getBpmnInstanceManager().createComponentInstance(targetDN, invocationProperties);
            instance = this.getBpmnInstanceManager().getCubeInstanceByConversationId(conversationId);
        }
        catch (Exception e) {
            BPMLogger.log((LoggerComponent)LoggerComponent.COMPONENT_INSTANCE_MANAGEMENT_SERVICE, (Severity)Severity.ERRORS, (Throwable)e);
            Object[] args = new Object[]{processId};
            throw new BPMException(70204, args, (Throwable)e);
        }
        if (instance == null) {
            Object[] args = new Object[]{processId};
            BPMLogger.log((LoggerComponent)LoggerComponent.COMPONENT_INSTANCE_MANAGEMENT_SERVICE, (Severity)Severity.ERRORS, (String)("Instance could not be created for unknown reason for target process '" + processId + "'. " + "Verify server log for error cause."));
            throw new BPMException(70204, args, null);
        }
        BPMLogger.log((LoggerComponent)LoggerComponent.COMPONENT_INSTANCE_MANAGEMENT_SERVICE, (Severity)Severity.DEBUG, (String)CLASSNAME, (String)"createProcessInstance()", (String)"End");
        return String.valueOf(instance.getCikey());
    }

    public Task createProcessInstanceTask(IBPMContext context, String processId) throws BPMException {
        BPMLogger.log((LoggerComponent)LoggerComponent.COMPONENT_INSTANCE_MANAGEMENT_SERVICE, (Severity)Severity.DEBUG, (String)CLASSNAME, (String)"createProcessInstanceTask()", (String)"Start");
        final ComponentDN targetDN = new ComponentDN(processId);
        Task task = null;
        try {
            this.performInitiatePermissionCheck(context, targetDN);
            this.getVerificationService().validateContext((IWorkflowContext)context);
            final Properties invocationProperties = new Properties();
            String conversationId = NMUtil.generateConversationId();
            String name = context.getUser();
            if (name != null) {
                invocationProperties.setProperty("creator", name);
            }
            invocationProperties.setProperty("tracking.conversationId", conversationId);
            invocationProperties.put("START_EVENT_ID_PROPERTY", "START_EVENT_USER_INITIATE");
            InstanceManagementService.runAs(name, new PrivilegedExceptionAction<Object>(){

                @Override
                public Object run() throws Exception {
                    InstanceManagementService.this.getBpmnInstanceManager().createComponentInstance(targetDN, invocationProperties);
                    return null;
                }
            });
            task = null;
            List tasks = null;
            ITaskQueryService queryService = this.getTaskQueryService();
            ArrayList<ITaskQueryService.OptionalInfo> optionalInfo = new ArrayList<ITaskQueryService.OptionalInfo>();
            Predicate predicate = new Predicate(TableConstants.WFTASK_IDENTIFICATIONKEY_COLUMN, 0, (Object)conversationId);
            optionalInfo.add(ITaskQueryService.OptionalInfo.DISPLAY_INFO);
            tasks = queryService.queryTasks((IWorkflowContext)context, null, optionalInfo, ITaskQueryService.AssignmentFilter.ALL, null, predicate, null, 0, 0);
            if (tasks != null && !tasks.isEmpty()) {
                task = (Task)tasks.get(0);
            }
        }
        catch (Exception e) {
            BPMLogger.log((LoggerComponent)LoggerComponent.COMPONENT_INSTANCE_MANAGEMENT_SERVICE, (Severity)Severity.ERRORS, (Throwable)e);
            Object[] args = new Object[]{processId};
            throw new BPMException(70204, args, (Throwable)e);
        }
        if (task == null) {
            Object[] args = new Object[]{processId};
            BPMLogger.log((LoggerComponent)LoggerComponent.COMPONENT_INSTANCE_MANAGEMENT_SERVICE, (Severity)Severity.ERRORS, (String)("Initiate task could not be created for unknown reason for target process '" + processId + "'. " + "Verify server log for error cause."));
            throw new BPMException(70204, args, null);
        }
        BPMLogger.log((LoggerComponent)LoggerComponent.COMPONENT_INSTANCE_MANAGEMENT_SERVICE, (Severity)Severity.DEBUG, (String)CLASSNAME, (String)"createProcessInstanceTask()", (String)"End");
        return task;
    }

    public IProcessComment addComment(IBPMContext context, IProcessInstance instance, IProcessComment comment) throws BPMException {
        BPMLogger.log((LoggerComponent)LoggerComponent.COMPONENT_INSTANCE_MANAGEMENT_SERVICE, (Severity)Severity.DEBUG, (String)CLASSNAME, (String)"addComment()", (String)"Start of adding process comment");
        boolean inTransaction = false;
        this.performPermissionsCheck(context, instance, IPermissionsService.InstanceAction.UPDATE_COMMENT);
        try {
            inTransaction = Transaction.inTransaction();
            if (!inTransaction) {
                Transaction.start();
            }
            IPersistencyService service = Transaction.getPersistencyService();
            Task taskObject = ((oracle.bpm.services.instancemanagement.model.impl.ProcessInstance)instance).getTask();
            String taskId = instance.getCubeInstanceId();
            String userName = context.getUser();
            IdentityType type = new IdentityType();
            type.setType("user");
            type.setId(userName);
            SystemAttributesType attributes = taskObject.getSystemAttributes();
            attributes.setUpdatedBy(type.getIdentityType());
            Calendar updatedDate = Calendar.getInstance();
            updatedDate.setTimeInMillis(System.currentTimeMillis());
            attributes.setUpdatedDate(updatedDate);
            String versionReason = attributes.getVersionReason();
            if (versionReason == null || versionReason.equals("")) {
                attributes.setVersionReason(ADD_COMMENT);
            }
            CommentType cType = ((ProcessComment)comment).getCommentType();
            taskObject.getSystemAttributes().setTaskId(taskId);
            service.addProcessInstanceComment((IWorkflowContext)context, taskObject, cType);
            BPMLogger.log((LoggerComponent)LoggerComponent.COMPONENT_INSTANCE_MANAGEMENT_SERVICE, (Severity)Severity.DEBUG, (String)CLASSNAME, (String)"addComment()", (String)"End of adding process comment");
            IProcessComment iProcessComment = comment;
            return iProcessComment;
        }
        catch (Exception exc) {
            String id = instance.getCubeInstanceId();
            Object[] obj = new String[]{id};
            BPMLogger.log((LoggerComponent)LoggerComponent.COMPONENT_INSTANCE_MANAGEMENT_SERVICE, (Severity)Severity.ERRORS, (Throwable)exc);
            throw new BPMException(70200, obj, (Throwable)exc);
        }
        finally {
            if (!inTransaction) {
                try {
                    Transaction.close();
                }
                catch (Exception ignored) {}
            }
        }
    }

    public IProcessAttachment addAttachment(IBPMContext context, IProcessInstance instance, IProcessAttachment attachment) throws BPMException {
        BPMLogger.log((LoggerComponent)LoggerComponent.COMPONENT_INSTANCE_MANAGEMENT_SERVICE, (Severity)Severity.DEBUG, (String)CLASSNAME, (String)"addAttachment()", (String)"Start of adding process attachment");
        boolean inTransaction = false;
        this.performPermissionsCheck(context, instance, IPermissionsService.InstanceAction.UPDATE_ATTACHMENT);
        try {
            inTransaction = Transaction.inTransaction();
            if (!inTransaction) {
                Transaction.start();
            }
            IPersistencyService service = Transaction.getPersistencyService();
            Task taskObject = ((oracle.bpm.services.instancemanagement.model.impl.ProcessInstance)instance).getTask();
            String taskId = instance.getCubeInstanceId();
            String userName = context.getUser();
            IdentityType type = new IdentityType();
            type.setType("user");
            type.setId(userName);
            SystemAttributesType attributes = taskObject.getSystemAttributes();
            attributes.setUpdatedBy(type.getIdentityType());
            Calendar updatedDate = Calendar.getInstance();
            updatedDate.setTimeInMillis(System.currentTimeMillis());
            attributes.setUpdatedDate(updatedDate);
            String versionReason = attributes.getVersionReason();
            if (versionReason == null || versionReason.equals("")) {
                attributes.setVersionReason("ADD_ATTACHMENT " + attachment.getName());
            }
            attachment.setUpdatedBy(userName);
            AttachmentType aType = ((ProcessAttachment)attachment).getAttachmentType();
            taskObject.getSystemAttributes().setTaskId(taskId);
            aType = service.addProcessInstanceAttachment((IWorkflowContext)context, taskObject, aType);
            ((ProcessAttachment)attachment).setAttachmentType(aType);
            BPMLogger.log((LoggerComponent)LoggerComponent.COMPONENT_INSTANCE_MANAGEMENT_SERVICE, (Severity)Severity.DEBUG, (String)CLASSNAME, (String)"addAttachment()", (String)"End of adding process comment");
            IProcessAttachment iProcessAttachment = attachment;
            return iProcessAttachment;
        }
        catch (Exception exc) {
            String id = instance.getCubeInstanceId();
            Object[] obj = new String[]{id};
            BPMLogger.log((LoggerComponent)LoggerComponent.COMPONENT_INSTANCE_MANAGEMENT_SERVICE, (Severity)Severity.ERRORS, (Throwable)exc);
            throw new BPMException(70201, obj, (Throwable)exc);
        }
        finally {
            if (!inTransaction) {
                try {
                    Transaction.close();
                }
                catch (Exception ignored) {}
            }
        }
    }

    public void deleteProcessAttachments(IBPMContext context, IProcessInstance instance, IProcessAttachment attachment) throws BPMException {
        String taskId = instance.getSystemAttributes().getProcessInstanceId();
        BPMLogger.log((LoggerComponent)LoggerComponent.COMPONENT_INSTANCE_MANAGEMENT_SERVICE, (Severity)Severity.DEBUG, (String)CLASSNAME, (String)"deleteProcessAttachments", (String)("Start of deleteProcessAttachments for instance id " + taskId));
        boolean inTransaction = false;
        this.performPermissionsCheck(context, instance, IPermissionsService.InstanceAction.UPDATE_ATTACHMENT);
        try {
            inTransaction = Transaction.inTransaction();
            if (!inTransaction) {
                Transaction.start();
            }
            IPersistencyService service = Transaction.getPersistencyService();
            Task task = ((oracle.bpm.services.instancemanagement.model.impl.ProcessInstance)instance).getTask();
            SystemAttributesType attributes = task.getSystemAttributes();
            String versionReason = attributes.getVersionReason();
            if (versionReason == null || versionReason.equals("")) {
                attributes.setVersionReason("DELETE_ATTACHMENT " + attachment.getName());
            }
            AttachmentType attType = ((ProcessAttachment)attachment).getAttachmentType();
            service.deleteProcessInstanceAttachment((IWorkflowContext)context, task, attType);
            BPMLogger.log((LoggerComponent)LoggerComponent.COMPONENT_INSTANCE_MANAGEMENT_SERVICE, (Severity)Severity.DEBUG, (String)CLASSNAME, (String)"deleteProcessAttachments", (String)("End of deleteProcessAttachments for instance id " + taskId));
        }
        catch (Exception exc) {
            BPMLogger.log((LoggerComponent)LoggerComponent.COMPONENT_INSTANCE_MANAGEMENT_SERVICE, (Severity)Severity.ERRORS, (Throwable)exc);
            Object[] objs = new String[]{taskId + ""};
            throw new BPMException(70401, objs, (Throwable)exc);
        }
        finally {
            if (!inTransaction) {
                try {
                    Transaction.close();
                }
                catch (Exception ignored) {}
            }
        }
    }

    public void updateProcessInstance(IBPMContext context, IProcessInstance instance) throws BPMException {
        String processInstanceId = instance.getSystemAttributes().getProcessInstanceId();
        boolean inTransaction = true;
        boolean failure = false;
        this.performPermissionsCheck(context, instance, IPermissionsService.InstanceAction.UPDATE);
        try {
            IInstanceQueryService instanceQueryService;
            IProcessInstance pInstance;
            this.bpmnInstanceManager.updateInstanceAttributes(Long.parseLong(instance.getCubeInstanceId()), new InstanceAttributes(instance.getTitle(), instance.getPriority()));
            inTransaction = Transaction.inTransaction();
            if (!inTransaction) {
                Transaction.start();
            }
            if ((pInstance = (instanceQueryService = this.getInstanceQueryService()).getProcessInstance(context, processInstanceId)) != null) {
                ArrayList<IProcessInstance> allInstances = new ArrayList<IProcessInstance>();
                allInstances.add(pInstance);
                allInstances.addAll(instanceQueryService.queryParallelInstances(context, pInstance, new ArrayList()));
                for (IProcessInstance inst : allInstances) {
                    String modifiedTitle = instance.getTitle();
                    int modifiedPriority = instance.getPriority();
                    inst.setTitle(modifiedTitle);
                    inst.setPriority(modifiedPriority);
                    IInternalInstanceManagementService local = this.getInternalInstanceManagementService();
                    local.insertUpdateInstance(context, inst);
                }
            }
        }
        catch (Exception exc) {
            failure = true;
            BPMLogger.log((LoggerComponent)LoggerComponent.COMPONENT_INSTANCE_MANAGEMENT_SERVICE, (Severity)Severity.ERRORS, (Throwable)exc);
            Object[] objs = new String[]{processInstanceId + ""};
            throw new BPMException(70219, objs, (Throwable)exc);
        }
        finally {
            if (!inTransaction) {
                try {
                    if (failure) {
                        Transaction.abort();
                    } else {
                        Transaction.close();
                    }
                }
                catch (Exception ignored) {}
            }
        }
    }

    public void cancelProcessInstance(@NotNull IBPMContext context, @NotNull IProcessInstance instance) throws BPMException {
        String cubeInstanceId = instance.getCubeInstanceId();
        BPMLogger.log((LoggerComponent)LoggerComponent.COMPONENT_INSTANCE_MANAGEMENT_SERVICE, (Severity)Severity.DEBUG, (String)CLASSNAME, (String)"cancelInstance", (String)("Start of cancelInstance for instance id " + cubeInstanceId));
        this.performPermissionsCheck(context, instance, IPermissionsService.InstanceAction.CANCEL);
        try {
            this.getBpmnInstanceManager().cancelInstance(Long.parseLong(cubeInstanceId));
            BPMLogger.log((LoggerComponent)LoggerComponent.COMPONENT_INSTANCE_MANAGEMENT_SERVICE, (Severity)Severity.DEBUG, (String)CLASSNAME, (String)"cancelInstance", (String)("End of cancelInstance for instance id " + cubeInstanceId));
        }
        catch (Exception e) {
            Object[] args = new Object[]{cubeInstanceId};
            BPMLogger.log((LoggerComponent)LoggerComponent.COMPONENT_INSTANCE_MANAGEMENT_SERVICE, (Severity)Severity.ERRORS, (String)("Instance could not be cancelled. Instance: '" + cubeInstanceId + "'. " + "Verify server log for error cause."));
            throw new BPMException(70206, args, (Throwable)e);
        }
    }

    public List<String> getAllowedActions(@NotNull IBPMContext context, @NotNull IProcessInstance instance) throws BPMException {
        return this.getPermissionsService().getPermissibleProcessActions(context, instance);
    }

    public void updateTask(IBPMContext context, ITaskUpdateAction action) throws BPMException {
        IInternalInstanceManagementService svc = this.getInternalInstanceManagementService();
        switch (action.getUpdateType()) {
            case UPDATE_OUTCOME: {
                svc.updateWorkflowTasksOutcome(context, action.getTaskIds(), action.getUpdateArg());
                break;
            }
            case UPDATE_PRIORITY: {
                svc.updatePriorityOfWorkflowTasks(context, action.getTaskIds(), Integer.valueOf(action.getUpdateArg()).intValue());
                break;
            }
            case WITHDRAW: {
                svc.withdrawWorkflowTasks(context, action.getTaskIds());
                break;
            }
            case SUSPEND: {
                svc.suspendWorkflowTasks(context, action.getTaskIds());
                break;
            }
            case RESUME: {
                svc.resumeWorkflowTasks(context, action.getTaskIds());
                break;
            }
            case ESCALATE: {
                svc.escalateWorkflowTasks(context, action.getTaskIds());
                break;
            }
            case REASSIGN: {
                svc.reassignWorkflowTasks(context, action.getTaskIds(), action.getUpdateArg());
                break;
            }
            case SUSPEND_TIMERS: {
                svc.suspendTimersOnWorkflowTasks(context, action.getTaskIds());
                break;
            }
            case RESUME_TIMERS: {
                svc.resumeTimersOnWorkflowTasks(context, action.getTaskIds());
            }
        }
    }

    public void deleteProcessInstance(IBPMContext context, String processInstanceId) throws BPMException {
        IInternalInstanceManagementService svc = this.getInternalInstanceManagementService();
        try {
            svc.abortInstancesByCompositeInstanceId(context, Long.valueOf(processInstanceId).longValue());
        }
        catch (Exception e) {
            throw new BPMException(e);
        }
    }

    public IGrabInstanceResponse grabInstance(IBPMContext context, IGrabInstanceRequest grabInstanceRequest) throws BPMException {
        BPMLogger.log((LoggerComponent)LoggerComponent.COMPONENT_INSTANCE_MANAGEMENT_SERVICE, (Severity)Severity.DEBUG, (String)CLASSNAME, (String)"grabInstance()", (String)"Start");
        IProcessInstance processInstance = grabInstanceRequest.getProcessInstance();
        String processName = SOAUtil.getComponentNameFromComponentDN((String)processInstance.getProcessDN());
        grabInstanceRequest.setRequester(context.getRequester());
        MigrateInstanceRequest mr = this.grab2MigrateInstanceRequest(grabInstanceRequest);
        ApplyChangesPlan migrationPlan = this.createMigrationPlan(processName, (IBaseMigrateInstanceRequest)mr);
        IProcessModelService processModelService = BPMServiceLocator.getProcessModelService();
        Process processModel = processModelService.getProcessModel(context, this.getComponentDN(processInstance).getCompositeDN_NoLabel(), processName).getProcessModel();
        Sequence flowNodes = processModel.getFlowNodes();
        ArrayList<FlowNode> flowNodeList = new ArrayList<FlowNode>();
        this.createSourceFlowChangeItemsList(mr, (Sequence<FlowNode>)flowNodes, flowNodeList);
        for (FlowNode flowNode : flowNodeList) {
            for (FlowNode flowNode2 : flowNodeList) {
                if (!flowNode.getParentObject().getId().equals(flowNode2.getId()) && !this.isInBoundayFlow(flowNode2, flowNode)) continue;
                UpdateInstanceSummary summary = new UpdateInstanceSummary();
                summary.setSuccessfullyUpdated(false);
                summary.setExceptionMessage("One or more flow changes requests depends each other");
                summary.setProcessInstance(processInstance);
                GrabInstanceResponse result = new GrabInstanceResponse((IInstanceSummary)summary);
                return result;
            }
        }
        MigrateInstanceResponse response = this.migrateOrGrabInstance(context, IPermissionsService.InstanceAction.GRAB, processInstance, migrationPlan);
        if (response.getInstanceSummary().isSuccessfullyUpdated() && grabInstanceRequest.isResumeInstanceIfRequired()) {
            this.resumeInstance(context, processInstance);
        }
        GrabInstanceResponse result = new GrabInstanceResponse(response.getInstanceSummary());
        BPMLogger.log((LoggerComponent)LoggerComponent.COMPONENT_INSTANCE_MANAGEMENT_SERVICE, (Severity)Severity.DEBUG, (String)CLASSNAME, (String)"grabInstance()", (String)"End");
        return result;
    }

    public IGrabMultipleInstancesResponse grabMultipleInstances(IBPMContext context, IGrabMultipleInstancesRequest grabMultipleInstancesRequest) throws BPMException {
        BPMLogger.log((LoggerComponent)LoggerComponent.COMPONENT_INSTANCE_MANAGEMENT_SERVICE, (Severity)Severity.DEBUG, (String)CLASSNAME, (String)"grabMultipleInstances()", (String)"Start");
        grabMultipleInstancesRequest.setRequester(context.getRequester());
        IMigrateMultipleInstancesRequest migrateMultipleInstanceRequest = this.grab2MigrateMultipleInstanceRequest(grabMultipleInstancesRequest);
        ApplyChangesPlan migrationPlan = this.createMigrationPlan(SOAUtil.getComponentNameFromComponentDN((String)grabMultipleInstancesRequest.getProcessDN()), (IBaseMigrateInstanceRequest)migrateMultipleInstanceRequest);
        MigrateMultipleInstancesResponse response = this.migrateOrGrabMultipleInstances(context, IPermissionsService.InstanceAction.GRAB, migrateMultipleInstanceRequest.getProcessDN(), migrationPlan, migrateMultipleInstanceRequest.isApplyToAllInstances(), migrateMultipleInstanceRequest.getProcessInstances(), migrateMultipleInstanceRequest.getPageSize(), new GrabPagedQueryProcedure(this.getInstanceQueryService()));
        if (grabMultipleInstancesRequest.isResumeInstanceIfRequired()) {
            for (UpdateInstanceSummary instanceSummary : response.getInstanceSummaries()) {
                if (!instanceSummary.isSuccessfullyUpdated()) continue;
                this.resumeInstance(context, instanceSummary.getProcessInstance());
            }
        }
        GrabMultipleInstancesResponse result = new GrabMultipleInstancesResponse((List)response.getInstanceSummaries());
        result.setNumberOfFailedInstances(response.getNumberOfFailedInstances());
        result.setNumberOfSucceededInstances(response.getNumberOfSucceededInstances());
        BPMLogger.log((LoggerComponent)LoggerComponent.COMPONENT_INSTANCE_MANAGEMENT_SERVICE, (Severity)Severity.DEBUG, (String)CLASSNAME, (String)"grabMultipleInstances()", (String)"End");
        return result;
    }

    public IMigrateInstanceResponse migrateInstance(IBPMContext context, IMigrateInstanceRequest migrateInstanceRequest) throws BPMException {
        BPMLogger.log((LoggerComponent)LoggerComponent.COMPONENT_INSTANCE_MANAGEMENT_SERVICE, (Severity)Severity.DEBUG, (String)CLASSNAME, (String)"migrateInstance()", (String)"Start");
        migrateInstanceRequest.setRequester(context.getRequester());
        IProcessInstance processInstance = migrateInstanceRequest.getProcessInstance();
        ComponentDN componentDN = this.getComponentDN(processInstance);
        String processName = componentDN.getComponentName();
        ApplyChangesPlan migrationPlan = this.createMigrationPlan(processName, (IBaseMigrateInstanceRequest)migrateInstanceRequest);
        MigrateInstanceResponse migrateInstanceResponse = this.migrateOrGrabInstance(context, IPermissionsService.InstanceAction.MIGRATE, processInstance, migrationPlan);
        BPMLogger.log((LoggerComponent)LoggerComponent.COMPONENT_INSTANCE_MANAGEMENT_SERVICE, (Severity)Severity.DEBUG, (String)CLASSNAME, (String)"migrateInstance()", (String)"End");
        if (migrateInstanceRequest.isResumeComponent()) {
            this.resumeComponentAndMergeSummary(componentDN, migrateInstanceResponse, this.createResumePlan((IBaseMigrateInstanceRequest)migrateInstanceRequest));
        }
        return migrateInstanceResponse;
    }

    public IMigrateMultipleInstancesResponse migrateMultipleInstances(IBPMContext context, File alterFlowModel, Iterable<IProcessInstance> instances) throws BPMException {
        try {
            Alterflow alterflow = AlterFlowXmlModelHelper.getInstance().readAlterFlowModel(alterFlowModel);
            return this.migrateMultipleInstances(context, this.createRequest(alterflow, instances, context.getRequester()));
        }
        catch (Exception e) {
            BPMLogger.log((LoggerComponent)LoggerComponent.COMPONENT_INSTANCE_MANAGEMENT_SERVICE, (Severity)Severity.ERRORS, (Throwable)e);
            Object[] args = new Object[]{alterFlowModel.getAbsolutePath()};
            throw new BPMException(70202, args, (Throwable)e);
        }
    }

    public IGrabMultipleInstancesResponse grabMultipleInstances(IBPMContext context, File alterFlowModel, Iterable<IProcessInstance> instances) throws BPMException {
        try {
            Alterflow alterflow = AlterFlowXmlModelHelper.getInstance().readAlterFlowModel(alterFlowModel);
            return this.grabMultipleInstances(context, (IGrabMultipleInstancesRequest)this.createRequest(alterflow, instances, context.getRequester()));
        }
        catch (Exception e) {
            BPMLogger.log((LoggerComponent)LoggerComponent.COMPONENT_INSTANCE_MANAGEMENT_SERVICE, (Severity)Severity.ERRORS, (Throwable)e);
            Object[] args = new Object[]{alterFlowModel.getAbsolutePath()};
            throw new BPMException(70202, args, (Throwable)e);
        }
    }

    public IMigrateMultipleInstancesResponse migrateMultipleInstances(IBPMContext context, IMigrateMultipleInstancesRequest migrateMultipleInstancesRequest) throws BPMException {
        BPMLogger.log((LoggerComponent)LoggerComponent.COMPONENT_INSTANCE_MANAGEMENT_SERVICE, (Severity)Severity.DEBUG, (String)CLASSNAME, (String)"migrateMultipleInstance()", (String)"Start");
        migrateMultipleInstancesRequest.setRequester(context.getRequester());
        String processDN = migrateMultipleInstancesRequest.getProcessDN();
        ComponentDN componentDN = InstanceManagementService.fixProcessDN(processDN);
        String processName = componentDN.getComponentName();
        Iterable processInstanceL = migrateMultipleInstancesRequest.getProcessInstances();
        ApplyChangesPlan migrationPlan = this.createMigrationPlan(processName, (IBaseMigrateInstanceRequest)migrateMultipleInstancesRequest);
        migrationPlan.setBatchSize(migrateMultipleInstancesRequest.getPageSize());
        MigrateMultipleInstancesResponse result = !migrateMultipleInstancesRequest.isMigrateInstance() && migrateMultipleInstancesRequest.isMigrateInstancesInResume() ? new MigrateMultipleInstancesResponse(Collections.emptyList()) : this.migrateOrGrabMultipleInstances(context, IPermissionsService.InstanceAction.MIGRATE, processDN, migrationPlan, migrateMultipleInstancesRequest.isApplyToAllInstances(), processInstanceL, migrateMultipleInstancesRequest.getPageSize(), new MigrationPagedQueryProcedure(this.getInstanceQueryService()));
        BPMLogger.log((LoggerComponent)LoggerComponent.COMPONENT_INSTANCE_MANAGEMENT_SERVICE, (Severity)Severity.DEBUG, (String)CLASSNAME, (String)"migrateMultipleInstance()", (String)"End");
        if (migrateMultipleInstancesRequest.isResumeComponent()) {
            this.resumeComponentAndMergeSummary(componentDN, result, this.createResumePlan((IBaseMigrateInstanceRequest)migrateMultipleInstancesRequest));
        }
        return result;
    }

    public boolean suspendInstance(IBPMContext context, IProcessInstance instance) throws BPMException {
        BPMLogger.log((LoggerComponent)LoggerComponent.COMPONENT_INSTANCE_MANAGEMENT_SERVICE, (Severity)Severity.DEBUG, (String)CLASSNAME, (String)"suspendInstance()", (String)"Start");
        long instanceId = InternalInstanceManagementService.getCubeInstanceId((IProcessInstance)instance);
        try {
            boolean result = this.getBpmnInstanceManager().suspendInstance(instanceId);
            BPMLogger.log((LoggerComponent)LoggerComponent.COMPONENT_INSTANCE_MANAGEMENT_SERVICE, (Severity)Severity.DEBUG, (String)CLASSNAME, (String)"suspendInstance()", (String)"End");
            return result;
        }
        catch (InstanceHandlingException e) {
            Object[] args = new Object[]{instanceId};
            throw new BPMException(70209, args, (Throwable)e);
        }
    }

    public boolean resumeInstance(IBPMContext context, IProcessInstance instance) throws BPMException {
        BPMLogger.log((LoggerComponent)LoggerComponent.COMPONENT_INSTANCE_MANAGEMENT_SERVICE, (Severity)Severity.DEBUG, (String)CLASSNAME, (String)"resumeInstance()", (String)"Start");
        long instanceId = InternalInstanceManagementService.getCubeInstanceId((IProcessInstance)instance);
        try {
            this.getBpmnInstanceManager().resumeInstance(instanceId);
            BPMLogger.log((LoggerComponent)LoggerComponent.COMPONENT_INSTANCE_MANAGEMENT_SERVICE, (Severity)Severity.DEBUG, (String)CLASSNAME, (String)"resumeInstance()", (String)"End");
            return true;
        }
        catch (InstanceHandlingException e) {
            Object[] args = new Object[]{instanceId};
            throw new BPMException(70209, args, (Throwable)e);
        }
    }

    public boolean suspendComponent(IBPMContext context, String processDN) throws BPMException {
        BPMLogger.log((LoggerComponent)LoggerComponent.COMPONENT_INSTANCE_MANAGEMENT_SERVICE, (Severity)Severity.DEBUG, (String)CLASSNAME, (String)"suspendComponent()", (String)"Start");
        try {
            this.getBpmnInstanceManager().suspendComponent(InstanceManagementService.fixProcessDN(processDN));
            BPMLogger.log((LoggerComponent)LoggerComponent.COMPONENT_INSTANCE_MANAGEMENT_SERVICE, (Severity)Severity.DEBUG, (String)CLASSNAME, (String)"suspendComponent()", (String)"End");
            return true;
        }
        catch (InstanceHandlingException e) {
            Object[] args = new Object[]{processDN};
            throw new BPMException(70209, args, (Throwable)e);
        }
    }

    public boolean resumeComponent(IBPMContext context, String processDN) throws BPMException {
        BPMLogger.log((LoggerComponent)LoggerComponent.COMPONENT_INSTANCE_MANAGEMENT_SERVICE, (Severity)Severity.DEBUG, (String)CLASSNAME, (String)"resumeComponent()", (String)"Start");
        try {
            ComponentDN componentDN = InstanceManagementService.fixProcessDN(processDN);
            this.getBpmnInstanceManager().resumeComponent(InstanceManagementService.createCompositeRevisionDN(componentDN), componentDN.getComponentName());
            BPMLogger.log((LoggerComponent)LoggerComponent.COMPONENT_INSTANCE_MANAGEMENT_SERVICE, (Severity)Severity.DEBUG, (String)CLASSNAME, (String)"resumeComponent()", (String)"End");
            return true;
        }
        catch (InstanceHandlingException e) {
            Object[] args = new Object[]{processDN};
            throw new BPMException(70210, args, (Throwable)e);
        }
    }

    private static <T> T runAs(final String userName, PrivilegedExceptionAction action) throws BPMException {
        try {
            ActionExecutor executor = AccessController.doPrivileged(new PrivilegedExceptionAction<ActionExecutor>(){

                @Override
                public ActionExecutor run() throws AssertionException, JpsException {
                    return SubjectSecurity.getInstance().getActionExecutor(userName);
                }
            }, null);
            return (T)executor.execute(action);
        }
        catch (Throwable pae) {
            try {
                return action.run();
            }
            catch (Exception e) {
                throw new BPMException(e);
            }
        }
    }

    private static ComponentDN fixProcessDN(String processDN) {
        return new ComponentDN(processDN.replaceFirst("!(.+)/", "!$1*null/"));
    }

    private static CompositeDN createCompositeRevisionDN(ComponentDN componentDN) {
        return new CompositeDN(componentDN.getApplicationName(), componentDN.getCompositeName(), componentDN.getRevision());
    }

    private static boolean hasSameRevisionDN(ComponentDN targetProcess, ProcessMetadataSummary candidate) {
        return candidate.getDomainName().equals(targetProcess.getApplicationName()) && candidate.getCompositeName().equals(targetProcess.getCompositeName()) && candidate.getRevision().equals(targetProcess.getRevision());
    }

    private static void fillVariableUpdate(Iterable<IVariableItem> source, List<Variable> target) {
        for (IVariableItem iVariableItem : source) {
            Object varValue = InstanceManagementService.getXMLVarValue(iVariableItem.getValue());
            Variable variable = iVariableItem.getExpressionString() != null ? Variable.forUpdate((String)iVariableItem.getName(), (Expression)new Expression(iVariableItem.getExpressionString(), iVariableItem.getNamespaceMapping())) : Variable.create((String)iVariableItem.getName(), (Object)varValue);
            target.add(variable);
        }
    }

    private static void fillCorrelationKeyUpdate(Iterable<ICorrelationKeyItem> source, List<CorrelationKey> target) {
        for (ICorrelationKeyItem correlationKeyItem : source) {
            HashSet<CorrelationProperty> properties = new HashSet<CorrelationProperty>();
            for (ICorrelationKeyProperty iCorrelationKeyProperty : correlationKeyItem.getProperties()) {
                QName name = iCorrelationKeyProperty.getName();
                Object varValue = InstanceManagementService.getXMLVarValue(iCorrelationKeyProperty.getValue());
                properties.add(CorrelationProperty.create((QName)name, (Object)varValue));
            }
            CorrelationKey correlationKey = CorrelationKey.createForUpdate((String)correlationKeyItem.getName(), properties, (boolean)correlationKeyItem.isReset());
            target.add(correlationKey);
        }
    }

    private static Object getXMLVarValue(String valueString) {
        Object varValue;
        try {
            varValue = XMLUtil.parseDocumentFromXMLString((String)valueString);
            varValue = varValue == null ? valueString : ((XMLDocument)varValue).getDocumentElement();
        }
        catch (Throwable t) {
            varValue = valueString;
        }
        return varValue;
    }

    private boolean isInBoundayFlow(FlowNode boundaryFlowNode, FlowNode flowNodeInBoundaryFlow) {
        if (ModelUtils.isInBoundaryFlow((FlowNode)flowNodeInBoundaryFlow)) {
            for (BoundaryEvent boundaryEvent : ModelUtils.getSourceBoundaryEvents((FlowNode)flowNodeInBoundaryFlow)) {
                if (!boundaryEvent.getBoundaryActivity().getId().equals(boundaryFlowNode.getId())) continue;
                return true;
            }
        }
        return false;
    }

    private void createSourceFlowChangeItemsList(MigrateInstanceRequest migrateInstanceRequest, Sequence<FlowNode> flowNodes, List<FlowNode> flowNodeList) {
        for (FlowNode flowNode : flowNodes) {
            for (IFlowChangeItem flowChangeItem : migrateInstanceRequest.getRequestedFlowChanges()) {
                if (!flowChangeItem.getSourceActivity().getId().equals(flowNode.getId())) continue;
                flowNodeList.add(flowNode);
                if (!(flowNode instanceof SubprocessImpl)) continue;
                this.createSourceFlowChangeItemsList(migrateInstanceRequest, (Sequence<FlowNode>)flowNode.getChildrenByType(FlowNode.class), flowNodeList);
            }
        }
    }

    private IMigrateMultipleInstancesRequest createRequest(Alterflow alterflow, Iterable<IProcessInstance> instances, String requester) {
        MigrateMultipleInstancesRequest result = new MigrateMultipleInstancesRequest();
        HashSet<VariableItem> requestedVariableChanges = new HashSet<VariableItem>();
        HashSet<VariableItem> requestedInstanceAttributeChanges = new HashSet<VariableItem>();
        HashSet<CorrelationKeyItem> requestedCorrelationKeyChanges = new HashSet<CorrelationKeyItem>();
        for (DataUpdate dataObjectUpdate : alterflow.getDataObjectUpdate()) {
            requestedVariableChanges.add(VariableItem.create((String)dataObjectUpdate.getName(), (String)dataObjectUpdate.getValue()));
        }
        for (DataUpdate instanceAttributeUpdate : alterflow.getInstanceAttributeUpdate()) {
            requestedInstanceAttributeChanges.add(VariableItem.create((String)instanceAttributeUpdate.getName(), (String)instanceAttributeUpdate.getValue()));
        }
        for (CorrelationKeyUpdate correlationKeyUpdate : alterflow.getCorrelationKeyUpdate()) {
            HashSet<CorrelationKeyProperty> properties = new HashSet<CorrelationKeyProperty>();
            for (PropertyUpdate propertyUpdate : correlationKeyUpdate.getProperties()) {
                properties.add(CorrelationKeyProperty.create((QName)propertyUpdate.getName(), (String)propertyUpdate.getValue()));
            }
            requestedCorrelationKeyChanges.add(CorrelationKeyItem.createForUpdate((String)correlationKeyUpdate.getName(), properties, (boolean)correlationKeyUpdate.isReset()));
        }
        HashSet<FlowChangeItem> requestedFlowChanges = new HashSet<FlowChangeItem>();
        for (FlowUpdate flowUpdate : alterflow.getFlowUpdate()) {
            requestedFlowChanges.add(FlowChangeItem.create((IActivityInfo)this.adaptActivity(flowUpdate.getSource()), (IActivityInfo)this.adaptActivity(flowUpdate.getTarget())));
        }
        result.setApplyToAllInstances(instances == null);
        if (instances != null) {
            result.setProcessInstances(instances);
        }
        result.setPageSize(alterflow.getBatchSize().intValue());
        result.setComments(alterflow.getComments());
        result.setMigrateInstance(alterflow.isMigrateInstance().booleanValue());
        result.setProcessDN(alterflow.getProcessDN());
        result.setValidateValue(alterflow.isValidateVariables().booleanValue());
        result.setResumeInstanceIfRequired(alterflow.isResumeInstance().booleanValue());
        result.setRequestedVariableValueChanges(requestedVariableChanges);
        result.setRequestedInstanceAttributeValueChanges(requestedInstanceAttributeChanges);
        result.setRequestedCorrelationKeyValueChanges(requestedCorrelationKeyChanges);
        result.setRequestedFlowChanges(requestedFlowChanges);
        result.setMigrateInstancesInResume(alterflow.isMigrateInstanceInResume().booleanValue());
        result.setRequester(requester);
        return result;
    }

    private IActivityInfo adaptActivity(oracle.bpm.bpmn.engine.model.runtime.instancehandling.model.Activity activity) {
        return ActivityInfo.create((String)activity.getId(), (String)activity.getDisplayName(), (String)activity.getProcessId());
    }

    private ResumeComponentPlan createResumePlan(IBaseMigrateInstanceRequest request) {
        return ResumeComponentPlan.create((String)request.getComments(), (boolean)request.isMigrateInstance(), (boolean)request.isLeaveNonMigratedInstancesSuspended(), (boolean)request.isMigrateInstancesInResume());
    }

    private void resumeComponentAndMergeSummary(ComponentDN componentDN, MigrateInstanceResponse response, ResumeComponentPlan plan) throws BPMException {
        try {
            ResumeComponentSummary resumeComponentSummary = this.getBpmnInstanceManager().resumeComponent(InstanceManagementService.createCompositeRevisionDN(componentDN), componentDN.getComponentName(), plan);
            response.setComponentResumed(resumeComponentSummary.isComponentResumed());
            response.setComponentResumeExceptionMsg(resumeComponentSummary.getComponentResumeExceptionMsg());
            response.setNumberOfSuspendedInstances(resumeComponentSummary.getNumberOfSuspendedInstances());
        }
        catch (InstanceHandlingException e) {
            throw new BPMException(70210, (Object[])new String[]{componentDN.getComponentName()}, (Throwable)e);
        }
    }

    private void resumeComponentAndMergeSummary(ComponentDN componentDN, MigrateMultipleInstancesResponse response, ResumeComponentPlan plan) throws BPMException {
        try {
            ResumeComponentSummary resumeComponentSummary = this.getBpmnInstanceManager().resumeComponent(InstanceManagementService.createCompositeRevisionDN(componentDN), componentDN.getComponentName(), plan);
            response.setComponentResumed(resumeComponentSummary.isComponentResumed());
            response.setComponentResumeExceptionMsg(resumeComponentSummary.getComponentResumeExceptionMsg());
            response.setNumberOfSuspendedInstances(resumeComponentSummary.getNumberOfSuspendedInstances());
        }
        catch (InstanceHandlingException e) {
            throw new BPMException(70210, (Object[])new String[]{componentDN.getComponentName()}, (Throwable)e);
        }
    }

    private MigrateInstanceResponse migrateOrGrabInstance(IBPMContext context, IPermissionsService.InstanceAction permissionToCheck, IProcessInstance processInstancePassed, ApplyChangesPlan applyChangesPlan) throws BPMException {
        MigrateInstanceResponse result;
        this.performPermissionsCheck(context, processInstancePassed, permissionToCheck);
        ComponentDN targetDN = this.getComponentDN(processInstancePassed);
        try {
            ProcessInstanceValidationHelper.validateErrorState(processInstancePassed);
            ProcessInstanceValidationHelper.validateCompositeState(processInstancePassed);
            String processInstanceId = processInstancePassed.getSystemAttributes().getProcessInstanceId();
            InstanceQueryInput input = new InstanceQueryInput();
            input.addState("OPEN");
            input.addState("PENDING_MIGRATION");
            input.addState("PENDING_MIGRATION_SUSPENDED");
            input.addState("SUSPENDED");
            Predicate pred = new Predicate(IColumnConstants.PROCESS_ID_COLUMN, 0, (Object)processInstanceId);
            if (context.getIsAdmin()) {
                input.setAssignmentFilter(IInstanceQueryInput.AssignmentFilter.ADMIN);
            } else {
                input.setAssignmentFilter(IInstanceQueryInput.AssignmentFilter.OWNER);
            }
            IInstanceQueryService service = BPMServiceLocator.getInstanceQueryService();
            ArrayList displayColumns = new ArrayList();
            List processInstanceL = service.queryInstances(context, displayColumns, pred, null, (IInstanceQueryInput)input);
            Iterator iterator = processInstanceL.iterator();
            if (!iterator.hasNext()) {
                Object[] objs = new String[]{processInstanceId};
                throw new BPMException(70220, objs, null);
            }
            IProcessInstance processInstance = (IProcessInstance)iterator.next();
            ArrayList<ProcessInstance> instances = new ArrayList<ProcessInstance>(1);
            oracle.bpm.services.instancemanagement.impl.internal.InstanceManagementService.addParallelInstances(context, processInstance, instances, this.getInstanceQueryService());
            AppliedChangesSummary appliedChangesSummary = this.getBpmnInstanceManager().applyChanges(targetDN, instances, applyChangesPlan);
            List saveresults = (List)appliedChangesSummary.getActionResult();
            AppliedChangesResult appliedChangesResult = (AppliedChangesResult)saveresults.get(0);
            UpdateInstanceSummary summary = new UpdateInstanceSummary();
            this.mergeToSummary(appliedChangesResult, processInstance, summary);
            if (applyChangesPlan.isUpdateInstanceToNewModel()) {
                AppliedChangesSummary migrationSummary = this.getBpmnInstanceManager().migrateInstances(targetDN, instances, applyChangesPlan);
                AppliedChangesResult migrationResult = this.findMainThreadResult((List)migrationSummary.getActionResult());
                this.mergeToSummary(migrationResult, processInstance, summary);
            }
            result = new MigrateInstanceResponse((IMigrateInstanceSummary)summary);
        }
        catch (Exception e) {
            BPMLogger.log((LoggerComponent)LoggerComponent.COMPONENT_INSTANCE_MANAGEMENT_SERVICE, (Severity)Severity.ERRORS, (Throwable)e);
            Object[] args = new Object[]{targetDN.getStringDN()};
            throw new BPMException(70202, args, (Throwable)e);
        }
        return result;
    }

    private AppliedChangesResult findMainThreadResult(List<AppliedChangesResult> actionResult) {
        AppliedChangesResult result = null;
        for (AppliedChangesResult appliedChangesResult : actionResult) {
            if (appliedChangesResult.getThread() != 0) continue;
            result = appliedChangesResult;
            break;
        }
        assert (result != null) : "Thread 0 must come in the result list";
        return result;
    }

    private ComponentDN getComponentDN(IProcessInstance processInstance) {
        return new ComponentDN(processInstance.getSca().getCompositeDN(), processInstance.getSca().getComponentName());
    }

    private MigrateMultipleInstancesResponse migrateOrGrabMultipleInstances(IBPMContext context, IPermissionsService.InstanceAction permission, String processDN, ApplyChangesPlan applyChangesPlan, boolean applyToAllInstances, Iterable<IProcessInstance> processInstances, int reqPageSize, PagedQueryProcedure pagedQueryProcedure) throws BPMException {
        try {
            ComponentDN targetDN = InstanceManagementService.fixProcessDN(processDN);
            ArrayList summary = new ArrayList(100);
            MigrateMultipleInstancesResponse result = new MigrateMultipleInstancesResponse(summary);
            ErroredInstances errorStatePI = new ErroredInstances();
            if (!applyToAllInstances) {
                InstanceQueryInput input = new InstanceQueryInput();
                input.addState("OPEN");
                input.addState("PENDING_MIGRATION");
                input.addState("PENDING_MIGRATION_SUSPENDED");
                input.addState("SUSPENDED");
                ArrayList<String> instanceIds = new ArrayList<String>();
                for (IProcessInstance instance : processInstances) {
                    String processInstanceId = instance.getSystemAttributes().getProcessInstanceId();
                    instanceIds.add(processInstanceId);
                    this.addToErroredInstances(instance, errorStatePI);
                }
                Predicate pred = new Predicate(IColumnConstants.PROCESS_ID_COLUMN, 9, instanceIds);
                if (context.getIsAdmin()) {
                    input.setAssignmentFilter(IInstanceQueryInput.AssignmentFilter.ADMIN);
                } else {
                    input.setAssignmentFilter(IInstanceQueryInput.AssignmentFilter.MY_AND_GROUP);
                }
                IInstanceQueryService service = BPMServiceLocator.getInstanceQueryService();
                ArrayList displayColumns = new ArrayList();
                List processInstanceL = service.queryInstances(context, displayColumns, pred, null, (IInstanceQueryInput)input);
                result = this.migrateOrGrabBatchOfInstances(context, targetDN, applyChangesPlan, processInstanceL, permission, errorStatePI);
            } else {
                int pageSize;
                int startRow = 0;
                int endRow = pageSize = reqPageSize;
                double countOfInstances = pagedQueryProcedure.getCountOfInstances(context, processDN);
                int numberOfPages = new Double(Math.ceil(countOfInstances / (double)pageSize)).intValue();
                for (int i = 0; i < numberOfPages; ++i) {
                    Iterable<IProcessInstance> pagedInstances = pagedQueryProcedure.getInstances(context, processDN, startRow, endRow);
                    for (IProcessInstance instance : pagedInstances) {
                        this.addToErroredInstances(instance, errorStatePI);
                    }
                    MigrateMultipleInstancesResponse response = this.migrateOrGrabBatchOfInstances(context, targetDN, applyChangesPlan, pagedInstances, pagedQueryProcedure.getAction(), errorStatePI);
                    result.mergeResponse((GrabMultipleInstancesResponse)response);
                    endRow = (startRow += response.getNumberOfFailedInstances()) + pageSize;
                }
            }
            return result;
        }
        catch (Exception exc) {
            throw new BPMException(exc);
        }
    }

    private void addToErroredInstances(IProcessInstance instance, ErroredInstances errorStatePI) {
        if (ProcessInstanceValidationHelper.isInErrorState(instance)) {
            errorStatePI.add(instance, 70221);
        } else if (ProcessInstanceValidationHelper.isCompositeNotAvailable(instance)) {
            errorStatePI.add(instance, 70222);
        }
    }

    private MigrateMultipleInstancesResponse migrateOrGrabBatchOfInstances(IBPMContext context, ComponentDN targetDN, ApplyChangesPlan applyChangesPlan, Iterable<IProcessInstance> instanceIterable, IPermissionsService.InstanceAction permission, ErroredInstances erroredInstances) throws BPMException {
        HashSet<IProcessInstance> actualInstances = new HashSet<IProcessInstance>();
        for (IProcessInstance processInstance : instanceIterable) {
            if (erroredInstances.contains(processInstance)) continue;
            actualInstances.add(processInstance);
            if (processInstance.getSystemAttributes().getThread() != 0) continue;
            actualInstances.addAll(this.getInstanceQueryService().queryParallelInstances(context, processInstance, new ArrayList()));
        }
        instanceIterable = actualInstances;
        ArrayList<UpdateInstanceSummary> summary = new ArrayList<UpdateInstanceSummary>(100);
        MigrateMultipleInstancesResponse result = new MigrateMultipleInstancesResponse(summary);
        int succeededPermissionInstances = 0;
        int failedPermissionInstances = 0;
        ArrayList<ProcessInstance> instances = new ArrayList<ProcessInstance>(100);
        for (IProcessInstance pInstance : instanceIterable) {
            UpdateInstanceSummary updateInstanceSummary = this.addUpdateInstanceSummaryToSummary(summary, pInstance, true);
            try {
                this.performPermissionsCheck(context, pInstance, permission);
                ++succeededPermissionInstances;
                instances.add(oracle.bpm.services.instancemanagement.impl.internal.InstanceManagementService.adaptInstance(pInstance));
            }
            catch (BPMException e) {
                BPMLogger.log((LoggerComponent)LoggerComponent.COMPONENT_INSTANCE_MANAGEMENT_SERVICE, (Severity)Severity.ERRORS, (Throwable)e);
                this.updateFailedInstanceMigration(updateInstanceSummary, e.getDescription(), e.getLocalizedMessage());
                ++failedPermissionInstances;
            }
        }
        int numInstances = succeededPermissionInstances + failedPermissionInstances;
        try {
            List appliedChangesResultList = (List)this.getBpmnInstanceManager().applyChanges(targetDN, instances, applyChangesPlan).getActionResult();
            assert (appliedChangesResultList.size() == numInstances);
            for (int i = 0; i < numInstances; ++i) {
                UpdateInstanceSummary updateInstanceSummary = (UpdateInstanceSummary)summary.get(i);
                AppliedChangesResult appliedChangesResult = (AppliedChangesResult)appliedChangesResultList.get(i);
                this.mergeToSummary(appliedChangesResult, updateInstanceSummary.getProcessInstance(), updateInstanceSummary);
            }
        }
        catch (InstanceHandlingException e) {
            throw new BPMException((Exception)((Object)e));
        }
        try {
            if (applyChangesPlan.isUpdateInstanceToNewModel()) {
                AppliedChangesSummary migrationSummary = this.getBpmnInstanceManager().migrateInstances(targetDN, instances, applyChangesPlan);
                List migrationResults = (List)migrationSummary.getActionResult();
                for (int i = 0; i < numInstances; ++i) {
                    UpdateInstanceSummary updateInstanceSummary = (UpdateInstanceSummary)summary.get(i);
                    AppliedChangesResult appliedChangesResult = (AppliedChangesResult)migrationResults.get(i);
                    this.mergeToSummary(appliedChangesResult, updateInstanceSummary.getProcessInstance(), updateInstanceSummary);
                }
            }
        }
        catch (InstanceHandlingException e) {
            throw new BPMException((Exception)((Object)e));
        }
        HashMap<String, Boolean> resultsByCubeInstance = new HashMap<String, Boolean>();
        for (int i = 0; i < numInstances; ++i) {
            UpdateInstanceSummary updateInstanceSummary = (UpdateInstanceSummary)summary.get(i);
            String cubeInstanceId = updateInstanceSummary.getProcessInstance().getCubeInstanceId();
            boolean success = updateInstanceSummary.isSuccessfullyUpdated();
            Boolean prevValue = (Boolean)resultsByCubeInstance.get(cubeInstanceId);
            if (prevValue == null) {
                resultsByCubeInstance.put(cubeInstanceId, success);
                continue;
            }
            if (!prevValue.booleanValue()) continue;
            resultsByCubeInstance.put(cubeInstanceId, success);
        }
        int succeededInstances = 0;
        int failedInstances = 0;
        for (Boolean success : resultsByCubeInstance.values()) {
            if (success.booleanValue()) {
                ++succeededInstances;
                continue;
            }
            ++failedInstances;
        }
        for (IProcessInstance pInstance : erroredInstances.getInstances()) {
            UpdateInstanceSummary updateInstanceSummary = this.addUpdateInstanceSummaryToSummary(summary, pInstance, false);
            AppliedChangesResult appliedChangesResult = new AppliedChangesResult(this.obtainId(pInstance.getSystemAttributes().getProcessInstanceId()), pInstance.getSystemAttributes().getThread());
            appliedChangesResult.addResultInfo(this.createResultInfo(pInstance, erroredInstances));
            this.mergeToSummary(appliedChangesResult, updateInstanceSummary.getProcessInstance(), updateInstanceSummary);
            ++failedInstances;
        }
        result.setNumberOfFailedInstances(failedInstances);
        result.setNumberOfSucceededInstances(succeededInstances);
        return result;
    }

    private ResultInfo createResultInfo(IProcessInstance processInstance, ErroredInstances erroredInstances) {
        ResultInfo info = new ResultInfo();
        Integer error = erroredInstances.getError(processInstance);
        String message = null;
        if (error.equals(70221)) {
            message = "Instance must not be in ERROR state";
        } else if (error.equals(70222)) {
            message = "Composite " + processInstance.getSca().getCompositeDN() + " not available";
        }
        info.setMessage(message);
        info.setSuccess(false);
        return info;
    }

    private UpdateInstanceSummary addUpdateInstanceSummaryToSummary(List<UpdateInstanceSummary> summary, IProcessInstance pInstance, boolean successfullyUpdated) {
        UpdateInstanceSummary updateInstanceSummary = new UpdateInstanceSummary();
        updateInstanceSummary.setProcessInstance(pInstance);
        updateInstanceSummary.setSuccessfullyUpdated(successfullyUpdated);
        summary.add(updateInstanceSummary);
        return updateInstanceSummary;
    }

    private void updateFailedInstanceMigration(UpdateInstanceSummary updateInstanceSummary, String excMsg, String msg) {
        updateInstanceSummary.setSuccessfullyUpdated(false);
        this.updateInstanceMigration(updateInstanceSummary, excMsg, msg);
    }

    private void updateInstanceMigration(UpdateInstanceSummary updateInstanceSummary, String excMsg, String msg) {
        updateInstanceSummary.setExceptionMessage(excMsg);
        updateInstanceSummary.setMessage(msg);
    }

    private ApplyChangesPlan createMigrationPlan(String processName, IBaseMigrateInstanceRequest request) {
        HashMap<Activity, Activity> flowUpdates = new HashMap<Activity, Activity>();
        ArrayList<Variable> dataObjectsUpdate = new ArrayList<Variable>();
        ArrayList<Variable> instanceAttributesUpdate = new ArrayList<Variable>();
        ArrayList<CorrelationKey> correlationKeyUpdates = new ArrayList<CorrelationKey>();
        for (IFlowChangeItem iFlowChangeItem : request.getRequestedFlowChanges()) {
            IOpenActivityInfo sourceActivity = iFlowChangeItem.getSourceActivity();
            IActivityInfo targetActivity = iFlowChangeItem.getTargetActivity();
            String sourceProcessName = sourceActivity.getProcessId() != null ? sourceActivity.getProcessId() : processName;
            String targetProcessName = targetActivity.getProcessId() != null ? targetActivity.getProcessId() : processName;
            Activity source = Activity.create((String)sourceProcessName, (String)sourceActivity.getId(), (String)sourceActivity.getDisplayName());
            Activity target = Activity.create((String)targetProcessName, (String)targetActivity.getId(), (String)targetActivity.getDisplayName());
            flowUpdates.put(source, target);
        }
        InstanceManagementService.fillVariableUpdate(request.getRequestedVariableValueChanges(), dataObjectsUpdate);
        InstanceManagementService.fillVariableUpdate(request.getRequestedInstanceAttributeValueChanges(), instanceAttributesUpdate);
        InstanceManagementService.fillCorrelationKeyUpdate(request.getRequestedCorrelationKeyValueChanges(), correlationKeyUpdates);
        ApplyChangesPlan applyChangesPlan = ApplyChangesPlan.create(flowUpdates, dataObjectsUpdate, instanceAttributesUpdate, (String)request.getComments(), (String)request.getRequester());
        applyChangesPlan.setCorrelationKeyUpdates(correlationKeyUpdates);
        applyChangesPlan.setUpdateInstanceToNewModel(request.isMigrateInstance());
        applyChangesPlan.setValidateVariables(request.isValidateValue());
        return applyChangesPlan;
    }

    private void mergeToSummary(AppliedChangesResult appliedChangesResult, IProcessInstance processInstance, UpdateInstanceSummary summary) {
        Set resultInfoSet = appliedChangesResult.getResultInfos();
        boolean isSuccessful = true;
        for (ResultInfo resultInfo : resultInfoSet) {
            if (resultInfo.getMessage() != null) {
                summary.setMessage((summary.getMessage() != null ? summary.getMessage() + "\n" : "") + resultInfo.getMessage());
            }
            if (resultInfo.getExceptionMessage() != null) {
                summary.setExceptionMessage((summary.getExceptionMessage() != null ? summary.getExceptionMessage() : "") + "\n" + resultInfo.getExceptionMessage());
            }
            isSuccessful = isSuccessful && resultInfo.isSuccess();
        }
        summary.setProcessInstance(processInstance);
        summary.setSuccessfullyUpdated(isSuccessful);
    }

    private long obtainId(String id) {
        int idx = id.indexOf(":");
        return Long.valueOf(id.substring(idx + 1));
    }

    private String getId(IProcessInstance instance) {
        String cubeInstanceId = instance.getCubeInstanceId();
        int thread = instance.getSystemAttributes().getThread();
        int parentThread = instance.getSystemAttributes().getParentThread();
        String taskId = cubeInstanceId;
        if (thread > 0 || parentThread > 0) {
            taskId = taskId + "-" + thread;
            taskId = taskId + "-" + parentThread;
        }
        return taskId;
    }

    private void performInitiatePermissionCheck(@NotNull IBPMContext context, @NotNull ComponentDN targetProcess) throws BPMException {
        boolean componentDNWithLabel = !Str.isEmpty((String)targetProcess.getLabel());
        ProcessMetadataSummary metadataSummary = null;
        if (componentDNWithLabel) {
            metadataSummary = this.getProcessMetadataService().getProcessMetadataSummary(context, targetProcess.getCompositeDN(), targetProcess.getComponentName());
        } else {
            List processMetadataSummaries = this.getProcessMetadataService().listProcessMetadataSummary(context, null, targetProcess.getComponentName(), null, null);
            for (ProcessMetadataSummary candidate : processMetadataSummaries) {
                if (!candidate.getProcessName().equals(targetProcess.getComponentName()) || !InstanceManagementService.hasSameRevisionDN(targetProcess, candidate)) continue;
                metadataSummary = candidate;
                break;
            }
        }
        if (metadataSummary == null) {
            throw new BPMException(70806, (Object[])new String[]{targetProcess.getStringDN()}, null);
        }
        boolean canPerform = false;
        List initiatables = this.getProcessMetadataService().getInitiatableProcesses(context);
        for (ProcessMetadataSummary candidate : initiatables) {
            if (!candidate.getProcessName().equals(targetProcess.getComponentName()) || (!componentDNWithLabel || !candidate.getCompositeDN().equals(targetProcess.getCompositeDN())) && (componentDNWithLabel || !InstanceManagementService.hasSameRevisionDN(targetProcess, candidate))) continue;
            canPerform = true;
            break;
        }
        if (!canPerform) {
            BPMException exception = new BPMException(70207, new Object[]{IPermissionsService.InstanceAction.INITIATE, targetProcess.toString(), context.getUser()}, null);
            throw exception;
        }
    }

    private MigrateInstanceRequest grab2MigrateInstanceRequest(IGrabInstanceRequest grabInstanceRequest) {
        MigrateInstanceRequest mr = new MigrateInstanceRequest();
        mr.setComments(grabInstanceRequest.getComments());
        mr.setProcessInstance(grabInstanceRequest.getProcessInstance());
        mr.setMigrateInstance(false);
        mr.setLeaveNonMigratedInstancesSuspended(!grabInstanceRequest.isResumeInstanceIfRequired());
        mr.setResumeComponent(false);
        mr.setRequestedFlowChanges(grabInstanceRequest.getRequestedFlowChanges());
        mr.setRequestedVariableValueChanges(grabInstanceRequest.getRequestedVariableValueChanges());
        mr.setRequestedInstanceAttributeValueChanges(grabInstanceRequest.getRequestedInstanceAttributeValueChanges());
        mr.setRequestedCorrelationKeyValueChanges(grabInstanceRequest.getRequestedCorrelationKeyValueChanges());
        mr.setValidateValue(grabInstanceRequest.isValidateValue());
        mr.setRequester(grabInstanceRequest.getRequester());
        return mr;
    }

    private IMigrateMultipleInstancesRequest grab2MigrateMultipleInstanceRequest(IGrabMultipleInstancesRequest grabMultipleInstanceRequest) {
        MigrateMultipleInstancesRequest migrateMultipleInstanceRequest = new MigrateMultipleInstancesRequest();
        migrateMultipleInstanceRequest.setApplyToAllInstances(grabMultipleInstanceRequest.isApplyToAllInstances());
        migrateMultipleInstanceRequest.setComments(grabMultipleInstanceRequest.getComments());
        migrateMultipleInstanceRequest.setLeaveNonMigratedInstancesSuspended(!grabMultipleInstanceRequest.isResumeInstanceIfRequired());
        migrateMultipleInstanceRequest.setMigrateInstance(false);
        migrateMultipleInstanceRequest.setProcessDN(grabMultipleInstanceRequest.getProcessDN());
        migrateMultipleInstanceRequest.setProcessInstances(grabMultipleInstanceRequest.getProcessInstances());
        migrateMultipleInstanceRequest.setRequestedFlowChanges(grabMultipleInstanceRequest.getRequestedFlowChanges());
        migrateMultipleInstanceRequest.setRequestedVariableValueChanges(grabMultipleInstanceRequest.getRequestedVariableValueChanges());
        migrateMultipleInstanceRequest.setRequestedInstanceAttributeValueChanges(grabMultipleInstanceRequest.getRequestedInstanceAttributeValueChanges());
        migrateMultipleInstanceRequest.setRequestedCorrelationKeyValueChanges(grabMultipleInstanceRequest.getRequestedCorrelationKeyValueChanges());
        migrateMultipleInstanceRequest.setResumeComponent(false);
        migrateMultipleInstanceRequest.setValidateValue(grabMultipleInstanceRequest.isValidateValue());
        migrateMultipleInstanceRequest.setRequester(grabMultipleInstanceRequest.getRequester());
        return migrateMultipleInstanceRequest;
    }

    private static class MigrationPagedQueryProcedure
    extends BasePagedQueryProcedure {
        private MigrationPagedQueryProcedure(IInstanceQueryService queryService) {
            super(queryService);
        }

        @Override
        public double getCountOfInstances(IBPMContext context, String processDN) throws BPMException {
            return this.getQueryService().getCountOfInstancesPendingMigration(context, processDN);
        }

        @Override
        public Iterable<IProcessInstance> getInstances(IBPMContext context, String processDN, int startRow, int endRow) throws BPMException {
            return this.getQueryService().getProcessInstancesPendingMigration(context, processDN, startRow, endRow);
        }

        @Override
        public IPermissionsService.InstanceAction getAction() {
            return IPermissionsService.InstanceAction.MIGRATE;
        }
    }

    private static class GrabPagedQueryProcedure
    extends BasePagedQueryProcedure {
        private GrabPagedQueryProcedure(IInstanceQueryService queryService) {
            super(queryService);
        }

        @Override
        public double getCountOfInstances(IBPMContext context, String processDN) throws BPMException {
            return this.getQueryService().getCountOfProcessInstances(context, processDN);
        }

        @Override
        public Iterable<IProcessInstance> getInstances(IBPMContext context, String processDN, int startRow, int endRow) throws BPMException, WorkflowException {
            Predicate predicate = new Predicate(IColumnConstants.PROCESS_PROCESSDEFINITIONID_COLUMN, 0, (Object)processDN);
            predicate.addClause(7, IColumnConstants.PROCESS_THREAD_COLUMN, 0, (Object)0);
            InstanceQueryInput input = new InstanceQueryInput();
            input.addState("OPEN");
            input.addState("SUSPENDED");
            input.setAssignmentFilter(IInstanceQueryInput.AssignmentFilter.ALL);
            input.setStartRow(startRow);
            input.setEndRow(endRow);
            ArrayList displayColumns = new ArrayList();
            return this.getQueryService().queryProcessInstances(context, displayColumns, predicate, null, (IInstanceQueryInput)input);
        }

        @Override
        public IPermissionsService.InstanceAction getAction() {
            return IPermissionsService.InstanceAction.GRAB;
        }
    }

    private static abstract class BasePagedQueryProcedure
    implements PagedQueryProcedure {
        private final IInstanceQueryService queryService;

        protected BasePagedQueryProcedure(IInstanceQueryService queryService) {
            this.queryService = queryService;
        }

        protected IInstanceQueryService getQueryService() {
            return this.queryService;
        }
    }

    private static interface PagedQueryProcedure {
        public double getCountOfInstances(IBPMContext var1, String var2) throws BPMException;

        public Iterable<IProcessInstance> getInstances(IBPMContext var1, String var2, int var3, int var4) throws BPMException, WorkflowException;

        public IPermissionsService.InstanceAction getAction();
    }
}

