/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.services.instancemanagement.impl;

import java.io.IOException;
import java.io.StringReader;
import java.lang.reflect.InvocationTargetException;
import java.math.BigDecimal;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import javax.xml.datatype.DatatypeConfigurationException;
import javax.xml.datatype.DatatypeFactory;
import javax.xml.datatype.Duration;
import javax.xml.datatype.XMLGregorianCalendar;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.ParserConfigurationException;
import oracle.bpel.services.bpm.common.IBPMContext;
import oracle.bpel.services.common.util.XMLUtil;
import oracle.bpm.services.client.IBPMServiceClient;
import oracle.bpm.services.common.exception.BPMException;
import oracle.bpm.services.instancemanagement.IInstanceAccess;
import oracle.bpm.services.instancemanagement.IInstanceManagementService;
import oracle.bpm.services.instancemanagement.JavaTypeDeserializer;
import oracle.bpm.services.instancemanagement.model.IGrabInstanceContext;
import oracle.bpm.services.instancemanagement.model.IGrabInstanceContextRequest;
import oracle.bpm.services.instancemanagement.model.IGrabInstanceContextResponse;
import oracle.bpm.services.instancemanagement.model.IGrabInstanceRequest;
import oracle.bpm.services.instancemanagement.model.IGrabInstanceResponse;
import oracle.bpm.services.instancemanagement.model.IInstanceContextConfiguration;
import oracle.bpm.services.instancemanagement.model.ILocationInfo;
import oracle.bpm.services.instancemanagement.model.IProcessInstance;
import oracle.bpm.services.instancemanagement.model.IVariableItem;
import oracle.bpm.services.instancemanagement.model.impl.alterflow.GrabInstanceContextRequest;
import oracle.bpm.services.instancemanagement.model.impl.alterflow.GrabInstanceRequest;
import oracle.bpm.services.instancemanagement.model.impl.alterflow.InstanceContextConfiguration;
import oracle.bpm.services.instancemanagement.model.impl.alterflow.LocationInfo;
import oracle.bpm.services.instancemanagement.model.impl.alterflow.VariableItem;
import oracle.bpm.services.instancequery.IInstanceQueryService;
import oracle.bpm.util.PrimitiveTypeUtils;
import oracle.xml.jaxp.JXDocumentBuilderFactory;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class InstanceAccessImpl
implements IInstanceAccess {
    private final IBPMContext context;
    private final Map<Class<?>, JavaTypeDeserializer> deserializerMap = new HashMap();
    private final IInstanceManagementService managementService;
    private final IInstanceQueryService queryService;
    private static final JavaTypeDeserializer defaultDeserializer = new DefaultJavaTypeDeserializer();

    public InstanceAccessImpl(IBPMServiceClient client, IBPMContext context) {
        this.context = context;
        this.managementService = client.getInstanceManagementService();
        this.queryService = client.getInstanceQueryService();
    }

    public <T> T getDataObjectValue(IProcessInstance instance, String dataObjectName, Class<T> type) throws BPMException {
        if (instance == null) {
            throw new IllegalArgumentException("instance can not be null");
        }
        if (dataObjectName == null) {
            throw new IllegalArgumentException("dataObjectName can not be null");
        }
        if (type == null) {
            throw new IllegalArgumentException("type can not be null");
        }
        String value = null;
        IGrabInstanceContext grabInstanceContext = this.createGrabInstanceContext(instance, true);
        for (IVariableItem item : grabInstanceContext.getAvailableVariables()) {
            if (!item.getName().equals(dataObjectName)) continue;
            value = item.getValue();
            break;
        }
        if (value == null) {
            throw new IllegalArgumentException("dataObjectName does not exist");
        }
        T result = type.cast(this.getDeserializer(type).deserialize(type, value));
        return result;
    }

    public Iterable<IVariableItem> getDataObjectDefinitions(IProcessInstance instance) throws BPMException {
        if (instance == null) {
            throw new IllegalArgumentException("instance can not be null");
        }
        IGrabInstanceContext grabInstanceContext = this.createGrabInstanceContext(instance, false);
        return grabInstanceContext.getAvailableVariables();
    }

    public boolean setDataObjectValue(IProcessInstance instance, String dataObjectName, Object value) throws BPMException {
        HashMap<String, Object> dataObjectUpdate = new HashMap<String, Object>();
        dataObjectUpdate.put(dataObjectName, value);
        return this.setDataObjectValues(instance, dataObjectUpdate);
    }

    public boolean setDataObjectValues(IProcessInstance instance, Map<String, Object> dataObjectUpdates) throws BPMException {
        if (instance == null) {
            throw new IllegalArgumentException("instance can not be null");
        }
        if (dataObjectUpdates == null) {
            throw new IllegalArgumentException("dataObjectName can not be null");
        }
        IInstanceManagementService managementService = this.getManagementService();
        IBPMContext bpmContext = this.getContext();
        GrabInstanceRequest grabRequest = new GrabInstanceRequest();
        grabRequest.setProcessInstance(instance);
        HashSet<VariableItem> variableChanges = new HashSet<VariableItem>();
        for (Map.Entry<String, Object> entry : dataObjectUpdates.entrySet()) {
            String dataObjectName = entry.getKey();
            Object dataObjectValue = entry.getValue();
            String stringValue = dataObjectValue.getClass().isPrimitive() ? String.valueOf(dataObjectValue) : this.getStringValue(dataObjectValue);
            VariableItem item = VariableItem.create((String)dataObjectName, (String)stringValue);
            variableChanges.add(item);
        }
        grabRequest.setRequestedVariableValueChanges(variableChanges);
        IGrabInstanceResponse grabResponse = managementService.grabInstance(bpmContext, (IGrabInstanceRequest)grabRequest);
        return grabResponse.getInstanceSummary().isSuccessfullyUpdated();
    }

    public void registerJavaTypeDeserializer(Class<?> type, JavaTypeDeserializer deserializer) {
        this.deserializerMap.put(type, deserializer);
    }

    private static JavaTypeDeserializer getDefaultDeserializer() {
        return defaultDeserializer;
    }

    private IGrabInstanceContext createGrabInstanceContext(IProcessInstance instance, boolean includeLargeDocuments) throws BPMException {
        IInstanceQueryService queryService = this.getQueryService();
        IBPMContext bpmContext = this.getContext();
        InstanceContextConfiguration.Builder builder = new InstanceContextConfiguration.Builder();
        builder.includeProcessDataObjects().includeProjectDataObjects();
        if (includeLargeDocuments) {
            builder.includeLargeDocuments();
        }
        IInstanceContextConfiguration configuration = builder.build();
        GrabInstanceContextRequest request = GrabInstanceContextRequest.create((IProcessInstance)instance, (boolean)false, (ILocationInfo)LocationInfo.ROOT_LOCATION, (IInstanceContextConfiguration)configuration);
        IGrabInstanceContextResponse response = queryService.createGrabInstanceContext(bpmContext, (IGrabInstanceContextRequest)request);
        return response.getGrabInstanceContext();
    }

    private String getStringValue(Object value) {
        String result = value instanceof Node ? XMLUtil.toString((Node)((Node)value)) : (value == null ? "" : value.toString());
        return result;
    }

    private IBPMContext getContext() {
        return this.context;
    }

    private IInstanceManagementService getManagementService() {
        return this.managementService;
    }

    private IInstanceQueryService getQueryService() {
        return this.queryService;
    }

    private JavaTypeDeserializer getDeserializer(Class<?> type) {
        JavaTypeDeserializer result = this.deserializerMap.get(type);
        if (result == null) {
            result = InstanceAccessImpl.getDefaultDeserializer();
        }
        return result;
    }

    private static class DefaultJavaTypeDeserializer
    implements JavaTypeDeserializer {
        private DefaultJavaTypeDeserializer() {
        }

        public Object deserialize(Class<?> type, String value) {
            Object result;
            if (type.isPrimitive()) {
                throw new IllegalArgumentException("Primitive classes are not supported, use the boxed class representation. For example, use Integer.class instead of int.class");
            }
            if (PrimitiveTypeUtils.unbox(type) != null) {
                result = this.convertStringToPrimitive(value, type);
            } else if (BigDecimal.class.isAssignableFrom(type)) {
                result = new BigDecimal(value);
            } else if (Element.class.isAssignableFrom(type)) {
                result = this.convertStringToXML(value);
            } else if (XMLGregorianCalendar.class.isAssignableFrom(type)) {
                result = this.toXMLGregorianCalendar(value);
            } else if (Duration.class.isAssignableFrom(type)) {
                result = this.toXMLDuration(value);
            } else if (String.class.isAssignableFrom(type)) {
                result = value;
            } else {
                throw new IllegalArgumentException("Invalid Class type specified:" + type.getName());
            }
            return result;
        }

        private XMLGregorianCalendar toXMLGregorianCalendar(String value) {
            try {
                return DatatypeFactory.newInstance().newXMLGregorianCalendar(value);
            }
            catch (DatatypeConfigurationException e) {
                throw new RuntimeException(e);
            }
        }

        private Duration toXMLDuration(String value) {
            try {
                return DatatypeFactory.newInstance().newDuration(value);
            }
            catch (DatatypeConfigurationException e) {
                throw new RuntimeException(e);
            }
        }

        private Object convertStringToPrimitive(String value, Class<?> clazz) {
            try {
                return clazz.getMethod("valueOf", String.class).invoke(null, value);
            }
            catch (IllegalAccessException e) {
                throw new RuntimeException(e);
            }
            catch (InvocationTargetException e) {
                throw new RuntimeException(e);
            }
            catch (NoSuchMethodException e) {
                throw new RuntimeException(e);
            }
        }

        private Element convertStringToXML(String value) {
            JXDocumentBuilderFactory dbf = new JXDocumentBuilderFactory();
            dbf.setNamespaceAware(true);
            try {
                DocumentBuilder documentBuilder = dbf.newDocumentBuilder();
                return documentBuilder.parse(new InputSource(new StringReader(value))).getDocumentElement();
            }
            catch (ParserConfigurationException e) {
                throw new RuntimeException(e);
            }
            catch (SAXException e) {
                throw new RuntimeException(e);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
    }
}

