/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.services.instancemanagement.impl;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import oracle.bpm.services.instancemanagement.model.IProcessInstance;

public class ErroredInstances {
    private Map<String, Payload> instances = new HashMap<String, Payload>();

    public boolean contains(IProcessInstance processInstance) {
        return this.instances.keySet().contains(this.getID(processInstance));
    }

    public Set<IProcessInstance> getInstances() {
        HashSet<IProcessInstance> pi = new HashSet<IProcessInstance>();
        for (String instanceId : this.instances.keySet()) {
            pi.add(this.instances.get(instanceId).getPI());
        }
        return pi;
    }

    public void add(IProcessInstance instance, int error) {
        this.instances.put(this.getID(instance), new Payload(instance, error));
    }

    public Integer getError(IProcessInstance processInstance) {
        return this.instances.get(this.getID(processInstance)).getError();
    }

    private String getID(IProcessInstance instance) {
        return instance.getSystemAttributes().getProcessInstanceId();
    }

    private class Payload {
        private int error;
        private IProcessInstance instance;

        public Payload(IProcessInstance instance, int error) {
            this.instance = instance;
            this.error = error;
        }

        public int getError() {
            return this.error;
        }

        public IProcessInstance getPI() {
            return this.instance;
        }
    }
}

