/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.services.document.impl;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import oracle.bpm.services.document.impl.RIDCContext;
import oracle.bpm.services.document.impl.RIDCDataObject;
import oracle.stellent.ridc.model.DataBinder;
import oracle.stellent.ridc.model.DataObject;
import oracle.stellent.ridc.model.DataResultSet;
import oracle.stellent.ridc.model.TransferFile;
import oracle.stellent.ridc.protocol.ServiceResponse;

public class RIDCUtil {
    public static DataBinder uploadDocument(RIDCContext context, String docName, String docType, String taskId, String updatedBy, InputStream inputStream) throws Exception {
        int len;
        DataBinder binder = context.getIdcClient().createBinder();
        binder.putLocal("IdcService", "CHECKIN_UNIVERSAL");
        binder.putLocal("dDocTitle", docName);
        binder.putLocal("dDocName", docName);
        binder.putLocal("dDocType", docType);
        binder.putLocal("dSecurityGroup", context.getSecurityGroup());
        binder.putLocal("xTaskId", taskId);
        binder.putLocal("dAuthor", updatedBy);
        binder.getLocalData().setDate("dInDate", new Date());
        File file = File.createTempFile(docName, ".tmp");
        FileOutputStream out = new FileOutputStream(file);
        byte[] buf = new byte[1024];
        while ((len = inputStream.read(buf)) > 0) {
            ((OutputStream)out).write(buf, 0, len);
        }
        inputStream.close();
        ((OutputStream)out).close();
        inputStream = new FileInputStream(file);
        binder.addFile("primaryFile", new TransferFile(inputStream, docName, file.length()));
        ServiceResponse response = context.getIdcClient().sendRequest(context.getIdcContext(), binder);
        return response.getResponseAsBinder();
    }

    public static InputStream getFile(RIDCContext context, String dID) throws Exception {
        DataBinder dataBinder = context.getIdcClient().createBinder();
        dataBinder.putLocal("IdcService", "GET_FILE");
        dataBinder.putLocal("dID", dID);
        ServiceResponse response = context.getIdcClient().sendRequest(context.getIdcContext(), dataBinder);
        return response.getResponseStream();
    }

    public static List<DataObject> getTaskDocDataObjects(RIDCContext context, String taskId) throws Exception {
        DataBinder dataBinder = context.getIdcClient().createBinder();
        dataBinder.putLocal("IdcService", "GET_SEARCH_RESULTS");
        dataBinder.putLocal("ResultCount", "2048");
        String queryText = "xTaskId <matches> `" + taskId + "`";
        dataBinder.putLocal("QueryText", queryText);
        dataBinder.putLocal("SearchQueryFormat", "Universal");
        ServiceResponse response = context.getIdcClient().sendRequest(context.getIdcContext(), dataBinder);
        DataBinder responseData = response.getResponseAsBinder();
        DataResultSet searchResults = responseData.getResultSet("SearchResults");
        List dataObjectRows = searchResults.getRows();
        return dataObjectRows;
    }

    public static void deleteFile(RIDCContext context, String dID, String dDocName) throws Exception {
        DataBinder dataBinder = context.getIdcClient().createBinder();
        dataBinder.putLocal("IdcService", "DELETE_DOC");
        dataBinder.putLocal("dID", dID);
        dataBinder.putLocal("dDocName", dDocName);
        ServiceResponse response = context.getIdcClient().sendRequest(context.getIdcContext(), dataBinder);
        response.getResponseAsBinder();
    }

    public static void deleteDocument(RIDCContext context, String taskId, String dDocName) throws Exception {
        String dID = RIDCUtil.getDocumentID(context, taskId, dDocName);
        RIDCUtil.deleteFile(context, dID, dDocName);
    }

    public static String getDocumentID(RIDCContext context, String taskId, String dDocName) throws Exception {
        List<RIDCDataObject> dataObjectRows = RIDCUtil.quickSearch(context, taskId);
        for (RIDCDataObject dataObject : dataObjectRows) {
            String documentName = dataObject.getDocumentName();
            if (!documentName.equals(dDocName)) continue;
            return (String)dataObject.getDataObject().get((Object)"dID");
        }
        return null;
    }

    public static InputStream getInputStream(RIDCContext context, RIDCDataObject dataObject) throws Exception {
        String documentId = (String)dataObject.getDataObject().get((Object)"dID");
        return RIDCUtil.getFile(context, documentId);
    }

    public static List<RIDCDataObject> quickSearch(RIDCContext context, String taskId) throws Exception {
        DataBinder dataBinder = context.getIdcClient().createBinder();
        dataBinder.putLocal("IdcService", "GET_SEARCH_RESULTS");
        dataBinder.putLocal("ResultCount", "2048");
        String queryText = "xTaskId <matches> `" + taskId + "`";
        dataBinder.putLocal("QueryText", queryText);
        dataBinder.putLocal("SearchQueryFormat", "Universal");
        ServiceResponse response = context.getIdcClient().sendRequest(context.getIdcContext(), dataBinder);
        DataBinder responseData = response.getResponseAsBinder();
        DataResultSet searchResults = responseData.getResultSet("SearchResults");
        List dataObjectRows = searchResults.getRows();
        ArrayList<RIDCDataObject> ridcDataObjectList = new ArrayList<RIDCDataObject>();
        for (DataObject row : dataObjectRows) {
            RIDCDataObject ridcDataObject = new RIDCDataObject(row);
            ridcDataObjectList.add(ridcDataObject);
        }
        return ridcDataObjectList;
    }

    public InputStream getFile(RIDCContext context, RIDCDataObject dataObject) throws Exception {
        String dID = dataObject.getDocumentId();
        return RIDCUtil.getFile(context, dID);
    }
}

