/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.services.document.impl;

import java.io.InputStream;
import java.io.Serializable;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.List;
import oracle.bpel.services.workflow.callback.DocumentStore;
import oracle.bpel.services.workflow.repos.Util;
import oracle.bpel.services.workflow.task.model.DocumentType;
import oracle.bpel.services.workflow.task.model.Task;
import oracle.bpel.services.workflow.verification.IVerificationService;
import oracle.bpel.services.workflow.verification.IWorkflowContext;
import oracle.bpel.services.workflow.verification.impl.VerificationService;
import oracle.bpm.services.document.impl.RIDCContext;
import oracle.bpm.services.document.impl.RIDCDataObject;
import oracle.bpm.services.document.impl.RIDCUtil;

public class RIDCDocumentStore
implements DocumentStore,
Serializable {
    IVerificationService verificationService = null;
    private RIDCContext m_context = this.getContext();
    public static final String MIME_TYPE = "application/octet-stream";

    public void addDocument(Task task, DocumentType document) throws Exception {
        InputStream is;
        String docTitle;
        String taskId = task.getSystemAttributes().getTaskId();
        String docName = docTitle = document.getName();
        String updatedBy = document.getUpdatedBy();
        String docType = document.getUcmDocumentType();
        if (docType == null || docType.equals("")) {
            docType = "Task";
        }
        if ((is = document.getInputStream()) == null) {
            return;
        }
        RIDCUtil.uploadDocument(this.m_context, docName, docType, taskId, updatedBy, is);
    }

    public List<DocumentType> getDocuments(Task task, String folderName, Boolean createNew) throws Exception {
        ArrayList<DocumentType> docList = new ArrayList<DocumentType>();
        String taskId = task.getSystemAttributes().getTaskId();
        List<RIDCDataObject> dataObjectRows = RIDCUtil.quickSearch(this.m_context, taskId);
        for (RIDCDataObject dataObject : dataObjectRows) {
            String uri = null;
            String content = null;
            String name = dataObject.getDocumentName();
            String updatedBy = dataObject.getUpdatedBy();
            Calendar updatedDate = Calendar.getInstance();
            String documentTypeName = dataObject.getDocumentType();
            DocumentType documentType = Util.getDocumentType((String)MIME_TYPE, uri, content, (String)name, (String)updatedBy, (Calendar)updatedDate);
            documentType.setUcmDocumentType(documentTypeName);
            docList.add(documentType);
        }
        return docList;
    }

    public DocumentType getDocumentStream(Task task, String documentName) throws Exception {
        String taskId = task.getSystemAttributes().getTaskId();
        List<RIDCDataObject> dataObjectRows = RIDCUtil.quickSearch(this.m_context, taskId);
        String mimeType = MIME_TYPE;
        String uri = null;
        String content = null;
        DocumentType documentType = null;
        Calendar updatedDate = Calendar.getInstance();
        for (RIDCDataObject dataObject : dataObjectRows) {
            String name = dataObject.getDocumentName();
            if (!name.equalsIgnoreCase(documentName)) continue;
            String updatedBy = dataObject.getUpdatedBy();
            documentType = Util.getDocumentType((String)mimeType, uri, content, (String)name, (String)updatedBy, (Calendar)updatedDate);
            InputStream is = RIDCUtil.getInputStream(this.m_context, dataObject);
            documentType.setInputStream(is);
        }
        return documentType;
    }

    public void removeDocument(Task task, List documentNames) throws Exception {
        String taskId = task.getSystemAttributes().getTaskId();
        for (int i = 0; i < documentNames.size(); ++i) {
            String documentName = (String)documentNames.get(i);
            RIDCUtil.deleteDocument(this.m_context, taskId, documentName);
        }
    }

    public void addDocument(IWorkflowContext wfctx, Task task, DocumentType document) throws Exception {
        String taskId = task.getSystemAttributes().getTaskId();
        this.validateContext(wfctx, taskId);
        this.addDocument(task, document);
    }

    public List<DocumentType> getDocuments(IWorkflowContext wfctx, Task task, String folderName, Boolean createNew) throws Exception {
        String taskId = task.getSystemAttributes().getTaskId();
        this.validateContext(wfctx, taskId);
        return this.getDocuments(task, folderName, createNew);
    }

    public DocumentType getDocumentStream(IWorkflowContext wfctx, Task task, String documentName) throws Exception {
        String taskId = task.getSystemAttributes().getTaskId();
        this.validateContext(wfctx, taskId);
        return this.getDocumentStream(task, documentName);
    }

    public void removeDocument(IWorkflowContext wfctx, Task task, List documentNames) throws Exception {
        String taskId = task.getSystemAttributes().getTaskId();
        this.validateContext(wfctx, taskId);
        this.removeDocument(task, documentNames);
    }

    public IVerificationService getVerificationService() {
        if (this.verificationService == null) {
            this.verificationService = new VerificationService();
        }
        return this.verificationService;
    }

    private RIDCContext getContext() {
        try {
            RIDCContext context = (RIDCContext)AccessController.doPrivileged(new PrivilegedExceptionAction(){

                public Object run() throws Exception {
                    RIDCContext object = new RIDCContext();
                    return object;
                }
            });
            return context;
        }
        catch (PrivilegedActionException pae) {
            return null;
        }
    }

    private void validateContext(IWorkflowContext context, String taskId) throws Exception {
        this.getVerificationService().validateContext(context);
    }
}

