/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.services.bpmapp.util;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import oracle.bpm.client.bpmapp.model.projectInfo.impl.BpmDeployedDevProjectInfoImpl;
import oracle.bpm.client.bpmapp.model.projectInfo.impl.BpmDeployedProjectInfoImpl;
import oracle.bpm.client.bpmapp.model.projectInfo.impl.BpmDevProjectInfoImpl;
import oracle.bpm.metadata.LocalRef;
import oracle.bpm.metadata.MdTree;
import oracle.bpm.metadata.entity.DeployedProject;
import oracle.bpm.metadata.entity.MdProject;
import oracle.bpm.metadata.entity.PublicShareProject;
import oracle.bpm.metadata.entity.TemplateProject;
import oracle.bpm.services.bpmapp.model.BpmDeployedProjectInfo;
import oracle.bpm.services.bpmapp.model.BpmDevProjectInfo;
import oracle.bpm.services.bpmapp.model.BpmProjectInfo;
import oracle.bpm.services.bpmapp.util.BpmAppServiceHelper;
import org.jetbrains.annotations.NotNull;

public class BpmProjectInfoFactory {
    public static List<BpmProjectInfo> createMergedList(@NotNull List<BpmDevProjectInfo> devProjects, @NotNull List<BpmDeployedProjectInfo> deployedProjects) {
        ArrayList<BpmProjectInfo> result = new ArrayList<BpmProjectInfo>();
        for (BpmDeployedProjectInfo deploy : deployedProjects) {
            BpmDevProjectInfo foundDev = BpmProjectInfoFactory.findProject(devProjects, deploy.getName());
            if (foundDev == null) {
                result.add((BpmProjectInfo)deploy);
                continue;
            }
            result.add((BpmProjectInfo)new BpmDeployedDevProjectInfoImpl(deploy, foundDev));
        }
        for (BpmDevProjectInfo dev : devProjects) {
            BpmDeployedProjectInfo foundDeploy = BpmProjectInfoFactory.findProject(deployedProjects, dev.getName());
            if (foundDeploy != null) continue;
            result.add((BpmProjectInfo)dev);
        }
        Collections.sort(result);
        return result;
    }

    public static List<BpmDevProjectInfo> createDevList(@NotNull MdTree projects) {
        ArrayList<BpmDevProjectInfo> result = new ArrayList<BpmDevProjectInfo>();
        Collection localRefCollection = projects.toCollection(true);
        for (LocalRef projectArtifactLocalRef : localRefCollection) {
            MdProject project = (MdProject)projectArtifactLocalRef.get();
            result.add((BpmDevProjectInfo)BpmProjectInfoFactory.createDev(project));
        }
        return result;
    }

    public static List<BpmDeployedProjectInfo> createDeployedList(@NotNull Collection<LocalRef<DeployedProject>> projects) {
        ArrayList<BpmDeployedProjectInfo> result = new ArrayList<BpmDeployedProjectInfo>();
        for (LocalRef<DeployedProject> projectArtifactLocalRef : projects) {
            DeployedProject project = (DeployedProject)projectArtifactLocalRef.get();
            result.add(BpmProjectInfoFactory.createDeployed(project));
        }
        return result;
    }

    private static <P extends BpmProjectInfo> P findProject(List<P> projects, String name) {
        for (BpmProjectInfo project : projects) {
            if (!project.getName().equals(name)) continue;
            return (P)project;
        }
        return null;
    }

    private static BpmDevProjectInfoImpl createDev(@NotNull MdProject project) {
        String description = null;
        if (project instanceof PublicShareProject) {
            description = ((PublicShareProject)project).getDescription();
        } else if (project instanceof TemplateProject) {
            description = ((TemplateProject)project).getDescription();
        }
        return new BpmDevProjectInfoImpl(project.getName(), project.getId(), description);
    }

    private static BpmDeployedProjectInfo createDeployed(@NotNull DeployedProject project) {
        String name = BpmAppServiceHelper.getDeployedProjectName(project);
        return new BpmDeployedProjectInfoImpl(name, project.getCompositeDN(), project.getVersion());
    }
}

