/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.services.bpmapp.util;

import java.io.File;
import java.util.ArrayList;
import java.util.List;
import oracle.bpm.client.bpmapp.exception.InvalidNameException;
import oracle.bpm.client.bpmapp.exception.ProcessNotFoundException;
import oracle.bpm.collections.Sequence;
import oracle.bpm.lang.Str;
import oracle.bpm.metadata.entity.DeployedProject;
import oracle.bpm.project.ProjectResourceObjectFactory;
import oracle.bpm.project.io.fs.FileProjectRepository;
import oracle.bpm.project.model.FolderContainer;
import oracle.bpm.project.model.Project;
import oracle.bpm.project.model.ProjectObject;
import oracle.bpm.project.model.ResourceContainer;
import oracle.bpm.project.model.catalog.DataDeclaration;
import oracle.bpm.project.model.catalog.DataDeclarationContainer;
import oracle.bpm.project.model.exception.ProjectException;
import oracle.bpm.project.model.processes.Event;
import oracle.bpm.project.model.processes.EventTriggerType;
import oracle.bpm.project.model.processes.Process;
import oracle.bpm.project.model.processes.conversational.DefineInterfaceConversationalDefinition;
import oracle.bpm.services.bpmapp.model.BpmOperationArgument;
import oracle.bpm.services.bpmapp.model.BpmProcessOperation;
import oracle.bpm.util.Identifier;
import org.jetbrains.annotations.NotNull;

public class BpmAppServiceHelper {
    private static final String DEPLOYED_PROJECT_REV = "_rev";
    private static final String TEMP_PROJECTS_DIR_NAME = "tempProjects";

    public static Project createScratchProject(@NotNull String name) throws ProjectException {
        String tempDir = System.getProperty("java.io.tmpdir");
        File projectsTmpDir = new File(tempDir, TEMP_PROJECTS_DIR_NAME);
        FileProjectRepository repository = FileProjectRepository.create((File)projectsTmpDir);
        Project project = repository.create(projectsTmpDir.toURI(), name);
        FolderContainer root = project.getModelsRoot();
        Process process = ProjectResourceObjectFactory.createProcess((ResourceContainer)root, (String)name, (boolean)true, (boolean)false);
        root.addChild((ProjectObject)process);
        project.getWriter().write(new ProjectObject[]{process});
        project.getWriter().write(new ProjectObject[]{project});
        return project;
    }

    public static List<BpmProcessOperation> getProcessArguments(@NotNull Process process, @NotNull Class<? extends Event> eventClass) {
        ArrayList<BpmProcessOperation> result = new ArrayList<BpmProcessOperation>();
        for (Event event : process.getEvents(eventClass, EventTriggerType.MESSAGE)) {
            DefineInterfaceConversationalDefinition conversationalDefinition = (DefineInterfaceConversationalDefinition)event.getConversationalDefinition().as(DefineInterfaceConversationalDefinition.class);
            if (conversationalDefinition == null) continue;
            String operationName = conversationalDefinition.getDefinedOperationName();
            DataDeclarationContainer container = conversationalDefinition.getArgumentsContainer();
            List<BpmOperationArgument> args = BpmAppServiceHelper.createBpmOperationArguments(container);
            result.add(new BpmProcessOperation(operationName, args));
        }
        return result;
    }

    public static String getDeployedProjectName(@NotNull DeployedProject deployedProject) {
        String deployedProjectName = deployedProject.getName();
        int revIndex = deployedProjectName.lastIndexOf(DEPLOYED_PROJECT_REV);
        if (revIndex > -1) {
            deployedProjectName = deployedProjectName.substring(0, revIndex);
        }
        return deployedProjectName;
    }

    public static void validateProjectName(String name) throws InvalidNameException {
        if (Str.isEmpty((String)name) || !Identifier.isValid((String)name)) {
            String suggested = Identifier.valid((String)name);
            if (Str.isEmpty((String)suggested)) {
                suggested = "NewProject";
            }
            throw new InvalidNameException(name, suggested);
        }
    }

    @NotNull
    public static Process findProcess(Project project, String processId) throws ProcessNotFoundException {
        Process process = project.findProcess(processId);
        if (process == null) {
            throw new ProcessNotFoundException(project.getId(), processId);
        }
        return process;
    }

    public static List<String> buildProcessList(Project project) {
        ArrayList<String> result = new ArrayList<String>();
        for (Process process : project.getProcesses()) {
            result.add(process.getId());
        }
        return result;
    }

    private static List<BpmOperationArgument> createBpmOperationArguments(DataDeclarationContainer container) {
        ArrayList<BpmOperationArgument> arguments = new ArrayList<BpmOperationArgument>();
        Sequence declarations = container.getLocalDeclarations();
        if (declarations != null) {
            for (DataDeclaration dec : declarations) {
                arguments.add(new BpmOperationArgument(dec.getName(), dec.getType().getText()));
            }
        }
        return arguments;
    }
}

