/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.services.bpmapp.impl;

import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import oracle.bpel.services.bpm.common.IBPMContext;
import oracle.bpel.services.workflow.client.IWorkflowServiceClientConstants;
import oracle.bpel.services.workflow.runtimeconfig.IRuntimeConfigService;
import oracle.bpel.services.workflow.verification.IVerificationService;
import oracle.bpel.services.workflow.verification.IWorkflowContext;
import oracle.bpm.client.BPMServiceClientFactory;
import oracle.bpm.client.bpmapp.model.template.impl.TemplateMetadataImpl;
import oracle.bpm.collections.Predicate;
import oracle.bpm.collections.Sequence;
import oracle.bpm.data.BusinessVariableType;
import oracle.bpm.log.Log;
import oracle.bpm.metadata.LocalRef;
import oracle.bpm.metadata.MdTree;
import oracle.bpm.metadata.artifact.jaxb.ProjectType;
import oracle.bpm.metadata.entity.DeployedProject;
import oracle.bpm.metadata.entity.ProjectFolder;
import oracle.bpm.metadata.entity.PublicShareProject;
import oracle.bpm.metadata.entity.TemplateProject;
import oracle.bpm.metadata.exception.MetadataException;
import oracle.bpm.metadata.exception.ProjectNotFoundException;
import oracle.bpm.metadata.impl.MetadataArtifactHelper;
import oracle.bpm.metadata.mds.MdsInstanceInitializer;
import oracle.bpm.pml.security.exception.PmlSecurityException;
import oracle.bpm.pml.security.model.ProjectPolicies;
import oracle.bpm.pml.security.model.ProjectPolicy;
import oracle.bpm.pml.security.model.ProjectRole;
import oracle.bpm.pml.service.ComposerMetadataService;
import oracle.bpm.pml.service.MdProjectSecurityManagerService;
import oracle.bpm.pml.service.impl.ComposerMetadataServiceImpl;
import oracle.bpm.pml.service.util.MdProjectUtil;
import oracle.bpm.project.model.Project;
import oracle.bpm.project.model.ProjectDataObject;
import oracle.bpm.project.model.exception.ProjectException;
import oracle.bpm.project.model.processes.EndEvent;
import oracle.bpm.project.model.processes.Event;
import oracle.bpm.project.model.processes.Process;
import oracle.bpm.project.model.processes.StartEvent;
import oracle.bpm.services.bpmapp.BpmAppServiceException;
import oracle.bpm.services.bpmapp.IBpmAppService;
import oracle.bpm.services.bpmapp.model.BpmDeployedProjectInfo;
import oracle.bpm.services.bpmapp.model.BpmDevProjectInfo;
import oracle.bpm.services.bpmapp.model.BpmProcessOperation;
import oracle.bpm.services.bpmapp.model.BpmProjectInfo;
import oracle.bpm.services.bpmapp.model.BpmProjectRole;
import oracle.bpm.services.bpmapp.model.templateMetadata.TemplateMetadata;
import oracle.bpm.services.bpmapp.msg.BpmAppServiceMsg;
import oracle.bpm.services.bpmapp.util.BpmAppServiceExceptionFactory;
import oracle.bpm.services.bpmapp.util.BpmAppServiceHelper;
import oracle.bpm.services.bpmapp.util.BpmProjectInfoFactory;
import oracle.bpm.services.common.exception.BPMException;
import oracle.bpm.services.internal.InternalBPMContext;
import oracle.fabric.composite.CompositeDN;
import oracle.integration.platform.common.FabricMDSAccessor;
import oracle.mds.core.MDSInstance;
import oracle.mds.exception.MDSException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class BpmAppService
implements IBpmAppService {
    private IVerificationService verificationService;
    private static final String ROOT_PROJECT_FOLDER_PATH = "/";
    private static final ProjectFolder ROOT_PROJECT_FOLDER = ProjectFolder.create((String)"/");

    public String createProject(@NotNull IBPMContext context, @NotNull String name) throws BpmAppServiceException {
        return this.createProject(context, name, null, true, true);
    }

    public String createProject(@NotNull IBPMContext context, @NotNull String name, @NotNull String templateId) throws BpmAppServiceException {
        return this.createProject(context, name, templateId, null, true, true);
    }

    public String createProject(@NotNull IBPMContext context, @NotNull String name, String description, boolean lock, boolean override) throws BpmAppServiceException {
        BpmAppServiceHelper.validateProjectName(name);
        ComposerMetadataService service = this.createComposerMetadataService(context);
        try {
            Project project = BpmAppServiceHelper.createScratchProject(name);
            PublicShareProject publicShare = new PublicShareProject(name, description, project);
            publicShare.setAllowSharing(true);
            publicShare = service.savePublicShare(ROOT_PROJECT_FOLDER, publicShare, override, lock);
            this.secureProject(service, name);
            return publicShare.getId();
        }
        catch (MetadataException e) {
            throw BpmAppServiceExceptionFactory.createException(e);
        }
        catch (ProjectException e) {
            throw new BpmAppServiceException((Throwable)e);
        }
    }

    public String createProject(@NotNull IBPMContext context, @NotNull String name, final @NotNull String templateId, String description, boolean lock, boolean override) throws BpmAppServiceException {
        BpmAppServiceHelper.validateProjectName(name);
        ComposerMetadataService service = this.createComposerMetadataService(context);
        try {
            LocalRef templateRef;
            block6: {
                templateRef = null;
                try {
                    templateRef = service.loadProject(TemplateProject.class, templateId, true);
                }
                catch (ProjectNotFoundException e) {
                    Collection localRefs = service.browse(TemplateProject.class, (Predicate)new Predicate<TemplateProject>(){

                        public boolean check(@Nullable TemplateProject value) {
                            return value != null && value.getId().equals(templateId);
                        }
                    }).toCollection(true);
                    if (localRefs.isEmpty()) break block6;
                    templateRef = (LocalRef)localRefs.iterator().next();
                }
            }
            if (templateRef == null) {
                throw new oracle.bpm.client.bpmapp.exception.ProjectNotFoundException(templateId);
            }
            TemplateProject templateProject = (TemplateProject)templateRef.get();
            Project project = (Project)templateProject.getProject().get();
            PublicShareProject publicShare = new PublicShareProject(name, description, project);
            publicShare.setAllowSharing(true);
            publicShare = service.createPublicShare(ROOT_PROJECT_FOLDER, publicShare, templateProject, override, lock);
            this.secureProject(service, name);
            return publicShare.getId();
        }
        catch (ProjectNotFoundException e) {
            throw new oracle.bpm.client.bpmapp.exception.ProjectNotFoundException(templateId);
        }
        catch (MetadataException e) {
            throw BpmAppServiceExceptionFactory.createException(e);
        }
    }

    public void grantRole(@NotNull IBPMContext context, @NotNull String project, @NotNull BpmProjectRole role, boolean isPublic, @Nullable Set<String> principals) throws BpmAppServiceException {
        BpmAppServiceHelper.validateProjectName(project);
        ComposerMetadataService service = this.createComposerMetadataService(context);
        ProjectPolicies projectPolicies = this.getProjectPolicies(service, project);
        try {
            ProjectPolicy policy = projectPolicies.getPolicyFor(ProjectRole.valueOf((String)role.name()));
            policy.setPublic(isPublic);
            if (isPublic) {
                policy.setPrincipals(null);
            } else {
                policy.setPrincipals(principals);
            }
            projectPolicies.save();
        }
        catch (PmlSecurityException e) {
            throw BpmAppServiceExceptionFactory.createException((MetadataException)((Object)e));
        }
    }

    public Set<String> getRoleGrants(@NotNull IBPMContext context, @NotNull String project, @NotNull BpmProjectRole role) throws BpmAppServiceException {
        BpmAppServiceHelper.validateProjectName(project);
        ComposerMetadataService service = this.createComposerMetadataService(context);
        ProjectPolicies projectPolicies = this.getProjectPolicies(service, project);
        ProjectPolicy policy = projectPolicies.getPolicyFor(ProjectRole.valueOf((String)role.name()));
        return policy.getPrincipals();
    }

    public boolean isRolePublic(@NotNull IBPMContext context, @NotNull String project, @NotNull BpmProjectRole role) throws BpmAppServiceException {
        BpmAppServiceHelper.validateProjectName(project);
        ComposerMetadataService service = this.createComposerMetadataService(context);
        ProjectPolicies projectPolicies = this.getProjectPolicies(service, project);
        ProjectPolicy policy = projectPolicies.getPolicyFor(ProjectRole.valueOf((String)role.name()));
        return policy.isPublic();
    }

    public List<BpmDevProjectInfo> getTemplateProjects(@NotNull IBPMContext context) throws BpmAppServiceException {
        ComposerMetadataService service = this.createComposerMetadataService(context);
        try {
            MdTree projects = service.browse(TemplateProject.class, null);
            return BpmProjectInfoFactory.createDevList(projects);
        }
        catch (MetadataException e) {
            throw BpmAppServiceExceptionFactory.createException(e);
        }
    }

    public List<BpmDevProjectInfo> getDevProjects(@NotNull IBPMContext context) throws BpmAppServiceException {
        ComposerMetadataService service = this.createComposerMetadataService(context);
        try {
            MdTree projects = service.browse(PublicShareProject.class, null);
            return BpmProjectInfoFactory.createDevList(projects);
        }
        catch (MetadataException e) {
            throw BpmAppServiceExceptionFactory.createException(e);
        }
    }

    public List<BpmDeployedProjectInfo> getDeployedProjects(@NotNull IBPMContext context, boolean onlyLastDeployedVersion) throws BpmAppServiceException {
        ComposerMetadataService service = this.createComposerMetadataService(context);
        try {
            Collection<LocalRef<DeployedProject>> projects = service.getDeployedProjects();
            if (onlyLastDeployedVersion) {
                projects = this.filterToLastDeployedVersion(service, projects);
            }
            return BpmProjectInfoFactory.createDeployedList(projects);
        }
        catch (MetadataException e) {
            throw BpmAppServiceExceptionFactory.createException(e);
        }
    }

    public List<BpmProjectInfo> getAllProjects(@NotNull IBPMContext context, boolean onlyLastDeployedVersion) throws BpmAppServiceException {
        List<BpmDevProjectInfo> devProjects = this.getDevProjects(context);
        List<BpmDeployedProjectInfo> deployedProjects = this.getDeployedProjects(context, onlyLastDeployedVersion);
        return BpmProjectInfoFactory.createMergedList(devProjects, deployedProjects);
    }

    public List<String> getDevProcesses(@NotNull IBPMContext context, @NotNull String projectId) throws BpmAppServiceException {
        ComposerMetadataService service = this.createComposerMetadataService(context);
        try {
            Project project = this.loadPublicSharedProject(service, projectId);
            return BpmAppServiceHelper.buildProcessList(project);
        }
        catch (MetadataException e) {
            throw BpmAppServiceExceptionFactory.createException(e);
        }
    }

    public List<String> getDeployedProcesses(@NotNull IBPMContext context, @NotNull String deployedProjectId) throws BpmAppServiceException {
        try {
            ComposerMetadataService service = this.createComposerMetadataService(context);
            Project project = this.loadDeployedProject(service, deployedProjectId);
            return BpmAppServiceHelper.buildProcessList(project);
        }
        catch (MetadataException e) {
            throw BpmAppServiceExceptionFactory.createException(e);
        }
    }

    public List<BpmProcessOperation> getDeployedInputProcessArguments(@NotNull IBPMContext context, @NotNull String deployedProjectId, @NotNull String processId) throws BpmAppServiceException {
        return this.getProcessArguments(context, deployedProjectId, processId, true, StartEvent.class);
    }

    public List<BpmProcessOperation> getDevInputProcessArguments(@NotNull IBPMContext context, @NotNull String devProjectId, @NotNull String processId) throws BpmAppServiceException {
        return this.getProcessArguments(context, devProjectId, processId, false, StartEvent.class);
    }

    public List<BpmProcessOperation> getDeployedOutputProcessArguments(@NotNull IBPMContext context, @NotNull String deployedProjectId, @NotNull String processId) throws BpmAppServiceException {
        return this.getProcessArguments(context, deployedProjectId, processId, true, EndEvent.class);
    }

    public List<BpmProcessOperation> getDevOutputProcessArguments(@NotNull IBPMContext context, @NotNull String devProjectId, @NotNull String processId) throws BpmAppServiceException {
        return this.getProcessArguments(context, devProjectId, processId, false, EndEvent.class);
    }

    public List<TemplateMetadata> getAllTemplateMetadata() throws BpmAppServiceException {
        try {
            List<BpmDevProjectInfo> templateProjects = this.getTemplateProjects(InternalBPMContext.getInternalBPMContext());
            ArrayList<TemplateMetadata> templateMetadataList = new ArrayList<TemplateMetadata>();
            for (BpmDevProjectInfo projectInfo : templateProjects) {
                templateMetadataList.add(this.getTemplateMetadata(projectInfo.getName()));
            }
            return templateMetadataList;
        }
        catch (BPMException e) {
            throw new BpmAppServiceException((Throwable)e);
        }
    }

    public TemplateMetadata getTemplateMetadata(String templateName) throws BpmAppServiceException {
        try {
            Project project = this.loadTemplateProject(InternalBPMContext.getInternalBPMContext(), templateName);
            String templateViewIdentifier = project.getPreferences().getTemplateViewIdentifier();
            List databaseGrantees = project.getPreferences().getDatabaseGrantees();
            TemplateMetadataImpl result = new TemplateMetadataImpl(templateName, templateViewIdentifier, databaseGrantees);
            this.addTemplateBI((TemplateMetadata)result, project);
            return result;
        }
        catch (MetadataException e) {
            throw BpmAppServiceExceptionFactory.createException(e);
        }
        catch (BPMException e2) {
            throw new BpmAppServiceException((Throwable)e2);
        }
    }

    public IVerificationService getVerificationService() {
        return this.verificationService;
    }

    public void setVerificationService(IVerificationService verificationService) {
        this.verificationService = verificationService;
    }

    private void addTemplateBI(@NotNull TemplateMetadata templateMetadata, @NotNull Project project) {
        Sequence businessIndicators = project.getBusinessIndicators();
        for (ProjectDataObject businessIndicator : businessIndicators) {
            BusinessVariableType biType = businessIndicator.getBusinessVariableType();
            String name = businessIndicator.getId();
            TemplateMetadata.BIType type = biType.isCounter() ? TemplateMetadata.BIType.COUNTER : (biType.isDimension() ? TemplateMetadata.BIType.DIMENSION : TemplateMetadata.BIType.MEASURE);
            TemplateMetadata.BIValueType valueType = businessIndicator.getType().isNumber() || businessIndicator.getType().isDecimal() || businessIndicator.getType().isInt() || businessIndicator.getType().isReal() ? TemplateMetadata.BIValueType.NUMBER : (businessIndicator.getType().isTime() ? TemplateMetadata.BIValueType.DATE : TemplateMetadata.BIValueType.STRING);
            templateMetadata.addBIInfo(name, type, valueType);
        }
    }

    private ProjectPolicies getProjectPolicies(@NotNull ComposerMetadataService service, String project) throws BpmAppServiceException {
        ProjectPolicies result;
        MdProjectSecurityManagerService managerService = service.getSecurityManagerService();
        ProjectType projectType = MetadataArtifactHelper.getProjectType(PublicShareProject.class);
        String projectId = MdProjectUtil.createMdProjectFullId((ProjectType)projectType, (String)project);
        try {
            result = managerService.getProjectPolicies(projectId);
        }
        catch (PmlSecurityException e) {
            throw BpmAppServiceExceptionFactory.createException((MetadataException)((Object)e));
        }
        return result;
    }

    private void secureProject(@NotNull ComposerMetadataService service, @NotNull String project) throws BpmAppServiceException {
        ProjectPolicies projectPolicies = this.getProjectPolicies(service, project);
        try {
            ProjectPolicy policy = projectPolicies.getPolicyFor(ProjectRole.OWNER);
            if (!policy.isPublic()) {
                policy.setPublic(true);
                projectPolicies.save();
            }
        }
        catch (PmlSecurityException e) {
            throw BpmAppServiceExceptionFactory.createException((MetadataException)((Object)e));
        }
    }

    private List<BpmProcessOperation> getProcessArguments(@NotNull IBPMContext context, @NotNull String projectId, @NotNull String processId, boolean deployed, @NotNull Class<? extends Event> eventClass) throws BpmAppServiceException {
        ComposerMetadataService service = this.createComposerMetadataService(context);
        try {
            Project project = deployed ? this.loadDeployedProject(service, projectId) : this.loadPublicSharedProject(service, projectId);
            Process process = BpmAppServiceHelper.findProcess(project, processId);
            return BpmAppServiceHelper.getProcessArguments(process, eventClass);
        }
        catch (MetadataException e) {
            throw BpmAppServiceExceptionFactory.createException(e);
        }
    }

    @NotNull
    private Project loadPublicSharedProject(@NotNull ComposerMetadataService service, @NotNull String projectId) throws MetadataException, BpmAppServiceException {
        try {
            LocalRef projectLocalRef = service.loadProject(PublicShareProject.class, projectId, true);
            return (Project)((PublicShareProject)projectLocalRef.get()).getProject().get();
        }
        catch (ProjectNotFoundException e) {
            throw new oracle.bpm.client.bpmapp.exception.ProjectNotFoundException(projectId);
        }
    }

    @NotNull
    private Project loadDeployedProject(@NotNull ComposerMetadataService service, @NotNull String compositeDN) throws MetadataException, BpmAppServiceException {
        CompositeDN compositeDNInstance = new CompositeDN(compositeDN);
        try {
            LocalRef projectLocalRef = service.getDeployedProject(compositeDNInstance);
            if (projectLocalRef == null) {
                throw new oracle.bpm.client.bpmapp.exception.ProjectNotFoundException(compositeDN);
            }
            return (Project)((DeployedProject)projectLocalRef.get()).getProject().get();
        }
        catch (ProjectNotFoundException e) {
            throw new oracle.bpm.client.bpmapp.exception.ProjectNotFoundException(compositeDN);
        }
    }

    private Project loadTemplateProject(@NotNull IBPMContext context, @NotNull String templateName) throws BpmAppServiceException, MetadataException {
        ComposerMetadataService service = this.createComposerMetadataService(context);
        try {
            ProjectFolder templateFolder = service.findProjectByName(TemplateProject.class, templateName);
            if (templateFolder == null) {
                throw new oracle.bpm.client.bpmapp.exception.ProjectNotFoundException(templateName);
            }
            LocalRef templateRef = service.loadProject(TemplateProject.class, templateFolder.getLocation(), true);
            TemplateProject templateProject = (TemplateProject)templateRef.get();
            return (Project)templateProject.getProject().get();
        }
        catch (ProjectNotFoundException e) {
            throw new oracle.bpm.client.bpmapp.exception.ProjectNotFoundException(templateName);
        }
    }

    private Collection<LocalRef<DeployedProject>> filterToLastDeployedVersion(@NotNull ComposerMetadataService service, @NotNull Collection<LocalRef<DeployedProject>> projects) throws MetadataException, BpmAppServiceException {
        ArrayList<LocalRef<DeployedProject>> result = new ArrayList<LocalRef<DeployedProject>>();
        HashMap<String, String> lastVersions = new HashMap<String, String>();
        for (LocalRef<DeployedProject> ref : projects) {
            DeployedProject deployedProject = (DeployedProject)ref.get();
            String lastVersion = this.getLastDeployedVersion(service, deployedProject, lastVersions);
            if (!lastVersion.equals(deployedProject.getVersion())) continue;
            result.add(ref);
        }
        return result;
    }

    private String getLastDeployedVersion(@NotNull ComposerMetadataService service, @NotNull DeployedProject deployedProject, @NotNull Map<String, String> lastVersions) throws MetadataException, BpmAppServiceException {
        String projectName = BpmAppServiceHelper.getDeployedProjectName(deployedProject);
        String lastVersion = lastVersions.get(projectName);
        if (lastVersion == null) {
            lastVersion = service.getLastDeployedVersion(projectName);
            if (lastVersion == null) {
                lastVersion = "";
            }
            lastVersions.put(projectName, lastVersion);
        }
        return lastVersion;
    }

    private void validateContext(IBPMContext context) throws BpmAppServiceException {
        if (context == null) {
            throw new IllegalArgumentException("null context");
        }
        try {
            this.getVerificationService().validateContext((IWorkflowContext)context);
        }
        catch (Exception e) {
            throw new BpmAppServiceException(BpmAppServiceMsg.AUTHORIZATION_ERROR.getCause());
        }
    }

    private ComposerMetadataService createComposerMetadataService(@NotNull IBPMContext context) throws BpmAppServiceException {
        this.validateContext(context);
        try {
            MDSInstance soainfraMdsInstance = FabricMDSAccessor.getMDSInstance();
            MDSInstance composerMdsInstance = this.getComposerMDSInstance();
            return new ComposerMetadataServiceImpl(composerMdsInstance, context.getUser(), this.getRuntimeConfigurationService(), null, soainfraMdsInstance);
        }
        catch (MetadataException e) {
            throw new BpmAppServiceException((Throwable)e);
        }
    }

    private IRuntimeConfigService getRuntimeConfigurationService() {
        HashMap<IWorkflowServiceClientConstants.CONNECTION_PROPERTY, String> properties = new HashMap<IWorkflowServiceClientConstants.CONNECTION_PROPERTY, String>();
        properties.put(IWorkflowServiceClientConstants.CONNECTION_PROPERTY.CLIENT_TYPE, "REMOTE");
        BPMServiceClientFactory clientFactory = BPMServiceClientFactory.getInstance(properties, null, null);
        return clientFactory.getBPMServiceClient().getRuntimeConfigService();
    }

    private MDSInstance getComposerMDSInstance() throws BpmAppServiceException {
        MDSInstance mdsInstance;
        ClassLoader loader = BpmAppService.class.getClassLoader();
        URL mdsConfig = loader.getResource("/oracle/bpm/services/bpmapp/impl/mds-config_wls.xml");
        try {
            mdsInstance = MdsInstanceInitializer.getMDSInstance((String)MdsInstanceInitializer.OBPM_MDS, (URL)mdsConfig);
        }
        catch (MDSException e) {
            Log.logSevere((Throwable)e);
            throw new BpmAppServiceException((Throwable)e);
        }
        return mdsInstance;
    }
}

