/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.services.activityguide.test;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Map;
import java.util.Set;
import javax.management.Attribute;
import javax.management.ObjectName;
import javax.management.remote.JMXConnector;
import javax.management.remote.JMXConnectorFactory;
import javax.management.remote.JMXServiceURL;
import junit.framework.TestCase;
import junit.textui.TestRunner;
import oracle.bpel.services.bpm.common.IBPMContext;
import oracle.bpel.services.workflow.WorkflowException;
import oracle.bpel.services.workflow.client.IWorkflowServiceClient;
import oracle.bpel.services.workflow.client.IWorkflowServiceClientConstants;
import oracle.bpel.services.workflow.client.WorkflowServiceClientFactory;
import oracle.bpel.services.workflow.query.ITaskQueryService;
import oracle.bpel.services.workflow.task.model.Task;
import oracle.bpel.services.workflow.test.TestUtil;
import oracle.bpel.services.workflow.verification.IWorkflowContext;
import oracle.bpm.client.BPMServiceClientFactory;
import oracle.bpm.services.activityguide.IBpmAGProcessBrokerService;
import oracle.bpm.services.activityguide.ProcessBrokerException;
import oracle.bpm.services.activityguide.ProcessBrokerTimeOutException;
import oracle.bpm.services.authentication.IBPMUserAuthenticationService;
import oracle.bpm.services.client.IBPMServiceClient;
import oracle.bpm.services.common.exception.BPMException;

public class BpmAGProcessBrokerTest
extends TestCase {
    protected IWorkflowContext adminCtx = null;
    IBpmAGProcessBrokerService ag_broker_svc = null;
    String processDefnId = "default/ProcessBrokerProject!1.0*/ProcessBroker";
    String taskId = null;
    public static final String USERNAME = TestUtil.getEJBUser();
    protected static final String PASSWORD = TestUtil.getEJBCred();
    public static final String REALM = "jazn.com";
    static String processInstanceId;
    private static final String JNDI_ROOT = "/jndi/";
    private static final String MSERVER = "weblogic.management.mbeanservers.domainruntime";
    private static final String MBEAN_ATTR_DISABLE_PROCESS_BROKER = "DisableProcessBroker";

    public BpmAGProcessBrokerTest(String name) {
        super(name);
        try {
            IBPMUserAuthenticationService auth_service = this.getBPMUserAuthenticationService();
            this.adminCtx = auth_service.authenticate(USERNAME, PASSWORD.toCharArray(), REALM);
            this.ag_broker_svc = this.getProcessBrokerService();
            this.setBPMNConfigAttribute(MBEAN_ATTR_DISABLE_PROCESS_BROKER, false);
        }
        catch (BPMException e) {
            System.out.println(e.getMessage());
        }
        catch (Exception e) {
            System.out.println(e.getMessage());
        }
    }

    public static void main(String[] args) {
        TestRunner.run(BpmAGProcessBrokerTest.class);
    }

    public void setUp() {
    }

    public void testStartProcessInst() {
        System.out.println("Invoking testStartProcessInst() method for starting bpm process");
        try {
            processInstanceId = this.ag_broker_svc.startProcessInst((IBPMContext)this.adminCtx, this.processDefnId, null);
            System.out.println("Starting process:" + processInstanceId);
            BpmAGProcessBrokerTest.assertNotNull((String)"Process Id is null. Start Process failed", (Object)processInstanceId);
        }
        catch (ProcessBrokerException e) {
            e.printStackTrace();
        }
    }

    public void testGetNextTaskObject() {
        System.out.println("Invoking testGetNextTaskObject() method for process:" + processInstanceId);
        Task firstTask = null;
        String taskInstanceId = null;
        String outcome = null;
        try {
            firstTask = this.ag_broker_svc.getNextTaskObject((IBPMContext)this.adminCtx, processInstanceId, new ArrayList(0), taskInstanceId, outcome, 5000L);
        }
        catch (ProcessBrokerException e) {
            BpmAGProcessBrokerTest.fail((String)e.getMessage());
        }
        catch (ProcessBrokerTimeOutException e) {
            System.out.println(e.getMessage());
            try {
                firstTask = this.ag_broker_svc.getNextTaskObject((IBPMContext)this.adminCtx, processInstanceId, new ArrayList(0), taskInstanceId, outcome, 5000L);
            }
            catch (Exception ex) {
                BpmAGProcessBrokerTest.fail((String)ex.getMessage());
            }
        }
        Task lastTask = null;
        Task secondTask = null;
        outcome = "APPROVE";
        BpmAGProcessBrokerTest.assertNotNull((String)("Did not find first task for processInstanceId:" + processInstanceId), (Object)firstTask);
        if (firstTask != null) {
            this.taskId = firstTask.getSystemAttributes().getTaskId();
            BpmAGProcessBrokerTest.assertEquals((String)"Task state is not assigned", (String)"ASSIGNED", (String)firstTask.getSystemAttributes().getState());
            try {
                secondTask = this.ag_broker_svc.getNextTaskObject((IBPMContext)this.adminCtx, processInstanceId, new ArrayList(0), firstTask.getSystemAttributes().getTaskId(), null, 50000L);
            }
            catch (ProcessBrokerException e) {
                BpmAGProcessBrokerTest.fail((String)e.getMessage());
            }
            catch (ProcessBrokerTimeOutException e) {
                System.out.println(e.getMessage());
                try {
                    secondTask = this.ag_broker_svc.getNextTaskObject((IBPMContext)this.adminCtx, processInstanceId, new ArrayList(0), firstTask.getSystemAttributes().getTaskId(), null, 50000L);
                }
                catch (Exception ex) {
                    BpmAGProcessBrokerTest.fail((String)ex.getMessage());
                }
            }
            BpmAGProcessBrokerTest.assertNotNull((String)("Did not find second task for processInstanceId:" + processInstanceId), secondTask);
            if (secondTask != null) {
                BpmAGProcessBrokerTest.assertEquals((String)"Second task state is not assgined ", (String)"ASSIGNED", (String)secondTask.getSystemAttributes().getState());
                this.taskId = secondTask.getSystemAttributes().getTaskId();
                try {
                    lastTask = this.ag_broker_svc.getNextTaskObject((IBPMContext)this.adminCtx, processInstanceId, new ArrayList(0), secondTask.getSystemAttributes().getTaskId(), "APPROVE", 5000L);
                }
                catch (ProcessBrokerException e) {
                    BpmAGProcessBrokerTest.fail((String)e.getMessage());
                }
                catch (ProcessBrokerTimeOutException e) {
                    System.out.println(e.getMessage());
                }
                BpmAGProcessBrokerTest.assertNotNull(lastTask);
                try {
                    this.ag_broker_svc.getNextTaskObject((IBPMContext)this.adminCtx, processInstanceId, new ArrayList(0), lastTask.getSystemAttributes().getTaskId(), "APPROVE", 5000L);
                }
                catch (ProcessBrokerException e) {
                    if (e.getErrorCode() != 72203) {
                        BpmAGProcessBrokerTest.fail((String)e.getMessage());
                    }
                }
                catch (ProcessBrokerTimeOutException e) {
                    System.out.println(e.getMessage());
                }
            }
        }
    }

    public void testDisconnectProcessInst() {
        System.out.println("Invoking testDisconnectProcessInst() method for disconnectin bpm process");
        try {
            String processId = this.ag_broker_svc.startProcessInst((IBPMContext)this.adminCtx, this.processDefnId, null);
            BpmAGProcessBrokerTest.assertNotNull((Object)processId);
            this.ag_broker_svc.disconnectProcessInst((IBPMContext)this.adminCtx, processId, Boolean.valueOf(true));
        }
        catch (ProcessBrokerException e) {
            BpmAGProcessBrokerTest.fail((String)e.getMessage());
        }
    }

    public void testRestartProcessInst() {
        System.out.println("Invoking testRestartProcessInst() method for disconnectin bpm process");
        try {
            String processId = this.ag_broker_svc.startProcessInst((IBPMContext)this.adminCtx, this.processDefnId, null);
            BpmAGProcessBrokerTest.assertNotNull((Object)processId);
            this.ag_broker_svc.restartProcessInst((IBPMContext)this.adminCtx, processId, Boolean.valueOf(true), Boolean.valueOf(true));
        }
        catch (ProcessBrokerException e) {
            BpmAGProcessBrokerTest.fail((String)e.getMessage());
        }
    }

    public BPMServiceClientFactory getBPMServiceClientFactory() {
        BPMServiceClientFactory bpmServiceClientFactory = BPMServiceClientFactory.getInstance(this.getProps(), null, null);
        return bpmServiceClientFactory;
    }

    public IWorkflowServiceClient getWorkflowServiceClient() throws WorkflowException {
        IWorkflowServiceClient wfServiceClient = WorkflowServiceClientFactory.getWorkflowServiceClient(this.getProps(), null, null);
        return wfServiceClient;
    }

    public ITaskQueryService getTaskQueryService() throws WorkflowException {
        return this.getWorkflowServiceClient().getTaskQueryService();
    }

    public IBPMServiceClient getBPMServiceClient() {
        return this.getBPMServiceClientFactory().getBPMServiceClient();
    }

    public IBpmAGProcessBrokerService getProcessBrokerService() {
        return this.getBPMServiceClient().getBpmAGProcessBrokerService();
    }

    public IBPMUserAuthenticationService getBPMUserAuthenticationService() {
        return this.getBPMServiceClientFactory().getBPMUserAuthenticationService();
    }

    private Map<IWorkflowServiceClientConstants.CONNECTION_PROPERTY, String> getProps() {
        HashMap<IWorkflowServiceClientConstants.CONNECTION_PROPERTY, String> properties = new HashMap<IWorkflowServiceClientConstants.CONNECTION_PROPERTY, String>();
        properties.put(IWorkflowServiceClientConstants.CONNECTION_PROPERTY.EJB_PROVIDER_URL, TestUtil.getWFEJBURL());
        properties.put(IWorkflowServiceClientConstants.CONNECTION_PROPERTY.EJB_SECURITY_PRINCIPAL, USERNAME);
        properties.put(IWorkflowServiceClientConstants.CONNECTION_PROPERTY.EJB_SECURITY_CREDENTIALS, PASSWORD);
        properties.put(IWorkflowServiceClientConstants.CONNECTION_PROPERTY.CLIENT_TYPE, "REMOTE");
        properties.put(IWorkflowServiceClientConstants.CONNECTION_PROPERTY.SOAP_END_POINT_ROOT, TestUtil.getWFWSSOAPEndPointRoot());
        return properties;
    }

    private JMXConnector getJMXConnector() throws Exception {
        Hashtable<String, String> properties = new Hashtable<String, String>();
        properties.put("java.naming.security.principal", USERNAME);
        properties.put("java.naming.security.credentials", PASSWORD);
        properties.put("jmx.remote.protocol.provider.pkgs", "weblogic.management.remote");
        String hostname = System.getProperty("host.name");
        JMXServiceURL serviceURL = new JMXServiceURL("t3", hostname, 7001, "/jndi/weblogic.management.mbeanservers.domainruntime");
        return JMXConnectorFactory.connect(serviceURL, properties);
    }

    private ObjectName getBPMNConfigObject(JMXConnector jmxConnector) throws Exception {
        ObjectName localObjName = new ObjectName("oracle.as.soainfra.config:name=bpmn,type=BPMNConfig,*");
        Set<ObjectName> onameSet = jmxConnector.getMBeanServerConnection().queryNames(localObjName, null);
        return onameSet.iterator().next();
    }

    private void setBPMNConfigAttribute(String name, Object value) throws Exception {
        JMXConnector jmxConnector = this.getJMXConnector();
        ObjectName configObj = this.getBPMNConfigObject(jmxConnector);
        Attribute attribute = new Attribute(name, value);
        jmxConnector.getMBeanServerConnection().setAttribute(configObj, attribute);
        jmxConnector.close();
    }
}

