/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.services.activityguide.model.metadata.impl;

import oracle.bpm.project.model.activityguide.DisplayMode;
import oracle.bpm.project.model.activityguide.MilestoneActivity;
import oracle.bpm.project.model.processes.Activity;
import oracle.bpm.project.model.processes.UserTask;
import oracle.bpm.services.activityguide.model.metadata.IMilestone;
import oracle.bpm.services.activityguide.model.metadata.ITranslatableValue;
import oracle.bpm.services.activityguide.model.metadata.IUserTask;
import oracle.bpm.services.activityguide.model.metadata.impl.MilestoneImpl;
import oracle.bpm.services.activityguide.model.metadata.impl.TranslatableValueImpl;

public class UserTaskImpl
implements IUserTask {
    private TranslatableValueImpl blockIconText = null;
    private String humanTaskName = null;
    private MilestoneImpl parentMilestone = null;
    private MilestoneActivity taskModel = null;
    private DisplayMode userTaskDisplayMode = null;

    public UserTaskImpl(MilestoneActivity msActivityModel, MilestoneImpl parentMsModel) {
        this.taskModel = msActivityModel;
        this.parentMilestone = parentMsModel;
        this.userTaskDisplayMode = msActivityModel.getDisplayMode() == null || msActivityModel.getDisplayMode() == DisplayMode.DEFAULT ? this.parentMilestone.getInternalDisplayMode() : msActivityModel.getDisplayMode();
        Activity t = this.taskModel.getActivity();
        if (t != null) {
            UserTask userTaskActivity;
            assert (t.isUserTask());
            if (t.isUserTask() && (userTaskActivity = (UserTask)t.asActivity(UserTask.class)) != null && userTaskActivity.getHumanTask() != null) {
                this.humanTaskName = userTaskActivity.getHumanTask().getHumanTaskNativeName();
            }
        }
        if (this.taskModel.getTranslatableBlockedIconText() != null) {
            this.blockIconText = new TranslatableValueImpl(this.taskModel.getTranslatableBlockedIconText().getType(), this.taskModel.getTranslatableBlockedIconText().getValue());
        }
    }

    public String getId() {
        return this.taskModel.getId();
    }

    public String getTaskName() {
        return this.humanTaskName;
    }

    public String getTaskDefinitionId() {
        return this.getParentMilestone().getParentActivityGuide().getCompositeDN() + "/" + this.humanTaskName;
    }

    public IMilestone getParentMilestone() {
        return this.parentMilestone;
    }

    public boolean isMarkedAsOptional() {
        return this.taskModel.isMarkedAsOptional();
    }

    public boolean isDisplayBlockedIcon() {
        return this.taskModel.isDisplayBlockedIcon();
    }

    public int getTasksRemaining() {
        return this.taskModel.getTasksRemaining();
    }

    public String getDisplayMode() {
        return this.userTaskDisplayMode.getValue();
    }

    public boolean isLastTaskInMilestone() {
        return this.taskModel.equals(this.taskModel.getMilestone().getLastTask());
    }

    public ITranslatableValue getExplanation() {
        return this.blockIconText;
    }
}

