/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.services.activityguide.impl.bpelmetadata;

import com.oracle.bpel.activityguide.metadata.definition.model.MilestoneDefinitionType;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import oracle.bpel.services.workflow.activityguide.query.bpelmetadata.BPELMetadataElement;
import oracle.bpel.services.workflow.activityguide.query.bpelmetadata.BPELMetadataProperties;
import oracle.bpel.services.workflow.activityguide.query.bpelmetadata.TaskMetadataElement;
import oracle.bpel.services.workflow.task.model.CallbackType;
import oracle.bpel.services.workflow.task.model.ObjectFactory;
import oracle.bpel.services.workflow.task.model.TaskType;

public class BPELMetadataUtils {
    public static boolean checkTasksForEquality(TaskType t, TaskType dt) {
        String taskDefId = t.getTaskDefinitionId();
        String dummyTaskDefId = dt.getTaskDefinitionId();
        return taskDefId != null && dummyTaskDefId != null && taskDefId.equalsIgnoreCase(dummyTaskDefId);
    }

    public static String getHumanTaskId(String taskName) {
        if (taskName != null) {
            int i;
            int len = taskName.length();
            for (i = len - 1; i > 0 && taskName.charAt(i) != '_'; --i) {
            }
            return taskName.substring(0, i);
        }
        return null;
    }

    public static BPELMetadataElement findTaskMetadataByName(TaskMetadataElement taskMetadataElement, String taskId) {
        if (taskMetadataElement != null && taskId.equalsIgnoreCase(taskMetadataElement.getTaskCallbackId())) {
            return taskMetadataElement;
        }
        if (taskMetadataElement != null && taskMetadataElement.getElements() != null) {
            List childs = taskMetadataElement.getElements();
            for (int i = 0; i < childs.size(); ++i) {
                TaskMetadataElement em = (TaskMetadataElement)BPELMetadataUtils.findTaskMetadataByName((TaskMetadataElement)childs.get(i), taskId);
                if (em == null || !taskId.equalsIgnoreCase(em.getTaskCallbackId())) continue;
                return em;
            }
        }
        return null;
    }

    public static BPELMetadataElement getRootParent(BPELMetadataElement elm) {
        if (elm == null) {
            return null;
        }
        if (elm.getParent() != null) {
            return BPELMetadataUtils.getRootParent(elm.getParent());
        }
        return elm;
    }

    public static BPELMetadataElement findMetadataByName(BPELMetadataElement bpelMetadataElement, String name) {
        if (bpelMetadataElement != null && bpelMetadataElement.getName().equalsIgnoreCase(name)) {
            return bpelMetadataElement;
        }
        if (bpelMetadataElement.getElements() != null) {
            List childs = bpelMetadataElement.getElements();
            for (int i = 0; i < childs.size(); ++i) {
                BPELMetadataElement em = BPELMetadataUtils.findMetadataByName((BPELMetadataElement)childs.get(i), name);
                if (em == null || !em.getName().equalsIgnoreCase(name)) continue;
                return em;
            }
        }
        return null;
    }

    public static BPELMetadataElement findMetadataById(BPELMetadataElement bpelMetadataElement, String Id) {
        if (bpelMetadataElement != null && bpelMetadataElement.getId().equalsIgnoreCase(Id)) {
            return bpelMetadataElement;
        }
        if (bpelMetadataElement.getElements() != null) {
            List childs = bpelMetadataElement.getElements();
            for (int i = 0; i < childs.size(); ++i) {
                BPELMetadataElement em = BPELMetadataUtils.findMetadataById((BPELMetadataElement)childs.get(i), Id);
                if (em == null || !em.getId().equalsIgnoreCase(Id)) continue;
                return em;
            }
        }
        return null;
    }

    public static BPELMetadataElement getTaskMetadataElement(String taskId, List taskMetadataList) {
        for (int i = 0; i < taskMetadataList.size(); ++i) {
            TaskMetadataElement em = (TaskMetadataElement)BPELMetadataUtils.findTaskMetadataByName((TaskMetadataElement)taskMetadataList.get(i), taskId);
            if (em == null || !em.getTaskCallbackId().contains(taskId)) continue;
            return em;
        }
        return null;
    }

    public static void readjustFutureTasks(List taskList, List futureTasksList) {
        TaskMetadataElement tm = null;
        for (int i = 0; i < taskList.size(); ++i) {
            String[] s;
            TaskType t = (TaskType)taskList.get(i);
            if (t == null || (tm = (TaskMetadataElement)BPELMetadataUtils.getTaskMetadataElement((s = t.getCallback().getId().split("/"))[1], futureTasksList)) == null) continue;
            BPELMetadataProperties prop = BPELMetadataUtils.getPropertyValue(tm, "REQUIRED");
            if (prop != null) {
                t.getSystemMessageAttributes().setTextAttribute1(prop.getDefaultValue());
            }
            BPELMetadataUtils.readjustFutureTaskMetadata(futureTasksList, (BPELMetadataElement)tm);
            futureTasksList.remove(tm);
        }
    }

    public static BPELMetadataProperties getPropertyValue(TaskMetadataElement scm, String propName) {
        if (scm != null) {
            List propList = scm.getPropertyList();
            for (int i = 0; propList != null && i < propList.size(); ++i) {
                BPELMetadataProperties elem = (BPELMetadataProperties)propList.get(i);
                if (elem == null || elem.getName() == null || !elem.getName().equalsIgnoreCase(propName)) continue;
                return (BPELMetadataProperties)propList.get(i);
            }
        }
        return null;
    }

    public static TaskType createDummyTask(TaskMetadataElement scm) {
        if (scm != null) {
            ObjectFactory objf = new ObjectFactory();
            TaskType dt = objf.createTaskType();
            dt.getSystemAttributes().setTaskId("AGDM_" + Long.toString(System.currentTimeMillis()) + scm.getId());
            BPELMetadataProperties reqProp = BPELMetadataUtils.getPropertyValue(scm, "REQUIRED");
            if (reqProp != null) {
                dt.getSystemMessageAttributes().setTextAttribute1(reqProp.getDefaultValue());
            }
            dt.setIdentificationKey(scm.getName());
            dt.setCreator("dummy");
            dt.setTaskDefinitionId(scm.getName());
            CallbackType cb = objf.createCallbackType();
            String taskName = scm.getName();
            String tId = BPELMetadataUtils.getHumanTaskId(taskName);
            String cbId = scm.getComponent() + "//" + tId + "TaskService" + taskName.substring(tId.length(), taskName.length());
            String taskDefId = scm.getDomainName() + "/" + scm.getCompositeName() + "!" + scm.getCompositeRevision() + "*" + scm.getComponentLabel() + "/" + tId;
            dt.setTaskDefinitionId(taskDefId);
            dt.setMdsLabel(scm.getComponentLabel());
            cb.setId(cbId);
            dt.setPercentageComplete(0.0);
            return dt;
        }
        return null;
    }

    public static boolean taskAlreadyExists(List taskInstancelist, TaskType dt) {
        for (int i = 0; i < taskInstancelist.size(); ++i) {
            TaskType t = (TaskType)taskInstancelist.get(i);
            boolean b = BPELMetadataUtils.checkTasksForEquality(t, dt);
            if (!b) continue;
            return true;
        }
        return false;
    }

    public static void readjustFutureTaskMetadata(List metadataList, BPELMetadataElement elem) {
        if (elem != null) {
            BPELMetadataElement parent = elem.getParent();
            if (parent != null) {
                List childs = parent.getElements();
                String nodeBranchElem = elem.getNodeBranch();
                String startPattern = nodeBranchElem.substring(0, nodeBranchElem.length() - 2);
                for (int i = 0; i < childs.size(); ++i) {
                    BPELMetadataElement bm = (BPELMetadataElement)childs.get(i);
                    if (bm == null || !bm.getNodeBranch().startsWith(startPattern)) continue;
                    bm.setParent(null);
                    metadataList.add(bm);
                }
            }
            BPELMetadataUtils.removePreviousTaskSwitches(metadataList, elem);
            if (parent != null && parent.getType().equalsIgnoreCase("switch")) {
                metadataList.remove(parent);
                elem.setParent(null);
            }
        }
    }

    public static List sortMilestones(List milestoneList, List milestoneBpelMetadataList) {
        if (milestoneList == null) {
            return null;
        }
        if (milestoneBpelMetadataList == null || milestoneBpelMetadataList.size() == 0) {
            return milestoneList;
        }
        ArrayList sortedList = new ArrayList();
        TreeMap<Integer, MilestoneDefinitionType> mMap = new TreeMap<Integer, MilestoneDefinitionType>();
        for (int i = 0; i < milestoneList.size(); ++i) {
            MilestoneDefinitionType milestoneDefinition = (MilestoneDefinitionType)milestoneList.get(i);
            BPELMetadataElement elem = BPELMetadataUtils.findMilestoneMetadata(milestoneBpelMetadataList, milestoneDefinition.getName());
            if (elem == null) continue;
            mMap.put(new Integer(elem.getNodeSeqNum()), milestoneDefinition);
        }
        for (Map.Entry entry : mMap.entrySet()) {
            sortedList.add(entry.getValue());
        }
        return sortedList;
    }

    public static BPELMetadataElement findMilestoneMetadata(List milestoneBpelMetadataList, String name) {
        if (!name.startsWith("switch")) {
            for (int i = 0; i < milestoneBpelMetadataList.size(); ++i) {
                BPELMetadataElement elem = (BPELMetadataElement)milestoneBpelMetadataList.get(i);
                BPELMetadataElement mElem = BPELMetadataUtils.findMetadataByName(elem, name);
                if (mElem == null) continue;
                return mElem;
            }
        } else {
            String[] arr = name.split("_");
            for (int i = 0; i < milestoneBpelMetadataList.size(); ++i) {
                BPELMetadataElement elem = (BPELMetadataElement)milestoneBpelMetadataList.get(i);
                BPELMetadataElement mElem = BPELMetadataUtils.findMetadataById(elem, arr[1]);
                if (mElem == null) continue;
                return mElem;
            }
        }
        return null;
    }

    public static boolean compareNodeBranch(String b1, String b2) {
        int l1 = b1.length();
        int l2 = b2.length();
        int i = 0;
        for (int j = 0; i < l1 && j < l2; i += 2, j += 2) {
            char c2;
            char c1 = b1.charAt(i);
            if (c1 - 48 > (c2 = b2.charAt(j)) - 48) {
                return true;
            }
            if (c1 - 48 < c2 - 48) {
                return false;
            }
            if (i + 2 < l1 && j + 2 < l2) continue;
            if (i + 2 >= l1 && j + 2 < l2) {
                return false;
            }
            if (j + 2 < l2 || i + 2 >= l1) continue;
            return true;
        }
        return false;
    }

    private static void removePreviousTaskSwitches(List metadataList, BPELMetadataElement elem) {
        for (int i = 0; i < metadataList.size(); ++i) {
            BPELMetadataElement bm = (BPELMetadataElement)metadataList.get(i);
            if (bm == null || elem == null || !BPELMetadataUtils.compareNodeBranch(elem.getNodeBranch(), bm.getNodeBranch()) || !bm.getType().equalsIgnoreCase("switch")) continue;
            metadataList.remove(bm);
            --i;
        }
    }
}

