/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.services.activityguide.impl;

import java.math.BigInteger;
import java.security.AccessController;
import java.security.Permission;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import oracle.bpel.services.bpm.common.IBPMContext;
import oracle.bpel.services.workflow.WorkflowException;
import oracle.bpel.services.workflow.activityguide.query.IAGQueryService;
import oracle.bpel.services.workflow.activityguide.query.model.AGDisplayInfo;
import oracle.bpel.services.workflow.activityguide.query.model.MilestoneDisplayInfo;
import oracle.bpel.services.workflow.activityguide.query.model.TaskDisplayInfo;
import oracle.bpel.services.workflow.fabric.WorkflowServiceEngine;
import oracle.bpel.services.workflow.metadata.impl.TaskMetadataCache;
import oracle.bpel.services.workflow.metadata.taskdefinition.model.TaskDefinition;
import oracle.bpel.services.workflow.permission.WorkflowPermission;
import oracle.bpel.services.workflow.query.ITaskQueryService;
import oracle.bpel.services.workflow.repos.Column;
import oracle.bpel.services.workflow.repos.Ordering;
import oracle.bpel.services.workflow.repos.Predicate;
import oracle.bpel.services.workflow.repos.PredicateImpl;
import oracle.bpel.services.workflow.repos.TableConstants;
import oracle.bpel.services.workflow.repos.driver.WFAGInstanceUtil;
import oracle.bpel.services.workflow.task.model.ObjectFactory;
import oracle.bpel.services.workflow.task.model.Task;
import oracle.bpel.services.workflow.task.model.TaskType;
import oracle.bpel.services.workflow.verification.IWorkflowContext;
import oracle.bpel.services.workflow.verification.impl.InternalWorkflowContext;
import oracle.bpel.services.workflow.verification.impl.VerificationService;
import oracle.bpm.services.activityguide.IBpmAGMetadataService;
import oracle.bpm.services.activityguide.common.AGi18nUtil;
import oracle.bpm.services.activityguide.impl.BaseAGQueryService;
import oracle.bpm.services.activityguide.model.metadata.IActivityGuide;
import oracle.bpm.services.activityguide.model.metadata.IMilestone;
import oracle.bpm.services.activityguide.model.metadata.IUserTask;
import oracle.bpm.services.activityguide.model.metadata.TranslatableValueTypeEnum;
import oracle.bpm.services.common.BPMServiceLocator;
import oracle.bpm.services.common.exception.BPMException;
import oracle.bpm.services.common.logger.BPMLogger;
import oracle.bpm.services.common.logger.LoggerComponent;
import oracle.bpm.services.common.logger.Severity;
import oracle.bpm.services.common.model.CompositeDNModel;
import oracle.bpm.services.instancemanagement.model.IProcessInstance;
import oracle.bpm.services.instancequery.IColumnConstants;
import oracle.bpm.services.instancequery.IInstanceQueryInput;
import oracle.bpm.services.instancequery.IInstanceQueryService;
import oracle.bpm.services.instancequery.impl.InstanceQueryInput;

public class BpmAGQueryService
extends BaseAGQueryService {
    private static final String CLASSNAME = "oracle.bpm.services.activityguide.impl.BpmAGQueryService";
    private static final String ALL_TASK_MAP = "AllTasksIdMap";
    private static final String FILTERED_TASK_MAP = "FilteredTasksIdMap";
    private static final Map<String, String> AG_BPM_STATE_MAP = new HashMap<String, String>();
    private static final String REVISION_DL = "!";
    protected static List taskVerificationColumns = new ArrayList();

    public static IAGQueryService.AGAssignmentFilter getAGAssignmentFilterEnum(String filter) {
        if (filter == null) {
            return null;
        }
        return IAGQueryService.AGAssignmentFilter.valueOf((String)filter.toUpperCase());
    }

    @Override
    public List queryAGDisplayInfos(IWorkflowContext ctx, List displayColumns, String assignmentFilter, Predicate predicate, Ordering order, int startRow, int endRow) throws WorkflowException {
        return this.queryAGDisplayInfos(ctx, displayColumns, BpmAGQueryService.getAGAssignmentFilterEnum(assignmentFilter), predicate, order, startRow, endRow);
    }

    @Override
    public List queryAGDisplayInfos(IWorkflowContext ctx, List displayColumns, IAGQueryService.AGAssignmentFilter assignmentFilter, Predicate customPredicate, Ordering order, int startRow, int endRow) throws WorkflowException {
        BPMLogger.log((LoggerComponent)LoggerComponent.COMPONENT_AG_QUERY_SERVICE, (Severity)Severity.DEBUG, (String)CLASSNAME, (String)"queryAGDisplayInfos", (String)("Start of queryAGDisplayInfos for user: " + ctx.getUser()));
        if (assignmentFilter == null) {
            return null;
        }
        ArrayList<AGDisplayInfo> agDisplayInfoList = new ArrayList<AGDisplayInfo>();
        AGDisplayInfo agDisplayInfo = null;
        this.getVerificationService().validateContext(ctx);
        List<String> instanceIds = this.getProcessInstanceIds(ctx, assignmentFilter);
        if (instanceIds == null || instanceIds.isEmpty()) {
            return agDisplayInfoList;
        }
        Ordering finalOrdering = order;
        if (finalOrdering == null) {
            finalOrdering = new Ordering(IColumnConstants.PROCESS_INSTANCEID_COLUMN, true, true);
        }
        IWorkflowContext internalCtx = BpmAGQueryService.getInternalWorkflowContext();
        IBPMContext authContext = (IBPMContext)internalCtx;
        InstanceQueryInput queryInput = new InstanceQueryInput();
        IInstanceQueryInput.AssignmentFilter processAssignmentFilter = IInstanceQueryInput.AssignmentFilter.ALL;
        queryInput.setAssignmentFilter(processAssignmentFilter);
        queryInput.setStartRow(startRow);
        queryInput.setEndRow(endRow);
        PredicateImpl agPredicate = new PredicateImpl(TableConstants.WFTASK_AG_ROOTID_COLUMN, 22, (Object)null);
        PredicateImpl instanceIdPredicate = new PredicateImpl(IColumnConstants.PROCESS_INSTANCEID_COLUMN, 9, instanceIds);
        PredicateImpl processStatePredicate = new PredicateImpl(IColumnConstants.PROCESS_STATE_COLUMN, 1, (Object)"STALE");
        if (assignmentFilter.equals((Object)IAGQueryService.AGAssignmentFilter.ADMIN) || assignmentFilter.equals((Object)IAGQueryService.AGAssignmentFilter.PREVIOUS)) {
            processStatePredicate.addClause(8, IColumnConstants.PROCESS_STATE_COLUMN, 21, (Object)null);
        }
        Predicate agQueryPredicate = WFAGInstanceUtil.combineTwoPredicatesByAND((Predicate)agPredicate, (Predicate)instanceIdPredicate);
        agQueryPredicate = WFAGInstanceUtil.combineTwoPredicatesByAND((Predicate)agQueryPredicate, (Predicate)processStatePredicate);
        Predicate finalPredicate = WFAGInstanceUtil.combineTwoPredicatesByAND((Predicate)agQueryPredicate, (Predicate)customPredicate);
        List<Column> processDisplayColumns = this.addDefaultProcessColumns(displayColumns);
        IInstanceQueryService instQrySvc = BPMServiceLocator.getInstanceQueryService();
        List agProcessInstances = new ArrayList();
        try {
            agProcessInstances = instQrySvc.queryProcessInstances(authContext, processDisplayColumns, finalPredicate, finalOrdering, (IInstanceQueryInput)queryInput);
        }
        catch (BPMException e) {
            Object[] errorObjs = new Object[]{"Failure to query AG process instance in queryAGDisplayInfos."};
            WorkflowException we = new WorkflowException(38006, errorObjs, (Throwable)e);
            BPMLogger.log((LoggerComponent)LoggerComponent.COMPONENT_AG_QUERY_SERVICE, (Severity)Severity.ERRORS, (Throwable)e);
            throw we;
        }
        BPMLogger.log((LoggerComponent)LoggerComponent.COMPONENT_AG_QUERY_SERVICE, (Severity)Severity.DEBUG, (String)CLASSNAME, (String)"queryAGDisplayInfos()", (String)("Number of active BPM AGs returned: " + agProcessInstances.size()));
        if (agProcessInstances.size() > 0) {
            IBpmAGMetadataService metadataSvc = BPMServiceLocator.getBpmAGMetadataService();
            for (int i = 0; i < agProcessInstances.size(); ++i) {
                IProcessInstance processInstance = (IProcessInstance)agProcessInstances.get(i);
                IActivityGuide activityGuide = null;
                try {
                    String compositeDN = processInstance.getSca().getCompositeDN();
                    activityGuide = metadataSvc.getAGDefinition(compositeDN);
                }
                catch (BPMException e) {
                    Object[] errorObjs = new Object[]{"Failure to query AG definition from metadata service in queryAGDisplayInfos."};
                    WorkflowException we = new WorkflowException(38006, errorObjs, (Throwable)e);
                    BPMLogger.log((LoggerComponent)LoggerComponent.COMPONENT_AG_QUERY_SERVICE, (Severity)Severity.ERRORS, (Throwable)e);
                    throw we;
                }
                if (activityGuide == null) {
                    BPMLogger.log((LoggerComponent)LoggerComponent.COMPONENT_AG_QUERY_SERVICE, (Severity)Severity.WARNING, (String)CLASSNAME, (String)"queryAGDisplayInfos", (String)("Null AG Definition returned by Bpm AG Metadata service for Instance Id" + processInstance.getCubeInstanceId()));
                    continue;
                }
                AGi18nUtil.setBpmMetadataService(metadataSvc);
                agDisplayInfo = this.constructAGDisplayInfo(processInstance, activityGuide, ctx, assignmentFilter, false, null);
                agDisplayInfo.setCreatedDate(processInstance.getSystemAttributes().getCreatedDate());
                agDisplayInfo.setUpdatedDate(processInstance.getSystemAttributes().getUpdatedDate());
                String processId = processInstance.getSca().getCompositeDN();
                CompositeDNModel compDNModel = CompositeDNModel.parseCompositeDN((String)processId);
                String compositeName = compDNModel.getCompositeName() + REVISION_DL + compDNModel.getRevision();
                agDisplayInfo.setCompositeName(compositeName);
                agDisplayInfoList.add(agDisplayInfo);
            }
        }
        BPMLogger.log((LoggerComponent)LoggerComponent.COMPONENT_AG_QUERY_SERVICE, (Severity)Severity.DEBUG, (String)CLASSNAME, (String)"queryAGDisplayInfos", (String)("End of queryAGDisplayInfos for user: " + ctx.getUser()));
        return agDisplayInfoList;
    }

    @Override
    public AGDisplayInfo getAGDisplayInfoDetailsById(IWorkflowContext ctx, long ciKey, List taskDisplayColumns, String agAssignmentFilter) throws WorkflowException {
        BPMLogger.log((LoggerComponent)LoggerComponent.COMPONENT_AG_QUERY_SERVICE, (Severity)Severity.DEBUG, (String)CLASSNAME, (String)"getAGDisplayInfoDetailsById", (String)("Start of getAGDisplayInfoDetailsById for user: " + ctx.getUser() + ", InstanceId: " + ciKey));
        if (agAssignmentFilter == null) {
            return null;
        }
        if (agAssignmentFilter.equals("Admin") && !BpmAGQueryService.isUserAGAdmin(ctx)) {
            Object[] errorObjs = new Object[]{ctx.getUser(), "isUserAGAdmin"};
            String reason = "User does not have the activity guide administration privilege required for using the ADMIN assignment filter. token = " + ctx.getToken() + " ctxUser = " + ctx.getUser();
            WorkflowException we = new WorkflowException(38004, reason, errorObjs);
            BPMLogger.log((LoggerComponent)LoggerComponent.COMPONENT_AG_QUERY_SERVICE, (Severity)Severity.ERRORS, (Throwable)we);
            throw we;
        }
        this.getVerificationService().validateContext(ctx);
        IWorkflowContext internalCtx = BpmAGQueryService.getInternalWorkflowContext();
        IBPMContext authContext = (IBPMContext)internalCtx;
        IInstanceQueryService instQrySvc = BPMServiceLocator.getInstanceQueryService();
        IProcessInstance agProcessInstance = null;
        try {
            agProcessInstance = instQrySvc.getProcessInstance(authContext, String.valueOf(ciKey));
        }
        catch (BPMException e) {
            Object[] errorObjs = new Object[]{"Failure to query AG process instance " + ciKey + "in getAGDisplayInfoDetailsById."};
            WorkflowException we = new WorkflowException(38006, errorObjs, (Throwable)e);
            BPMLogger.log((LoggerComponent)LoggerComponent.COMPONENT_AG_QUERY_SERVICE, (Severity)Severity.ERRORS, (Throwable)e);
            throw we;
        }
        if (agProcessInstance == null) {
            return null;
        }
        BPMLogger.log((LoggerComponent)LoggerComponent.COMPONENT_AG_QUERY_SERVICE, (Severity)Severity.DEBUG, (String)CLASSNAME, (String)"getAGDisplayInfoDetailsById", (String)("Got the process Instance with Id: " + ciKey + "from process query service"));
        IActivityGuide activityGuide = null;
        IBpmAGMetadataService metadataSvc = BPMServiceLocator.getBpmAGMetadataService();
        try {
            String compositeDN = agProcessInstance.getSca().getCompositeDN();
            activityGuide = metadataSvc.getAGDefinition(compositeDN);
        }
        catch (BPMException e) {
            Object[] errorObjs = new Object[]{"Failure to retrieve AG definition from metadata service in getAGDisplayInfoDetailsById."};
            WorkflowException we = new WorkflowException(38006, errorObjs, (Throwable)e);
            BPMLogger.log((LoggerComponent)LoggerComponent.COMPONENT_AG_QUERY_SERVICE, (Severity)Severity.ERRORS, (Throwable)e);
            throw we;
        }
        if (activityGuide == null) {
            BPMLogger.log((LoggerComponent)LoggerComponent.COMPONENT_AG_QUERY_SERVICE, (Severity)Severity.WARNING, (String)CLASSNAME, (String)"getAGDisplayInfoDetailsById", (String)("Null AG Definition returned by Bpm AG Metadata service for Instance Id" + ciKey));
            return null;
        }
        AGi18nUtil.setBpmMetadataService(metadataSvc);
        AGDisplayInfo agDisplayInfo = this.constructAGDisplayInfo(agProcessInstance, activityGuide, ctx, BpmAGQueryService.getAGAssignmentFilterEnum(agAssignmentFilter), true, taskDisplayColumns);
        BPMLogger.log((LoggerComponent)LoggerComponent.COMPONENT_AG_QUERY_SERVICE, (Severity)Severity.DEBUG, (String)CLASSNAME, (String)"getAGDisplayInfoDetailsById", (String)("End of getAGDisplayInfoDetailsById for user: " + ctx.getUser() + ", InstanceId: " + ciKey));
        return agDisplayInfo;
    }

    @Override
    public MilestoneDisplayInfo getMilestoneDisplayInfo(IWorkflowContext ctx, long cikey, String milestoneName, List taskDisplayColumns, String agAssignmentFilter) throws WorkflowException {
        BPMLogger.log((LoggerComponent)LoggerComponent.COMPONENT_AG_QUERY_SERVICE, (Severity)Severity.DEBUG, (String)CLASSNAME, (String)"getMilestoneDisplayInfo", (String)("Start of getMilestoneDisplayInfo for user: " + ctx.getUser() + ", InstanceId: " + cikey + ", Milestone: " + milestoneName));
        if (agAssignmentFilter == null) {
            return null;
        }
        if (agAssignmentFilter.equals("Admin") && !BpmAGQueryService.isUserAGAdmin(ctx)) {
            Object[] errorObjs = new Object[]{ctx.getUser(), "isUserAGAdmin"};
            String reason = "User does not have the activity guide administration privilege required for using the ADMIN assignment filter. token = " + ctx.getToken() + " ctxUser = " + ctx.getUser();
            WorkflowException we = new WorkflowException(38004, reason, errorObjs);
            BPMLogger.log((LoggerComponent)LoggerComponent.COMPONENT_AG_QUERY_SERVICE, (Severity)Severity.ERRORS, (Throwable)we);
            throw we;
        }
        this.getVerificationService().validateContext(ctx);
        IWorkflowContext internalCtx = null;
        IBPMContext authContext = null;
        internalCtx = BpmAGQueryService.getInternalWorkflowContext();
        authContext = (IBPMContext)internalCtx;
        IInstanceQueryService instQrySvc = BPMServiceLocator.getInstanceQueryService();
        IProcessInstance processInstance = null;
        try {
            processInstance = instQrySvc.getProcessInstance(authContext, String.valueOf(cikey));
        }
        catch (Exception e) {
            Object[] errorObjs = new Object[]{"Failure to retrieve AG process instance " + cikey + "in getMilestoneDisplayInfo."};
            WorkflowException we = new WorkflowException(38006, errorObjs, (Throwable)e);
            BPMLogger.log((LoggerComponent)LoggerComponent.COMPONENT_AG_QUERY_SERVICE, (Severity)Severity.ERRORS, (Throwable)e);
            throw we;
        }
        if (processInstance == null) {
            return null;
        }
        BPMLogger.log((LoggerComponent)LoggerComponent.COMPONENT_AG_QUERY_SERVICE, (Severity)Severity.DEBUG, (String)CLASSNAME, (String)"getMilestoneDisplayInfo", (String)("Got the process Instance with Id: " + cikey + "from process query service"));
        IActivityGuide activityGuide = null;
        IBpmAGMetadataService metadataSvc = BPMServiceLocator.getBpmAGMetadataService();
        try {
            String compositeDN = processInstance.getSca().getCompositeDN();
            activityGuide = metadataSvc.getAGDefinition(compositeDN);
        }
        catch (BPMException e) {
            Object[] errorObjs = new Object[]{"Failure to retrieve AG definition from metadata service in getMilestoneDisplayInfo."};
            WorkflowException we = new WorkflowException(38006, errorObjs, (Throwable)e);
            BPMLogger.log((LoggerComponent)LoggerComponent.COMPONENT_AG_QUERY_SERVICE, (Severity)Severity.ERRORS, (Throwable)e);
            throw we;
        }
        if (activityGuide == null) {
            BPMLogger.log((LoggerComponent)LoggerComponent.COMPONENT_AG_QUERY_SERVICE, (Severity)Severity.WARNING, (String)CLASSNAME, (String)"getMilestoneDisplayInfo", (String)("Null AG Definition returned by Bpm AG Metadata service for Instance Id" + cikey));
            return null;
        }
        IMilestone milestoneDefn = activityGuide.findMilestone(milestoneName);
        if (milestoneDefn == null) {
            return null;
        }
        String compositeInstanceID = processInstance.getSca().getCompositeInstanceId();
        HashMap taskListMap = this.getTasksInAG(compositeInstanceID, ctx, BpmAGQueryService.getAGAssignmentFilterEnum(agAssignmentFilter), taskDisplayColumns);
        HashMap taskIdMap = (HashMap)taskListMap.get(FILTERED_TASK_MAP);
        boolean canUserSeeAG = this.canUserSeeAGDisplayInfo(ctx, taskIdMap);
        if (!canUserSeeAG) {
            Object[] errorObjs = new Object[]{ctx.getUser(), String.valueOf(cikey), "getMilestoneDisplayInfo"};
            String reason = "User is not allowed to see the activity guide. token = " + ctx.getToken() + " ctxUser = " + ctx.getUser() + " ciKey = " + String.valueOf(cikey) + " milestoneName = " + milestoneName;
            BPMLogger.log((LoggerComponent)LoggerComponent.COMPONENT_AG_QUERY_SERVICE, (Severity)Severity.ERRORS, (String)CLASSNAME, (String)"getMilestoneDisplayInfo()", (String)reason);
            throw new WorkflowException(38003, reason, errorObjs);
        }
        MilestoneDisplayInfo msDisplayInfo = null;
        AGi18nUtil.setBpmMetadataService(metadataSvc);
        msDisplayInfo = this.constructMilestoneDisplayInfo(ctx, activityGuide, taskListMap, milestoneDefn);
        List taskDisplayInfoList = msDisplayInfo.getTaskDisplayInfo();
        String ag_status = AG_BPM_STATE_MAP.get(processInstance.getSystemAttributes().getState());
        taskDisplayInfoList = this.filterBranchEntries(taskDisplayInfoList, milestoneDefn, ag_status, false);
        msDisplayInfo.getTaskDisplayInfo().clear();
        msDisplayInfo.getTaskDisplayInfo().addAll(taskDisplayInfoList);
        msDisplayInfo = this.checkMilestoneStatus(msDisplayInfo);
        BPMLogger.log((LoggerComponent)LoggerComponent.COMPONENT_AG_QUERY_SERVICE, (Severity)Severity.DEBUG, (String)CLASSNAME, (String)"getMilestoneDisplayInfo", (String)("End of getMilestoneDisplayInfo for user: " + ctx.getUser() + ", InstanceId: " + cikey + ", Milestone: " + milestoneName));
        return msDisplayInfo;
    }

    protected MilestoneDisplayInfo checkMilestoneStatus(MilestoneDisplayInfo msDisplayInfo) {
        String msStatus = msDisplayInfo.getStatus();
        String taskStatus = null;
        String newMSStatus = null;
        if (msStatus != null && msStatus.equals("In Progress")) {
            List taskDisplayInfoList = msDisplayInfo.getTaskDisplayInfo();
            for (Object taskDispInfo : taskDisplayInfoList) {
                taskStatus = ((TaskDisplayInfo)taskDispInfo).getTask().getSystemAttributes().getState();
                if (this.isTaskCompleted(taskStatus)) {
                    newMSStatus = "Completed";
                    continue;
                }
                newMSStatus = "In Progress";
                break;
            }
            if (!msStatus.equals(newMSStatus)) {
                msDisplayInfo.setStatus(newMSStatus);
            }
        }
        return msDisplayInfo;
    }

    boolean isTaskCompleted(String taskState) {
        return "COMPLETED".equals(taskState) || "WITHDRAWN".equals(taskState) || "EXPIRED".equals(taskState) || "STALE".equals(taskState);
    }

    private static void initTaskVerificationColumns() {
        taskVerificationColumns.add("ACQUIREDBY");
        taskVerificationColumns.add("ACTIVITYID");
        taskVerificationColumns.add("INSTANCEID");
        taskVerificationColumns.add("ASSIGNEES");
        taskVerificationColumns.add("ASSIGNEEGROUPS");
        taskVerificationColumns.add("ASSIGNEEUSERS");
        taskVerificationColumns.add("REVIEWERS");
        taskVerificationColumns.add("OWNERUSER");
        taskVerificationColumns.add("OWNERGROUP");
        taskVerificationColumns.add("ORIGINALASSIGNEEUSER");
        taskVerificationColumns.add("PARTICIPANTNAME");
        taskVerificationColumns.add("APPROVERS");
        taskVerificationColumns.add("IDENTITYCONTEXT");
        taskVerificationColumns.add("TASKDEFINITIONNAME");
        taskVerificationColumns.add("COMPONENTNAME");
        taskVerificationColumns.add("COMPOSITENAME");
        taskVerificationColumns.add("CALLBACKID");
        taskVerificationColumns.add("STATE");
        taskVerificationColumns.add("SUBSTATE");
        taskVerificationColumns.add("PROCESSID");
    }

    private static boolean isUserAGAdmin(IWorkflowContext ctx) throws WorkflowException {
        boolean hasPermission = VerificationService.hasPermission((IWorkflowContext)ctx, (Permission)WorkflowPermission.ADMIN_ACTIVITYGUIDE_PERMISSION);
        boolean isWFSystemUser = ctx instanceof InternalWorkflowContext;
        return hasPermission || isWFSystemUser;
    }

    private static IWorkflowContext getInternalWorkflowContext() throws WorkflowException {
        try {
            IWorkflowContext wfCtx = (IWorkflowContext)AccessController.doPrivileged(new PrivilegedExceptionAction(){

                public Object run() throws Exception {
                    return VerificationService.createInternalWorkflowContext();
                }
            });
            return wfCtx;
        }
        catch (PrivilegedActionException pae) {
            Exception orgEx = pae.getException();
            if (orgEx instanceof WorkflowException) {
                throw (WorkflowException)((Object)orgEx);
            }
            throw new WorkflowException((Throwable)pae);
        }
    }

    private AGDisplayInfo constructAGDisplayInfo(IProcessInstance processInstance, IActivityGuide activityGuide, IWorkflowContext ctx, IAGQueryService.AGAssignmentFilter filter, boolean bDisplayTasks, List taskDisplayColumns) throws WorkflowException {
        HashMap taskIdMap;
        boolean canUserSeeAG;
        AGDisplayInfo agDisplayInfo = new oracle.bpel.services.workflow.activityguide.query.model.ObjectFactory().createAGDisplayInfo();
        String titleValue = null;
        String descriptionValue = null;
        agDisplayInfo.setCompletedTaskCount(BigInteger.ZERO);
        agDisplayInfo.setTotalTasks(BigInteger.ZERO);
        agDisplayInfo.setName(activityGuide.getId());
        try {
            if (activityGuide.getTitle() != null) {
                TranslatableValueTypeEnum titleType = activityGuide.getTitle().getType();
                titleValue = AGi18nUtil.renderValueForValueType(ctx.getLocale(), activityGuide, activityGuide.getTitle().getValue(), titleType.toString());
            }
            if (activityGuide.getDescription() != null) {
                TranslatableValueTypeEnum descriptionType = activityGuide.getDescription().getType();
                descriptionValue = AGi18nUtil.renderValueForValueType(ctx.getLocale(), activityGuide, activityGuide.getDescription().getValue(), descriptionType.toString());
            }
        }
        catch (Exception e) {
            Object[] errorObjs = new Object[]{"Failure to retrieve AG resource bundle from metadata service in constructAGDisplayInfo."};
            WorkflowException we = new WorkflowException(38006, errorObjs, (Throwable)e);
            BPMLogger.log((LoggerComponent)LoggerComponent.COMPONENT_AG_QUERY_SERVICE, (Severity)Severity.ERRORS, (Throwable)e);
            throw we;
        }
        if (titleValue == null) {
            titleValue = processInstance.getProcessName();
        }
        agDisplayInfo.setTitle(titleValue);
        agDisplayInfo.setDescription(descriptionValue);
        agDisplayInfo.setIconLocation(activityGuide.getIconLocation());
        agDisplayInfo.setGlobalTaskAccessMode(activityGuide.getTaskAccessMode());
        agDisplayInfo.setTaskBlockedIconLocation(activityGuide.getTaskBlockedIconLocation());
        HashMap taskListMap = new HashMap();
        String compositeInstanceID = processInstance.getSca().getCompositeInstanceId();
        if (bDisplayTasks && !(canUserSeeAG = this.canUserSeeAGDisplayInfo(ctx, taskIdMap = (HashMap)(taskListMap = this.getTasksInAG(compositeInstanceID, ctx, filter, taskDisplayColumns)).get(FILTERED_TASK_MAP)))) {
            Object[] errorObjs = new Object[]{ctx.getUser(), String.valueOf(processInstance.getCubeInstanceId()), "constructAGDisplayInfo()"};
            String reason = "User is not allowed to see the activity guide. token = " + ctx.getToken() + " ctxUser = " + ctx.getUser() + " ciKey = " + String.valueOf(processInstance.getCubeInstanceId());
            BPMLogger.log((LoggerComponent)LoggerComponent.COMPONENT_AG_QUERY_SERVICE, (Severity)Severity.ERRORS, (String)CLASSNAME, (String)"constructAGDisplayInfo()", (String)reason);
        }
        String process_state = processInstance.getSystemAttributes().getState();
        String ag_status = AG_BPM_STATE_MAP.get(process_state);
        agDisplayInfo.setStatus(ag_status);
        agDisplayInfo.setProcessMode("AGBPM");
        agDisplayInfo.setInstanceId(processInstance.getCubeInstanceId());
        List milestoneDisplayInfoList = this.constructMilestoneDisplayInfoList(ctx, taskListMap, activityGuide, ag_status);
        BigInteger agCompletedTasks = BigInteger.ZERO;
        BigInteger estimatedFutureTasks = BigInteger.ZERO;
        BigInteger milestoneCompletedTasks = BigInteger.ZERO;
        HashMap filteredTaskIDMap = (HashMap)taskListMap.get(FILTERED_TASK_MAP);
        for (int i = 0; i < milestoneDisplayInfoList.size(); ++i) {
            MilestoneDisplayInfo ms = (MilestoneDisplayInfo)milestoneDisplayInfoList.get(i);
            List taskList = ms.getTaskDisplayInfo();
            ArrayList<TaskDisplayInfo> filteredTaskDisplayInfoList = new ArrayList<TaskDisplayInfo>();
            milestoneCompletedTasks = ms.getCompletedTaskCount();
            agCompletedTasks = agCompletedTasks.add(milestoneCompletedTasks);
            if (taskList != null) {
                for (int j = 0; j < taskList.size(); ++j) {
                    TaskDisplayInfo taskDisplayInfo = (TaskDisplayInfo)taskList.get(j);
                    if (taskDisplayInfo.isTaskInactive()) {
                        filteredTaskDisplayInfoList.add(taskDisplayInfo);
                    } else if (filteredTaskIDMap.containsKey(taskDisplayInfo.getTask().getSystemAttributes().getTaskId())) {
                        filteredTaskDisplayInfoList.add(taskDisplayInfo);
                    }
                    String taskState = taskDisplayInfo.getTask().getSystemAttributes().getState();
                    if (!"ASSIGNED".equals(taskState)) continue;
                    estimatedFutureTasks = taskDisplayInfo.getTasksRemaining().intValue() > 0 ? taskDisplayInfo.getTasksRemaining() : ms.getTotalTasksLeft().subtract(milestoneCompletedTasks);
                }
            }
            ms.getTaskDisplayInfo().clear();
            ms.getTaskDisplayInfo().addAll(filteredTaskDisplayInfoList);
        }
        agDisplayInfo.setCompletedTaskCount(agCompletedTasks);
        BigInteger agTotalTasks = agCompletedTasks.add(estimatedFutureTasks);
        agDisplayInfo.setTotalTasks(agTotalTasks);
        if (agTotalTasks.intValue() > 0 && agCompletedTasks.intValue() > 0) {
            agDisplayInfo.setCompletedTaskCount(agCompletedTasks);
            agDisplayInfo.setPercentageComplete(agCompletedTasks.multiply(BigInteger.TEN.multiply(BigInteger.TEN)).divide(agTotalTasks));
        } else {
            agDisplayInfo.setPercentageComplete(BigInteger.ZERO);
        }
        agDisplayInfo.getMilestoneDisplayInfo().clear();
        agDisplayInfo.getMilestoneDisplayInfo().addAll(milestoneDisplayInfoList);
        agDisplayInfo.setCreatedDate(processInstance.getSystemAttributes().getCreatedDate());
        agDisplayInfo.setUpdatedDate(processInstance.getSystemAttributes().getUpdatedDate());
        String processId = processInstance.getSca().getCompositeDN();
        CompositeDNModel compDNModel = CompositeDNModel.parseCompositeDN((String)processId);
        String compositeName = compDNModel.getCompositeName() + REVISION_DL + compDNModel.getRevision();
        agDisplayInfo.setCompositeName(compositeName);
        return agDisplayInfo;
    }

    private List constructMilestoneDisplayInfoList(IWorkflowContext ctx, HashMap taskListMap, IActivityGuide activityGuide, String ag_status) throws WorkflowException {
        IMilestone milestoneDefinition = null;
        MilestoneDisplayInfo milestoneDisplayInfo = null;
        List<MilestoneDisplayInfo> milestoneDisplayInfoList = new ArrayList();
        List milestoneDefinitionList = activityGuide.getMilestones();
        HashMap<String, IMilestone> milestoneDefnMap = new HashMap<String, IMilestone>();
        for (int i = 0; i < milestoneDefinitionList.size(); ++i) {
            milestoneDefinition = (IMilestone)milestoneDefinitionList.get(i);
            milestoneDisplayInfo = this.constructMilestoneDisplayInfo(ctx, activityGuide, taskListMap, milestoneDefinition);
            if (milestoneDisplayInfo == null) continue;
            milestoneDisplayInfoList.add(milestoneDisplayInfo);
            milestoneDefnMap.put(milestoneDisplayInfo.getName(), milestoneDefinition);
        }
        milestoneDisplayInfoList = this.filterBranchEntries(milestoneDisplayInfoList, activityGuide, ag_status, false);
        List<MilestoneDisplayInfo> filteredMSDisplayInfoList = new ArrayList<MilestoneDisplayInfo>();
        for (int i = 0; milestoneDisplayInfoList != null && i < milestoneDisplayInfoList.size(); ++i) {
            MilestoneDisplayInfo nextMilestone;
            boolean isNextMSEnabled = false;
            MilestoneDisplayInfo msDisplayInfo = (MilestoneDisplayInfo)milestoneDisplayInfoList.get(i);
            List taskDisplayInfoList = msDisplayInfo.getTaskDisplayInfo();
            MilestoneDisplayInfo milestoneDisplayInfo2 = nextMilestone = i < milestoneDisplayInfoList.size() - 1 ? (MilestoneDisplayInfo)milestoneDisplayInfoList.get(i + 1) : null;
            if (nextMilestone != null && !nextMilestone.getStatus().equals("Not Started")) {
                isNextMSEnabled = true;
            }
            IMilestone milestoneDefn = (IMilestone)milestoneDefnMap.get(msDisplayInfo.getName());
            List filteredTaskDisplayInfoList = this.filterBranchEntries(taskDisplayInfoList, milestoneDefn, ag_status, isNextMSEnabled);
            msDisplayInfo.getTaskDisplayInfo().clear();
            msDisplayInfo.getTaskDisplayInfo().addAll(filteredTaskDisplayInfoList);
            msDisplayInfo = this.checkMilestoneStatus(msDisplayInfo);
            filteredMSDisplayInfoList.add(msDisplayInfo);
        }
        filteredMSDisplayInfoList = this.checkTaskBlockedStatus(filteredMSDisplayInfoList, ag_status);
        return filteredMSDisplayInfoList;
    }

    private MilestoneDisplayInfo constructMilestoneDisplayInfo(IWorkflowContext ctx, IActivityGuide activityGuide, HashMap taskListMap, IMilestone milestoneDefinition) throws WorkflowException {
        if (milestoneDefinition == null) {
            return null;
        }
        MilestoneDisplayInfo milestoneDisplayInfo = new oracle.bpel.services.workflow.activityguide.query.model.ObjectFactory().createMilestoneDisplayInfo();
        milestoneDisplayInfo.setCompletedTaskCount(BigInteger.ZERO);
        milestoneDisplayInfo.setName(milestoneDefinition.getId());
        TranslatableValueTypeEnum titleType = milestoneDefinition.getTitle().getType();
        String titleValue = milestoneDefinition.getTitle().getValue();
        TranslatableValueTypeEnum descriptionType = milestoneDefinition.getDescription().getType();
        String descriptionValue = milestoneDefinition.getDescription().getValue();
        try {
            titleValue = AGi18nUtil.renderValueForValueType(ctx.getLocale(), activityGuide, titleValue, titleType.toString());
            descriptionValue = AGi18nUtil.renderValueForValueType(ctx.getLocale(), activityGuide, descriptionValue, descriptionType.toString());
        }
        catch (Exception e) {
            Object[] errorObjs = new Object[]{"Failure to retrieve AG resource bundle from metadata service in constructMilestoneDisplayInfo."};
            WorkflowException we = new WorkflowException(38006, errorObjs, (Throwable)e);
            BPMLogger.log((LoggerComponent)LoggerComponent.COMPONENT_AG_QUERY_SERVICE, (Severity)Severity.ERRORS, (Throwable)e);
            throw we;
        }
        milestoneDisplayInfo.setTitle(titleValue);
        milestoneDisplayInfo.setDescription(descriptionValue);
        milestoneDisplayInfo.setIconLocation(milestoneDefinition.getIconLocation());
        milestoneDisplayInfo.setTotalTasksLeft(BigInteger.valueOf(milestoneDefinition.getTasksRemaining()));
        if (milestoneDefinition.getUserTasks() == null || milestoneDefinition.getUserTasks().isEmpty()) {
            milestoneDisplayInfo.setStatus("Completed");
            milestoneDisplayInfo.getTaskDisplayInfo().clear();
            return milestoneDisplayInfo;
        }
        HashMap allTaskIdMap = (HashMap)taskListMap.get(ALL_TASK_MAP);
        boolean hasMilestoneStarted = this.hasMilestoneStarted(milestoneDefinition, allTaskIdMap);
        if (!hasMilestoneStarted && milestoneDefinition.getDisplayMode().equals("whenInstantiated")) {
            milestoneDisplayInfo.setTitle("switch_" + milestoneDefinition.getId());
        }
        ArrayList<TaskDisplayInfo> taskDisplayInfoList = new ArrayList<TaskDisplayInfo>();
        TaskDisplayInfo taskDisplayInfo = null;
        List userTaskList = milestoneDefinition.getUserTasks();
        for (IUserTask userTask : userTaskList) {
            List taskList;
            String userTaskId = userTask.getId();
            List list = taskList = allTaskIdMap == null ? null : (List)allTaskIdMap.get(userTaskId);
            if (taskList != null && !taskList.isEmpty()) {
                for (Task task : taskList) {
                    taskDisplayInfo = this.constructTaskDisplayInfo(ctx, userTask, task);
                    String taskState = task.getSystemAttributes().getState();
                    if (this.isTaskCompleted(taskState)) {
                        milestoneDisplayInfo.setCompletedTaskCount(milestoneDisplayInfo.getCompletedTaskCount().add(BigInteger.ONE));
                        if (userTask.isLastTaskInMilestone()) {
                            milestoneDisplayInfo.setStatus("Completed");
                        }
                    }
                    taskDisplayInfoList.add(taskDisplayInfo);
                }
                continue;
            }
            taskDisplayInfo = this.constructTaskDisplayInfo(ctx, userTask, null);
            taskDisplayInfoList.add(taskDisplayInfo);
        }
        String milestoneStatus = null;
        if (!hasMilestoneStarted) {
            milestoneStatus = "Not Started";
        } else {
            for (int i = taskDisplayInfoList.size() - 1; i >= 0; --i) {
                String taskStatus = ((TaskDisplayInfo)taskDisplayInfoList.get(i)).getTask().getSystemAttributes().getState();
                if (!this.isTaskCompleted(taskStatus)) {
                    milestoneStatus = "In Progress";
                    break;
                }
                milestoneStatus = "Completed";
            }
        }
        if (milestoneStatus != null) {
            milestoneDisplayInfo.setStatus(milestoneStatus);
        }
        milestoneDisplayInfo.getTaskDisplayInfo().clear();
        milestoneDisplayInfo.getTaskDisplayInfo().addAll(taskDisplayInfoList);
        return milestoneDisplayInfo;
    }

    private TaskDisplayInfo constructTaskDisplayInfo(IWorkflowContext ctx, IUserTask userTask, Task task) throws WorkflowException {
        TaskDisplayInfo taskDisplayInfo = new oracle.bpel.services.workflow.activityguide.query.model.ObjectFactory().createTaskDisplayInfo();
        taskDisplayInfo.setTaskInactive(true);
        if (task != null) {
            taskDisplayInfo.setTaskInactive(false);
            String taskTitle = AGi18nUtil.renderValueforTaskValueType(ctx.getLocale(), task);
            if (taskTitle != null) {
                task.setTitle(taskTitle);
            }
            taskDisplayInfo.setTask((TaskType)task);
        } else {
            ObjectFactory objf = new ObjectFactory();
            Task dummyTask = objf.createTask();
            dummyTask.getSystemAttributes().setTaskId("AGDM_" + Long.toString(System.currentTimeMillis()) + userTask.getId());
            dummyTask.getSystemAttributes().setState("Not Started");
            if (userTask.getDisplayMode().equals("whenInstantiated")) {
                dummyTask.setTitle("switch_" + userTask.getId());
            } else {
                Task tempTask = objf.createTask();
                TaskMetadataCache taskCache = TaskMetadataCache.getInstance();
                TaskDefinition taskDefn = taskCache.getTaskDefinition(userTask.getTaskDefinitionId(), null);
                tempTask.setTaskDefinitionId(taskDefn.getId());
                String currentLabel = WorkflowServiceEngine.getInstance().getLatestMDSLabel(userTask.getTaskDefinitionId());
                tempTask.setMdsLabel(currentLabel);
                String taskTitle = null;
                if (taskDefn.getTitle() != null) {
                    if (taskDefn.getTitle().getType().equals("STATIC")) {
                        taskTitle = taskDefn.getTitle().getValue();
                    } else if (taskDefn.getTitle().getType().equals("XPATH")) {
                        taskTitle = taskDefn.getName();
                    } else if (taskDefn.getTitle().getType().equals("RESOURCEREF") || taskDefn.getTitle().getType().equals("RESOURCE")) {
                        taskTitle = AGi18nUtil.renderValueforTaskValueType(ctx.getLocale(), tempTask);
                    }
                }
                if (taskTitle == null || taskTitle.isEmpty()) {
                    dummyTask.setTitle(userTask.getTaskName());
                } else {
                    dummyTask.setTitle(taskTitle);
                }
            }
            taskDisplayInfo.setTask((TaskType)dummyTask);
        }
        this.copyTaskAttributes(ctx, taskDisplayInfo, userTask);
        return taskDisplayInfo;
    }

    private void copyTaskAttributes(IWorkflowContext ctx, TaskDisplayInfo taskDisplayInfo, IUserTask userTask) throws WorkflowException {
        TaskType task;
        taskDisplayInfo.setId(userTask.getId());
        taskDisplayInfo.setOptional(userTask.isMarkedAsOptional());
        taskDisplayInfo.setLastMilestoneTask(userTask.isLastTaskInMilestone());
        BigInteger tasksRemaining = new BigInteger(Integer.toString(userTask.getTasksRemaining()));
        taskDisplayInfo.setTasksRemaining(tasksRemaining);
        if (userTask.isDisplayBlockedIcon() && (task = taskDisplayInfo.getTask()) != null && task.getSystemAttributes().getState() != null && task.getSystemAttributes().getState().equals("COMPLETED")) {
            taskDisplayInfo.setDisplayBlockedIcon(userTask.isDisplayBlockedIcon());
            if (userTask.getExplanation() != null) {
                String blockedExplanationValue = userTask.getExplanation().getValue();
                TranslatableValueTypeEnum blockedExplanationType = userTask.getExplanation().getType();
                try {
                    blockedExplanationValue = AGi18nUtil.renderValueForValueType(ctx.getLocale(), userTask.getParentMilestone().getParentActivityGuide(), blockedExplanationValue, blockedExplanationType.toString());
                }
                catch (Exception e) {
                    Object[] errorObjs = new Object[]{"Failure to retrieve AG resource bundle from metadata service in copyTaskAttributes."};
                    WorkflowException we = new WorkflowException(38006, errorObjs, (Throwable)e);
                    BPMLogger.log((LoggerComponent)LoggerComponent.COMPONENT_AG_QUERY_SERVICE, (Severity)Severity.ERRORS, (Throwable)e);
                    throw we;
                }
                taskDisplayInfo.setBlockedExplanation(blockedExplanationValue);
            }
        }
    }

    private HashMap getTasksInAG(String compositeInstanceID, IWorkflowContext ctx, IAGQueryService.AGAssignmentFilter assignmentFilter, List taskDisplayColumns) throws WorkflowException {
        String taskID;
        HashMap taskIdMap = new HashMap(2);
        HashMap<String, Task> filteredTaskIDMap = new HashMap<String, Task>();
        HashMap<String, ArrayList<Task>> allTaskIDMap = new HashMap<String, ArrayList<Task>>();
        PredicateImpl taskPredicate = new PredicateImpl(IColumnConstants.PROCESS_COMPOSITEINSTANCEID_COLUMN, 0, (Object)compositeInstanceID);
        ArrayList taskQueryColumns = new ArrayList(taskVerificationColumns);
        if (taskDisplayColumns != null && !taskDisplayColumns.isEmpty()) {
            taskQueryColumns.addAll(taskDisplayColumns);
        }
        Ordering ordering = new Ordering(TableConstants.WFTASK_CREATEDDATE_COLUMN, true, true);
        ArrayList<ITaskQueryService.OptionalInfo> optionInfos = new ArrayList<ITaskQueryService.OptionalInfo>();
        optionInfos.add(ITaskQueryService.OptionalInfo.DISPLAY_INFO);
        List allTaskList = new ArrayList();
        allTaskList = this.getTaskQueryService().queryTasks(BpmAGQueryService.getInternalWorkflowContext(), taskQueryColumns, optionInfos, ITaskQueryService.AssignmentFilter.ALL, null, (Predicate)taskPredicate, ordering, 0, 0);
        for (Task taskVO : allTaskList) {
            String activityID = taskVO.getSystemAttributes().getActivityId();
            String processId = taskVO.getProcessInfo().getProcessId();
            taskID = activityID + "_" + processId;
            ArrayList<Task> taskList = (ArrayList<Task>)allTaskIDMap.get(taskID);
            if (taskList == null || taskList.isEmpty()) {
                taskList = new ArrayList<Task>();
                taskList.add(taskVO);
            } else {
                taskList.add(taskVO);
            }
            allTaskIDMap.put(taskID, taskList);
        }
        List filteredTaskList = new ArrayList();
        ITaskQueryService.AssignmentFilter taskFilter = this.getTaskAssignmentFilter(assignmentFilter);
        filteredTaskList = this.getTaskQueryService().queryTasks(ctx, taskQueryColumns, optionInfos, taskFilter, null, (Predicate)taskPredicate, ordering, 0, 0);
        if (filteredTaskList.size() > 0) {
            Task task = null;
            for (int i = filteredTaskList.size() - 1; i >= 0; --i) {
                task = (Task)filteredTaskList.get(i);
                if (!this.getVerificationService().canUserSeeTaskDetails(ctx, task)) {
                    filteredTaskList.remove(i);
                    continue;
                }
                taskID = task.getSystemAttributes().getTaskId();
                filteredTaskIDMap.put(taskID, task);
            }
        }
        BPMLogger.log((LoggerComponent)LoggerComponent.COMPONENT_AG_QUERY_SERVICE, (Severity)Severity.DEBUG, (String)CLASSNAME, (String)"getTasksInAG", (String)("Number of TaskVO in AG that user can see" + filteredTaskList.size()));
        taskIdMap.put(ALL_TASK_MAP, allTaskIDMap);
        taskIdMap.put(FILTERED_TASK_MAP, filteredTaskIDMap);
        return taskIdMap;
    }

    private List filterBranchEntries(List displayInfoList, Object parent_definition, String ag_status, boolean isNextMSEnabled) {
        ArrayList returnListObject = new ArrayList();
        if (displayInfoList == null || displayInfoList.isEmpty()) {
            return returnListObject;
        }
        ArrayList temporary_branch_list = new ArrayList();
        for (int i = 0; i < displayInfoList.size(); ++i) {
            Object listItem = displayInfoList.get(i);
            String displayMode = this.getDisplayMode(parent_definition, listItem);
            if (displayMode.equalsIgnoreCase("whenInstantiated")) {
                String current_item_status = this.getStatus(listItem);
                if (temporary_branch_list.isEmpty()) {
                    Object nextItem;
                    if (current_item_status != null && !current_item_status.equals("Not Started")) {
                        temporary_branch_list.add(listItem);
                        returnListObject.add(listItem);
                        continue;
                    }
                    if (current_item_status == null || !current_item_status.equals("Not Started")) continue;
                    boolean isNextItemEnabled = false;
                    int j = i + 1;
                    Object v0 = nextItem = j < displayInfoList.size() ? displayInfoList.get(j) : null;
                    while (nextItem != null) {
                        String next_item_status = this.getStatus(nextItem);
                        if (!next_item_status.equals("Not Started")) {
                            isNextItemEnabled = true;
                            break;
                        }
                        nextItem = ++j < displayInfoList.size() ? displayInfoList.get(j) : null;
                    }
                    if (isNextItemEnabled || ag_status == null || ag_status.equals("Completed")) continue;
                    if (listItem instanceof TaskDisplayInfo) {
                        if (isNextMSEnabled) continue;
                        temporary_branch_list.add(listItem);
                        returnListObject.add(listItem);
                        continue;
                    }
                    temporary_branch_list.add(listItem);
                    returnListObject.add(listItem);
                    continue;
                }
                if (current_item_status == null || current_item_status.equals("Not Started")) continue;
                Object old_item = temporary_branch_list.get(temporary_branch_list.size() - 1);
                String old_item_status = this.getStatus(old_item);
                if (old_item_status != null && old_item_status.equals("Not Started")) {
                    returnListObject.remove(old_item);
                    temporary_branch_list.remove(old_item);
                }
                temporary_branch_list.add(listItem);
                returnListObject.add(listItem);
                continue;
            }
            returnListObject.add(listItem);
            temporary_branch_list.clear();
        }
        return returnListObject;
    }

    private String getStatus(Object listItem) {
        if (listItem instanceof MilestoneDisplayInfo) {
            return ((MilestoneDisplayInfo)listItem).getStatus();
        }
        if (listItem instanceof TaskDisplayInfo) {
            return ((TaskDisplayInfo)listItem).getTask().getSystemAttributes().getState();
        }
        return null;
    }

    private String getDisplayMode(Object parent_definition, Object listItem) {
        if (parent_definition instanceof IActivityGuide) {
            MilestoneDisplayInfo milestoneItem = (MilestoneDisplayInfo)listItem;
            IMilestone child_definition = ((IActivityGuide)parent_definition).findMilestone(milestoneItem.getName());
            return child_definition.getDisplayMode();
        }
        if (parent_definition instanceof IMilestone) {
            TaskDisplayInfo taskItem = (TaskDisplayInfo)listItem;
            IUserTask child_definition = ((IMilestone)parent_definition).findUserTask(taskItem.getId());
            return child_definition.getDisplayMode();
        }
        return null;
    }

    private List<MilestoneDisplayInfo> checkTaskBlockedStatus(List<MilestoneDisplayInfo> msDisplayInfoList, String agStatus) {
        boolean hasActiveTasks = this.hasActiveTasksInAG(msDisplayInfoList);
        for (int i = 0; i < msDisplayInfoList.size(); ++i) {
            MilestoneDisplayInfo currentMSDisplayInfo = msDisplayInfoList.get(i);
            List taskDisplayInfoList = currentMSDisplayInfo.getTaskDisplayInfo();
            for (int j = 0; taskDisplayInfoList != null && j < taskDisplayInfoList.size(); ++j) {
                TaskDisplayInfo currentTaskDisplayInfo = (TaskDisplayInfo)taskDisplayInfoList.get(j);
                if (!currentTaskDisplayInfo.isDisplayBlockedIcon() || (agStatus == null || !agStatus.equals("Completed")) && !hasActiveTasks) continue;
                currentTaskDisplayInfo.setDisplayBlockedIcon(false);
                currentTaskDisplayInfo.setBlockedExplanation("");
            }
        }
        return msDisplayInfoList;
    }

    private boolean hasMilestoneStarted(IMilestone milestoneDefinition, HashMap allTaskMap) {
        boolean milestoneStarted = false;
        if (allTaskMap != null && !allTaskMap.isEmpty()) {
            Set taskIds = allTaskMap.keySet();
            for (String taskId : taskIds) {
                IUserTask userTask = milestoneDefinition.findUserTask(taskId);
                if (userTask == null) continue;
                milestoneStarted = true;
                break;
            }
        }
        return milestoneStarted;
    }

    private List<String> getProcessInstanceIds(IWorkflowContext ctx, IAGQueryService.AGAssignmentFilter agFilter) throws WorkflowException {
        ArrayList<String> instanceIds = new ArrayList<String>();
        PredicateImpl taskStatePredicate = null;
        if (agFilter.equals((Object)IAGQueryService.AGAssignmentFilter.ADMIN)) {
            if (!BpmAGQueryService.isUserAGAdmin(ctx)) {
                Object[] errorObjs = new Object[]{ctx.getUser(), "isUserAGAdmin"};
                String reason = "User does not have the activity guide administration privilege required for using the ADMIN assignment filter. token = " + ctx.getToken() + " ctxUser = " + ctx.getUser();
                WorkflowException we = new WorkflowException(38004, reason, errorObjs);
                BPMLogger.log((LoggerComponent)LoggerComponent.COMPONENT_AG_QUERY_SERVICE, (Severity)Severity.ERRORS, (Throwable)we);
                throw we;
            }
        } else if (agFilter.equals((Object)IAGQueryService.AGAssignmentFilter.MY) || agFilter.equals((Object)IAGQueryService.AGAssignmentFilter.REPORTEES)) {
            ArrayList<String> taskStateList = new ArrayList<String>();
            taskStateList.add("ASSIGNED");
            taskStateList.add("INFO_REQUESTED");
            taskStatePredicate = new PredicateImpl(TableConstants.WFTASK_STATE_COLUMN, 9, taskStateList);
        } else if (agFilter.equals((Object)IAGQueryService.AGAssignmentFilter.PREVIOUS) || agFilter.equals((Object)IAGQueryService.AGAssignmentFilter.REVIEWER)) {
            taskStatePredicate = null;
        } else {
            return instanceIds;
        }
        HashSet taskList = new HashSet();
        ITaskQueryService task_query_svc = this.getTaskQueryService();
        List taskListWithStatePredicate = task_query_svc.queryTasks(ctx, taskVerificationColumns, null, this.getTaskAssignmentFilter(agFilter), null, taskStatePredicate, null, 0, 0);
        Map ownerAppRoles = VerificationService.getAppRoleNamesMap((IWorkflowContext)ctx);
        if (agFilter.equals((Object)IAGQueryService.AGAssignmentFilter.MY) && ownerAppRoles.size() != 0) {
            List ownedTaskList = new ArrayList();
            ownedTaskList = task_query_svc.queryTasks(ctx, taskVerificationColumns, null, ITaskQueryService.AssignmentFilter.OWNER, null, (Predicate)taskStatePredicate, null, 0, 0);
            taskList.addAll(taskListWithStatePredicate);
            taskList.addAll(ownedTaskList);
        } else {
            taskList.addAll(taskListWithStatePredicate);
        }
        for (Task task : taskList) {
            String instanceId = task.getProcessInfo().getInstanceId();
            if (instanceId == null || instanceIds.contains(instanceId)) continue;
            instanceIds.add(instanceId);
        }
        return instanceIds;
    }

    private ITaskQueryService.AssignmentFilter getTaskAssignmentFilter(IAGQueryService.AGAssignmentFilter assignmentFilter) {
        ITaskQueryService.AssignmentFilter taskFilter = null;
        if (assignmentFilter.equals((Object)IAGQueryService.AGAssignmentFilter.ADMIN)) {
            taskFilter = ITaskQueryService.AssignmentFilter.ALL;
        } else if (assignmentFilter.equals((Object)IAGQueryService.AGAssignmentFilter.MY)) {
            taskFilter = ITaskQueryService.AssignmentFilter.MY_AND_GROUP;
        } else if (assignmentFilter.equals((Object)IAGQueryService.AGAssignmentFilter.PREVIOUS)) {
            taskFilter = ITaskQueryService.AssignmentFilter.PREVIOUS;
        } else if (assignmentFilter.equals((Object)IAGQueryService.AGAssignmentFilter.REPORTEES)) {
            taskFilter = ITaskQueryService.AssignmentFilter.REPORTEES;
        } else if (assignmentFilter.equals((Object)IAGQueryService.AGAssignmentFilter.REVIEWER)) {
            taskFilter = ITaskQueryService.AssignmentFilter.REVIEWER;
        }
        return taskFilter;
    }

    private List<Column> addDefaultProcessColumns(List processColumns) throws WorkflowException {
        List<Column> defaultColumns = Arrays.asList(IAGQueryService.AG_BPM_DEFAULT_COLUMNS);
        ArrayList<Column> returnList = new ArrayList<Column>();
        if (processColumns != null) {
            for (Object inputCol : processColumns) {
                Column column = null;
                if (inputCol instanceof String) {
                    column = Column.getColumn((String)((String)inputCol));
                } else if (inputCol instanceof Column) {
                    column = (Column)inputCol;
                }
                if (column != null) {
                    returnList.add(column);
                    continue;
                }
                throw new WorkflowException(30952, new Object[]{inputCol});
            }
        }
        if (returnList.isEmpty()) {
            returnList.addAll(defaultColumns);
            return returnList;
        }
        for (Column col : defaultColumns) {
            this.addOnce(returnList, col);
        }
        return returnList;
    }

    private void addOnce(List list, Column column) {
        if (list == null || column == null) {
            return;
        }
        if (!list.contains(column)) {
            list.add(column);
        }
    }

    private boolean canUserSeeAGDisplayInfo(IWorkflowContext ctx, Map taskIdMap) throws WorkflowException {
        BPMLogger.log((LoggerComponent)LoggerComponent.COMPONENT_AG_QUERY_SERVICE, (Severity)Severity.DEBUG, (String)CLASSNAME, (String)"canUserSeeAGDisplayInfo", (String)("Start of canUserSeeAGDisplayInfo for user: " + ctx.getUser()));
        boolean bCanUserSeeAGDisplayInfo = false;
        if (BpmAGQueryService.isUserAGAdmin(ctx)) {
            bCanUserSeeAGDisplayInfo = true;
            BPMLogger.log((LoggerComponent)LoggerComponent.COMPONENT_AG_QUERY_SERVICE, (Severity)Severity.DEBUG, (String)CLASSNAME, (String)"canUserSeeAGDisplayInfo", (String)"User is AG admin and can see AG");
            return bCanUserSeeAGDisplayInfo;
        }
        if (taskIdMap != null && !taskIdMap.isEmpty()) {
            bCanUserSeeAGDisplayInfo = true;
            BPMLogger.log((LoggerComponent)LoggerComponent.COMPONENT_AG_QUERY_SERVICE, (Severity)Severity.DEBUG, (String)CLASSNAME, (String)"canUserSeeAGDisplayInfo", (String)"User can see the AG.");
        }
        BPMLogger.log((LoggerComponent)LoggerComponent.COMPONENT_AG_QUERY_SERVICE, (Severity)Severity.DEBUG, (String)CLASSNAME, (String)"canUserSeeAGDisplayInfo", (String)("Completed. canUserSeeAGDisplayInfo " + String.valueOf(bCanUserSeeAGDisplayInfo)));
        return bCanUserSeeAGDisplayInfo;
    }

    private boolean hasActiveTasksInAG(List<MilestoneDisplayInfo> msDisplayInfoList) {
        BPMLogger.log((LoggerComponent)LoggerComponent.COMPONENT_AG_QUERY_SERVICE, (Severity)Severity.DEBUG, (String)CLASSNAME, (String)"hasActiveTasksInAG", (String)"Start of hasActiveTasksInAG");
        boolean hasActiveTask = false;
        for (int i = 0; i < msDisplayInfoList.size(); ++i) {
            MilestoneDisplayInfo nextMSDisplayInfo = msDisplayInfoList.get(i);
            if (nextMSDisplayInfo == null || !nextMSDisplayInfo.getStatus().equals("In Progress")) continue;
            List taskDisplayList = nextMSDisplayInfo.getTaskDisplayInfo();
            for (TaskDisplayInfo taskDisplayInfo : taskDisplayList) {
                if (taskDisplayInfo.getTask() == null || !"ASSIGNED".equals(taskDisplayInfo.getTask().getSystemAttributes().getState())) continue;
                hasActiveTask = true;
                BPMLogger.log((LoggerComponent)LoggerComponent.COMPONENT_AG_QUERY_SERVICE, (Severity)Severity.DEBUG, (String)CLASSNAME, (String)"hasActiveTasksInAG", (String)("Completed. hasActiveTasksInAG " + String.valueOf(hasActiveTask)));
                return hasActiveTask;
            }
        }
        BPMLogger.log((LoggerComponent)LoggerComponent.COMPONENT_AG_QUERY_SERVICE, (Severity)Severity.DEBUG, (String)CLASSNAME, (String)"hasActiveTasksInAG", (String)("Completed. hasActiveTasksInAG " + String.valueOf(hasActiveTask)));
        return hasActiveTask;
    }

    static {
        BpmAGQueryService.initTaskVerificationColumns();
        AG_BPM_STATE_MAP.put("COMPLETED", "Completed");
        AG_BPM_STATE_MAP.put("OPEN", "In Progress");
        AG_BPM_STATE_MAP.put("STALE", "Stale");
    }
}

