/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.services.activityguide.impl;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import oracle.bpel.services.bpm.common.IBPMContext;
import oracle.bpel.services.workflow.StaleObjectException;
import oracle.bpel.services.workflow.WorkflowException;
import oracle.bpel.services.workflow.activityguide.query.IAGQueryService;
import oracle.bpel.services.workflow.activityguide.query.model.AGDisplayInfo;
import oracle.bpel.services.workflow.activityguide.query.model.MilestoneDisplayInfo;
import oracle.bpel.services.workflow.activityguide.query.model.TaskDisplayInfoType;
import oracle.bpel.services.workflow.activityguide.uibroker.IAGUIBrokerRegService;
import oracle.bpel.services.workflow.client.IWorkflowServiceClient;
import oracle.bpel.services.workflow.client.WorkflowServiceClientFactory;
import oracle.bpel.services.workflow.messaging.IMessageBody;
import oracle.bpel.services.workflow.task.ITaskService;
import oracle.bpel.services.workflow.task.impl.WorkflowUtil;
import oracle.bpel.services.workflow.task.model.Task;
import oracle.bpel.services.workflow.verification.IVerificationService;
import oracle.bpel.services.workflow.verification.IWorkflowContext;
import oracle.bpm.services.activityguide.IBpmAGProcessBrokerService;
import oracle.bpm.services.activityguide.ProcessBrokerException;
import oracle.bpm.services.activityguide.ProcessBrokerTimeOutException;
import oracle.bpm.services.common.AbstractBPMService;
import oracle.bpm.services.common.exception.BPMException;
import oracle.bpm.services.common.logger.BPMLogger;
import oracle.bpm.services.common.logger.LoggerComponent;
import oracle.bpm.services.common.logger.Severity;
import oracle.bpm.services.instancemanagement.ejb.IInstanceManagementServiceLocal;
import oracle.bpm.services.instancemanagement.model.IProcessInstance;
import oracle.integration.platform.blocks.FabricConfigManager;
import oracle.soa.management.config.ConfigDefs;
import oracle.soa.management.config.bpmn.BPMNConfig;

public class BpmAGProcessBrokerService
extends AbstractBPMService
implements IBpmAGProcessBrokerService {
    private IInstanceManagementServiceLocal instanceMgmtLocalBean;
    private ITaskService taskService;
    private static boolean bpmInstalled = false;
    private static final String CLASSNAME = "oracle.bpm.services.activityguide.impl.BpmAGProcessBrokerService";

    public String startProcessInst(IBPMContext bpmContext, String processDefnId, Map<Object, Object> payload) throws ProcessBrokerException {
        BPMLogger.log((LoggerComponent)LoggerComponent.COMPONENT_AG_PROCESS_BROKER_SERVICE, (Severity)Severity.DEBUG, (String)CLASSNAME, (String)"startProcessInst", (String)("Start of startProcessInst for process defn id:" + processDefnId + " by user: " + bpmContext.getUser()));
        boolean disableProcessBrokerFlag = (Boolean)this.getMBeanPropertyValue();
        if (!bpmInstalled || disableProcessBrokerFlag) {
            return null;
        }
        IVerificationService verificationService = this.getVerificationService();
        try {
            verificationService.validateContext((IWorkflowContext)bpmContext);
        }
        catch (WorkflowException e) {
            String msg = "Exception thrown in verification service during validateContext";
            BPMLogger.log((LoggerComponent)LoggerComponent.COMPONENT_AG_PROCESS_BROKER_SERVICE, (Severity)Severity.ERRORS, (String)msg);
            throw new ProcessBrokerException(Severity.ERRORS, 71051, (Object[])new String[]{bpmContext.getUser(), bpmContext.getIdentityContext()}, (Throwable)e);
        }
        IInstanceManagementServiceLocal instanceMgmtSvc = this.getInstanceMgmtLocalBean();
        String processInstanceId = null;
        try {
            processInstanceId = instanceMgmtSvc.createProcessInstance(bpmContext, processDefnId);
        }
        catch (BPMException e) {
            String msg = "Exception thrown in instance mgmt service during createProcessInstance";
            BPMLogger.log((LoggerComponent)LoggerComponent.COMPONENT_AG_PROCESS_BROKER_SERVICE, (Severity)Severity.ERRORS, (String)msg);
            throw new ProcessBrokerException(Severity.ERRORS, 70204, (Object[])new String[]{processDefnId}, (Throwable)e);
        }
        if (processInstanceId == null) {
            String msg = "Null process instanceid returned from instance mgmt service during createProcessInstance";
            BPMLogger.log((LoggerComponent)LoggerComponent.COMPONENT_AG_PROCESS_BROKER_SERVICE, (Severity)Severity.ERRORS, (String)msg);
            return null;
        }
        IProcessInstance processInstance = null;
        try {
            processInstance = this.getInstanceQueryService().getProcessInstance(bpmContext, processInstanceId);
        }
        catch (BPMException e) {
            String msg = "Exception thrown in instance query service during getProcessInstance";
            BPMLogger.log((LoggerComponent)LoggerComponent.COMPONENT_AG_PROCESS_BROKER_SERVICE, (Severity)Severity.ERRORS, (String)msg);
            throw new ProcessBrokerException(Severity.ERRORS, 70401, (Object[])new String[]{processInstanceId}, (Throwable)e);
        }
        IAGUIBrokerRegService agRegistrationSvc = this.getAGUIBrokerRegService();
        try {
            if (processInstance != null) {
                agRegistrationSvc.registerInstance((IWorkflowContext)bpmContext, processInstanceId, processInstance.getSca().getCompositeInstanceId());
            }
        }
        catch (WorkflowException e) {
            String msg = "Exception thrown in registration service during registerInstance for process:" + processInstanceId;
            BPMLogger.log((LoggerComponent)LoggerComponent.COMPONENT_AG_PROCESS_BROKER_SERVICE, (Severity)Severity.ERRORS, (String)msg);
            throw new ProcessBrokerException(Severity.ERRORS, 72200, (Object[])new String[0], (Throwable)e);
        }
        BPMLogger.log((LoggerComponent)LoggerComponent.COMPONENT_AG_PROCESS_BROKER_SERVICE, (Severity)Severity.DEBUG, (String)CLASSNAME, (String)"startProcessInst", (String)("Process with Id" + processInstanceId + "is started"));
        BPMLogger.log((LoggerComponent)LoggerComponent.COMPONENT_AG_PROCESS_BROKER_SERVICE, (Severity)Severity.DEBUG, (String)CLASSNAME, (String)"startProcessInst", (String)("End of startProcessInst for process defn id:" + processDefnId + " by user: " + bpmContext.getUser()));
        return processInstanceId;
    }

    public void restartProcessInst(IBPMContext bpmContext, String processInstanceId, Boolean withdrawPendingTasks, Boolean forceRestart) throws ProcessBrokerException {
        BPMLogger.log((LoggerComponent)LoggerComponent.COMPONENT_AG_PROCESS_BROKER_SERVICE, (Severity)Severity.DEBUG, (String)CLASSNAME, (String)"restartProcessInst", (String)("Start of restartProcessInst for process instance id:" + processInstanceId + " by user: " + bpmContext.getUser()));
        boolean disableProcessBrokerFlag = (Boolean)this.getMBeanPropertyValue();
        if (!bpmInstalled || disableProcessBrokerFlag) {
            return;
        }
        IVerificationService verificationService = this.getVerificationService();
        try {
            verificationService.validateContext((IWorkflowContext)bpmContext);
        }
        catch (WorkflowException e) {
            String msg = "Exception thrown in verification service during validateContext";
            BPMLogger.log((LoggerComponent)LoggerComponent.COMPONENT_AG_PROCESS_BROKER_SERVICE, (Severity)Severity.ERRORS, (String)msg);
            throw new ProcessBrokerException(Severity.ERRORS, 71051, (Object[])new String[]{bpmContext.getUser(), bpmContext.getIdentityContext()}, (Throwable)e);
        }
        IAGUIBrokerRegService agRegistrationSvc = this.getAGUIBrokerRegService();
        boolean userRegistered = agRegistrationSvc.isUserRegistered((IWorkflowContext)bpmContext, processInstanceId);
        if (userRegistered && !forceRestart.booleanValue()) {
            String msg = "Cannot restart since the process is already restarted";
            BPMLogger.log((LoggerComponent)LoggerComponent.COMPONENT_AG_PROCESS_BROKER_SERVICE, (Severity)Severity.ERRORS, (String)msg);
            throw new ProcessBrokerException(Severity.ERRORS, 72201, (Object[])new String[]{processInstanceId, bpmContext.getUser()});
        }
        if (withdrawPendingTasks.booleanValue()) {
            BPMLogger.log((LoggerComponent)LoggerComponent.COMPONENT_AG_PROCESS_BROKER_SERVICE, (Severity)Severity.DEBUG, (String)CLASSNAME, (String)"restartProcessInst", (String)("Withdrawing active tasks for process Id " + processInstanceId));
            IAGQueryService agQuerySvc = this.getAGQueryService();
            String taskId = null;
            AGDisplayInfo agDisplayInfo = null;
            try {
                agDisplayInfo = agQuerySvc.getAGDisplayInfoDetailsById("AGBPM", (IWorkflowContext)bpmContext, (long)Integer.parseInt(processInstanceId), null, "My");
                List msDispInfoList = agDisplayInfo.getMilestoneDisplayInfo();
                ITaskService taskService = this.getTaskServiceLocalBean();
                for (MilestoneDisplayInfo msDispInfo : msDispInfoList) {
                    if (!msDispInfo.getStatus().equals("In Progress")) continue;
                    List taskList = msDispInfo.getTaskDisplayInfo();
                    for (TaskDisplayInfoType taskDisplayInfo : taskList) {
                        if (taskDisplayInfo.getTask() == null || taskDisplayInfo.getTask().getSystemAttributes().getState() == null || !taskDisplayInfo.getTask().getSystemAttributes().getState().equals("ASSIGNED")) continue;
                        taskId = taskDisplayInfo.getTask().getSystemAttributes().getTaskId();
                        taskService.withdrawTask((IWorkflowContext)bpmContext, taskId);
                        BPMLogger.log((LoggerComponent)LoggerComponent.COMPONENT_AG_PROCESS_BROKER_SERVICE, (Severity)Severity.DEBUG, (String)CLASSNAME, (String)"restartProcessInst", (String)("Task with Id " + taskId + " is withdrawn"));
                    }
                }
            }
            catch (WorkflowException e) {
                String msg = "Exception thrown in task service during withdrawTask for task id:" + taskId;
                BPMLogger.log((LoggerComponent)LoggerComponent.COMPONENT_AG_PROCESS_BROKER_SERVICE, (Severity)Severity.ERRORS, (String)msg);
                throw new ProcessBrokerException(Severity.ERRORS, 72200, (Object[])new String[0], (Throwable)e);
            }
            catch (StaleObjectException e) {
                String msg = "Exception thrown in task service during withdrawTask for task id:" + taskId;
                BPMLogger.log((LoggerComponent)LoggerComponent.COMPONENT_AG_PROCESS_BROKER_SERVICE, (Severity)Severity.ERRORS, (String)msg);
                throw new ProcessBrokerException(Severity.ERRORS, 72200, (Object[])new String[0], (Throwable)e);
            }
        }
        try {
            agRegistrationSvc.deRegisterUser((IWorkflowContext)bpmContext, processInstanceId);
        }
        catch (WorkflowException e) {
            String msg = "Exception thrown in registration service during deRegisterUser for process:" + processInstanceId;
            BPMLogger.log((LoggerComponent)LoggerComponent.COMPONENT_AG_PROCESS_BROKER_SERVICE, (Severity)Severity.ERRORS, (String)msg);
            throw new ProcessBrokerException(Severity.ERRORS, 72200, (Object[])new String[0], (Throwable)e);
        }
        BPMLogger.log((LoggerComponent)LoggerComponent.COMPONENT_AG_PROCESS_BROKER_SERVICE, (Severity)Severity.DEBUG, (String)CLASSNAME, (String)"restartProcessInst", (String)("End of restartProcessInst for process instance id:" + processInstanceId + " by user: " + bpmContext.getUser()));
    }

    public void disconnectProcessInst(IBPMContext bpmContext, String processInstanceId, Boolean releaseTasks) throws ProcessBrokerException {
        BPMLogger.log((LoggerComponent)LoggerComponent.COMPONENT_AG_PROCESS_BROKER_SERVICE, (Severity)Severity.DEBUG, (String)CLASSNAME, (String)"disconnectProcessInst", (String)("Start of disconnectProcessInst for process instance id:" + processInstanceId + " by user: " + bpmContext.getUser()));
        boolean disableProcessBrokerFlag = (Boolean)this.getMBeanPropertyValue();
        if (!bpmInstalled || disableProcessBrokerFlag) {
            return;
        }
        IVerificationService verificationService = this.getVerificationService();
        try {
            verificationService.validateContext((IWorkflowContext)bpmContext);
        }
        catch (WorkflowException e) {
            String msg = "Exception thrown in verification service during validateContext";
            BPMLogger.log((LoggerComponent)LoggerComponent.COMPONENT_AG_PROCESS_BROKER_SERVICE, (Severity)Severity.ERRORS, (String)msg);
            throw new ProcessBrokerException(Severity.ERRORS, 71051, (Object[])new String[]{bpmContext.getUser(), bpmContext.getIdentityContext()}, (Throwable)e);
        }
        IAGUIBrokerRegService agRegistrationSvc = this.getAGUIBrokerRegService();
        try {
            agRegistrationSvc.deRegisterUser((IWorkflowContext)bpmContext, processInstanceId);
        }
        catch (WorkflowException e) {
            String msg = "Exception thrown in registration service during deRegisterUser for process:" + processInstanceId;
            BPMLogger.log((LoggerComponent)LoggerComponent.COMPONENT_AG_PROCESS_BROKER_SERVICE, (Severity)Severity.ERRORS, (String)msg);
            throw new ProcessBrokerException(Severity.ERRORS, 72200, (Object[])new String[0], (Throwable)e);
        }
        if (releaseTasks.booleanValue()) {
            IAGQueryService agQuerySvc = this.getAGQueryService();
            AGDisplayInfo agDisplayInfo = null;
            String taskId = null;
            try {
                agDisplayInfo = agQuerySvc.getAGDisplayInfoDetailsById("AGBPM", (IWorkflowContext)bpmContext, (long)Integer.parseInt(processInstanceId), null, "My");
                List msDispInfoList = agDisplayInfo.getMilestoneDisplayInfo();
                ITaskService taskService = this.getTaskServiceLocalBean();
                for (MilestoneDisplayInfo msDispInfo : msDispInfoList) {
                    if (!msDispInfo.getStatus().equals("In Progress")) continue;
                    List taskList = msDispInfo.getTaskDisplayInfo();
                    for (TaskDisplayInfoType taskDisplayInfo : taskList) {
                        if (taskDisplayInfo.getTask() == null || taskDisplayInfo.getTask().getSystemAttributes().getState() == null || !taskDisplayInfo.getTask().getSystemAttributes().getState().equals("ASSIGNED") || !taskDisplayInfo.getTask().getSystemAttributes().isIsGroup()) continue;
                        taskId = taskDisplayInfo.getTask().getSystemAttributes().getTaskId();
                        taskService.releaseTask((IWorkflowContext)bpmContext, taskId);
                        BPMLogger.log((LoggerComponent)LoggerComponent.COMPONENT_AG_PROCESS_BROKER_SERVICE, (Severity)Severity.DEBUG, (String)CLASSNAME, (String)"disconnectProcessInst", (String)("Task with Id " + taskId + " is released"));
                    }
                }
            }
            catch (WorkflowException e) {
                String msg = "Exception thrown in task service during withdrawTask for task id:" + taskId;
                BPMLogger.log((LoggerComponent)LoggerComponent.COMPONENT_AG_PROCESS_BROKER_SERVICE, (Severity)Severity.ERRORS, (String)msg);
                throw new ProcessBrokerException(Severity.ERRORS, 72200, (Object[])new String[0], (Throwable)e);
            }
            catch (StaleObjectException e) {
                String msg = "Exception thrown in task service during withdrawTask for task id:" + taskId;
                BPMLogger.log((LoggerComponent)LoggerComponent.COMPONENT_AG_PROCESS_BROKER_SERVICE, (Severity)Severity.ERRORS, (String)msg);
                throw new ProcessBrokerException(Severity.ERRORS, 72200, (Object[])new String[0], (Throwable)e);
            }
        }
        BPMLogger.log((LoggerComponent)LoggerComponent.COMPONENT_AG_PROCESS_BROKER_SERVICE, (Severity)Severity.DEBUG, (String)CLASSNAME, (String)"disconnectProcessInst", (String)("End of disconnectProcessInst for process instance id:" + processInstanceId + " by user: " + bpmContext.getUser()));
    }

    public Task getNextTaskObject(IBPMContext bpmContext, String processInstanceId, List taskDisplayColumns, String taskInstanceId, String outcome, long timeout) throws ProcessBrokerException, ProcessBrokerTimeOutException {
        String msg;
        String msg2;
        BPMLogger.log((LoggerComponent)LoggerComponent.COMPONENT_AG_PROCESS_BROKER_SERVICE, (Severity)Severity.DEBUG, (String)CLASSNAME, (String)"getNextTaskObject", (String)("Start of getNextTaskObject for process instance id:" + processInstanceId + " by user: " + bpmContext.getUser() + " with timeout:" + timeout + " milli seconds. Approving taskInstanceId:" + taskInstanceId + " with outcome:" + outcome));
        boolean disableProcessBrokerFlag = (Boolean)this.getMBeanPropertyValue();
        if (!bpmInstalled || disableProcessBrokerFlag) {
            return null;
        }
        long startTime = System.currentTimeMillis();
        long endTime = 0L;
        long timeoutLeft = 0L;
        Task nextTask = null;
        IAGUIBrokerRegService registrationSvc = this.getAGUIBrokerRegService();
        try {
            registrationSvc.registerUser((IWorkflowContext)bpmContext, processInstanceId);
        }
        catch (WorkflowException e) {
            if (e.getErrorCode() == 38101) {
                msg2 = "Exception thrown in registration service during registerUser.. Reregistering..";
                BPMLogger.log((LoggerComponent)LoggerComponent.COMPONENT_AG_PROCESS_BROKER_SERVICE, (Severity)Severity.WARNING, (String)msg2);
                IProcessInstance processInstance = null;
                try {
                    processInstance = this.getInstanceQueryService().getProcessInstance(bpmContext, processInstanceId);
                }
                catch (BPMException e1) {
                    String msg1 = "Exception thrown in instance query service during getProcessInstance";
                    BPMLogger.log((LoggerComponent)LoggerComponent.COMPONENT_AG_PROCESS_BROKER_SERVICE, (Severity)Severity.ERRORS, (String)msg1);
                    throw new ProcessBrokerException(Severity.ERRORS, 70401, (Object[])new String[]{processInstanceId}, (Throwable)e1);
                }
                if (processInstance != null) {
                    try {
                        registrationSvc.registerInstance((IWorkflowContext)bpmContext, processInstanceId, processInstance.getSca().getCompositeInstanceId());
                    }
                    catch (WorkflowException f) {
                        String msg1 = "Exception thrown in registration service during Reregistering instance with id:" + processInstanceId;
                        BPMLogger.log((LoggerComponent)LoggerComponent.COMPONENT_AG_PROCESS_BROKER_SERVICE, (Severity)Severity.ERRORS, (String)msg1);
                        throw new ProcessBrokerException(Severity.ERRORS, 72200, (Object[])new String[0], (Throwable)f);
                    }
                    try {
                        registrationSvc.registerUser((IWorkflowContext)bpmContext, processInstanceId);
                    }
                    catch (WorkflowException f) {
                        String msg1 = "Exception thrown in registration service during Reregistering user:" + bpmContext.getUser();
                        BPMLogger.log((LoggerComponent)LoggerComponent.COMPONENT_AG_PROCESS_BROKER_SERVICE, (Severity)Severity.ERRORS, (String)msg1);
                        throw new ProcessBrokerException(Severity.ERRORS, 72200, (Object[])new String[0], (Throwable)f);
                    }
                }
                String msg22 = "Null process instance returned by process query service";
                BPMLogger.log((LoggerComponent)LoggerComponent.COMPONENT_AG_PROCESS_BROKER_SERVICE, (Severity)Severity.ERRORS, (String)msg22);
                throw new ProcessBrokerException(Severity.ERRORS, 72202, (Object[])new String[]{processInstanceId});
            }
            String msg3 = "Exception thrown in registration service during registerUser for process:" + processInstanceId + " and user:" + bpmContext.getUser();
            BPMLogger.log((LoggerComponent)LoggerComponent.COMPONENT_AG_PROCESS_BROKER_SERVICE, (Severity)Severity.ERRORS, (String)msg3);
            throw new ProcessBrokerException(Severity.ERRORS, 72200, (Object[])new String[0]);
        }
        if (taskInstanceId != null && outcome != null) {
            msg = "Updating task with id:" + taskInstanceId + " with outcome:" + outcome;
            BPMLogger.log((LoggerComponent)LoggerComponent.COMPONENT_AG_PROCESS_BROKER_SERVICE, (Severity)Severity.DEBUG, (String)CLASSNAME, (String)"getNextTaskObject", (String)msg);
            this.updateTaskOutcome(bpmContext, taskInstanceId, outcome);
        }
        if ((nextTask = this.getNextTaskObject(bpmContext, processInstanceId, taskDisplayColumns)) == null || nextTask.getSystemAttributes().getTaskId().equals(taskInstanceId)) {
            msg = "Next task is null for user:" + bpmContext.getUser() + ". Invoking messaging svc receive for task initiation";
            BPMLogger.log((LoggerComponent)LoggerComponent.COMPONENT_AG_PROCESS_BROKER_SERVICE, (Severity)Severity.DEBUG, (String)CLASSNAME, (String)"getNextTaskObject", (String)msg);
            HashMap<String, String> properties = new HashMap<String, String>();
            properties.put("agRootId", processInstanceId);
            properties.put("userId", bpmContext.getUser());
            IMessageBody messageBody = null;
            try {
                messageBody = this.getMessagingService().receive((IWorkflowContext)bpmContext, timeout, properties);
                endTime = System.currentTimeMillis();
                timeoutLeft = timeout - (endTime - startTime);
                BPMLogger.log((LoggerComponent)LoggerComponent.COMPONENT_AG_PROCESS_BROKER_SERVICE, (Severity)Severity.DEBUG, (String)CLASSNAME, (String)"getNextTaskObject", (String)("Timeout left after JMS receive is " + timeoutLeft + " ms."));
            }
            catch (WorkflowException e) {
                String msg1;
                if (e.getErrorCode() == 38202) {
                    timeoutLeft = 0L;
                    msg1 = "Time out exception thrown in process broker service during JMS receive for process:" + processInstanceId;
                    BPMLogger.log((LoggerComponent)LoggerComponent.COMPONENT_AG_PROCESS_BROKER_SERVICE, (Severity)Severity.ERRORS, (String)msg1);
                }
                endTime = System.currentTimeMillis();
                timeoutLeft = timeout - (endTime - startTime);
                msg1 = "Exception thrown in messaging service during receive. Timeoutleft is " + timeoutLeft + " ms.";
                BPMLogger.log((LoggerComponent)LoggerComponent.COMPONENT_AG_PROCESS_BROKER_SERVICE, (Severity)Severity.WARNING, (String)msg1);
            }
            if (messageBody != null && messageBody.getTaskInstanceId() != null) {
                String taskId = messageBody.getTaskInstanceId();
                BPMLogger.log((LoggerComponent)LoggerComponent.COMPONENT_AG_PROCESS_BROKER_SERVICE, (Severity)Severity.DEBUG, (String)CLASSNAME, (String)"getNextTaskObject", (String)("Received message from messaging svc; taskId is:" + taskId));
                long waitTime = 0L;
                while (nextTask == null && waitTime < timeoutLeft) {
                    try {
                        nextTask = this.getTaskQueryService().getTaskDetailsById((IWorkflowContext)bpmContext, taskId);
                        waitTime += 200L;
                        if (nextTask != null) break;
                        try {
                            Thread.sleep(waitTime);
                        }
                        catch (InterruptedException e) {
                            e.printStackTrace();
                        }
                    }
                    catch (WorkflowException e) {
                        if (e.getErrorCode() == 30513) {
                            String msg23 = "User " + bpmContext.getUser() + "cannot see task with id:" + taskId;
                            BPMLogger.log((LoggerComponent)LoggerComponent.COMPONENT_AG_PROCESS_BROKER_SERVICE, (Severity)Severity.WARNING, (String)CLASSNAME, (String)"getNextTaskObject", (String)msg23);
                            long startAGQueryTime = System.currentTimeMillis();
                            nextTask = this.getNextTaskObject(bpmContext, processInstanceId, taskDisplayColumns);
                            long endAGQueryTime = System.currentTimeMillis();
                            waitTime += endAGQueryTime - startAGQueryTime;
                            continue;
                        }
                        String msg1 = "Exception thrown in task query service during getTaskDetailsById for process:" + processInstanceId;
                        BPMLogger.log((LoggerComponent)LoggerComponent.COMPONENT_AG_PROCESS_BROKER_SERVICE, (Severity)Severity.ERRORS, (String)msg1);
                        throw new ProcessBrokerException(Severity.ERRORS, 72200, (Object[])new String[0], (Throwable)e);
                    }
                }
            }
            try {
                this.getMessagingService().flushMessages(properties);
            }
            catch (WorkflowException e) {
                String msg1 = "Exception thrown in messaging service during flushMesssages for process:" + processInstanceId;
                BPMLogger.log((LoggerComponent)LoggerComponent.COMPONENT_AG_PROCESS_BROKER_SERVICE, (Severity)Severity.ERRORS, (String)msg1);
            }
        }
        try {
            registrationSvc.deRegisterUser((IWorkflowContext)bpmContext, processInstanceId);
        }
        catch (WorkflowException e) {
            msg2 = "Exception thrown in registration service during deRegisterUser for process:" + processInstanceId;
            BPMLogger.log((LoggerComponent)LoggerComponent.COMPONENT_AG_PROCESS_BROKER_SERVICE, (Severity)Severity.ERRORS, (String)msg2);
            throw new ProcessBrokerException(Severity.ERRORS, 72200, (Object[])new String[0], (Throwable)e);
        }
        BPMLogger.log((LoggerComponent)LoggerComponent.COMPONENT_AG_PROCESS_BROKER_SERVICE, (Severity)Severity.DEBUG, (String)CLASSNAME, (String)"getNextTask", (String)("Next task# returned:" + (nextTask != null ? Integer.valueOf(nextTask.getSystemAttributes().getTaskNumber()) : null)));
        BPMLogger.log((LoggerComponent)LoggerComponent.COMPONENT_AG_PROCESS_BROKER_SERVICE, (Severity)Severity.DEBUG, (String)CLASSNAME, (String)"getNextTask", (String)("End of getNextTask for process instance id:" + processInstanceId + " by user: " + bpmContext.getUser()));
        if (nextTask == null) {
            nextTask = this.getNextTaskObject(bpmContext, processInstanceId, taskDisplayColumns);
        }
        if (nextTask == null) {
            throw new ProcessBrokerTimeOutException(Severity.ERRORS, 72205, (Object[])new String[]{processInstanceId, bpmContext.getUser()});
        }
        return nextTask;
    }

    private Task getNextTaskObject(IBPMContext bpmContext, String processInstanceId, List taskDisplayColumns) throws ProcessBrokerException {
        IAGQueryService agQuerySvc = this.getAGQueryService();
        AGDisplayInfo agDisplayInfo = null;
        try {
            agDisplayInfo = agQuerySvc.getAGDisplayInfoDetailsById("AGBPM", (IWorkflowContext)bpmContext, (long)Integer.parseInt(processInstanceId), taskDisplayColumns, "My");
        }
        catch (WorkflowException e) {
            if (e.getErrorCode() == 38003) {
                BPMLogger.log((LoggerComponent)LoggerComponent.COMPONENT_AG_PROCESS_BROKER_SERVICE, (Severity)Severity.WARNING, (String)e.getMessage());
                return null;
            }
            String msg = "Exception thrown in AG query service during getAGDisplayInfoDetailsById for process:" + processInstanceId;
            BPMLogger.log((LoggerComponent)LoggerComponent.COMPONENT_AG_PROCESS_BROKER_SERVICE, (Severity)Severity.ERRORS, (String)msg);
            throw new ProcessBrokerException(Severity.ERRORS, 72200, (Object[])new String[0], (Throwable)e);
        }
        if (agDisplayInfo == null) {
            String msg = "The process with Id:" + processInstanceId + " is not found";
            BPMLogger.log((LoggerComponent)LoggerComponent.COMPONENT_AG_PROCESS_BROKER_SERVICE, (Severity)Severity.ERRORS, (String)msg);
            throw new ProcessBrokerException(Severity.ERRORS, 72202, (Object[])new String[]{processInstanceId});
        }
        if (!agDisplayInfo.getStatus().equals("In Progress")) {
            IAGUIBrokerRegService agRegistrationSvc = this.getAGUIBrokerRegService();
            try {
                agRegistrationSvc.deRegisterUser((IWorkflowContext)bpmContext, processInstanceId);
            }
            catch (WorkflowException e) {
                String msg = "Exception thrown in registration service during deRegisterUser";
                BPMLogger.log((LoggerComponent)LoggerComponent.COMPONENT_AG_PROCESS_BROKER_SERVICE, (Severity)Severity.ERRORS, (String)msg);
            }
            String msg = "The process with Id:" + processInstanceId + " is not active";
            BPMLogger.log((LoggerComponent)LoggerComponent.COMPONENT_AG_PROCESS_BROKER_SERVICE, (Severity)Severity.ERRORS, (String)msg);
            throw new ProcessBrokerException(Severity.ERRORS, 72203, (Object[])new String[]{processInstanceId});
        }
        List msDispInfoList = agDisplayInfo.getMilestoneDisplayInfo();
        Task nextActiveTask = null;
        for (MilestoneDisplayInfo msDispInfo : msDispInfoList) {
            if (!msDispInfo.getStatus().equals("In Progress")) continue;
            List taskList = msDispInfo.getTaskDisplayInfo();
            for (TaskDisplayInfoType taskDisplayInfo : taskList) {
                if (taskDisplayInfo.getTask() == null || taskDisplayInfo.getTask().getSystemAttributes().getState() == null || !taskDisplayInfo.getTask().getSystemAttributes().getState().equals("ASSIGNED")) continue;
                try {
                    nextActiveTask = this.queryTask(bpmContext, taskDisplayInfo);
                    return nextActiveTask;
                }
                catch (WorkflowException e) {
                    if (e.getErrorCode() == 30513) {
                        String msg2 = "User " + bpmContext.getUser() + "cannot see task with id:" + taskDisplayInfo.getTask().getSystemAttributes().getTaskId();
                        BPMLogger.log((LoggerComponent)LoggerComponent.COMPONENT_AG_PROCESS_BROKER_SERVICE, (Severity)Severity.WARNING, (String)CLASSNAME, (String)"getNextTaskObject", (String)msg2);
                        return null;
                    }
                    String msg = "Exception thrown in task query service during getTaskDetailsById for task id:" + taskDisplayInfo.getTask().getSystemAttributes().getTaskId();
                    BPMLogger.log((LoggerComponent)LoggerComponent.COMPONENT_AG_PROCESS_BROKER_SERVICE, (Severity)Severity.ERRORS, (String)msg);
                    throw new ProcessBrokerException(Severity.ERRORS, 72200, (Object[])new String[0], (Throwable)e);
                }
            }
        }
        return null;
    }

    private Task queryTask(IBPMContext bpmContext, TaskDisplayInfoType taskDispInfo) throws WorkflowException {
        String taskId = taskDispInfo.getTask().getSystemAttributes().getTaskId();
        Task nextTask = this.getTaskQueryService().getTaskDetailsById((IWorkflowContext)bpmContext, taskId);
        return nextTask;
    }

    private Task updateTaskOutcome(IBPMContext bpmContext, String taskInstanceId, String outcome) throws ProcessBrokerException {
        Task task = null;
        try {
            this.getTaskServiceLocalBean().updateTaskOutcome((IWorkflowContext)bpmContext, taskInstanceId, outcome);
        }
        catch (StaleObjectException e) {
            try {
                this.getTaskServiceLocalBean().updateTaskOutcome((IWorkflowContext)bpmContext, taskInstanceId, outcome);
            }
            catch (StaleObjectException f) {
                String msg = f.getMessage();
                BPMLogger.log((LoggerComponent)LoggerComponent.COMPONENT_AG_PROCESS_BROKER_SERVICE, (Severity)Severity.ERRORS, (String)msg);
                throw new ProcessBrokerException(Severity.ERRORS, 72204, (Object[])new String[]{taskInstanceId, outcome}, (Throwable)e);
            }
            catch (WorkflowException f) {
                String msg = f.getMessage();
                BPMLogger.log((LoggerComponent)LoggerComponent.COMPONENT_AG_PROCESS_BROKER_SERVICE, (Severity)Severity.ERRORS, (String)msg);
                throw new ProcessBrokerException(Severity.ERRORS, 72204, (Object[])new String[]{taskInstanceId, outcome}, (Throwable)e);
            }
        }
        catch (WorkflowException e) {
            String msg = e.getMessage();
            BPMLogger.log((LoggerComponent)LoggerComponent.COMPONENT_AG_PROCESS_BROKER_SERVICE, (Severity)Severity.ERRORS, (String)msg);
            throw new ProcessBrokerException(Severity.ERRORS, 72204, (Object[])new String[]{taskInstanceId, outcome}, (Throwable)e);
        }
        return task;
    }

    private ITaskService getTaskServiceLocalBean() {
        if (this.taskService != null) {
            return this.taskService;
        }
        IWorkflowServiceClient client = WorkflowServiceClientFactory.getWorkflowServiceClient((String)"LOCAL");
        this.taskService = client.getTaskService();
        return this.taskService;
    }

    private IInstanceManagementServiceLocal getInstanceMgmtLocalBean() throws ProcessBrokerException {
        if (this.instanceMgmtLocalBean != null) {
            return this.instanceMgmtLocalBean;
        }
        try {
            this.instanceMgmtLocalBean = (IInstanceManagementServiceLocal)new InitialContext().lookup("java:comp/env/ejb/local/InstanceManagementServiceBean");
            return this.instanceMgmtLocalBean;
        }
        catch (NamingException e) {
            String msg = e.getMessage();
            BPMLogger.log((LoggerComponent)LoggerComponent.COMPONENT_AG_PROCESS_BROKER_SERVICE, (Severity)Severity.ERRORS, (String)msg);
            throw new ProcessBrokerException(Severity.ERRORS, 72200, (Object[])new String[0], (Throwable)e);
        }
    }

    private Object getMBeanPropertyValue() {
        Boolean propertyValue = null;
        try {
            BPMNConfig bpmnConfigObj = (BPMNConfig)FabricConfigManager.loadConfigObject((String)ConfigDefs.URL_BPMN_CONFIG);
            propertyValue = bpmnConfigObj.getDisableProcessBroker();
        }
        catch (Exception e) {
            BPMLogger.log((LoggerComponent)LoggerComponent.COMPONENT_AG_PROCESS_BROKER_SERVICE, (Severity)Severity.ERRORS, (String)e.getMessage());
        }
        return propertyValue;
    }

    static {
        try {
            bpmInstalled = WorkflowUtil.isBPMInstall();
        }
        catch (WorkflowException e) {
            BPMLogger.log((LoggerComponent)LoggerComponent.COMPONENT_AG_PROCESS_BROKER_SERVICE, (Severity)Severity.DEBUG, (String)e.getMessage());
        }
    }
}

