/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.services.activityguide.impl;

import java.net.URL;
import java.net.URLClassLoader;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import oracle.bpel.services.workflow.metadata.impl.TaskMetadataServiceUtil;
import oracle.bpm.bpmn.engine.service.BPMNServiceEngine;
import oracle.bpm.project.model.Project;
import oracle.bpm.project.model.activityguide.ActivityGuide;
import oracle.bpm.services.activityguide.common.AGMetadataServiceUtil;
import oracle.bpm.services.activityguide.model.metadata.IActivityGuide;
import oracle.bpm.services.activityguide.model.metadata.impl.ActivityGuideImpl;
import oracle.bpm.services.common.exception.BPMException;
import oracle.bpm.services.common.logger.BPMLogger;
import oracle.bpm.services.common.logger.LoggerComponent;
import oracle.bpm.services.common.logger.Severity;
import oracle.fabric.composite.CompositeClassLoader;
import oracle.fabric.composite.CompositeDN;
import oracle.fabric.composite.model.CompositeModel;
import oracle.fabric.composite.model.CompositeNameModel;

public class BpmAGMetadataCache {
    private Map<String, IActivityGuide> agMetadataMap = new HashMap<String, IActivityGuide>();
    private Map<String, Object> agResourceBundleMap = new HashMap<String, Object>();
    private static BpmAGMetadataCache cache = new BpmAGMetadataCache();

    private BpmAGMetadataCache() {
    }

    public ClassLoader setCompositeClassLoaderAsThreadContextLoader(String compositeDN) {
        CompositeModel composite = BPMNServiceEngine.getInstance().getMesh().getComposite(compositeDN);
        if (!CompositeNameModel.isValidCompositeName((String)composite.getDN())) {
            return Thread.currentThread().getContextClassLoader();
        }
        try {
            CompositeClassLoader cl = composite.getResourceClassloader();
            return cl.setAsThreadContextLoader();
        }
        catch (Exception e) {
            return Thread.currentThread().getContextClassLoader();
        }
    }

    static BpmAGMetadataCache getInstance() {
        return cache;
    }

    IActivityGuide getAGDefinition(String compositeDN) throws BPMException {
        IActivityGuide agMetadata = null;
        BPMLogger.log((LoggerComponent)LoggerComponent.COMPONENT_AG_METADATA_SERVICE, (Severity)Severity.DEBUG, (String)this.getClass().getName(), (String)"getAGDefinition", (String)("Get Definition, DN = " + compositeDN));
        if (compositeDN == null) {
            return null;
        }
        if (this.agMetadataMap.containsKey(compositeDN)) {
            agMetadata = this.agMetadataMap.get(compositeDN);
            BPMLogger.log((LoggerComponent)LoggerComponent.COMPONENT_AG_METADATA_SERVICE, (Severity)Severity.DEBUG, (String)this.getClass().getName(), (String)"getAGDefinition", (String)("Definition found in cache, DN = " + compositeDN));
            return agMetadata;
        }
        Map<String, IActivityGuide> map = this.agMetadataMap;
        synchronized (map) {
            if (this.agMetadataMap.containsKey(compositeDN)) {
                agMetadata = this.agMetadataMap.get(compositeDN);
                return agMetadata;
            }
            try {
                ActivityGuide agModel;
                CompositeModel compositeModel = BPMNServiceEngine.getInstance().getMesh().getComposite(compositeDN);
                Project project = BPMNServiceEngine.getDeployedProjectServiceImpl().findDeployedProject(new CompositeDN(compositeDN), compositeModel);
                if (project != null && (agModel = project.getActivityGuide()) != null && agModel.getRootProcess() != null) {
                    agMetadata = new ActivityGuideImpl(compositeDN, agModel);
                    BPMLogger.log((LoggerComponent)LoggerComponent.COMPONENT_AG_METADATA_SERVICE, (Severity)Severity.DEBUG, (String)this.getClass().getName(), (String)"getAGDefinition", (String)("Loading definition in cache, DN = " + compositeDN));
                }
                if (agMetadata == null) {
                    BPMLogger.log((LoggerComponent)LoggerComponent.COMPONENT_AG_METADATA_SERVICE, (Severity)Severity.DEBUG, (String)this.getClass().getName(), (String)"getAGDefinition", (String)("No activity guide with composite DN = " + compositeDN));
                }
                this.agMetadataMap.put(compositeDN, agMetadata);
                return agMetadata;
            }
            catch (Exception e) {
                throw new BPMException(71001, null, (Throwable)e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void removeFromCache(String compositeDN) {
        Map<String, Object> map;
        if (this.agMetadataMap.containsKey(compositeDN)) {
            map = this.agMetadataMap;
            synchronized (map) {
                this.agMetadataMap.remove(compositeDN);
            }
        }
        if (this.agResourceBundleMap.get(compositeDN) != null) {
            map = this.agResourceBundleMap;
            synchronized (map) {
                this.agResourceBundleMap.remove(compositeDN);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    ResourceBundle getResourceBundle(String compositeDN, Locale locale) throws BPMException {
        ClassLoader originalClassLoader = null;
        try {
            originalClassLoader = this.setCompositeClassLoaderAsThreadContextLoader(compositeDN);
            ResourceBundle resourceBundle = this.getResourceBundleLocal(compositeDN, locale);
            return resourceBundle;
        }
        finally {
            if (originalClassLoader != null) {
                Thread.currentThread().setContextClassLoader(originalClassLoader);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ResourceBundle getResourceBundleLocal(String compositeDN, Locale locale) throws BPMException {
        String resourceBundleName = null;
        String resourceBundleLocation = null;
        ResourceBundle resourceBundle = null;
        String soaApplicationBaseUrl = null;
        IActivityGuide agMetadata = this.getAGDefinition(compositeDN);
        if (compositeDN == null || agMetadata == null) {
            return null;
        }
        if (agMetadata.getResourceBundleInfo() == null) {
            return null;
        }
        if (locale == null) {
            locale = Locale.getDefault();
        }
        BPMLogger.log((LoggerComponent)LoggerComponent.COMPONENT_AG_METADATA_SERVICE, (Severity)Severity.DEBUG, (String)this.getClass().getName(), (String)"getResourceBundle", (String)("DN = " + compositeDN + ", Locale = " + locale.getLanguage() + ", Bundle Name = " + agMetadata.getResourceBundleInfo().getName() + ", Bundle Location = " + agMetadata.getResourceBundleInfo().getLocation()));
        Object url = this.agResourceBundleMap.get(compositeDN);
        if (url != null && url instanceof String && url.equals("DEFAULT_CLASSLOADER")) {
            if (agMetadata.getResourceBundleInfo() != null) {
                resourceBundleName = agMetadata.getResourceBundleInfo().getName();
                return ResourceBundle.getBundle(resourceBundleName, locale, Thread.currentThread().getContextClassLoader());
            }
            return null;
        }
        if (url != null) {
            assert (url instanceof URL);
            if (agMetadata.getResourceBundleInfo() != null) {
                resourceBundleName = agMetadata.getResourceBundleInfo().getName();
                resourceBundle = this.loadResourceBundle(resourceBundleName, (URL)url, locale);
                if (resourceBundle == null) {
                    BPMLogger.log((LoggerComponent)LoggerComponent.COMPONENT_AG_METADATA_SERVICE, (Severity)Severity.DEBUG, (String)this.getClass().getName(), (String)"getResourceBundle", (String)("Load bundle from default class loader, bundle name " + resourceBundleName));
                    return ResourceBundle.getBundle(resourceBundleName, locale, Thread.currentThread().getContextClassLoader());
                }
                return resourceBundle;
            }
            return null;
        }
        Map<String, Object> map = this.agResourceBundleMap;
        synchronized (map) {
            url = this.agResourceBundleMap.get(compositeDN);
            if (url != null) {
                return this.getResourceBundle(compositeDN, locale);
            }
            if (agMetadata.getResourceBundleInfo() != null) {
                resourceBundleLocation = agMetadata.getResourceBundleInfo().getLocation();
                if (resourceBundleLocation != null) {
                    resourceBundleLocation = resourceBundleLocation.trim();
                }
                if ((resourceBundleName = agMetadata.getResourceBundleInfo().getName()) != null) {
                    resourceBundleName = resourceBundleName.trim();
                }
            }
            try {
                soaApplicationBaseUrl = BPMNServiceEngine.getInstance().getDeployedCompositeBaseURL(compositeDN);
                BPMLogger.log((LoggerComponent)LoggerComponent.COMPONENT_AG_METADATA_SERVICE, (Severity)Severity.DEBUG, (String)this.getClass().getName(), (String)"getResourceBundle", (String)("SOA application URL = " + soaApplicationBaseUrl));
                assert (soaApplicationBaseUrl != null);
                soaApplicationBaseUrl = AGMetadataServiceUtil.getURLSafeString(soaApplicationBaseUrl);
            }
            catch (Exception e) {
                throw new BPMException(71003, null, (Throwable)e);
            }
            URL resourceBundleUrl = TaskMetadataServiceUtil.getResourceURL((String)soaApplicationBaseUrl, (String)resourceBundleLocation);
            try {
                resourceBundle = this.loadResourceBundle(resourceBundleName, resourceBundleUrl, locale);
            }
            catch (MissingResourceException e) {
                String msg = "Missing resource exception thrown while loading resource " + resourceBundleName + " using URLClassLoader for compositeDN:" + compositeDN + ". Retrying to load with composite class loader";
                BPMLogger.log((LoggerComponent)LoggerComponent.COMPONENT_AG_METADATA_SERVICE, (Severity)Severity.DEBUG, (String)this.getClass().getName(), (String)"getResourceBundleLocal", (String)msg);
                resourceBundle = null;
            }
            if (resourceBundle == null) {
                this.agResourceBundleMap.put(compositeDN, "DEFAULT_CLASSLOADER");
                resourceBundle = ResourceBundle.getBundle(resourceBundleName, locale, Thread.currentThread().getContextClassLoader());
                String msg = "Resource successfully loaded using composite class loader for compositeDN:" + compositeDN;
                BPMLogger.log((LoggerComponent)LoggerComponent.COMPONENT_AG_METADATA_SERVICE, (Severity)Severity.DEBUG, (String)this.getClass().getName(), (String)"getResourceBundleLocal", (String)msg);
                return resourceBundle;
            }
            this.agResourceBundleMap.put(compositeDN, url);
            return resourceBundle;
        }
    }

    private ResourceBundle loadResourceBundle(String resourceBundleName, URL url, Locale locale) {
        BPMLogger.log((LoggerComponent)LoggerComponent.COMPONENT_AG_METADATA_SERVICE, (Severity)Severity.DEBUG, (String)this.getClass().getName(), (String)"loadResourceBundle", (String)("Resource bundle URL = " + url.toString()));
        URLClassLoader resourceClassLoader = new URLClassLoader(new URL[]{url});
        ResourceBundle resourceBundle = ResourceBundle.getBundle(resourceBundleName, locale, resourceClassLoader);
        return resourceBundle;
    }
}

