/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.services.activityguide.impl;

import com.collaxa.cube.CubeException;
import com.oracle.bpel.activityguide.instance.model.AGInstance;
import com.oracle.bpel.activityguide.instance.model.MilestoneInstanceType;
import com.oracle.bpel.activityguide.metadata.definition.model.AGDefinition;
import com.oracle.bpel.activityguide.metadata.definition.model.MilestoneDefinitionType;
import java.security.Permission;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import oracle.bpel.services.workflow.WorkflowException;
import oracle.bpel.services.workflow.activityguide.common.AGLogger;
import oracle.bpel.services.workflow.activityguide.query.IAGQueryService;
import oracle.bpel.services.workflow.activityguide.query.bpelmetadata.BPELMetadataElement;
import oracle.bpel.services.workflow.activityguide.query.bpelmetadata.ScopeCompositeMetadataElement;
import oracle.bpel.services.workflow.activityguide.query.bpelmetadata.TaskMetadataElement;
import oracle.bpel.services.workflow.activityguide.query.model.AGDisplayInfo;
import oracle.bpel.services.workflow.activityguide.query.model.MilestoneDisplayInfo;
import oracle.bpel.services.workflow.metadata.impl.TaskMetadataCache;
import oracle.bpel.services.workflow.metadata.taskdefinition.model.TaskDefinition;
import oracle.bpel.services.workflow.permission.WorkflowPermission;
import oracle.bpel.services.workflow.query.ITaskQueryService;
import oracle.bpel.services.workflow.query.impl.TaskQueryService;
import oracle.bpel.services.workflow.repos.Column;
import oracle.bpel.services.workflow.repos.IPersistencyService;
import oracle.bpel.services.workflow.repos.Ordering;
import oracle.bpel.services.workflow.repos.PersistencyDriver;
import oracle.bpel.services.workflow.repos.Predicate;
import oracle.bpel.services.workflow.repos.PredicateImpl;
import oracle.bpel.services.workflow.repos.TableConstants;
import oracle.bpel.services.workflow.repos.driver.WFAGInstanceUtil;
import oracle.bpel.services.workflow.task.model.ObjectFactory;
import oracle.bpel.services.workflow.task.model.Task;
import oracle.bpel.services.workflow.task.model.TaskType;
import oracle.bpel.services.workflow.util.StringUtil;
import oracle.bpel.services.workflow.verification.IWorkflowContext;
import oracle.bpel.services.workflow.verification.impl.InternalWorkflowContext;
import oracle.bpel.services.workflow.verification.impl.VerificationService;
import oracle.bpm.services.activityguide.common.AGi18nUtil;
import oracle.bpm.services.activityguide.impl.BaseAGQueryService;
import oracle.bpm.services.activityguide.impl.bpelmetadata.BPELMetadataUtils;

public class BpelAGQueryService
extends BaseAGQueryService {
    private Hashtable m_AGMetadataTable = new Hashtable();
    private static final String CLASSNAME = "BPELAGQueryService";
    private static final String AG_MILESTONE_PATH_DELIMITER = ":";
    protected static List taskVerificationColumns = new ArrayList();

    public static IAGQueryService.AGAssignmentFilter getAGAssignmentFilterEnum(String filter) {
        if (filter == null) {
            return null;
        }
        return IAGQueryService.AGAssignmentFilter.valueOf((String)filter.toUpperCase());
    }

    @Override
    public List queryAGDisplayInfos(IWorkflowContext ctx, List agDisplayColumns, String agAssignmentFilter, Predicate predicate, Ordering ordering, int startRow, int endRow) throws WorkflowException {
        return this.queryAGDisplayInfos(ctx, agDisplayColumns, BpelAGQueryService.getAGAssignmentFilterEnum(agAssignmentFilter), predicate, ordering, startRow, endRow);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List queryAGDisplayInfos(IWorkflowContext ctx, List agDisplayColumns, IAGQueryService.AGAssignmentFilter agAssignmentFilter, Predicate predicate, Ordering ordering, int startRow, int endRow) throws WorkflowException {
        AGLogger.logDebug((String)CLASSNAME, (String)"queryAGDisplayInfos()", (String)(" Inputs: token = " + ctx.getToken() + " ctxUser = " + ctx.getUser() + " agDisplayColumns = " + StringUtil.getStringFromList((List)agDisplayColumns) + " agAssignmentFilter = " + agAssignmentFilter + " predicate = " + StringUtil.nvl((Object)predicate) + " ordering = " + StringUtil.nvl((Object)ordering) + " startRow = " + startRow + " endRow = " + endRow));
        if (agAssignmentFilter == null) {
            return null;
        }
        IPersistencyService service = null;
        List agInstanceList = null;
        ArrayList<AGDisplayInfo> agDisplayInfoList = new ArrayList<AGDisplayInfo>();
        AGDisplayInfo agDisplayInfo = null;
        try {
            this.getVerificationService().validateContext(ctx);
            boolean[] bColumnsSpecified = new boolean[2];
            List agColumnList = this.getAGListingColumns(agDisplayColumns, bColumnsSpecified);
            boolean bIsMilestoneStateSpecified = bColumnsSpecified[0];
            boolean bIsBPELStatusSpecified = bColumnsSpecified[1];
            Predicate taskPredicate = BpelAGQueryService.getTaskPredicate(ctx, agAssignmentFilter, true);
            Predicate agPredicate = BpelAGQueryService.getAGPredicate(ctx, agAssignmentFilter, predicate, bIsBPELStatusSpecified);
            Ordering finalOrdering = ordering;
            if (finalOrdering == null) {
                finalOrdering = new Ordering(TableConstants.AGINSTANCE_CIKEY_COLUMN, true, true);
            }
            service = PersistencyDriver.getInstance();
            agInstanceList = service.getAGInstance(ctx, agColumnList, taskPredicate, agPredicate, finalOrdering, startRow, endRow);
            AGLogger.logDebug((String)CLASSNAME, (String)"queryAGDisplayInfos()", (String)("Number of AGs returned: " + agInstanceList.size()));
            if (agInstanceList.size() > 0) {
                for (int i = 0; i < agInstanceList.size(); ++i) {
                    agDisplayInfo = this.constructAGDisplayInfo((AGInstance)agInstanceList.get(i), ctx, agAssignmentFilter, bIsMilestoneStateSpecified, false, null);
                    agDisplayInfoList.add(agDisplayInfo);
                }
            }
            AGLogger.logDebug((String)CLASSNAME, (String)"queryAGDisplayInfos()", (String)"Completed.");
            ArrayList<AGDisplayInfo> arrayList = agDisplayInfoList;
            return arrayList;
        }
        finally {
            if (service != null) {
                service.close();
            }
            this.clearMetadataCache();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public AGDisplayInfo getAGDisplayInfoDetailsById(IWorkflowContext ctx, long ciKey, List taskDisplayColumns, String agAssignmentFilter) throws WorkflowException {
        AGLogger.logDebug((String)CLASSNAME, (String)"getAGDisplayInfoDetailsById()", (String)(" Inputs: token = " + ctx.getToken() + " ctxUser = " + ctx.getUser() + " ciKey = " + String.valueOf(ciKey) + " taskDisplayColumns = " + StringUtil.getStringFromList((List)taskDisplayColumns) + " agAssignmentFilter = " + agAssignmentFilter));
        if (agAssignmentFilter == null) {
            return null;
        }
        IPersistencyService service = null;
        AGDisplayInfo agDisplayInfo = null;
        this.getVerificationService().validateContext(ctx);
        try {
            ArrayList<Column> agColumnList = new ArrayList<Column>();
            agColumnList.add(TableConstants.AGINSTANCE_CIKEY_COLUMN);
            agColumnList.add(TableConstants.AGINSTANCE_ROOTAGID_COLUMN);
            agColumnList.add(TableConstants.AGINSTANCE_DEFINITIONID_COLUMN);
            agColumnList.add(TableConstants.AGINSTANCE_CMPSTID_COLUMN);
            agColumnList.add(TableConstants.AGINSTANCE_CREATIONDATE_COLUMN);
            agColumnList.add(TableConstants.AGINSTANCE_CREATOR_COLUMN);
            agColumnList.add(TableConstants.AGINSTANCE_TITLE_COLUMN);
            agColumnList.add(TableConstants.AGINSTANCE_IDENTIFICATIONKEY_COLUMN);
            agColumnList.add(TableConstants.AGINSTANCE_STATUS_COLUMN);
            agColumnList.add(TableConstants.AGINSTANCE_COMPLETIONPERCENTAGE_COLUMN);
            agColumnList.add(TableConstants.AGINSTANCE_ERRORMESSAGE_COLUMN);
            agColumnList.add(TableConstants.AGINSTANCE_MILESTONESTATE_COLUMN);
            agColumnList.add(TableConstants.CUBEINSTANCE_STATUS_COLUMN);
            PredicateImpl ciKeyPredicate = new PredicateImpl(TableConstants.AGINSTANCE_CIKEY_COLUMN, 0, (Object)ciKey);
            IAGQueryService.AGAssignmentFilter agAssignmentFilterObj = BpelAGQueryService.getAGAssignmentFilterEnum(agAssignmentFilter);
            Predicate taskPredicate = BpelAGQueryService.getTaskPredicate(ctx, agAssignmentFilterObj, false);
            Predicate agPredicate = BpelAGQueryService.getAGPredicate(ctx, agAssignmentFilterObj, (Predicate)ciKeyPredicate, true);
            AGInstance agInstance = null;
            service = PersistencyDriver.getInstance();
            List agInstanceList = service.getAGInstance(ctx, agColumnList, taskPredicate, agPredicate, null, 0, 0);
            if (agInstanceList.size() > 0) {
                agInstance = (AGInstance)agInstanceList.get(0);
            }
            if (agInstance != null) {
                AGLogger.logDebug((String)CLASSNAME, (String)"getAGDisplayInfoDetailsById()", (String)"Got an AG instance from DB.");
                if (!this.canUserSeeAGDisplayInfo(ctx, agInstance)) {
                    Object[] errorObjs = new Object[]{ctx.getUser(), String.valueOf(ciKey), "getAGDisplayInfoDetailsById"};
                    String reason = "User is not allowed to see the activity guide. token = " + ctx.getToken() + " ctxUser = " + ctx.getUser() + " ciKey = " + String.valueOf(ciKey);
                    AGLogger.logError((String)CLASSNAME, (String)"getAGDisplayInfoDetailsById()", (String)reason);
                    throw new WorkflowException(38003, reason, errorObjs);
                }
                agDisplayInfo = this.constructAGDisplayInfo(agInstance, ctx, agAssignmentFilterObj, true, true, taskDisplayColumns);
            }
            AGLogger.logDebug((String)CLASSNAME, (String)"getAGDisplayInfoDetailsById()", (String)"Completed.");
            AGDisplayInfo aGDisplayInfo = agDisplayInfo;
            return aGDisplayInfo;
        }
        finally {
            if (service != null) {
                service.close();
            }
            this.clearMetadataCache();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public MilestoneDisplayInfo getMilestoneDisplayInfo(IWorkflowContext ctx, long ciKey, String milestoneName, List taskDisplayColumns, String assignmentFilter) throws WorkflowException {
        AGLogger.logDebug((String)CLASSNAME, (String)"getMilestoneDisplayInfo()", (String)("Inputs: token = " + ctx.getToken() + " ctxUser = " + ctx.getUser() + " ciKey = " + String.valueOf(ciKey) + " milestoneName = " + milestoneName + " taskDisplayColumns = " + StringUtil.getStringFromList((List)taskDisplayColumns) + " assignmentFilter = " + assignmentFilter));
        IPersistencyService service = null;
        this.getVerificationService().validateContext(ctx);
        try {
            AGInstance agInstance = null;
            MilestoneDisplayInfo milestoneDisplayInfo = null;
            if (assignmentFilter == null) {
                MilestoneDisplayInfo milestoneDisplayInfo2 = null;
                return milestoneDisplayInfo2;
            }
            ArrayList<Column> agColumnList = new ArrayList<Column>();
            agColumnList.add(TableConstants.AGINSTANCE_CIKEY_COLUMN);
            agColumnList.add(TableConstants.AGINSTANCE_ROOTAGID_COLUMN);
            agColumnList.add(TableConstants.AGINSTANCE_DEFINITIONID_COLUMN);
            agColumnList.add(TableConstants.AGINSTANCE_CMPSTID_COLUMN);
            agColumnList.add(TableConstants.AGINSTANCE_CREATIONDATE_COLUMN);
            agColumnList.add(TableConstants.AGINSTANCE_CREATOR_COLUMN);
            agColumnList.add(TableConstants.AGINSTANCE_TITLE_COLUMN);
            agColumnList.add(TableConstants.AGINSTANCE_IDENTIFICATIONKEY_COLUMN);
            agColumnList.add(TableConstants.AGINSTANCE_STATUS_COLUMN);
            agColumnList.add(TableConstants.AGINSTANCE_COMPLETIONPERCENTAGE_COLUMN);
            agColumnList.add(TableConstants.AGINSTANCE_ERRORMESSAGE_COLUMN);
            agColumnList.add(TableConstants.AGINSTANCE_MILESTONESTATE_COLUMN);
            agColumnList.add(TableConstants.CUBEINSTANCE_STATUS_COLUMN);
            PredicateImpl ciKeyPredicate = new PredicateImpl(TableConstants.AGINSTANCE_CIKEY_COLUMN, 0, (Object)ciKey);
            IAGQueryService.AGAssignmentFilter agAssignmentFilterObj = BpelAGQueryService.getAGAssignmentFilterEnum(assignmentFilter);
            Predicate taskPredicate = BpelAGQueryService.getTaskPredicate(ctx, agAssignmentFilterObj, false);
            Predicate agPredicate = BpelAGQueryService.getAGPredicate(ctx, agAssignmentFilterObj, (Predicate)ciKeyPredicate, true);
            service = PersistencyDriver.getInstance();
            List agInstanceList = service.getAGInstance(ctx, agColumnList, taskPredicate, agPredicate, null, 0, 0);
            if (agInstanceList.size() > 0) {
                agInstance = (AGInstance)agInstanceList.get(0);
            }
            if (agInstance != null) {
                AGLogger.logDebug((String)CLASSNAME, (String)"getMilestoneDisplayInfo()", (String)"Got an AG instance from DB.");
                if (!this.canUserSeeAGDisplayInfo(ctx, agInstance)) {
                    Object[] errorObjs = new Object[]{ctx.getUser(), String.valueOf(ciKey), "getMilestoneisplayInfo"};
                    String reason = "User is not allowed to see the activity guide. token = " + ctx.getToken() + " ctxUser = " + ctx.getUser() + " ciKey = " + String.valueOf(ciKey) + " milestoneName = " + milestoneName;
                    AGLogger.logError((String)CLASSNAME, (String)"getMilestoneDisplayInfo()", (String)reason);
                    throw new WorkflowException(38003, reason, errorObjs);
                }
                milestoneDisplayInfo = this.constructMilestoneDisplayInfo(agInstance, milestoneName, ctx, agAssignmentFilterObj, taskDisplayColumns);
            }
            AGLogger.logDebug((String)CLASSNAME, (String)"getMilestoneDisplayInfo()", (String)"Completed.");
            MilestoneDisplayInfo milestoneDisplayInfo3 = milestoneDisplayInfo;
            return milestoneDisplayInfo3;
        }
        finally {
            if (service != null) {
                service.close();
            }
        }
    }

    boolean isTaskCompleted(String taskState) {
        return "COMPLETED".equals(taskState) || "WITHDRAWN".equals(taskState) || "EXPIRED".equals(taskState) || "STALE".equals(taskState);
    }

    private static void initTaskVerificationColumns() {
        taskVerificationColumns.add("ACQUIREDBY");
        taskVerificationColumns.add("ASSIGNEES");
        taskVerificationColumns.add("ASSIGNEEGROUPS");
        taskVerificationColumns.add("ASSIGNEEUSERS");
        taskVerificationColumns.add("REVIEWERS");
        taskVerificationColumns.add("OWNERUSER");
        taskVerificationColumns.add("OWNERGROUP");
        taskVerificationColumns.add("ORIGINALASSIGNEEUSER");
        taskVerificationColumns.add("PARTICIPANTNAME");
        taskVerificationColumns.add("APPROVERS");
        taskVerificationColumns.add("IDENTITYCONTEXT");
        taskVerificationColumns.add("TASKDEFINITIONNAME");
        taskVerificationColumns.add("COMPONENTNAME");
        taskVerificationColumns.add("CALLBACKID");
        taskVerificationColumns.add("STATE");
        taskVerificationColumns.add("SUBSTATE");
    }

    private static Predicate getTaskPredicate(IWorkflowContext ctx, IAGQueryService.AGAssignmentFilter agAssignmentFilter, boolean addTaskStatePredicate) throws WorkflowException {
        AGLogger.logDebug((String)CLASSNAME, (String)"getTaskPredicate()", (String)("Inputs: token = " + ctx.getToken() + " ctxUser = " + ctx.getUser() + " agAssignmentFilter = " + agAssignmentFilter));
        Object taskPredicate = null;
        if (agAssignmentFilter.equals((Object)IAGQueryService.AGAssignmentFilter.MY)) {
            taskPredicate = TaskQueryService.getAssignmentFilterPredicate((IWorkflowContext)ctx, (ITaskQueryService.AssignmentFilter)ITaskQueryService.AssignmentFilter.MY_AND_GROUP);
            if (addTaskStatePredicate) {
                taskPredicate = BpelAGQueryService.addTaskStatePredicate((Predicate)taskPredicate);
            }
        } else if (agAssignmentFilter.equals((Object)IAGQueryService.AGAssignmentFilter.REPORTEES)) {
            taskPredicate = TaskQueryService.getAssignmentFilterPredicate((IWorkflowContext)ctx, (ITaskQueryService.AssignmentFilter)ITaskQueryService.AssignmentFilter.REPORTEES);
            if (addTaskStatePredicate) {
                taskPredicate = BpelAGQueryService.addTaskStatePredicate((Predicate)taskPredicate);
            }
        } else {
            taskPredicate = agAssignmentFilter.equals((Object)IAGQueryService.AGAssignmentFilter.PREVIOUS) ? TaskQueryService.getAssignmentFilterPredicate((IWorkflowContext)ctx, (ITaskQueryService.AssignmentFilter)ITaskQueryService.AssignmentFilter.PREVIOUS) : null;
        }
        AGLogger.logDebug((String)CLASSNAME, (String)"getTaskPredicate()", (String)("Completed.  Task predicate: " + StringUtil.nvl((Object)taskPredicate)));
        return taskPredicate;
    }

    /*
     * Enabled aggressive block sorting
     */
    private static Predicate getAGPredicate(IWorkflowContext ctx, IAGQueryService.AGAssignmentFilter agAssignmentFilter, Predicate predicate, boolean bIsBPELStatusSpecified) throws WorkflowException {
        AGLogger.logDebug((String)CLASSNAME, (String)"getAGPredicate()", (String)("Inputs: token = " + ctx.getToken() + " ctxUser = " + ctx.getUser() + " agAssignmentFilter = " + agAssignmentFilter + " predicate = " + StringUtil.nvl((Object)predicate) + " bIsBPELStatusSpecified = " + String.valueOf(bIsBPELStatusSpecified)));
        PredicateImpl agPredicate = null;
        if (agAssignmentFilter.equals((Object)IAGQueryService.AGAssignmentFilter.ADMIN)) {
            if (!BpelAGQueryService.isUserAGAdmin(ctx) && !(ctx instanceof InternalWorkflowContext)) {
                Object[] errorObjs = new Object[]{ctx.getUser(), "getAGPredicate"};
                String reason = "User does not have the activity guide administration privilege required for the using of the ADMIN assignment filter. token = " + ctx.getToken() + " ctxUser = " + ctx.getUser();
                AGLogger.logError((String)CLASSNAME, (String)"getAGPredicate", (String)reason);
                throw new WorkflowException(38004, reason, errorObjs);
            }
            agPredicate = null;
        } else {
            agPredicate = agAssignmentFilter.equals((Object)IAGQueryService.AGAssignmentFilter.CREATOR) ? new PredicateImpl(TableConstants.AGINSTANCE_CREATOR_COLUMN, 0, (Object)ctx.getUser()) : null;
        }
        AGLogger.logDebug((String)CLASSNAME, (String)"getAGPredicate()", (String)("AG predicate based on assignment filter: " + StringUtil.nvl((Object)agPredicate)));
        if (bIsBPELStatusSpecified) {
            PredicateImpl bpelJoinPredicate = new PredicateImpl(TableConstants.CUBEINSTANCE_CIKEY_COLUMN, 0, TableConstants.AGINSTANCE_CIKEY_COLUMN);
            agPredicate = WFAGInstanceUtil.combineTwoPredicatesByAND((Predicate)agPredicate, (Predicate)bpelJoinPredicate);
            AGLogger.logDebug((String)CLASSNAME, (String)"getAGPredicate()", (String)("AG predicate after adding the bpel join predicate: " + StringUtil.nvl((Object)agPredicate)));
        }
        agPredicate = WFAGInstanceUtil.combineTwoPredicatesByAND((Predicate)agPredicate, (Predicate)predicate);
        Predicate agStatePredicate = BpelAGQueryService.addAGStatePredicate();
        agPredicate = WFAGInstanceUtil.combineTwoPredicatesByAND((Predicate)agPredicate, (Predicate)agStatePredicate);
        AGLogger.logDebug((String)CLASSNAME, (String)"getAGPredicate()", (String)("Completed. AG predicate: " + StringUtil.nvl((Object)agPredicate)));
        return agPredicate;
    }

    private static boolean isUserAGAdmin(IWorkflowContext ctx) throws WorkflowException {
        return VerificationService.hasPermission((IWorkflowContext)ctx, (Permission)WorkflowPermission.ADMIN_ACTIVITYGUIDE_PERMISSION);
    }

    private static Predicate addTaskJoinPredicate(Predicate predicate) throws WorkflowException {
        PredicateImpl taskJoinPredicate = new PredicateImpl(TableConstants.AGINSTANCE_CIKEY_COLUMN, 0, TableConstants.WFTASK_AG_ROOTID_COLUMN);
        return WFAGInstanceUtil.combineTwoPredicatesByAND((Predicate)predicate, (Predicate)taskJoinPredicate);
    }

    private static Predicate addTaskStatePredicate(Predicate predicate) throws WorkflowException {
        ArrayList<String> taskStateList = new ArrayList<String>();
        taskStateList.add("ASSIGNED");
        taskStateList.add("INFO_REQUESTED");
        PredicateImpl taskStatePred = new PredicateImpl(TableConstants.WFTASK_STATE_COLUMN, 9, taskStateList);
        return WFAGInstanceUtil.combineTwoPredicatesByAND((Predicate)predicate, (Predicate)taskStatePred);
    }

    private static Predicate addAGStatePredicate() throws WorkflowException {
        ArrayList<String> agStateList = new ArrayList<String>();
        agStateList.add("Stale");
        PredicateImpl agStatePred = new PredicateImpl(TableConstants.AGINSTANCE_STATUS_COLUMN, 10, agStateList);
        return agStatePred;
    }

    private List getAGListingColumns(List agDisplayColumns, boolean[] bColumnsSpecified) {
        ArrayList<Column> agColumnList = new ArrayList<Column>();
        String tableName = null;
        String columnName = null;
        bColumnsSpecified[0] = false;
        bColumnsSpecified[1] = false;
        agColumnList.add(TableConstants.AGINSTANCE_CIKEY_COLUMN);
        agColumnList.add(TableConstants.AGINSTANCE_TITLE_COLUMN);
        agColumnList.add(TableConstants.AGINSTANCE_IDENTIFICATIONKEY_COLUMN);
        agColumnList.add(TableConstants.AGINSTANCE_STATUS_COLUMN);
        agColumnList.add(TableConstants.AGINSTANCE_DEFINITIONID_COLUMN);
        if (agDisplayColumns == null || agDisplayColumns.size() == 0) {
            this.addDefaultColumns(agColumnList);
        } else {
            for (int i = 0; i < agDisplayColumns.size(); ++i) {
                columnName = (String)agDisplayColumns.get(i);
                if (columnName == null || columnName.trim().equals("")) continue;
                if (columnName.trim().toUpperCase().equals("MILESTONE_STATE".toUpperCase())) {
                    bColumnsSpecified[0] = true;
                }
                if (columnName.trim().toUpperCase().equals("bpel_status".toUpperCase())) {
                    tableName = "CUBE_INSTANCE";
                    columnName = "STATE";
                    bColumnsSpecified[1] = true;
                } else {
                    tableName = "AG_INSTANCE";
                }
                this.addSpecifiedColumn(agColumnList, tableName, columnName);
            }
        }
        return agColumnList;
    }

    private void addDefaultColumns(List agColumnList) {
        this.addOnce(agColumnList, TableConstants.AGINSTANCE_CREATOR_COLUMN);
        this.addOnce(agColumnList, TableConstants.AGINSTANCE_CREATIONDATE_COLUMN);
        this.addOnce(agColumnList, TableConstants.AGINSTANCE_COMPLETIONPERCENTAGE_COLUMN);
    }

    private void addSpecifiedColumn(List agColumnList, String tableName, String columnName) {
        Column column = Column.getColumn((String)tableName, (String)columnName);
        if (column != null) {
            this.addOnce(agColumnList, column);
        } else {
            WorkflowException wfe = new WorkflowException(38007, (Object[])new String[]{columnName});
        }
    }

    private void addOnce(List list, Column column) {
        if (list == null || column == null) {
            return;
        }
        if (!list.contains(column)) {
            list.add(column);
        }
    }

    private AGDisplayInfo constructAGDisplayInfo(AGInstance agInstance, IWorkflowContext ctx, IAGQueryService.AGAssignmentFilter filter, boolean bDisplayMilestones, boolean bDisplayTasks, List taskDisplayColumns) throws WorkflowException {
        AGLogger.logDebug((String)CLASSNAME, (String)"constructAGDisplayInfo()", (String)("Inputs: AG instance cikey = " + agInstance.getAGInstanceInfo().getCiKey() + " AG instance definition id = " + agInstance.getAGInstanceInfo().getDefinitionId() + " bDisplayMilestones = " + String.valueOf(bDisplayMilestones) + " bDisplayTasks = " + String.valueOf(bDisplayTasks) + " taskDisplayColumns = " + StringUtil.getStringFromList((List)taskDisplayColumns)));
        AGDisplayInfo agDisplayInfo = new oracle.bpel.services.workflow.activityguide.query.model.ObjectFactory().createAGDisplayInfo();
        String agDefinitionId = agInstance.getAGInstanceInfo().getDefinitionId();
        AGDefinition agDefinition = this.getAGMetadataService().getAGDefinitionById(ctx, agDefinitionId);
        String agTitle = agDefinition.getTitle().getValue();
        String agTitleType = agDefinition.getTitle().getType();
        String agDescription = agDefinition.getDescription().getValue();
        String agDescriptionType = agDefinition.getDescription().getType();
        try {
            agTitle = AGi18nUtil.renderValueForValueType(ctx.getLocale(), agDefinition, agTitle, agTitleType);
            agDescription = AGi18nUtil.renderValueForValueType(ctx.getLocale(), agDefinition, agDescription, agDescriptionType);
        }
        catch (Exception e) {
            AGLogger.logError((String)CLASSNAME, (String)"constructAGDisplayInfos()", (Throwable)e);
            throw new WorkflowException((Throwable)e);
        }
        agDisplayInfo.setName(agDefinition.getName());
        agDisplayInfo.setDescription(agDescription);
        agDisplayInfo.setTitle(agTitle);
        agDisplayInfo.setName(agInstance.getAGInstanceInfo().getIdentificationKey());
        if (bDisplayMilestones) {
            List milestoneDisplayInfoList = this.constructMilestoneDisplayInfoList(agDefinition, agInstance, ctx, filter, bDisplayTasks, taskDisplayColumns);
            if (milestoneDisplayInfoList != null && !milestoneDisplayInfoList.isEmpty() && agInstance.getAGInstanceInfo().getStatus().equals("In Progress")) {
                MilestoneDisplayInfo msDisp;
                int msCompleteCounter = 0;
                Iterator i$ = milestoneDisplayInfoList.iterator();
                while (!(!i$.hasNext() || (msDisp = (MilestoneDisplayInfo)i$.next()).getMilestoneInstance().getStatus().equals("In Progress") || msDisp.getMilestoneInstance().getStatus().equals("Running With Warning") || msDisp.getMilestoneInstance().getStatus().equals("Waiting") || msDisp.getMilestoneInstance().getStatus().equals("Not Started"))) {
                    ++msCompleteCounter;
                }
                if (msCompleteCounter == milestoneDisplayInfoList.size()) {
                    agInstance = this.completeInstance(ctx, agInstance.getAGInstanceInfo().getCiKey(), true, null);
                }
            }
            agDisplayInfo.getMilestoneDisplayInfo().clear();
            agDisplayInfo.getMilestoneDisplayInfo().addAll(milestoneDisplayInfoList);
        }
        agDisplayInfo.setProcessMode("AGBPEL");
        agDisplayInfo.setStatus(agInstance.getAGInstanceInfo().getStatus());
        agDisplayInfo.setInstanceId(Long.toString(agInstance.getAGInstanceInfo().getCiKey()));
        AGLogger.logDebug((String)CLASSNAME, (String)"constructAGDisplayInfo()", (String)"Completed.");
        return agDisplayInfo;
    }

    private List constructMilestoneDisplayInfoList(AGDefinition agDefinition, AGInstance agInstance, IWorkflowContext ctx, IAGQueryService.AGAssignmentFilter filter, boolean bDisplayTasks, List taskDisplayColumns) throws WorkflowException {
        AGLogger.logDebug((String)CLASSNAME, (String)"constructMilestoneDisplayInfoList()", (String)("Inputs: AG instance cikey = " + agInstance.getAGInstanceInfo().getCiKey() + " AG definition id = " + agDefinition.getId() + " AG display mode = " + agDefinition.getMilestoneDisplayMode() + " bDisplayTasks = " + String.valueOf(bDisplayTasks) + " taskDisplayColumns = " + StringUtil.getStringFromList((List)taskDisplayColumns)));
        MilestoneDefinitionType milestoneDefinition = null;
        MilestoneInstanceType milestoneInstance = null;
        MilestoneDisplayInfo milestoneDisplayInfo = null;
        ArrayList<MilestoneDisplayInfo> milestoneDisplayInfoList = new ArrayList<MilestoneDisplayInfo>();
        String milestoneName = null;
        AGInstance updatedInstance = null;
        if (agDefinition.getMilestoneDisplayMode().equals("ShowAll")) {
            List milestoneList = agDefinition.getMilestone();
            List milestoneDefinitionList = null;
            List milestoneBpelMetadataList = null;
            if (!this.isMilestonesAlreadyPopulated(agInstance.getAGInstanceInfo().getCiKey())) {
                milestoneBpelMetadataList = this.getFutureMilestones(agInstance, ctx);
                this.m_AGMetadataTable.put(agInstance.getAGInstanceInfo().getCiKey(), milestoneBpelMetadataList);
            } else {
                milestoneBpelMetadataList = (List)this.m_AGMetadataTable.get(agInstance.getAGInstanceInfo().getCiKey());
            }
            milestoneDefinitionList = BPELMetadataUtils.sortMilestones(milestoneList, milestoneBpelMetadataList);
            this.repopulateMilestoneMap((List)this.m_AGMetadataTable.get(agInstance.getAGInstanceInfo().getCiKey()));
            for (int i = 0; i < milestoneDefinitionList.size(); ++i) {
                milestoneDefinition = (MilestoneDefinitionType)milestoneDefinitionList.get(i);
                milestoneName = milestoneDefinition.getName();
                milestoneInstance = this.getMilestoneInstanceByName(agInstance, milestoneName);
                if (milestoneInstance != null) {
                    milestoneDisplayInfo = this.constructMilestoneDisplayInfo(agDefinition, milestoneInstance, ctx, filter, bDisplayTasks, taskDisplayColumns, agInstance.getAGInstanceInfo().getCiKey());
                    if (milestoneInstance.isOptionalTaskComplete() && (milestoneInstance.getStatus().equals("In Progress") || milestoneInstance.getStatus().equals("Running With Warning"))) {
                        updatedInstance = this.completeInstance(ctx, agInstance.getAGInstanceInfo().getCiKey(), false, milestoneName);
                        milestoneDisplayInfo.setMilestoneInstance(this.getMilestoneInstanceByName(updatedInstance, milestoneName));
                        agInstance.getAGInstanceInfo().setCompletionPercentage(updatedInstance.getAGInstanceInfo().getCompletionPercentage());
                    }
                    BPELMetadataElement elem = this.getMilestoneMetadataElement(agInstance.getAGInstanceInfo().getCiKey(), milestoneName);
                    milestoneDisplayInfo.setStatus(milestoneDisplayInfo.getMilestoneInstance().getStatus());
                } else {
                    milestoneDisplayInfo = this.constructMilestoneDisplayInfo(agDefinition, milestoneName, ctx, agInstance, bDisplayTasks);
                    BPELMetadataElement elm = this.getMilestoneMetadataElement(agInstance.getAGInstanceInfo().getCiKey(), milestoneName);
                }
                milestoneDisplayInfo.setName(milestoneName);
                milestoneDisplayInfoList.add(milestoneDisplayInfo);
            }
            this.readjustMilestonesForBranches(agInstance, milestoneBpelMetadataList, milestoneDisplayInfoList);
        } else {
            List milestoneInstanceList = agInstance.getMilestoneInstanceList().getMilestoneInstance();
            for (int i = 0; i < milestoneInstanceList.size(); ++i) {
                milestoneInstance = (MilestoneInstanceType)milestoneInstanceList.get(i);
                milestoneDisplayInfo = this.constructMilestoneDisplayInfo(agDefinition, milestoneInstance, ctx, filter, bDisplayTasks, taskDisplayColumns, agInstance.getAGInstanceInfo().getCiKey());
                if (milestoneInstance.isOptionalTaskComplete() && (milestoneInstance.getStatus().equals("In Progress") || milestoneInstance.getStatus().equals("Running With Warning"))) {
                    updatedInstance = this.completeInstance(ctx, agInstance.getAGInstanceInfo().getCiKey(), false, milestoneName);
                    milestoneDisplayInfo.setMilestoneInstance(this.getMilestoneInstanceByName(agInstance, milestoneName));
                    agInstance.getAGInstanceInfo().setCompletionPercentage(updatedInstance.getAGInstanceInfo().getCompletionPercentage());
                }
                milestoneDisplayInfo.setStatus(milestoneDisplayInfo.getMilestoneInstance().getStatus());
                milestoneDisplayInfo.setName(milestoneName);
                milestoneDisplayInfoList.add(milestoneDisplayInfo);
            }
        }
        AGLogger.logDebug((String)CLASSNAME, (String)"constructMilestoneDisplayInfoList()", (String)"Completed");
        return milestoneDisplayInfoList;
    }

    private MilestoneDisplayInfo constructMilestoneDisplayInfo(AGInstance agInstance, String milestoneName, IWorkflowContext ctx, IAGQueryService.AGAssignmentFilter filter, List taskDisplayColumns) throws WorkflowException {
        AGLogger.logDebug((String)CLASSNAME, (String)"constructMilestoneDisplayInfo()", (String)("Inputs: AG instance cikey = " + agInstance.getAGInstanceInfo().getCiKey() + " AG instance definition id = " + agInstance.getAGInstanceInfo().getDefinitionId() + " taskDisplayColumns = " + StringUtil.getStringFromList((List)taskDisplayColumns) + " milestoneName = " + milestoneName));
        MilestoneInstanceType milestoneInstance = this.getMilestoneInstanceByName(agInstance, milestoneName);
        String agDefinitionId = agInstance.getAGInstanceInfo().getDefinitionId();
        AGDefinition agDefinition = this.getAGMetadataService().getAGDefinitionById(ctx, agDefinitionId);
        MilestoneDisplayInfo milestoneDisplayInfo = null;
        if (milestoneInstance != null) {
            milestoneDisplayInfo = this.constructMilestoneDisplayInfo(agDefinition, milestoneInstance, ctx, filter, true, taskDisplayColumns, agInstance.getAGInstanceInfo().getCiKey());
            if (milestoneInstance.isOptionalTaskComplete() && (milestoneInstance.getStatus().equals("In Progress") || milestoneInstance.getStatus().equals("Running With Warning"))) {
                agInstance = this.completeInstance(ctx, agInstance.getAGInstanceInfo().getCiKey(), false, milestoneName);
                milestoneDisplayInfo.setMilestoneInstance(this.getMilestoneInstanceByName(agInstance, milestoneName));
            }
        } else {
            milestoneDisplayInfo = this.constructMilestoneDisplayInfo(agDefinition, milestoneName, ctx, agInstance, true);
            AGLogger.logDebug((String)CLASSNAME, (String)"constructMilestoneDisplayInfo()", (String)("Constructed non-started milestone: " + milestoneName));
        }
        milestoneDisplayInfo.setStatus(milestoneDisplayInfo.getMilestoneInstance().getStatus());
        milestoneDisplayInfo.setName(milestoneName);
        AGLogger.logDebug((String)CLASSNAME, (String)"constructMilestoneDisplayInfo()", (String)"Completed.");
        return milestoneDisplayInfo;
    }

    private MilestoneDisplayInfo constructMilestoneDisplayInfo(AGDefinition agDefinition, String milestoneName, IWorkflowContext ctx, AGInstance agInstance, boolean bDisplayTasks) throws WorkflowException {
        MilestoneDisplayInfo milestoneDisplayInfo = new oracle.bpel.services.workflow.activityguide.query.model.ObjectFactory().createMilestoneDisplayInfo();
        milestoneDisplayInfo.getMilestoneInstance().setName(milestoneName);
        milestoneDisplayInfo.getMilestoneInstance().setStatus("Not Started");
        MilestoneDefinitionType milestoneDefinition = this.getMilestoneDefinitionByName(agDefinition, milestoneName);
        if (milestoneDefinition != null) {
            String msTitle = milestoneDefinition.getTitle().getValue();
            String msTitleType = milestoneDefinition.getTitle().getType();
            String msDescription = milestoneDefinition.getDescription().getValue();
            String msDescriptionType = milestoneDefinition.getDescription().getType();
            try {
                msTitle = AGi18nUtil.renderValueForValueType(ctx.getLocale(), agDefinition, msTitle, msTitleType);
                msDescription = AGi18nUtil.renderValueForValueType(ctx.getLocale(), agDefinition, msDescription, msDescriptionType);
            }
            catch (Exception e) {
                AGLogger.logError((String)CLASSNAME, (String)"constructAGDisplayInfos()", (Throwable)e);
                throw new WorkflowException((Throwable)e);
            }
            milestoneDisplayInfo.setTitle(msTitle);
            milestoneDisplayInfo.setDescription(msDescription);
            milestoneDisplayInfo.setIconLocation(milestoneDefinition.getIconLocation());
        }
        if (bDisplayTasks) {
            try {
                BPELMetadataElement milestoneMetadata = this.getMilestoneMetadataElement(agInstance.getAGInstanceInfo().getCiKey(), milestoneName);
                if (milestoneMetadata != null && milestoneMetadata instanceof ScopeCompositeMetadataElement) {
                    BPELMetadataElement parent = BPELMetadataUtils.getRootParent(milestoneMetadata);
                    List futureTasksList = this.getFutureTasks((ScopeCompositeMetadataElement)milestoneMetadata, ctx);
                    ArrayList<TaskType> dummyTaskList = new ArrayList<TaskType>();
                    for (int i = 0; i < futureTasksList.size(); ++i) {
                        List tl;
                        TaskType dt;
                        TaskMetadataElement scm = (TaskMetadataElement)futureTasksList.get(i);
                        String title = this.getFutureTaskTitle(scm, ctx, dt = BPELMetadataUtils.createDummyTask(scm));
                        if (title != null) {
                            dt.setTitle(title);
                        }
                        if (BPELMetadataUtils.taskAlreadyExists(dummyTaskList, dt) || title == null || BPELMetadataUtils.taskAlreadyExists(tl = milestoneDisplayInfo.getTask(), dt)) continue;
                        dummyTaskList.add(i, dt);
                    }
                    milestoneDisplayInfo.getTask().clear();
                    milestoneDisplayInfo.getTask().addAll(dummyTaskList);
                }
            }
            catch (Exception e) {
                System.out.println(e.getMessage());
            }
        }
        milestoneDisplayInfo.setStatus(milestoneDisplayInfo.getMilestoneInstance().getStatus());
        return milestoneDisplayInfo;
    }

    private MilestoneDisplayInfo constructMilestoneDisplayInfo(AGDefinition agDefinition, MilestoneInstanceType milestoneInstance, IWorkflowContext ctx, IAGQueryService.AGAssignmentFilter assignmentFilter, boolean bDisplayTasks, List taskDisplayColumns, long ciKey) throws WorkflowException {
        AGLogger.logDebug((String)CLASSNAME, (String)"constructMilestoneDisplayInfo()", (String)("Inputs: token = " + ctx.getToken() + " ctxUser = " + ctx.getUser() + " milestoneName = " + milestoneInstance.getName() + " bDisplayTasks = " + String.valueOf(bDisplayTasks) + " taskDisplayColumns = " + StringUtil.getStringFromList((List)taskDisplayColumns) + " ciKey = " + ciKey));
        MilestoneDisplayInfo milestoneDisplayInfo = new oracle.bpel.services.workflow.activityguide.query.model.ObjectFactory().createMilestoneDisplayInfo();
        milestoneDisplayInfo.setMilestoneInstance(milestoneInstance);
        MilestoneDefinitionType milestoneDefinition = this.getMilestoneDefinitionByName(agDefinition, milestoneInstance.getName());
        if (milestoneDefinition != null) {
            String msTitle = milestoneDefinition.getTitle().getValue();
            String msTitleType = milestoneDefinition.getTitle().getType();
            String msDescription = milestoneDefinition.getDescription().getValue();
            String msDescriptionType = milestoneDefinition.getDescription().getType();
            try {
                msTitle = AGi18nUtil.renderValueForValueType(ctx.getLocale(), agDefinition, msTitle, msTitleType);
                msDescription = AGi18nUtil.renderValueForValueType(ctx.getLocale(), agDefinition, msDescription, msDescriptionType);
            }
            catch (Exception e) {
                AGLogger.logError((String)CLASSNAME, (String)"constructAGDisplayInfos()", (Throwable)e);
                throw new WorkflowException((Throwable)e);
            }
            milestoneDisplayInfo.setTitle(msTitle);
            milestoneDisplayInfo.setDescription(msDescription);
            milestoneDisplayInfo.setIconLocation(milestoneDefinition.getIconLocation());
        }
        if (bDisplayTasks) {
            PredicateImpl agPredicate = new PredicateImpl(TableConstants.WFTASK_AG_ROOTID_COLUMN, 0, (Object)ciKey);
            String name = null;
            name = milestoneDefinition != null ? milestoneDefinition.getName() : milestoneInstance.getName();
            String currentMilestonePath = String.valueOf(ciKey) + AG_MILESTONE_PATH_DELIMITER + name;
            PredicateImpl milestonePredicate = new PredicateImpl(TableConstants.WFTASK_AG_MILESTONE_PATH_COLUMN, 12, (Object)currentMilestonePath);
            Predicate combinedPredicate = WFAGInstanceUtil.combineTwoPredicatesByAND((Predicate)agPredicate, (Predicate)milestonePredicate);
            AGLogger.logDebug((String)CLASSNAME, (String)"constructMilestoneDisplayInfo()", (String)("CombinedPredicate: " + StringUtil.nvl((Object)combinedPredicate)));
            ArrayList taskQueryColumns = new ArrayList(taskVerificationColumns);
            if (taskDisplayColumns != null && !taskDisplayColumns.isEmpty()) {
                taskQueryColumns.addAll(taskDisplayColumns);
            }
            Ordering ordering = new Ordering(TableConstants.WFTASK_CREATEDDATE_COLUMN, true, true);
            ArrayList<ITaskQueryService.OptionalInfo> optionInfos = new ArrayList<ITaskQueryService.OptionalInfo>();
            optionInfos.add(ITaskQueryService.OptionalInfo.DISPLAY_INFO);
            List allTaskList = this.getTaskQueryService().queryTasks(ctx, taskQueryColumns, optionInfos, ITaskQueryService.AssignmentFilter.ALL, null, combinedPredicate, ordering, 0, 0);
            AGLogger.logDebug((String)CLASSNAME, (String)"constructMilestoneDisplayInfo()", (String)("Returned task list size: " + allTaskList.size()));
            if (milestoneInstance.getStatus().equals("In Progress") || milestoneInstance.getStatus().equals("Running With Warning")) {
                int taskCompleteCounter = 0;
                String taskState = null;
                if (allTaskList != null && !allTaskList.isEmpty()) {
                    for (int i = allTaskList.size() - 1; i >= 0 && this.isTaskCompleted(taskState = ((Task)allTaskList.get(i)).getSystemAttributes().getState()); --i) {
                        ++taskCompleteCounter;
                    }
                    if (taskCompleteCounter == allTaskList.size()) {
                        milestoneInstance.setOptionalTaskComplete(true);
                    }
                } else {
                    milestoneInstance.setOptionalTaskComplete(true);
                }
            }
            ITaskQueryService.AssignmentFilter taskFilter = null;
            if (assignmentFilter.equals((Object)IAGQueryService.AGAssignmentFilter.ADMIN) || assignmentFilter.equals((Object)IAGQueryService.AGAssignmentFilter.CREATOR)) {
                taskFilter = ITaskQueryService.AssignmentFilter.ALL;
            } else if (assignmentFilter.equals((Object)IAGQueryService.AGAssignmentFilter.MY)) {
                taskFilter = ITaskQueryService.AssignmentFilter.MY;
            } else if (assignmentFilter.equals((Object)IAGQueryService.AGAssignmentFilter.PREVIOUS)) {
                taskFilter = ITaskQueryService.AssignmentFilter.PREVIOUS;
            } else if (assignmentFilter.equals((Object)IAGQueryService.AGAssignmentFilter.REPORTEES)) {
                taskFilter = ITaskQueryService.AssignmentFilter.REPORTEES;
            }
            List taskList = this.getTaskQueryService().queryTasks(ctx, taskQueryColumns, optionInfos, taskFilter, null, combinedPredicate, ordering, 0, 0);
            if (taskList.size() > 0) {
                Task task = null;
                String msg = null;
                for (int i = taskList.size() - 1; i >= 0; --i) {
                    task = (Task)taskList.get(i);
                    if (!this.getVerificationService().canUserSeeTaskDetails(ctx, task)) {
                        taskList.remove(i);
                        msg = "Task is removed from the list since user cannot see this task.";
                    } else {
                        msg = "user can see this task";
                    }
                    AGLogger.logDebug((String)CLASSNAME, (String)"constructMilestoneDisplayInfo()", (String)(" i=: " + i + " task number: " + task.getSystemAttributes().getTaskNumber() + msg));
                    String taskTitle = AGi18nUtil.renderValueforTaskValueType(ctx.getLocale(), task);
                    if (taskTitle == null) continue;
                    task.setTitle(taskTitle);
                }
            }
            milestoneDisplayInfo.getTask().addAll(taskList);
            String milestoneStatus = null;
            if (milestoneDisplayInfo.getMilestoneInstance() != null) {
                milestoneStatus = milestoneDisplayInfo.getMilestoneInstance().getStatus();
            }
            if (milestoneStatus != null && !milestoneStatus.equalsIgnoreCase("Completed With Warning") && !milestoneStatus.equalsIgnoreCase("Completed")) {
                String name2 = null;
                name2 = milestoneDefinition != null ? milestoneDefinition.getName() : milestoneInstance.getName();
                BPELMetadataElement milestoneMetadata = this.getMilestoneMetadataElement(ciKey, name2);
                List dummyTaskList = this.constructFutureTasksList(milestoneMetadata, ctx, taskList, milestoneDisplayInfo);
                milestoneDisplayInfo.getTask().addAll(dummyTaskList);
            }
        }
        milestoneDisplayInfo.setStatus(milestoneDisplayInfo.getMilestoneInstance().getStatus());
        AGLogger.logDebug((String)CLASSNAME, (String)"constructMilestoneDisplayInfo()", (String)"Completed.");
        return milestoneDisplayInfo;
    }

    private MilestoneDefinitionType getMilestoneDefinitionByName(AGDefinition agDefinition, String milestoneName) {
        MilestoneDefinitionType milestoneDefinition = null;
        boolean bFound = false;
        List milestoneDefinitionList = agDefinition.getMilestone();
        for (int i = 0; i < milestoneDefinitionList.size(); ++i) {
            milestoneDefinition = (MilestoneDefinitionType)milestoneDefinitionList.get(i);
            if (!milestoneDefinition.getName().equals(milestoneName) && !milestoneName.startsWith(milestoneDefinition.getName())) continue;
            bFound = true;
            break;
        }
        if (!bFound) {
            milestoneDefinition = null;
        }
        return milestoneDefinition;
    }

    private MilestoneInstanceType getMilestoneInstanceByName(AGInstance agInstance, String milestoneName) {
        MilestoneInstanceType milestoneInstance = null;
        boolean bFound = false;
        List milestoneInstanceList = agInstance.getMilestoneInstanceList().getMilestoneInstance();
        for (int i = 0; i < milestoneInstanceList.size(); ++i) {
            milestoneInstance = (MilestoneInstanceType)milestoneInstanceList.get(i);
            if (!milestoneInstance.getName().equals(milestoneName) && !milestoneInstance.getName().startsWith(milestoneName)) continue;
            bFound = true;
            break;
        }
        if (!bFound) {
            milestoneInstance = null;
        }
        return milestoneInstance;
    }

    private boolean canUserSeeAGDisplayInfo(IWorkflowContext ctx, AGInstance agInstance) throws WorkflowException {
        AGLogger.logDebug((String)CLASSNAME, (String)"canUserSeeAGDisplayInfo()", (String)("Inputs: token = " + ctx.getToken() + " ctxUser = " + ctx.getUser() + " AG instance cikey = " + agInstance.getAGInstanceInfo().getCiKey()));
        boolean bCanUserSeeAGDisplayInfo = false;
        if (BpelAGQueryService.isUserAGAdmin(ctx) || ctx instanceof InternalWorkflowContext) {
            bCanUserSeeAGDisplayInfo = true;
            AGLogger.logDebug((String)CLASSNAME, (String)"canUserSeeAGDisplayInfo()", (String)"User is AG admin and can see AG");
            return bCanUserSeeAGDisplayInfo;
        }
        String creator = agInstance.getAGInstanceInfo().getCreator();
        if (creator != null && creator.equals(ctx.getUser())) {
            bCanUserSeeAGDisplayInfo = true;
            AGLogger.logDebug((String)CLASSNAME, (String)"canUserSeeAGDisplayInfo()", (String)"User is AG creator and can see AG");
            return bCanUserSeeAGDisplayInfo;
        }
        PredicateImpl agPredicate = new PredicateImpl(TableConstants.WFTASK_AG_ROOTID_COLUMN, 0, (Object)agInstance.getAGInstanceInfo().getCiKey());
        Ordering ordering = new Ordering(TableConstants.WFTASK_CREATEDDATE_COLUMN, true, true);
        ArrayList<ITaskQueryService.OptionalInfo> optionInfos = new ArrayList<ITaskQueryService.OptionalInfo>();
        optionInfos.add(ITaskQueryService.OptionalInfo.DISPLAY_INFO);
        List taskList = this.getTaskQueryService().queryTasks(ctx, taskVerificationColumns, optionInfos, ITaskQueryService.AssignmentFilter.ALL, null, (Predicate)agPredicate, ordering, 0, 0);
        AGLogger.logDebug((String)CLASSNAME, (String)"canUserSeeAGDisplayInfo()", (String)("Returned task list size: " + taskList.size()));
        if (taskList.size() > 0) {
            Task task = null;
            for (int i = 0; i < taskList.size(); ++i) {
                task = (Task)taskList.get(i);
                AGLogger.logDebug((String)CLASSNAME, (String)"canUserSeeAGDisplayInfo()", (String)(" i=: " + i + " task number: " + task.getSystemAttributes().getTaskNumber()));
                if (!this.getVerificationService().canUserSeeTaskDetails(ctx, task)) continue;
                bCanUserSeeAGDisplayInfo = true;
                AGLogger.logDebug((String)CLASSNAME, (String)"canUserSeeAGDisplayInfo()", (String)"User can see this task and the AG.");
                break;
            }
        }
        AGLogger.logDebug((String)CLASSNAME, (String)"canUserSeeAGDisplayInfo()", (String)("Completed. canUserSeeAGDisplayInfo " + String.valueOf(bCanUserSeeAGDisplayInfo)));
        return bCanUserSeeAGDisplayInfo;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List getFutureMilestones(AGInstance agInstance, IWorkflowContext ctx) throws WorkflowException {
        AGLogger.logDebug((String)CLASSNAME, (String)"configureFutureMilestones()", (String)("Inputs: agInstance = " + agInstance.getAGInstanceInfo().getTitle() + " ctxUser = " + ctx.getUser()));
        IPersistencyService service = null;
        List bpelScopeMetadataList = null;
        this.getVerificationService().validateContext(ctx);
        try {
            service = PersistencyDriver.getInstance();
            bpelScopeMetadataList = service.getBPELScopeMetadata(ctx, agInstance);
            if (bpelScopeMetadataList != null) {
                AGLogger.logDebug((String)CLASSNAME, (String)"configureFutureMilestones()", (String)"Got the metadata details from DB.");
                this.refineScopeMetadataList(bpelScopeMetadataList);
            }
            AGLogger.logDebug((String)CLASSNAME, (String)"getMilestoneDisplayInfo()", (String)"Completed.");
            List list = bpelScopeMetadataList;
            return list;
        }
        finally {
            if (service != null) {
                service.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List getFutureTasks(ScopeCompositeMetadataElement scopeMetadataElement, IWorkflowContext ctx) throws WorkflowException {
        AGLogger.logDebug((String)CLASSNAME, (String)"getFutureTasks()", (String)("Inputs: BPELMetadataElement = " + scopeMetadataElement.getName() + " ctxUser = " + ctx.getUser()));
        IPersistencyService service = null;
        List bpelTaskMetadataList = null;
        this.getVerificationService().validateContext(ctx);
        try {
            service = PersistencyDriver.getInstance();
            bpelTaskMetadataList = service.getBPELTaskMetadata(ctx, scopeMetadataElement);
            if (bpelTaskMetadataList != null) {
                AGLogger.logDebug((String)CLASSNAME, (String)"getFutureTasks()", (String)"Got the task metadata details from DB.");
                this.refineScopeMetadataList(bpelTaskMetadataList);
            }
            AGLogger.logDebug((String)CLASSNAME, (String)"getMilestoneDisplayInfo()", (String)"Completed.");
            List list = bpelTaskMetadataList;
            return list;
        }
        finally {
            if (service != null) {
                service.close();
            }
        }
    }

    private void refineScopeMetadataList(List bpelScopeMetadataList) {
        for (int i = 0; i < bpelScopeMetadataList.size(); ++i) {
            BPELMetadataElement scopeElem = (BPELMetadataElement)bpelScopeMetadataList.get(i);
            if (scopeElem == null || !scopeElem.getType().equalsIgnoreCase("switch") || scopeElem.hasChildMilestones()) continue;
            bpelScopeMetadataList.remove(i);
        }
    }

    private boolean isMilestonesAlreadyPopulated(long mName) {
        return this.m_AGMetadataTable.containsKey(mName);
    }

    private BPELMetadataElement getMilestoneMetadataElement(long agId, String name) {
        List metadataList = (List)this.m_AGMetadataTable.get(agId);
        if (metadataList != null) {
            for (int i = 0; i < metadataList.size(); ++i) {
                BPELMetadataElement elem = BPELMetadataUtils.findMetadataByName((BPELMetadataElement)metadataList.get(i), name);
                if (elem == null) continue;
                return elem;
            }
        }
        return null;
    }

    private List constructFutureTasksList(BPELMetadataElement milestoneMetadata, IWorkflowContext ctx, List taskList, MilestoneDisplayInfo milestoneDisplayInfo) {
        ArrayList<TaskType> dummyTaskList = new ArrayList<TaskType>();
        try {
            if (milestoneMetadata != null && milestoneMetadata instanceof ScopeCompositeMetadataElement) {
                List futureTasksList = this.getFutureTasks((ScopeCompositeMetadataElement)milestoneMetadata, ctx);
                this.setTitleForInstantiatedTasks(taskList, futureTasksList, ctx);
                BPELMetadataUtils.readjustFutureTasks(taskList, futureTasksList);
                for (int i = 0; i < futureTasksList.size(); ++i) {
                    List tl;
                    String title;
                    TaskType dt;
                    TaskMetadataElement scm = (TaskMetadataElement)futureTasksList.get(i);
                    BPELMetadataElement root = BPELMetadataUtils.getRootParent((BPELMetadataElement)scm);
                    if (root != null && root.getType().equalsIgnoreCase("switch") && !root.getName().startsWith("switch")) {
                        root.setName("switch_" + root.getId());
                        dt = BPELMetadataUtils.createDummyTask((TaskMetadataElement)root);
                        title = this.getFutureTaskTitle(scm, ctx, dt);
                        if (title != null) {
                            dt.setTitle(title);
                        }
                        if (BPELMetadataUtils.taskAlreadyExists(dummyTaskList, dt) || title == null || BPELMetadataUtils.taskAlreadyExists(tl = milestoneDisplayInfo.getTask(), dt)) continue;
                        dummyTaskList.add(i, dt);
                        continue;
                    }
                    if (root != null && !root.getType().equalsIgnoreCase("switch")) {
                        dt = BPELMetadataUtils.createDummyTask(scm);
                        title = this.getFutureTaskTitle(scm, ctx, dt);
                        if (title != null) {
                            dt.setTitle(title);
                        }
                        if (BPELMetadataUtils.taskAlreadyExists(dummyTaskList, dt) || title == null || BPELMetadataUtils.taskAlreadyExists(tl = milestoneDisplayInfo.getTask(), dt)) continue;
                        dummyTaskList.add(i, dt);
                        continue;
                    }
                    if (root != null) continue;
                    dt = BPELMetadataUtils.createDummyTask(scm);
                    title = this.getFutureTaskTitle(scm, ctx, dt);
                    if (title != null) {
                        dt.setTitle(title);
                    }
                    if (BPELMetadataUtils.taskAlreadyExists(dummyTaskList, dt) || title == null || BPELMetadataUtils.taskAlreadyExists(tl = milestoneDisplayInfo.getTask(), dt)) continue;
                    dummyTaskList.add(i, dt);
                }
            }
        }
        catch (Exception e) {
            // empty catch block
        }
        return dummyTaskList;
    }

    private void repopulateMilestoneMap(List milestoneMetadata) {
    }

    private AGInstance completeInstance(IWorkflowContext ctx, long ciKey, boolean isAGComplete, String milestoneName) throws WorkflowException {
        IPersistencyService service = PersistencyDriver.getInstance();
        AGInstance agInstance = service.getAGInstance(ctx, ciKey);
        try {
            if (isAGComplete) {
                agInstance.setSaved();
                agInstance.setAGInstanceCompleted();
            } else {
                MilestoneInstanceType msInstance = this.getMilestoneInstanceByName(agInstance, milestoneName);
                msInstance.setOptionalTaskComplete(true);
                agInstance.setSaved();
                agInstance.setMilestoneCompleted(milestoneName);
            }
        }
        catch (CubeException e) {
            Object[] errorObjs = new Object[]{ctx.getUser(), String.valueOf(ciKey), "completeMilestone"};
            throw new WorkflowException(38006, e.getMessage(), errorObjs);
        }
        return agInstance;
    }

    private String getFutureTaskTitle(TaskMetadataElement scm, IWorkflowContext ctx, TaskType dt) {
        if (scm.getType().equalsIgnoreCase("switch")) {
            return "switch_" + scm.getId();
        }
        try {
            ObjectFactory objf = new ObjectFactory();
            Task tempTask = objf.createTask();
            tempTask.setCallback(dt.getCallback());
            TaskMetadataCache taskCache = TaskMetadataCache.getInstance();
            TaskDefinition taskDefn = taskCache.getTaskDefinition(dt.getTaskDefinitionId(), dt.getMdsLabel());
            tempTask.setTaskDefinitionId(taskDefn.getId());
            String taskTitle = null;
            if (taskDefn.getTitle().getType().equals("RESOURCE") || taskDefn.getTitle().getType().equals("RESOURCEREF")) {
                taskTitle = AGi18nUtil.renderValueforTaskValueType(ctx.getLocale(), tempTask);
            } else if (taskDefn.getTitle().getType().equals("XPATH")) {
                taskTitle = taskDefn.getName();
            } else if (taskDefn.getTitle().getType().equalsIgnoreCase("STATIC")) {
                taskTitle = taskDefn.getTitle().getValue();
            }
            return taskTitle;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    private void setTitleForInstantiatedTasks(List taskList, List futureTasksList, IWorkflowContext ctx) {
        for (int i = 0; i < taskList.size(); ++i) {
            String[] s;
            TaskMetadataElement tm;
            String title;
            TaskType t = (TaskType)taskList.get(i);
            if (t == null || (title = this.getFutureTaskTitle(tm = (TaskMetadataElement)BPELMetadataUtils.getTaskMetadataElement((s = t.getCallback().getId().split("/"))[1], futureTasksList), ctx, t)) == null) continue;
            t.setTitle(title);
        }
    }

    private void clearMetadataCache() {
        if (this.m_AGMetadataTable != null) {
            this.m_AGMetadataTable.clear();
        }
    }

    private boolean checkIfMilestoneExists(List milestoneDisplayInfoList, String name) {
        for (int j = 0; j < milestoneDisplayInfoList.size(); ++j) {
            MilestoneDisplayInfo mdispInfo = (MilestoneDisplayInfo)milestoneDisplayInfoList.get(j);
            if (mdispInfo == null || !mdispInfo.getTitle().equalsIgnoreCase(name)) continue;
            return true;
        }
        return false;
    }

    private void readjustMilestonesForBranches(AGInstance agInstance, List metadataList, List milestoneDisplayInfoList) {
        BPELMetadataElement parent;
        BPELMetadataElement m;
        String title;
        MilestoneDisplayInfo mdispInfo;
        int j;
        for (j = 0; j < milestoneDisplayInfoList.size(); ++j) {
            mdispInfo = (MilestoneDisplayInfo)milestoneDisplayInfoList.get(j);
            title = mdispInfo.getTitle();
            if (this.getMilestoneInstanceByName(agInstance, title) != null) {
                m = BPELMetadataUtils.findMilestoneMetadata(metadataList, title);
                if (m == null) continue;
                String currNodeStartPattern = m.getNodeBranch().substring(0, m.getNodeBranch().length() - 2);
                BPELMetadataElement p = m.getParent();
                if (p == null) continue;
                List childs = p.getElements();
                for (int k = 0; childs != null && k < childs.size(); ++k) {
                    BPELMetadataElement cm = (BPELMetadataElement)childs.get(k);
                    String childStartPattern = cm.getNodeBranch().substring(0, cm.getNodeBranch().length() - 2);
                    if (cm == null || cm.getId().equalsIgnoreCase(m.getId()) || currNodeStartPattern.equalsIgnoreCase(childStartPattern)) continue;
                    this.removeMSFromOtherBranch(cm, milestoneDisplayInfoList);
                }
                continue;
            }
            m = BPELMetadataUtils.findMilestoneMetadata(metadataList, title);
            if (m == null || (parent = m.getParent()) == null || parent == null || !this.checkIsSiblingAvailable(m, milestoneDisplayInfoList, parent, metadataList)) continue;
            milestoneDisplayInfoList.remove(mdispInfo);
            --j;
        }
        for (j = 0; j < milestoneDisplayInfoList.size(); ++j) {
            mdispInfo = (MilestoneDisplayInfo)milestoneDisplayInfoList.get(j);
            title = mdispInfo.getTitle();
            if (this.getMilestoneInstanceByName(agInstance, title) != null || (m = BPELMetadataUtils.findMilestoneMetadata(metadataList, title)) == null || (parent = m.getParent()) == null || !parent.getType().equalsIgnoreCase("switch")) continue;
            mdispInfo.setTitle("switch_" + m.getId());
        }
    }

    private boolean checkIsSiblingAvailable(BPELMetadataElement elem, List milestoneDisplayInfoList, BPELMetadataElement parent, List metadataList) {
        List childList = parent.getElements();
        for (int j = 0; j < milestoneDisplayInfoList.size(); ++j) {
            MilestoneDisplayInfo mdispInfo = (MilestoneDisplayInfo)milestoneDisplayInfoList.get(j);
            String title = mdispInfo.getTitle();
            BPELMetadataElement m = BPELMetadataUtils.findMilestoneMetadata(childList, title);
            if (m == null || m.getId().equalsIgnoreCase(elem.getId())) continue;
            return true;
        }
        return false;
    }

    private void removeMSFromOtherBranch(BPELMetadataElement elem, List milestoneDisplayInfoList) {
        MilestoneDisplayInfo mCurrDispInfo = null;
        if (elem != null) {
            List childList = elem.getElements();
            if (childList != null) {
                for (int j = 0; j < milestoneDisplayInfoList.size(); ++j) {
                    BPELMetadataElement m;
                    MilestoneDisplayInfo mdispInfo = (MilestoneDisplayInfo)milestoneDisplayInfoList.get(j);
                    String title = mdispInfo.getTitle();
                    if (title.equalsIgnoreCase(elem.getName())) {
                        mCurrDispInfo = mdispInfo;
                    }
                    if ((m = BPELMetadataUtils.findMilestoneMetadata(childList, title)) == null) continue;
                    milestoneDisplayInfoList.remove(mdispInfo);
                    --j;
                }
            }
            milestoneDisplayInfoList.remove(mCurrDispInfo);
        }
    }

    static {
        BpelAGQueryService.initTaskVerificationColumns();
    }
}

