/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.services.activityguide.common;

import com.oracle.bpel.activityguide.metadata.definition.model.AGDefinition;
import com.oracle.bpel.activityguide.metadata.impl.AGDefinitionCache;
import java.util.Locale;
import java.util.ResourceBundle;
import oracle.bpel.services.common.ServicesLogger;
import oracle.bpel.services.workflow.WorkflowException;
import oracle.bpel.services.workflow.metadata.impl.TaskMetadataCache;
import oracle.bpel.services.workflow.metadata.taskdefinition.TaskDefinitionUtil;
import oracle.bpel.services.workflow.metadata.taskdefinition.model.TaskDefinition;
import oracle.bpel.services.workflow.metadata.taskdefinition.model.TranslatableValueType;
import oracle.bpel.services.workflow.task.model.Task;
import oracle.bpm.services.activityguide.IBpmAGMetadataService;
import oracle.bpm.services.activityguide.model.metadata.IActivityGuide;

public class AGi18nUtil {
    private static String CLASS_NAME = AGi18nUtil.class.getName();
    protected static String VALUE_TYPE_STATIC = "STATIC";
    protected static String VALUE_TYPE_XPATH = "XPATH";
    protected static String VALUE_TYPE_RESOURCE = "RESOURCE";
    protected static String VALUE_TYPE_RESOURCEREF = "RESOURCEREF";
    protected static IBpmAGMetadataService bpmMetadataSvc = null;

    public static String renderValueForValueType(Locale locale, Object activityGuideMetadata, String agDefValue, String agValueType) throws Exception {
        ResourceBundle rBundle;
        String log_methodName = "renderValueForValueType";
        if (ServicesLogger.canLog((int)4, (int)ServicesLogger.SERVICESLOGGER_DEBUG)) {
            ServicesLogger.log((int)4, (int)ServicesLogger.SERVICESLOGGER_DEBUG, (String)CLASS_NAME, (String)"renderValueForValueType", (String)("AG/Milestone value type {" + agValueType + "} AG/Milestone value {" + agDefValue + "} "));
        }
        if (agDefValue == null) {
            return null;
        }
        String displayStr = null;
        if (VALUE_TYPE_STATIC.equals(agValueType)) {
            displayStr = agDefValue;
        } else if (VALUE_TYPE_RESOURCE.equals(agValueType) && (rBundle = AGi18nUtil.getResourceBundle(locale, activityGuideMetadata)) != null) {
            displayStr = rBundle.getString(agDefValue);
        }
        if (ServicesLogger.canLog((int)4, (int)ServicesLogger.SERVICESLOGGER_DEBUG)) {
            ServicesLogger.log((int)4, (int)ServicesLogger.SERVICESLOGGER_DEBUG, (String)CLASS_NAME, (String)"renderValueForValueType", (String)("Rendered ag display string {" + displayStr + "}"));
        }
        return displayStr;
    }

    public static String renderValueforTaskValueType(Locale locale, Task task) throws WorkflowException {
        String log_methodName = "renderValueforTaskValueType";
        String displayStr = null;
        TaskMetadataCache taskCache = TaskMetadataCache.getInstance();
        TaskDefinition taskDefn = taskCache.getTaskDefinition(task.getTaskDefinitionId(), task.getMdsLabel());
        displayStr = taskDefn.getTitle() == null ? task.getSca().getCompositeName() : (taskDefn.getTitle().getType().equals(VALUE_TYPE_RESOURCE) || taskDefn.getTitle().getType().equals(VALUE_TYPE_RESOURCEREF) ? TaskDefinitionUtil.getDisplayValueForValueType((Locale)locale, (TaskDefinition)taskDefn, (Task)task, (String)task.getTaskDefinitionId(), null, (TranslatableValueType)taskDefn.getTitle()) : null);
        if (ServicesLogger.canLog((int)4, (int)ServicesLogger.SERVICESLOGGER_DEBUG)) {
            ServicesLogger.log((int)4, (int)ServicesLogger.SERVICESLOGGER_DEBUG, (String)CLASS_NAME, (String)"renderValueforTaskValueType", (String)("Rendered task display string {" + displayStr + "}"));
        }
        return displayStr;
    }

    public static void setBpmMetadataService(IBpmAGMetadataService bpmMetadataSvc) {
        AGi18nUtil.bpmMetadataSvc = bpmMetadataSvc;
    }

    private static ResourceBundle getResourceBundle(Locale locale, Object activityGuideMetadata) throws Exception {
        ResourceBundle rBundle = null;
        if (activityGuideMetadata instanceof IActivityGuide) {
            String compositeDN = ((IActivityGuide)activityGuideMetadata).getCompositeDN();
            if (bpmMetadataSvc != null) {
                rBundle = bpmMetadataSvc.getResourceBundle(compositeDN, locale);
            }
        } else if (activityGuideMetadata instanceof AGDefinition) {
            AGDefinitionCache agCache = AGDefinitionCache.getInstance();
            String defnId = ((AGDefinition)activityGuideMetadata).getId();
            rBundle = agCache.getResourceBundle(defnId, locale);
        }
        return rBundle;
    }
}

