/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.services.activityguide.common;

import java.io.UnsupportedEncodingException;
import java.net.URI;
import java.net.URLEncoder;
import oracle.bpm.services.common.logger.BPMLogger;
import oracle.bpm.services.common.logger.LoggerComponent;
import oracle.bpm.services.common.logger.Severity;

public class AGMetadataServiceUtil {
    static final String CLASSNAME = "AGMetadataServiceUtil";
    private static Character[] urlSafeChars = new Character[]{null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, Character.valueOf('#'), Character.valueOf('$'), Character.valueOf('%'), Character.valueOf('&'), null, null, null, null, Character.valueOf('+'), null, Character.valueOf('-'), Character.valueOf('.'), Character.valueOf('/'), Character.valueOf('0'), Character.valueOf('1'), Character.valueOf('2'), Character.valueOf('3'), Character.valueOf('4'), Character.valueOf('5'), Character.valueOf('6'), Character.valueOf('7'), Character.valueOf('8'), Character.valueOf('9'), Character.valueOf(':'), Character.valueOf(';'), null, Character.valueOf('='), null, Character.valueOf('?'), Character.valueOf('@'), Character.valueOf('A'), Character.valueOf('B'), Character.valueOf('C'), Character.valueOf('D'), Character.valueOf('E'), Character.valueOf('F'), Character.valueOf('G'), Character.valueOf('H'), Character.valueOf('I'), Character.valueOf('J'), Character.valueOf('K'), Character.valueOf('L'), Character.valueOf('M'), Character.valueOf('N'), Character.valueOf('O'), Character.valueOf('P'), Character.valueOf('Q'), Character.valueOf('R'), Character.valueOf('S'), Character.valueOf('T'), Character.valueOf('U'), Character.valueOf('V'), Character.valueOf('W'), Character.valueOf('X'), Character.valueOf('Y'), Character.valueOf('Z'), null, null, null, null, Character.valueOf('_'), null, Character.valueOf('a'), Character.valueOf('b'), Character.valueOf('c'), Character.valueOf('d'), Character.valueOf('e'), Character.valueOf('f'), Character.valueOf('g'), Character.valueOf('h'), Character.valueOf('i'), Character.valueOf('j'), Character.valueOf('k'), Character.valueOf('l'), Character.valueOf('m'), Character.valueOf('n'), Character.valueOf('o'), Character.valueOf('p'), Character.valueOf('q'), Character.valueOf('r'), Character.valueOf('s'), Character.valueOf('t'), Character.valueOf('u'), Character.valueOf('v'), Character.valueOf('w'), Character.valueOf('x'), Character.valueOf('y'), Character.valueOf('z'), null, null, null, null, null};

    public static String getURLSafeString(String url) throws UnsupportedEncodingException {
        char[] chars = url.toCharArray();
        char[] destChars = new char[chars.length * 3];
        int di = 0;
        for (char ch : chars) {
            if (ch < urlSafeChars.length && urlSafeChars[ch] != null) {
                destChars[di++] = ch;
                continue;
            }
            char[] asciiVal = URLEncoder.encode(String.valueOf(ch), "UTF-8").toCharArray();
            System.arraycopy(asciiVal, 0, destChars, di, asciiVal.length);
            di += asciiVal.length;
        }
        return new String(destChars, 0, di);
    }

    public static String getResourceLocationUrl(String applicationBaseUrl, String resourceLocation) {
        try {
            if (resourceLocation != null && !resourceLocation.isEmpty()) {
                BPMLogger.log((LoggerComponent)LoggerComponent.COMPONENT_AG_METADATA_SERVICE, (Severity)Severity.DEBUG, (String)CLASSNAME, (String)"getResourceLocationUrl", (String)("BaseURL: " + applicationBaseUrl + " ResourceLocation: " + resourceLocation));
                URI applicationBaseURI = new URI(applicationBaseUrl);
                URI uri = applicationBaseURI.resolve(resourceLocation);
                return uri.toURL().toString();
            }
        }
        catch (Exception e) {
            BPMLogger.log((LoggerComponent)LoggerComponent.COMPONENT_AG_METADATA_SERVICE, (Severity)Severity.WARNING, (String)CLASSNAME, (String)"getResourceLocationUrl", (String)"Icon location URL cannot be resolved and is set to NULL");
            BPMLogger.log((LoggerComponent)LoggerComponent.COMPONENT_AG_METADATA_SERVICE, (Severity)Severity.WARNING, (Throwable)e);
        }
        return null;
    }
}

