/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.fusion.repository;

import java.awt.EventQueue;
import java.util.Arrays;
import java.util.Set;
import oracle.bpm.collections.CollectionUtils;
import oracle.bpm.collections.Predicate;
import oracle.bpm.collections.PredicateUtils;
import oracle.bpm.collections.Sequence;
import oracle.bpm.fusion.repository.fs.FusionFileSystem;
import oracle.bpm.log.Log;
import oracle.bpm.project.catalog.composite.CompositeAccessorFactory;
import oracle.bpm.project.interfaces.BuilderException;
import oracle.bpm.project.interfaces.ProcessUtil;
import oracle.bpm.project.interfaces.ProcessWsdlWriter;
import oracle.bpm.project.interfaces.ProjectWsdlWriter;
import oracle.bpm.project.io.fs.FileProjectLoader;
import oracle.bpm.project.model.Project;
import oracle.bpm.project.model.ProjectFileSystem;
import oracle.bpm.project.model.ProjectObject;
import oracle.bpm.project.model.ProjectRepository;
import oracle.bpm.project.model.events.ProjectEvent;
import oracle.bpm.project.model.events.ProjectEventSet;
import oracle.bpm.project.model.events.ProjectListener;
import oracle.bpm.project.model.events.ProjectListenerAdapter;
import oracle.bpm.project.model.exception.ProjectException;
import oracle.bpm.project.model.processes.Process;
import oracle.bpm.project.model.util.ModelUtils;
import org.jetbrains.annotations.Nullable;

class FusionProjectLoader
extends FileProjectLoader {
    private final String CURVE_EVENT = "curve";
    private final Predicate<ProjectEvent> DOCUMENTATION_EVENT_PREDICATE = this.filterByProperties(CollectionUtils.immutableSet(Arrays.asList("process.documentation", "process.useCaseDocumentation", "process.object.documentation", "process.object.useCaseDocumentation")));
    private ProjectListener listener;
    private Project project;
    private final String X_EVENT = "x";
    private final String Y_EVENT = "y";
    private final Predicate<ProjectEvent> IGNORED_EVENT_PREDICATE = this.filterByProperties(CollectionUtils.immutableSet(Arrays.asList("process.label", "process.description", "x", "y", "curve", "process.appinfo.linkName", "process.appinfo.description", "process.appinfo.category", "process.appinfo.tags", "process.appinfo.documentation")));
    private final Predicate<ProjectEvent> LAYOUT_EVENT_PREDICATE = this.filterByProperties(CollectionUtils.immutableSet(Arrays.asList("x", "y", "curve")));

    public FusionProjectLoader(ProjectRepository repository, Project project, ProjectFileSystem fileSystem) {
        super(repository, project, fileSystem);
        this.project = project;
        this.listener = new ProjectListenerAdapter<Process>(Process.class){

            public void processPostEvents(ProjectEventSet events) {
                Sequence eventSeq = CollectionUtils.asSequence(events);
                if (eventSeq.select(FusionProjectLoader.this.DOCUMENTATION_EVENT_PREDICATE).isEmpty() && eventSeq.select(FusionProjectLoader.this.LAYOUT_EVENT_PREDICATE).isEmpty()) {
                    super.processPostEvents(ProjectEventSet.createFrom(eventSeq.select(PredicateUtils.not(FusionProjectLoader.this.IGNORED_EVENT_PREDICATE))));
                } else {
                    ProjectEventSet from = ProjectEventSet.createFrom(eventSeq.select(PredicateUtils.not(FusionProjectLoader.this.IGNORED_EVENT_PREDICATE)).select(PredicateUtils.not(FusionProjectLoader.this.DOCUMENTATION_EVENT_PREDICATE)).select(PredicateUtils.not(FusionProjectLoader.this.LAYOUT_EVENT_PREDICATE)));
                    if (from.size() > 1) {
                        super.processPostEvents(from);
                    }
                }
            }

            public void postObjectAdded(Process process, ProjectObject parent) {
                FusionProjectLoader.this.updateComposite(process);
            }

            public void preObjectRemoved(Process process, ProjectObject parent) throws ProjectException {
                if (!ModelUtils.isDefaultProcess((Process)process)) {
                    CompositeAccessorFactory.createCompositeUpdater((Process)process).delete();
                }
            }

            public void objectChanged(Process process, ProjectEvent event) {
                if (event.getProjectObject() == process && process.isDirty() && EventQueue.isDispatchThread()) {
                    FusionProjectLoader.this.updateComposite(process);
                }
            }

            public void objectReplaced(Process oldProcess, Process newProcess) {
                FusionProjectLoader.this.updateComposite(newProcess);
            }
        };
        project.addListener(this.listener);
    }

    @Override
    public void dispose() {
        super.dispose();
        this.getFusionFileSystem().dispose();
        this.project.removeListener(this.listener);
    }

    private Predicate<ProjectEvent> filterByProperties(final Set<String> ignoredProperties) {
        return new Predicate<ProjectEvent>(){

            @Override
            public boolean check(@Nullable ProjectEvent event) {
                return event != null && ignoredProperties.contains(event.getPropertyName());
            }
        };
    }

    private void updateComposite(Process process) {
        block4: {
            if (!ModelUtils.isDefaultProcess((Process)process) && !ProcessUtil.hasCycles((Process)process)) {
                try {
                    if (process.getProject() != null) {
                        ProcessWsdlWriter.write((Process)process);
                        CompositeAccessorFactory.createCompositeUpdater((Process)process).updateComposite();
                        ProjectWsdlWriter.write((Project)process.getProject());
                    }
                }
                catch (BuilderException e) {
                    if ($assertionsDisabled || Log.logDebug(e)) break block4;
                    throw new AssertionError();
                }
            }
        }
    }

    private FusionFileSystem getFusionFileSystem() {
        return (FusionFileSystem)this.getProjectFileSystem().getDataFileSystem();
    }
}

