/*
 * Decompiled with CFR 0.152.
 */
package oracle.apps.fnd.wf.engine.util;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import javax.activation.DataSource;

public class ByteArrayDataSource
implements DataSource {
    public static final String RCS_ID = "$Header: /wfdev/wf/3.0/java/engine/util/RCS/ByteArrayDataSource.java,v 30.1 2004/08/19 22:41:00 dlam noship $";
    private byte[] data;
    private String type;

    public ByteArrayDataSource(InputStream is, String type) {
        this.type = type;
        try {
            int ch;
            ByteArrayOutputStream os = new ByteArrayOutputStream();
            while ((ch = is.read()) != -1) {
                os.write(ch);
            }
            this.data = os.toByteArray();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public ByteArrayDataSource(byte[] data, String type) {
        this.data = data;
        this.type = type;
    }

    public ByteArrayDataSource(String data, String type) {
        try {
            this.data = data.getBytes("iso-8859-1");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            // empty catch block
        }
        this.type = type;
    }

    public InputStream getInputStream() throws IOException {
        if (this.data == null) {
            throw new IOException("no data");
        }
        return new ByteArrayInputStream(this.data);
    }

    public OutputStream getOutputStream() throws IOException {
        throw new IOException("cannot do this");
    }

    public String getContentType() {
        return this.type;
    }

    public String getName() {
        return "dummy";
    }
}

