/*
 * Decompiled with CFR 0.152.
 */
package oracle.apps.fnd.wf.design;

import java.util.Iterator;
import java.util.List;
import java.util.Vector;
import oracle.apps.fnd.wf.common.Correlation;
import oracle.apps.fnd.wf.common.WorkflowContext;
import oracle.apps.fnd.wf.common.WorkflowException;
import oracle.apps.fnd.wf.design.Activity;
import oracle.apps.fnd.wf.design.DesignBaseComponent;
import oracle.apps.fnd.wf.design.ProcessActivity;
import oracle.apps.fnd.wf.design.VerificationError;

public class Process
extends Activity {
    public static final String RCS_ID = "$Header: /wfdev/wf/3.0/java/design/RCS/Process.java,v 30.4 2005/01/15 00:44:03 anpwang noship $";
    private String mDiagramContent;

    public Process() {
    }

    public Process(String id) {
        super(id);
    }

    @Override
    public String getType() {
        return "PROCESS";
    }

    public ProcessActivity getProcessActivityByLabel(String pLabel) {
        if (pLabel != null) {
            for (ProcessActivity node : this.getChildrenByType(ProcessActivity.class)) {
                if (!pLabel.equals(node.getInstanceLabel())) continue;
                return node;
            }
        }
        return null;
    }

    public ProcessActivity getProcessActivityById(String pNodeId) {
        for (ProcessActivity node : this.getChildrenByType(ProcessActivity.class)) {
            if (!pNodeId.equals(node.getId())) continue;
            return node;
        }
        return null;
    }

    public Iterator getStartActivities(Correlation correlation) {
        Iterator iter = this.getChildrenByType(ProcessActivity.class).iterator();
        Vector<ProcessActivity> v = new Vector<ProcessActivity>();
        while (iter.hasNext()) {
            ProcessActivity node = (ProcessActivity)iter.next();
            if (!node.isAStartNode(correlation)) continue;
            v.add(node);
        }
        return v.iterator();
    }

    public Iterator getProcessActivities() {
        Iterator iter = this.getChildrenByType(ProcessActivity.class).iterator();
        return iter;
    }

    @Override
    public void saveChildren(WorkflowContext pCtx) throws WorkflowException {
        super.saveChildren(pCtx);
        List list = this.getChildrenByType(ProcessActivity.class);
        for (DesignBaseComponent element : list) {
            element.save(pCtx);
        }
        for (DesignBaseComponent element : list) {
            element.saveChildren(pCtx);
        }
    }

    @Override
    public void loadChildren(WorkflowContext pCtx) throws WorkflowException {
        this.getChildrenByType(ProcessActivity.class);
        super.loadChildren(pCtx);
    }

    @Override
    public void verify(WorkflowContext pCtx, boolean pStopOnFailure) throws WorkflowException {
        super.verify(pCtx, pStopOnFailure);
        if (!this.getStartActivities(null).hasNext()) {
            VerificationError.createVerificationError(pCtx, this, "WF_START_ACTIVITIES_NOTFOUND", this.getFullName(), pStopOnFailure);
        }
        if (!this.hasEndActivity()) {
            VerificationError.createVerificationError(pCtx, this, "WF_END_ACTIVITIES_NOTFOUND", this.getFullName(), pStopOnFailure);
        }
        if (this.isRecursivelyUsed()) {
            VerificationError.createVerificationError(pCtx, this, "WF_RECURSIVE_SUB_PROCESS", this.getFullName(), pStopOnFailure);
        }
    }

    private boolean isRecursivelyUsed() {
        Iterator iter = this.getProcessActivities();
        while (iter.hasNext()) {
            ProcessActivity pa = (ProcessActivity)iter.next();
            if (pa.getActivity() != this) continue;
            return true;
        }
        return false;
    }

    private boolean hasEndActivity() {
        Iterator iter = this.getProcessActivities();
        while (iter.hasNext()) {
            ProcessActivity pa = (ProcessActivity)iter.next();
            if (!pa.isEndNode()) continue;
            return true;
        }
        return false;
    }

    public void setDiagramContent(String pDiagramContent) {
        this.mDiagramContent = pDiagramContent;
    }

    public String getDiagramContent() {
        return this.mDiagramContent;
    }
}

