/*
 * Decompiled with CFR 0.152.
 */
package oracle.apps.fnd.wf.design;

import java.util.List;
import oracle.apps.fnd.wf.common.WorkflowContext;
import oracle.apps.fnd.wf.common.WorkflowException;
import oracle.apps.fnd.wf.design.Attribute;
import oracle.apps.fnd.wf.design.AttributeValue;
import oracle.apps.fnd.wf.design.DesignBaseAttributeComponent;
import oracle.apps.fnd.wf.design.DesignBaseComponent;
import oracle.apps.fnd.wf.design.ItemType;
import oracle.apps.fnd.wf.design.MessageAttribute;
import oracle.apps.fnd.wf.design.MessageContent;
import oracle.apps.fnd.wf.design.VerificationError;

public class Message
extends DesignBaseAttributeComponent {
    public static final String RCS_ID = "$Header: /wfdev/wf/3.0/java/design/RCS/Message.java,v 30.3 2005/01/15 00:39:27 anpwang noship $";
    private String mSubject;
    private MessageContent mHtmlContent;
    private MessageContent mTextContent;
    private int mPriority = 50;
    private AttributeValue mResult;
    private String mReadRole;
    private String mWriteRole;
    private String mExecuteRole;

    public Message(String id) {
        super(id);
    }

    public Message() {
        super("");
    }

    public String getSubject() {
        return this.mSubject;
    }

    public void setSubject(String pSubject) {
        this.mSubject = pSubject;
    }

    public String getBody() {
        return this.getTextContent().getData();
    }

    public void setBody(String pBody) {
        this.getTextContent().setData(pBody);
    }

    public int getPriority() {
        return this.mPriority;
    }

    public void setPriority(int pPriority) {
        this.mPriority = pPriority;
    }

    public String getHtmlBody() {
        return this.getHTMLContent().getData();
    }

    private MessageContent getTextContent() {
        if (this.mTextContent == null) {
            List list = this.getChildrenByType(MessageContent.class);
            for (int i = 0; i < list.size(); ++i) {
                MessageContent mc = (MessageContent)list.get(i);
                if (!"TEXT".equals(mc.getContentType())) continue;
                this.mTextContent = mc;
                break;
            }
            if (this.mTextContent == null) {
                this.mTextContent = new MessageContent();
                this.mTextContent.setContentSubtype("DEFAULT");
                this.mTextContent.setContentType("TEXT");
                this.addChild(this.mTextContent);
            }
        }
        return this.mTextContent;
    }

    @Override
    public void loadChildren(WorkflowContext pCtx) throws WorkflowException {
        this.getChildrenByType(MessageAttribute.class);
        this.getChildrenByType(MessageContent.class);
        super.loadChildren(pCtx);
    }

    private MessageContent getHTMLContent() {
        if (this.mHtmlContent == null) {
            List list = this.getChildrenByType(MessageContent.class);
            for (int i = 0; i < list.size(); ++i) {
                MessageContent mc = (MessageContent)list.get(i);
                if (!"HTML".equals(mc.getContentType())) continue;
                this.mHtmlContent = mc;
                break;
            }
            if (this.mHtmlContent == null) {
                this.mHtmlContent = new MessageContent();
                this.mHtmlContent.setContentSubtype("DEFAULT");
                this.mHtmlContent.setContentType("HTML");
                this.addChild(this.mHtmlContent);
            }
        }
        return this.mHtmlContent;
    }

    public void setHtmlBody(String pHtmlBody) {
        this.getHTMLContent().setData(pHtmlBody);
    }

    public Attribute getAttribute(String attrName) {
        return (Attribute)this.getChildByTypeAndName(MessageAttribute.class, attrName);
    }

    public String getReadRole() {
        return this.mReadRole;
    }

    public void setReadRoleName(String pRoleName) {
        this.mReadRole = pRoleName;
    }

    public String getWriteRole() {
        return this.mWriteRole;
    }

    public void setWriteRoleName(String pRoleName) {
        this.mReadRole = pRoleName;
    }

    public String getExecuteRole() {
        return this.mExecuteRole;
    }

    public void setExecuteRoleName(String pRoleName) {
        this.mReadRole = pRoleName;
    }

    public ItemType getItemType() {
        return (ItemType)this.getParent();
    }

    @Override
    public void saveChildren(WorkflowContext pCtx) throws WorkflowException {
        List list = this.getChildrenByType(MessageAttribute.class);
        for (DesignBaseComponent element : list) {
            element.save(pCtx);
        }
    }

    public List getMessageAttributes() {
        return this.getChildrenByType(Attribute.class);
    }

    @Override
    public void verify(WorkflowContext pCtx, boolean pStopOnFailure) throws WorkflowException {
        super.verify(pCtx, pStopOnFailure);
        if (this.getDisplayName() == null || this.getDisplayName().length() == 0) {
            VerificationError.createVerificationError(pCtx, this, "WF_FIELD_REQUIRED", "displayName", pStopOnFailure);
        }
        if (this.getSubject() == null || this.getSubject().length() == 0) {
            VerificationError.createVerificationError(pCtx, this, "WF_FIELD_REQUIRED", "subject", pStopOnFailure);
        }
    }
}

