/*
 * Decompiled with CFR 0.152.
 */
package oracle.apps.fnd.wf.design;

import java.util.List;
import oracle.apps.fnd.wf.common.WorkflowContext;
import oracle.apps.fnd.wf.common.WorkflowException;
import oracle.apps.fnd.wf.design.Activity;
import oracle.apps.fnd.wf.design.Function;
import oracle.apps.fnd.wf.design.VerificationError;
import oracle.apps.fnd.wf.design.Version;

public class FunctionActivity
extends Activity {
    public static final String RCS_ID = "$Header: /wfdev/wf/3.0/java/design/RCS/FunctionActivity.java,v 30.3 2004/12/13 20:37:08 anpwang noship $";

    public FunctionActivity() {
    }

    public FunctionActivity(String id) {
        super(id);
    }

    public FunctionActivity(String id, Activity pAct) {
        super(id);
        this.copyActivity(pAct);
    }

    @Override
    public String getFunctionType() {
        String parentFcnType = super.getFunctionType();
        if (parentFcnType == null) {
            this.setFunctionType("PL/SQL");
        } else {
            this.setFunctionType(parentFcnType);
        }
        return parentFcnType;
    }

    @Override
    public String getType() {
        return "FUNCTION";
    }

    @Override
    public void resolveReference(Version pVersion) {
        super.resolveReference(pVersion);
        List fcnList = this.getChildrenByType(Function.class);
        if (fcnList == null || fcnList.isEmpty()) {
            Function newFunction = new Function("RUN");
            newFunction.setFunctionName(this.getTempFunction());
            newFunction.setFunctionType(this.getFunctionType());
            this.addChild(newFunction);
        }
    }

    @Override
    public void verify(WorkflowContext pCtx, boolean pStopOnFailure) throws WorkflowException {
        Function function;
        super.verify(pCtx, pStopOnFailure);
        if (this.getFunctionType() == null || this.getFunctionType().length() == 0) {
            VerificationError.createVerificationError(pCtx, this, "WF_FIELD_REQUIRED", "functionType", pStopOnFailure);
        }
        if ((function = this.getFunction("RUN")) == null) {
            VerificationError.createVerificationError(pCtx, this, "WF_FIELD_REQUIRED", "runfunction", pStopOnFailure);
        }
    }
}

