/*
 * Decompiled with CFR 0.152.
 */
package oracle.apps.fnd.wf.design;

import oracle.apps.fnd.wf.design.Activity;
import oracle.apps.fnd.wf.design.ActivityAttribute;
import oracle.apps.fnd.wf.design.DesignBaseComponent;
import oracle.apps.fnd.wf.design.Function;

public class EventActivity
extends Activity {
    public static final String DB_EVENT_MESSAGE_ATTR_NAME = "#EVENTMESSAGE";
    public static final String DB_EVENT_KEY_ATTR_NAME = "#EVENTKEY";
    public static final String DB_EVENT_NAME_ATTR_NAME = "#EVENTNAME";
    public static final String DB_EVENT_TO_AGENT_ATTR_NAME = "#EVENTTOAGENT";
    public static final String DB_EVENT_OUT_AGENT_ATTR_NAME = "#EVENTOUTAGENT";
    String mFilter;
    String mAction;

    public EventActivity() {
    }

    public EventActivity(String id) {
        super(id);
    }

    private void addInternalAttribute(String pAttributeName, String pValueType) {
        ActivityAttribute attribute = new ActivityAttribute(pAttributeName);
        attribute.setValueType("CONSTANT");
        attribute.setName("java.util.String");
        attribute.setDirection("LOCAL");
        attribute.setDefaultValue("");
        this.addChild(attribute);
    }

    @Override
    public void assign(DesignBaseComponent comp) {
        super.assign(comp);
        if (comp instanceof EventActivity) {
            EventActivity ea = (EventActivity)comp;
            this.setFilter(ea.getFilter());
            this.setAction(ea.getAction());
        }
    }

    @Override
    public String getType() {
        return "EVENT";
    }

    public void setFilter(String filter) {
        this.mFilter = filter;
    }

    public String getFilter() {
        return this.mFilter;
    }

    public void setAction(String action) {
        this.mAction = action;
        boolean isNew = false;
        Function newFunction = this.getFunction("RUN");
        if (newFunction == null) {
            newFunction = new Function("RUN");
            isNew = true;
        }
        if ("RECEIVE".equals(this.mAction)) {
            newFunction.setFunctionName("oracle.apps.fnd.wf.engine.standard.StandardEvent.receive");
        }
        if ("SEND".equals(this.mAction)) {
            newFunction.setFunctionName("oracle.apps.fnd.wf.engine.standard.StandardEvent.notify");
        }
        if ("RAISE".equals(this.mAction)) {
            newFunction.setFunctionName("oracle.apps.fnd.wf.engine.standard.StandardEvent.raise");
        }
        newFunction.setFunctionType("EXTJAVA");
        if (isNew) {
            this.addChild(newFunction);
        }
    }

    public String getAction() {
        return this.mAction;
    }
}

