/*
 * Decompiled with CFR 0.152.
 */
package oracle.apps.fnd.wf.design;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.List;
import oracle.apps.fnd.wf.common.Element;
import oracle.apps.fnd.wf.common.Loader;
import oracle.apps.fnd.wf.common.Store;
import oracle.apps.fnd.wf.common.StoreManager;
import oracle.apps.fnd.wf.common.WorkflowContext;
import oracle.apps.fnd.wf.common.WorkflowException;
import oracle.apps.fnd.wf.common.WorkflowRuntimeException;
import oracle.apps.fnd.wf.design.DesignBaseComponent;
import oracle.apps.fnd.wf.design.ItemType;
import oracle.apps.fnd.wf.design.LookupTypes;
import oracle.apps.fnd.wf.design.Role;
import oracle.apps.fnd.wf.design.WFCharSetMapper;

public class DesignStore
extends DesignBaseComponent
implements Store {
    public static final String RCS_ID = "$Header: /wfdev/wf/3.0/java/design/RCS/DesignStore.java,v 30.11 2005/01/15 00:26:35 anpwang noship $";
    private String mMajorVersion;
    private String mMinorVersion;
    private String mLanguage;
    private int mAccessLevel;
    private boolean mLoaded = false;
    private String mStoreLocation;
    private String mStoreType;
    private Loader mLoader;
    private String mCharSet;
    private WorkflowContext mContext;
    private static Hashtable loader2Class = new Hashtable();

    public static DesignStore getInstance(WorkflowContext pCtx) throws WorkflowException {
        String storeType = "WF_WFT";
        if (storeType == null || !"WF_DB".equals(storeType) && !"WF_XML".equals(storeType) && !"WF_WFT".equals(storeType)) {
            throw new WorkflowException(pCtx, DesignStore.class, "Store.getInstance.invalid store type");
        }
        String storeLocation = pCtx.getStoreLocation();
        if (storeLocation != null) {
            DesignStore designStore = (DesignStore)StoreManager.getInstance().getStore(pCtx, DesignStore.class, storeLocation);
            designStore.setStoreLocation(storeLocation);
            designStore.setStoreType(storeType);
            designStore.setName(storeLocation);
            designStore.mContext = pCtx;
            designStore.setCharset(storeLocation);
            try {
                designStore.setLoader();
                designStore.loadStore(pCtx);
            }
            catch (Exception e) {
                e.printStackTrace();
                HashMap<String, String> map = new HashMap<String, String>();
                map.put("NAME", storeLocation);
                throw new WorkflowException(pCtx, DesignStore.class, "WF_DESIGN_ENTITY_ERROR", map, e);
            }
            return designStore;
        }
        throw new WorkflowException(pCtx, DesignStore.class, "WF_DESIGN_ENTITY_ERROR");
    }

    public String getAccessLevel() {
        return "" + this.mAccessLevel;
    }

    public void setAccessLevel(String pAccessLevel) {
        this.mAccessLevel = Integer.parseInt(pAccessLevel);
    }

    public String getMajorVersion() {
        return this.mMajorVersion;
    }

    public void setMajorVersion(String pMajorVersion) {
        this.mMajorVersion = pMajorVersion;
    }

    public String getMinorVersion() {
        return this.mMinorVersion;
    }

    public void setMinorVersion(String pMinorVersion) {
        this.mMinorVersion = pMinorVersion;
    }

    public String getLanguage() {
        return this.mLanguage;
    }

    public void setLanguage(String pLanguage) {
        this.mLanguage = pLanguage;
    }

    @Override
    public String getStoreLocation() {
        return this.mStoreLocation;
    }

    @Override
    public void setStoreLocation(String pStoreLocation) {
        this.mStoreLocation = pStoreLocation;
    }

    public void setStoreType(String pStoreType) {
        this.mStoreType = pStoreType;
    }

    public String getStoreType() {
        return this.mStoreType;
    }

    public synchronized void loadStore(WorkflowContext pWFContext) throws WorkflowException {
        if (!this.mLoaded) {
            if (this.mLoader == null) {
                throw new WorkflowException(this.mContext, this, "Loader.NotFound[" + this.mStoreType + "]");
            }
            this.mLoader.load(pWFContext, this);
            this.mLoaded = true;
        }
    }

    public synchronized void saveStore(WorkflowContext pWFContext) throws Exception {
        if (this.mLoader == null) {
            throw new WorkflowException(this.mContext, this, "Loader.NotFound[" + this.mStoreType + "]");
        }
        this.mLoader.save(pWFContext, this);
    }

    @Override
    public String getDisplayName() {
        return this.toString();
    }

    public WorkflowContext getContext() {
        return this.mContext;
    }

    public LookupTypes getLookupTypes(String pLookupTypeName) {
        if (pLookupTypeName == null || pLookupTypeName.length() == 0) {
            throw new IllegalArgumentException("LookupType.Name.MustProvided");
        }
        LookupTypes currentObject = (LookupTypes)super.getChildByTypeAndName(LookupTypes.class, pLookupTypeName);
        WorkflowContext ctx = this.getContext();
        if (currentObject == null) {
            try {
                currentObject = (LookupTypes)this.getLoader().loadChild(ctx, this, LookupTypes.class, pLookupTypeName);
            }
            catch (WorkflowException e) {
                throw new WorkflowRuntimeException(ctx, (Object)this, "WF_DESIGN_ENTITY_ERROR", e);
            }
        }
        try {
            this.getLoader().synch(ctx, currentObject);
        }
        catch (WorkflowException e) {
            throw new WorkflowRuntimeException(ctx, (Object)this, "WF_DESIGN_ENTITY_ERROR", e);
        }
        return currentObject;
    }

    public ItemType getItemType(String pItemName) {
        if (pItemName == null || pItemName.length() == 0) {
            throw new IllegalArgumentException("ItemType.Name.MustProvided");
        }
        ItemType currentObject = (ItemType)super.getChildByTypeAndName(ItemType.class, pItemName);
        WorkflowContext ctx = this.getContext();
        if (currentObject == null) {
            try {
                currentObject = (ItemType)this.getLoader().loadChild(ctx, this, ItemType.class, pItemName);
            }
            catch (WorkflowException e) {
                throw new WorkflowRuntimeException(ctx, (Object)this, "WF_DESIGN_ENTITY_ERROR", e);
            }
        }
        try {
            this.getLoader().synch(ctx, currentObject);
        }
        catch (WorkflowException e) {
            throw new WorkflowRuntimeException(ctx, (Object)this, "WF_DESIGN_ENTITY_ERROR", e);
        }
        return currentObject;
    }

    @Override
    public Store getStore() {
        return this;
    }

    public List getItemTypes() {
        try {
            return this.getChildrenByType(ItemType.class);
        }
        catch (Exception e) {
            throw new WorkflowRuntimeException(this, "Get.ItemTypes.Failed", e);
        }
    }

    public List getRoles() {
        try {
            return this.getChildrenByType(Role.class);
        }
        catch (Exception e) {
            throw new WorkflowRuntimeException(this, "Get.Roles.Failed", e);
        }
    }

    public void setLoader() throws Exception {
        if (this.mLoader != null) {
            return;
        }
        if (this.mStoreType == null) {
            throw new WorkflowException(this.mContext, this, "Store.setLoader.StoreType.NotFound");
        }
        if (!("WF_XML".equals(this.mStoreType) || "WF_WFT".equals(this.mStoreType) || "WF_DB".equals(this.mStoreType))) {
            throw new WorkflowException(this.mContext, this, "Store.loadStore.invalid store type");
        }
        this.mLoader = (Loader)Class.forName((String)loader2Class.get(this.mStoreType)).newInstance();
    }

    @Override
    public Loader getLoader() {
        return this.mLoader;
    }

    @Override
    public final void load(WorkflowContext pCtx, Element pComponent) throws WorkflowException {
        if (this.getLoader() == null) {
            throw new WorkflowException(this.mContext, this, "Store.load.noLoaders");
        }
        if (pComponent == null) {
            throw new WorkflowException(this.mContext, this, "Store.load.noComonent");
        }
        this.getLoader().load(pCtx, pComponent);
    }

    @Override
    public final void save(WorkflowContext pCtx, Element pComponent) throws WorkflowException {
        if (this.getLoader() == null) {
            throw new WorkflowException(this.mContext, this, "Store.save.noLoaders");
        }
        if (pComponent == null) {
            throw new WorkflowException(this.mContext, this, "Store.save.noComponent");
        }
        this.getLoader().save(pCtx, pComponent);
    }

    @Override
    public final void create(WorkflowContext pCtx, Element pComponent) throws WorkflowException {
        this.mContext = pCtx;
        if (this.getLoader() == null) {
            throw new WorkflowException(this.mContext, this, "Store.create.noLoaders");
        }
        if (pComponent == null) {
            throw new WorkflowException(this.mContext, this, "Store.create.noComonent");
        }
        this.getLoader().create(pCtx, pComponent);
    }

    private void setCharset(String storageLocation) {
        URL storageURL;
        if (storageLocation == null) {
            throw new IllegalStateException("Could not load store, as persistent media does not exsit");
        }
        if (storageLocation.indexOf(":") == -1) {
            storageURL = this.getClass().getResource(storageLocation);
        } else {
            try {
                storageURL = new URL(storageLocation);
            }
            catch (MalformedURLException e) {
                throw new WorkflowRuntimeException(this, "setCharSet", e);
            }
        }
        if (storageURL == null) {
            throw new WorkflowRuntimeException(this, "Could not load store, as persistent media does not exsit " + storageLocation);
        }
        try {
            InputStream ip = storageURL.openStream();
            BufferedReader br = new BufferedReader(new InputStreamReader(ip));
            String lineRead = br.readLine();
            String langStr = "";
            int lineCtr = 1;
            while (lineRead != null) {
                if (lineRead.contains("LANGUAGE =")) {
                    langStr = lineRead.substring(lineRead.indexOf("LANGUAGE =") + 12);
                    if (langStr.charAt(0) == '\"') {
                        langStr = langStr.substring(1);
                    }
                    if (langStr.charAt(langStr.length() - 1) == '\"') {
                        langStr = langStr.substring(0, langStr.length() - 1);
                    }
                    WFCharSetMapper mapper = new WFCharSetMapper();
                    this.mCharSet = mapper.getCharSet(langStr);
                    break;
                }
                lineRead = br.readLine();
                ++lineCtr;
            }
        }
        catch (IOException e) {
            throw new WorkflowRuntimeException(this, "setCharSet", e);
        }
    }

    public String getCharSet() {
        return this.mCharSet;
    }

    static {
        String pkgName = "oracle.apps.fnd.wf.design.loader.";
        loader2Class.put("WF_WFT", pkgName + "wft.WFLoader");
        loader2Class.put("WF_XML", pkgName + "mds.MDSLoader");
        loader2Class.put("WF_DB", pkgName + "db.DBLoader");
    }
}

