/*
 * Decompiled with CFR 0.152.
 */
package oracle.apps.fnd.wf.design;

import oracle.apps.fnd.wf.common.BaseComponent;
import oracle.apps.fnd.wf.design.Attribute;
import oracle.apps.fnd.wf.design.DesignBaseComponent;
import oracle.apps.fnd.wf.design.ItemType;
import oracle.apps.fnd.wf.design.ProcessActivity;
import oracle.apps.fnd.wf.design.Version;

public class AttributeValue
extends DesignBaseComponent {
    public static final String RCS_ID = "$Header: /wfdev/wf/3.0/java/design/RCS/AttributeValue.java,v 30.8 2005/01/15 00:26:32 anpwang noship $";
    private String mValueType = "CONSTANT";
    private Object mValue;
    private String mItemName;
    private String mAttributeName;
    protected Attribute mAttribute;

    public AttributeValue(String id) {
        super(id);
    }

    public AttributeValue() {
    }

    public String getValueType() {
        return this.mValueType;
    }

    public void setValueType(String pValueType) {
        if (pValueType != null && ("CONSTANT".equals(pValueType) || "ITEMATTR".equals(pValueType) || "DEFER".equals(pValueType) || "NOTSET".equals(pValueType))) {
            this.mValueType = pValueType;
        }
    }

    public Object getValue() {
        return this.mValue;
    }

    public void setValue(Object pValue) {
        this.mValue = pValue;
    }

    public String getItemName() {
        return this.mItemName;
    }

    public void setItemName(String pItemName) {
        this.mItemName = pItemName;
    }

    void setMetaType(Attribute pAttribute) {
        this.mAttribute = pAttribute;
    }

    public Attribute getAttribute() {
        return this.mAttribute;
    }

    public BaseComponent getOwner() {
        return this.getParent();
    }

    @Override
    public void resolveReference(Version pVersion) {
        ProcessActivity node;
        this.mResolved = true;
        if (this.getParent() instanceof ProcessActivity) {
            node = (ProcessActivity)this.getParent();
            this.mAttribute = node.getActivity(pVersion).getAttribute(this.getAttributeName());
        } else if (this.getParent() instanceof ItemType) {
            ItemType it = (ItemType)this.getParent();
            this.mAttribute = it.getAttribute(this.getName());
        }
        if (this.mAttribute == null) {
            this.mAttribute = new Attribute(this.getName());
            this.mAttribute.setType("VARCHAR2");
            if (this.mValue != null) {
                this.mAttribute.setNativeType(this.mValue.getClass().getName());
            } else {
                this.mAttribute.setNativeType("java.lang.String");
            }
            if (this.getParent() instanceof ProcessActivity) {
                node = (ProcessActivity)this.getParent();
                node.getActivity(pVersion).addChild(this.mAttribute);
            }
        }
        if ("ITEMATTR".equals(this.mValueType)) {
            if (this.mValue != null) {
                this.mItemName = this.mValue.toString();
                this.mValue = null;
            }
        } else if (this.mValue != null) {
            this.setValue(this.mValue);
        }
        super.resolveReference(pVersion);
    }

    public Object clone() {
        try {
            AttributeValue av = (AttributeValue)this.getClass().newInstance();
            av.assign(this);
            return av;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public void assignItemAttrValue(AttributeValue pItemAttrValue) {
        this.mItemName = pItemAttrValue.getName();
        this.mValue = pItemAttrValue.getValue();
    }

    @Override
    public String toString() {
        return this.mAttributeName;
    }

    public void assign(AttributeValue pComponent) {
        super.assign(pComponent);
        this.setName(pComponent.getName());
        this.mItemName = pComponent.mItemName;
        this.mValueType = pComponent.getValueType();
        this.mAttribute = pComponent.getAttribute();
        this.mValue = pComponent.getValue();
        this.mResolved = pComponent.mResolved;
    }

    public void setAttributeName(String pAttributeName) {
        this.mAttributeName = pAttributeName;
    }

    public String getAttributeName() {
        return this.mAttributeName;
    }

    @Override
    public String getName() {
        if (this.mAttribute != null) {
            return this.mAttribute.getName();
        }
        return super.getName();
    }
}

