/*
 * Decompiled with CFR 0.152.
 */
package oracle.apps.fnd.wf.design;

import java.util.Calendar;
import java.util.Date;
import java.util.List;
import oracle.apps.fnd.wf.common.WorkflowContext;
import oracle.apps.fnd.wf.common.WorkflowException;
import oracle.apps.fnd.wf.common.WorkflowRuntimeException;
import oracle.apps.fnd.wf.design.ActivityAttribute;
import oracle.apps.fnd.wf.design.Attribute;
import oracle.apps.fnd.wf.design.DesignBaseAttributeComponent;
import oracle.apps.fnd.wf.design.DesignBaseComponent;
import oracle.apps.fnd.wf.design.EventActivity;
import oracle.apps.fnd.wf.design.FunctionActivity;
import oracle.apps.fnd.wf.design.ItemType;
import oracle.apps.fnd.wf.design.LookupType;
import oracle.apps.fnd.wf.design.Notification;
import oracle.apps.fnd.wf.design.Process;
import oracle.apps.fnd.wf.design.VerificationError;

public abstract class Activity
extends DesignBaseAttributeComponent {
    public static final String RCS_ID = "$Header: /wfdev/wf/3.0/java/design/RCS/Activity.java,v 30.4 2005/01/15 00:26:30 anpwang noship $";
    private int mCost;
    private String mIconName;
    private Calendar mBeginDate;
    private Calendar mEndDate;
    private String mResult;
    private String mErrorProcess;
    private String mMessageName;
    private String mErrorItemType = "WFJERROR";
    private String mActionOnRevisit;
    private String mFunctionType;
    private String mTFunction;
    private boolean mIsRunnable = false;
    private String mReadRole;
    private String mWriteRole;
    private String mExecuteRole;
    public static final String FUNCTION_TYPE = "FUNCTION";
    public static final String PROCESS_TYPE = "PROCESS";
    public static final String NOTIFICATION_TYPE = "NOTICE";
    public static final String EVENT_TYPE = "EVENT";

    public Activity() {
    }

    public Activity(String id) {
        super(id);
    }

    public void copyActivity(Activity pAct) {
        if (pAct != null) {
            this.setVersion(pAct.getVersion());
            this.setIconName(pAct.getIconName());
            this.setBeginDate(pAct.getBeginDate());
            this.setEndDate(pAct.getEndDate());
            this.setResult(pAct.getResult());
            this.setActionOnRevisit(pAct.getActionOnRevisit());
            this.setCost(pAct.getCost());
            this.setErrorProcess(pAct.getErrorProcess());
            this.setReadRole(pAct.getReadRole());
            this.setWriteRole(pAct.getWriteRole());
            this.setExecuteRole(pAct.getExecuteRole());
            this.setMessageName(pAct.getMessageName());
            this.setErrorItemType(pAct.getErrorItemType());
            this.setFunctionType(pAct.getFunctionType());
            this.setTempFunction(pAct.getTempFunction());
        }
    }

    public String getIconName() {
        if (this.mIconName != null) {
            return this.mIconName;
        }
        if (this instanceof FunctionActivity) {
            return "FUNCTION.ICO";
        }
        if (this instanceof Process) {
            return "PROCESS.ICO";
        }
        if (this instanceof EventActivity) {
            return "EVENT.ICO";
        }
        if (this instanceof Notification) {
            return "NOTIFY.ICO";
        }
        return "DEFAULT.ICO";
    }

    public void setIconName(String pIconName) {
        this.mIconName = pIconName;
    }

    public Calendar getBeginDate() {
        return this.mBeginDate;
    }

    public void setBeginDate(Calendar pBeginDate) {
        if (pBeginDate != null) {
            this.mBeginDate = (Calendar)pBeginDate.clone();
        }
    }

    public Calendar getEndDate() {
        return this.mEndDate;
    }

    public void setEndDate(Calendar pEndDate) {
        if (pEndDate != null) {
            this.mEndDate = (Calendar)pEndDate.clone();
        }
    }

    public String getResult() {
        return this.mResult;
    }

    public void setResult(String pResult) {
        this.mResult = pResult;
    }

    public int getCost() {
        return this.mCost;
    }

    public void setCost(int pCost) {
        this.mCost = pCost;
    }

    public List getAttributes() {
        try {
            return this.getChildrenByType(ActivityAttribute.class);
        }
        catch (WorkflowRuntimeException e) {
            throw new WorkflowRuntimeException(this, "Attributes.Loading.Failed", e.getRootException());
        }
    }

    public Attribute getAttribute(String attrName) {
        return (Attribute)this.getChildByTypeAndName(ActivityAttribute.class, attrName);
    }

    public String getReadRole() {
        return this.mReadRole;
    }

    public void setReadRole(String pReadRole) {
        this.mReadRole = pReadRole;
    }

    public String getWriteRole() {
        return this.mWriteRole;
    }

    public void setWriteRole(String pWriteRole) {
        this.mWriteRole = pWriteRole;
    }

    public String getExecuteRole() {
        return this.mExecuteRole;
    }

    public void setExecuteRole(String pExecuteRole) {
        this.mExecuteRole = pExecuteRole;
    }

    public String getErrorProcess() {
        return this.mErrorProcess;
    }

    public void setErrorProcess(String pErrorProcess) {
        this.mErrorProcess = pErrorProcess;
    }

    public String getErrorItemType() {
        return this.mErrorItemType;
    }

    public void setErrorItemType(String pErrorItemType) {
        this.mErrorItemType = pErrorItemType;
    }

    public String getActionOnRevisit() {
        return this.mActionOnRevisit;
    }

    public void setActionOnRevisit(String pActionOnRevisit) {
        this.mActionOnRevisit = pActionOnRevisit;
    }

    public String getFunctionType() {
        return this.mFunctionType;
    }

    public void setFunctionType(String pFunctionType) {
        this.mFunctionType = pFunctionType;
    }

    public String getMessageName() {
        return this.mMessageName;
    }

    public void setMessageName(String pMessageName) {
        this.mMessageName = pMessageName;
    }

    public String getTempFunction() {
        return this.mTFunction;
    }

    public void setTempFunction(String pFunctionName) {
        this.mTFunction = pFunctionName;
    }

    public boolean isRunnable() {
        return this.mIsRunnable;
    }

    public void setRunnable(boolean pIsRunnable) {
        this.mIsRunnable = pIsRunnable;
    }

    public ItemType getItemType() {
        return (ItemType)this.getParent();
    }

    public LookupType getLookupType() {
        for (LookupType comp : this.getParent().getChildrenByType(LookupType.class)) {
            if (!comp.getName().equals(this.getResult())) continue;
            return comp;
        }
        return null;
    }

    public abstract String getType();

    boolean checkVersion(Date pDate) {
        if (pDate == null) {
            return this.mEndDate == null;
        }
        long testTime = pDate.getTime();
        long beginDate = this.mBeginDate == null ? testTime - 10L : this.mBeginDate.getTime().getTime();
        long endDate = this.mEndDate == null ? testTime + 10L : this.mEndDate.getTime().getTime();
        return testTime >= beginDate && testTime < endDate;
    }

    public void assign(DesignBaseComponent pComponent) {
        super.assign(pComponent);
        if (pComponent instanceof Activity) {
            Activity activity = (Activity)pComponent;
            this.setId(activity.getId());
            this.setVersion(activity.getVersion());
            this.setIconName(activity.getIconName());
            this.setResult(activity.getResult());
            this.setCost(activity.getCost());
            this.setErrorItemType(activity.getErrorItemType());
            this.setErrorProcess(activity.getErrorProcess());
            this.setActionOnRevisit(activity.getActionOnRevisit());
        }
    }

    @Override
    public void saveChildren(WorkflowContext pCtx) throws WorkflowException {
        List list = this.getChildrenByType(ActivityAttribute.class);
        for (DesignBaseComponent element : list) {
            element.save(pCtx);
        }
        for (DesignBaseComponent element : list) {
            element.saveChildren(pCtx);
        }
    }

    @Override
    public String getName() {
        return super.getName().toUpperCase();
    }

    @Override
    public void loadChildren(WorkflowContext pCtx) throws WorkflowException {
        this.getChildrenByType(ActivityAttribute.class);
        super.loadChildren(pCtx);
    }

    @Override
    public void verify(WorkflowContext pCtx, boolean pStopOnFailure) throws WorkflowException {
        String name;
        super.verify(pCtx, pStopOnFailure);
        if (this.getDisplayName() == null || this.getDisplayName().length() == 0) {
            VerificationError.createVerificationError(pCtx, this, "WF_FIELD_REQUIRED", "displayName", pStopOnFailure);
        }
        if ((name = this.getName()).length() > 240) {
            VerificationError.createVerificationError(pCtx, this, "WF_FIELD_LENGTH_ERROR", "activityName < 240", pStopOnFailure);
        }
        if (this.mResult != null && this.mResult.length() > 30) {
            VerificationError.createVerificationError(pCtx, this, "WF_FIELD_LENGTH_ERROR", "resultType", pStopOnFailure);
        }
        if (!name.equals(name.toUpperCase())) {
            System.err.println(name + '=' + name.toUpperCase());
            VerificationError.createVerificationError(pCtx, this, "WF_ILLEGAL_NAMING_ERROR", "internalName : " + name, pStopOnFailure);
        }
    }
}

