/*
 * Decompiled with CFR 0.152.
 */
package oracle.apps.fnd.wf.common;

import java.io.IOException;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.io.Serializable;
import java.util.Map;
import oracle.apps.fnd.wf.common.WorkflowContext;
import oracle.apps.fnd.wf.common.WorkflowException;

public class WorkflowRuntimeException
extends RuntimeException
implements Serializable {
    public static final String RCS_ID = "$Header: /wfdev/wf/3.0/java/common/RCS/WorkflowRuntimeException.java,v 30.5 2004/12/14 00:40:26 anpwang noship $";
    private Throwable mCausingError;
    private Object mSource;

    public WorkflowRuntimeException(String message) {
        super(message);
    }

    public WorkflowRuntimeException(WorkflowContext pCtx, Object pSource, String pMessage) {
        super(WorkflowException.getMessage(pCtx, pMessage, null));
        this.mSource = pSource;
    }

    public WorkflowRuntimeException(WorkflowContext pCtx, Object pSource, String pMessage, Throwable pError) {
        super(WorkflowException.getMessage(pCtx, pMessage, null));
        this.mSource = pSource;
        this.mCausingError = pError;
    }

    public WorkflowRuntimeException(WorkflowContext pCtx, Object pSource, String pMessage, Map pMap) {
        super(WorkflowException.getMessage(pCtx, pMessage, pMap));
        this.mSource = pSource;
    }

    public WorkflowRuntimeException(Object source, String msg) {
        super(msg);
    }

    public WorkflowRuntimeException(Object pSource, String pMessage, Throwable pException) {
        super(pMessage);
        this.setRootCause(pSource, pException);
    }

    public WorkflowRuntimeException(Throwable pException) {
        super(pException.getMessage());
        this.setRootCause(null, pException);
    }

    public Object getSource() {
        return this.mSource;
    }

    public Throwable getRootException() {
        if (this.mCausingError != null && this.mCausingError instanceof WorkflowException) {
            return ((WorkflowException)this.mCausingError).getRootException();
        }
        if (this.mCausingError == null) {
            return this;
        }
        return this.mCausingError;
    }

    private void setRootCause(Object pSource, Throwable pException) {
        this.mCausingError = pException;
        this.mSource = pSource;
    }

    @Override
    public void printStackTrace(PrintStream pPrintStream) {
        if (this.mCausingError == null || this.mCausingError == this) {
            this.writeMessage(pPrintStream);
        } else if (this.mCausingError instanceof WorkflowException) {
            this.mCausingError.printStackTrace(pPrintStream);
        } else {
            try {
                String mTest = "Root Exception:\n\n";
                pPrintStream.write(mTest.getBytes());
                this.getRootException().printStackTrace(pPrintStream);
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    void writeMessage(PrintStream pPrintStream) {
        try {
            pPrintStream.write(this.getMessage().getBytes());
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    @Override
    public void printStackTrace() {
        this.printStackTrace(System.err);
    }

    @Override
    public void printStackTrace(PrintWriter pPrintWriter) {
        if (this.getRootException() == null || this.getRootException() == this) {
            super.printStackTrace(pPrintWriter);
        } else {
            String mTest = "Root Exception:\n";
            super.printStackTrace(pPrintWriter);
            pPrintWriter.write(mTest.toCharArray());
            this.getRootException().printStackTrace(pPrintWriter);
        }
    }
}

