/*
 * Decompiled with CFR 0.152.
 */
package oracle.apps.fnd.wf.common;

import java.io.IOException;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.io.Serializable;
import java.util.Map;
import oracle.apps.fnd.wf.common.WorkflowContext;

public class WorkflowException
extends Exception
implements Serializable {
    public static final String RCS_ID = "$Header: /wfdev/wf/3.0/java/common/RCS/WorkflowException.java,v 30.11 2005/01/17 22:22:10 anpwang noship $";
    private Throwable mCausingError;
    private Object mSource;

    public WorkflowException(String pMessage) {
        super(pMessage);
    }

    public WorkflowException(WorkflowContext pCtx, Object pSource, String pMessage, Map pTokens) {
        super(WorkflowException.getMessage(pCtx, pMessage, pTokens));
        this.mSource = pSource;
    }

    public WorkflowException(WorkflowContext pCtx, Object pSource, String pMessage) {
        super(WorkflowException.getMessage(pCtx, pMessage, null));
        this.mSource = pSource;
    }

    public WorkflowException(Object pSource, String pMessage) {
        super(pMessage);
        this.mSource = pSource;
    }

    public WorkflowException(WorkflowContext pCtx, Object pSource, String pMessage, Map pTokens, Throwable pException) {
        super(WorkflowException.getMessage(pCtx, pMessage, pTokens));
        this.setRootCause(pSource, pException);
    }

    public WorkflowException(Throwable pException) {
        super(pException.getMessage());
        this.setRootCause(null, pException);
    }

    public Throwable getRootException() {
        if (this.mCausingError != null && this.mCausingError instanceof WorkflowException) {
            return ((WorkflowException)this.mCausingError).getRootException();
        }
        if (this.mCausingError == null) {
            return this;
        }
        return this.mCausingError;
    }

    public Object getSource() {
        return this.mSource;
    }

    private void setRootCause(Object pSource, Throwable pException) {
        this.mCausingError = pException;
        this.mSource = pSource;
    }

    @Override
    public void printStackTrace(PrintStream pPrintStream) {
        if (this.getRootException() == null || this.getRootException() == this) {
            super.printStackTrace(pPrintStream);
        } else {
            try {
                pPrintStream.write(this.getMessage().getBytes());
                String mTest = "\nCaused By: ";
                pPrintStream.write(mTest.getBytes());
                if (this.mCausingError != null) {
                    this.mCausingError.printStackTrace(pPrintStream);
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    @Override
    public void printStackTrace() {
        this.printStackTrace(System.err);
    }

    @Override
    public void printStackTrace(PrintWriter pPrintWriter) {
        if (this.getRootException() == null || this.getRootException() == this) {
            super.printStackTrace(pPrintWriter);
        } else {
            String mTest = "Root Exception:\n";
            super.printStackTrace(pPrintWriter);
            pPrintWriter.write(mTest.toCharArray());
            this.getRootException().printStackTrace(pPrintWriter);
        }
    }

    public static String getMessage(WorkflowContext pCtx, String messageName, Map tokens) {
        if (messageName != null) {
            if (tokens != null) {
                for (String key : tokens.keySet()) {
                    messageName = messageName + "\n\tTOKEN :\t" + key + " = " + tokens.get(key);
                }
            }
            return messageName.toString();
        }
        return "WF_UNKOWN_ERROR";
    }
}

