/*
 * Decompiled with CFR 0.152.
 */
package oracle.apps.fnd.wf;

import java.sql.Connection;
import java.sql.Driver;
import java.sql.DriverManager;
import java.sql.SQLException;
import oracle.apps.fnd.wf.WFTestCase;
import oracle.apps.fnd.wf.common.WorkflowContext;
import oracle.jdbc.driver.OracleDriver;
import oracle.jdbc.pool.OracleDataSource;

public class WFTestCaseSetup {
    public static final String RCS_ID = "$Header: /wfdev/wf/3.0/java/ut/RCS/WFTestCaseSetup.java,v 30.6 2004/08/19 22:41:31 dlam noship $";
    protected static String database = "jdbc:oracle:thin:@ap593sun:1531:wf817";
    protected static String mDbcFileName;
    protected static String user;
    protected static String pwd;
    private static boolean initialized;
    static final String CMD_LINE_KEY = "WFTestCaseSetup.CmdlineArgs";
    private WorkflowContext mContext;
    private Connection mConn;
    private boolean mCommitFlag = false;
    private String mTestCaseName;

    public void setup() {
        if (!initialized) {
            String[] args = (String[])System.getProperties().get(CMD_LINE_KEY);
            if (args == null) {
                return;
            }
            WFTestCaseSetup.parseCmdline(args);
            mDbcFileName = System.getProperty("DBC_FILE_NAME");
            initialized = true;
        }
    }

    protected static void parseCmdline(String[] args) {
        if (args == null) {
            return;
        }
        for (int i = 0; i < args.length; ++i) {
            String arg = args[i];
            if (arg == null) continue;
            if (arg.length() == 0) {
                args[i] = null;
                continue;
            }
            if (!arg.startsWith("-")) continue;
            if (arg.startsWith("-user")) {
                user = args[++i];
                continue;
            }
            if (arg.startsWith("-pwd")) {
                pwd = args[++i];
                continue;
            }
            if (!arg.startsWith("-database")) continue;
            database = args[++i];
        }
    }

    protected void writeTestMessage(Object source, String msg) {
        System.out.println(msg);
    }

    protected void writeTestException(Object source, String msg) {
        System.out.println(msg);
    }

    public void setupTestCase(WFTestCase source) throws SQLException {
        if (this.mConn != null) {
            this.writeTestMessage(this, "Connection not release since last test");
            this.mConn.close();
            this.mConn = null;
        }
        this.mContext = new WorkflowContext(null);
        this.writeTestMessage(this, "\nStart Test " + ((Object)((Object)source)).getClass().getName() + "." + source.getName());
        this.writeTestMessage(this, "A new WorkflowContext is ready");
    }

    private Connection getConnection() throws SQLException {
        OracleDataSource ods = new OracleDataSource();
        ods.setUser(user);
        ods.setPassword(pwd);
        ods.setNetworkProtocol("tcp");
        ods.setURL(database);
        DriverManager.registerDriver((Driver)new OracleDriver());
        this.mConn = ods.getConnection();
        this.mConn.setAutoCommit(false);
        return this.mConn;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void tearDownTestCase(WFTestCase source) {
        if (this.getContext() != null) {
            try {
                if (this.mCommitFlag) {
                    this.writeTestMessage(this, "Current database transaction is committed.");
                } else {
                    this.writeTestMessage(this, "Current database transaction is rolled back.");
                }
                this.setTestCommit(false);
            }
            catch (Exception e) {
                e.printStackTrace(System.err);
                this.writeTestMessage(this, e.getMessage());
            }
        }
        this.writeTestMessage(this, "Done\n");
    }

    public String toString() {
        return "WorkflowSetup";
    }

    void setTestCommit(boolean pCommit) {
        this.mCommitFlag = pCommit;
    }

    protected WorkflowContext getContext() {
        return this.mContext;
    }

    static {
        user = "wf26";
        pwd = "wf26";
        initialized = false;
        user = System.getProperties().getProperty("DB_USER");
        pwd = System.getProperties().getProperty("DB_PASSWORD");
        database = System.getProperties().getProperty("DB_URL");
    }
}

