/*
 * Decompiled with CFR 0.152.
 */
package oracle.apps.fnd.wf;

import java.sql.Connection;
import java.util.Hashtable;
import oracle.apps.fnd.wf.WFDB;

public class WFContext {
    public static final String RCS_ID = "$Header: /wfdev/wf/3.0/java/RCS/WFContext.java,v 30.0 2003/06/14 00:53:37 dlam noship $";
    private Hashtable wJavaLangList;
    public String wCurrLangCode;
    public String wWebAgent;
    public boolean wAdminFlag;
    private Connection wConn = null;
    private WFDB wDB = null;

    public WFContext(String dbLangCode) {
        this.initCaches();
        this.wCurrLangCode = (String)this.wJavaLangList.get(dbLangCode);
    }

    public WFContext(WFDB pDB, String dbLangCode) {
        this.initCaches();
        this.wCurrLangCode = (String)this.wJavaLangList.get(dbLangCode);
        if (this.wCurrLangCode == null) {
            this.wCurrLangCode = "8859_1";
        }
        this.setDB(pDB);
    }

    public WFContext(String webAgent, String dbLangCode, boolean adminFlag) {
        this.initCaches();
        this.wCurrLangCode = (String)this.wJavaLangList.get(dbLangCode);
        if (this.wCurrLangCode == null) {
            this.wCurrLangCode = "8859_1";
        }
        this.wWebAgent = webAgent;
        this.wAdminFlag = adminFlag;
    }

    public String getCurrLangCode() {
        return this.wCurrLangCode;
    }

    public void setCurrLangCode(String lang) {
        this.wCurrLangCode = lang;
    }

    public String getWebAgent() {
        return this.wWebAgent;
    }

    public boolean getAdminFlag() {
        return this.wAdminFlag;
    }

    public void setJDBCConnection(Connection pConn) {
        if (this.wDB == null) {
            this.wDB = new WFDB();
        }
        this.wDB.setConnection(pConn);
    }

    public Connection getJDBCConnection() {
        if (this.wDB != null) {
            return this.wDB.getConnection();
        }
        return this.wConn;
    }

    public void setDB(WFDB pDB) {
        this.wDB = pDB;
    }

    public WFDB getDB() {
        return this.wDB;
    }

    private void initCaches() {
        this.wJavaLangList = new Hashtable();
        this.wJavaLangList.put("AL24UTFFSS", "UTF8");
        this.wJavaLangList.put("AL32UTF8", "UTF8");
        this.wJavaLangList.put("AR8ARABICMAC", "MacArabic");
        this.wJavaLangList.put("AR8ARABICMACS", "MacArabic");
        this.wJavaLangList.put("AR8ISO8859P6", "8859_6");
        this.wJavaLangList.put("AR8MSAWIN", "Cp1256");
        this.wJavaLangList.put("AR8MSWIN1256", "Cp1256");
        this.wJavaLangList.put("BLT8EBCDIC1112", "Cp1112");
        this.wJavaLangList.put("BLT8MSWIN1257", "Cp1257");
        this.wJavaLangList.put("BLT8PC775", "Cp775");
        this.wJavaLangList.put("CDN8PC863", "Cp863");
        this.wJavaLangList.put("CL8EBCDIC1025", "Cp1025");
        this.wJavaLangList.put("CL8EBCDIC1025X", "Cp1025");
        this.wJavaLangList.put("CL8ISO8859P5", "8859_5");
        this.wJavaLangList.put("CL8KOI8R", "KOI8_R");
        this.wJavaLangList.put("CL8MACCYRILLIC", "MacCyrillic");
        this.wJavaLangList.put("CL8MACCYRILLICS", "MacCyrillic");
        this.wJavaLangList.put("CL8MSWIN1251", "Cp1251");
        this.wJavaLangList.put("D8EBCDIC273", "Cp273");
        this.wJavaLangList.put("DK8EBCDIC277", "Cp277");
        this.wJavaLangList.put("EE8EBCDIC870", "Cp870");
        this.wJavaLangList.put("EE8ISO8859P2", "8859_2");
        this.wJavaLangList.put("EE8MACCE", "MacCentralEurope");
        this.wJavaLangList.put("EE8MACCES", "MacCentralEurope");
        this.wJavaLangList.put("EE8MACCROATIAN", "MacCroatian");
        this.wJavaLangList.put("EE8MACCROATIANS", "MacCroatian");
        this.wJavaLangList.put("EE8MSWIN1250", "Cp1250");
        this.wJavaLangList.put("EE8PC852", "Cp852");
        this.wJavaLangList.put("EL8EBCDIC875", "Cp875");
        this.wJavaLangList.put("EL8ISO8859P7", "8859_7");
        this.wJavaLangList.put("EL8MACGREEK", "MacGreek");
        this.wJavaLangList.put("EL8MACGREEKS", "MacGreek");
        this.wJavaLangList.put("EL8MSWIN1253", "Cp1253");
        this.wJavaLangList.put("EL8PC737", "Cp737");
        this.wJavaLangList.put("EL8PC869", "Cp869");
        this.wJavaLangList.put("EUCJIS", "8859_1");
        this.wJavaLangList.put("F8EBCDIC297", "Cp297");
        this.wJavaLangList.put("I8EBCDIC280", "Cp280");
        this.wJavaLangList.put("IS8MACICELANDIC", "MacIceland");
        this.wJavaLangList.put("IS8MACICELANDICS", "MacIceland");
        this.wJavaLangList.put("IS8PC861", "Cp861");
        this.wJavaLangList.put("IW8EBCDIC424", "Cp424");
        this.wJavaLangList.put("IW8ISO8859P8", "8859_8");
        this.wJavaLangList.put("IW8MACHEBREW", "MacHebrew");
        this.wJavaLangList.put("IW8MACHEBREWS", "MacHebrew");
        this.wJavaLangList.put("IW8MSWIN1255", "Cp1255");
        this.wJavaLangList.put("JA16EBCDIC930", "Cp930");
        this.wJavaLangList.put("JA16EUC", "EUCJIS");
        this.wJavaLangList.put("JA16EUCYEN", "EUCJIS");
        this.wJavaLangList.put("JA16MACSJIS", "SJIS");
        this.wJavaLangList.put("JA16SJIS", "SJIS");
        this.wJavaLangList.put("JA16SJISYEN", "SJIS");
        this.wJavaLangList.put("JA16VMS", "JIS0208");
        this.wJavaLangList.put("KO16KSC5601", "KSC5601");
        this.wJavaLangList.put("LT8MSWIN921", "Cp921");
        this.wJavaLangList.put("N8PC865", "Cp865");
        this.wJavaLangList.put("NEE8ISO8859P4", "8859_4");
        this.wJavaLangList.put("RU8PC855", "Cp855");
        this.wJavaLangList.put("RU8PC866", "Cp866");
        this.wJavaLangList.put("S8EBCDIC278", "Cp278");
        this.wJavaLangList.put("SE8ISO8859P3", "8859_3");
        this.wJavaLangList.put("TH8MACTHAI", "MacThai");
        this.wJavaLangList.put("TH8MACTHAIS", "MacThai");
        this.wJavaLangList.put("TH8TISASCII", "Cp874");
        this.wJavaLangList.put("TR8EBCDIC1026", "Cp1026");
        this.wJavaLangList.put("TR8MACTURKISH", "MacTurkish");
        this.wJavaLangList.put("TR8MACTURKISHS", "MacTurkish");
        this.wJavaLangList.put("TR8MSWIN1254", "Cp1254");
        this.wJavaLangList.put("TR8PC857", "Cp857");
        this.wJavaLangList.put("US7ASCII", "8859_1");
        this.wJavaLangList.put("US8PC437", "Cp437");
        this.wJavaLangList.put("UTF8", "UTF8");
        this.wJavaLangList.put("WE8DEC", "8859_1");
        this.wJavaLangList.put("WE8EBCDIC284", "Cp284");
        this.wJavaLangList.put("WE8EBCDIC285", "Cp285");
        this.wJavaLangList.put("WE8EBCDIC37", "Cp037");
        this.wJavaLangList.put("WE8EBCDIC37C", "Cp037");
        this.wJavaLangList.put("WE8EBCDIC500", "Cp500");
        this.wJavaLangList.put("WE8EBCDIC500C", "Cp500");
        this.wJavaLangList.put("WE8EBCDIC871", "Cp871");
        this.wJavaLangList.put("WE8ISO8859P1", "8859_1");
        this.wJavaLangList.put("WE8ISO8859P9", "8859_1");
        this.wJavaLangList.put("WE8ISO8859P15", "8859_1");
        this.wJavaLangList.put("WE8MACROMAN8", "MacRoman");
        this.wJavaLangList.put("WE8MACROMAN8S", "MacRoman");
        this.wJavaLangList.put("WE8MSWIN1252", "Cp1252");
        this.wJavaLangList.put("WE8PC850", "Cp850");
        this.wJavaLangList.put("WE8PC860", "Cp860");
        this.wJavaLangList.put("ZHS16CGB231280", "GB2312");
        this.wJavaLangList.put("ZHS16GBK", "GB2312");
        this.wJavaLangList.put("ZHS16MACCGB231280", "GB2312");
        this.wJavaLangList.put("ZHT16BIG5", "Big5");
    }
}

