/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.ui.wizards.ui;

import java.util.ArrayList;
import java.util.List;
import oracle.bpm.ui.Image;
import oracle.bpm.ui.LabelProvider;
import oracle.bpm.ui.Panel;
import oracle.bpm.ui.UiContainer;
import oracle.bpm.ui.tree.Tree;
import oracle.bpm.ui.wizards.ui.WorkerListener;
import oracle.bpm.util.ProgressMonitor;

public abstract class AbstractTreeBrowser
extends Panel {
    protected Tree tree;
    private WorkerListener listener;

    public AbstractTreeBrowser(UiContainer parent, WorkerListener listener) {
        super(parent);
        this.setListener(listener);
    }

    public abstract String getSelectedNodes();

    protected abstract Image getIconForNode(NodeData var1, boolean var2, boolean var3, boolean var4);

    protected abstract List getSelectedNodesId();

    protected abstract NodeData populateTree(ProgressMonitor var1) throws Exception;

    protected abstract void build(ProgressMonitor var1);

    protected abstract void setRoot(DefaultBaseTreeNode var1);

    protected abstract DefaultBaseTreeNode createTreeRoot(NodeData var1);

    protected final void build() {
        this.build(ProgressMonitor.NULL_INSTANCE);
    }

    protected void setListener(WorkerListener listener) {
        this.listener = listener;
    }

    protected WorkerListener getListener() {
        return this.listener;
    }

    protected DefaultBaseTreeNode getRoot() {
        return (DefaultBaseTreeNode)((Object)this.tree.getRoot());
    }

    protected void setTree(Tree tree) {
        this.tree = tree;
    }

    protected Tree getTree() {
        return this.tree;
    }

    protected class DefaultTreeNodeLabelProvider
    extends LabelProvider.Default {
        protected DefaultTreeNodeLabelProvider() {
        }

        @Override
        public Image getIcon(Object element) {
            DefaultBaseTreeNode treeNode = (DefaultBaseTreeNode)element;
            return AbstractTreeBrowser.this.getIconForNode(treeNode.getNodeData(), false, false, false);
        }

        @Override
        public String getText(Object element) {
            return element.toString();
        }
    }

    public static class NodeData {
        private List<NodeData> children_d;
        private Object data_d;
        private String id_d;
        private String name_d;

        public NodeData(String id) {
            this(id, id);
        }

        public NodeData(String id, String name) {
            this(id, name, null);
        }

        public NodeData(String id, String name, Object data) {
            this.setId(id);
            this.setName(name);
            this.setData(data);
            this.setChildren(new ArrayList<NodeData>());
        }

        public void setChildren(List<NodeData> children) {
            this.children_d = children;
        }

        public List<NodeData> getChildren() {
            return this.children_d;
        }

        public void setData(Object data) {
            this.data_d = data;
        }

        public Object getData() {
            return this.data_d;
        }

        public void setId(String id) {
            this.id_d = id;
        }

        public String getId() {
            return this.id_d;
        }

        public boolean isLeaf() {
            return false;
        }

        public void setName(String name) {
            this.name_d = name;
        }

        public String getName() {
            return this.name_d;
        }

        public boolean hasChildren() {
            return this.children_d.isEmpty();
        }
    }

    protected static interface DefaultBaseTreeNode {
        public NodeData getNodeData();

        public int getChildCount();

        public int loadChildren(NodeData var1);
    }
}

