/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.ui.wizards.model;

import oracle.bpm.lang.DefaultRuntimeException;
import oracle.bpm.log.Log;
import oracle.bpm.ui.SwingWorker;
import oracle.bpm.ui.UiUtilities;
import oracle.bpm.ui.wizards.model.WizardSwingWorkerActionAdaptor;

public class WizardSwingWorker
extends SwingWorker {
    protected WizardSwingWorkerActionAdaptor actionAdaptor_d;

    public WizardSwingWorker(WizardSwingWorkerActionAdaptor adaptor) {
        this.actionAdaptor_d = adaptor;
    }

    public WizardSwingWorkerActionAdaptor getActionAdaptor() {
        return this.actionAdaptor_d;
    }

    public Object construct() {
        try {
            this.getActionAdaptor().startActionIn(this);
            return Boolean.TRUE;
        }
        catch (Throwable t) {
            Log.logSevere(t);
            return t;
        }
    }

    public void displayText(final String text) {
        UiUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                WizardSwingWorker.this.getActionAdaptor().displayText(text);
            }
        });
    }

    @Override
    public void finished() {
        Thread.yield();
        this.getActionAdaptor().stopActionIn(this);
        Object value = this.getValue();
        if (value instanceof Throwable) {
            Throwable throwable = (Throwable)value;
            String message = throwable.getMessage();
            if (throwable instanceof DefaultRuntimeException && throwable.getCause() != null) {
                message = message + "\n" + throwable.getCause().getMessage();
            }
            throwable.printStackTrace();
            this.displayText(message);
            return;
        }
        assert (value instanceof Boolean) : "Expected 'Boolean' but was: " + (value != null ? value.getClass() : null);
        if (((Boolean)value).booleanValue()) {
            this.getActionAdaptor().finishActionIn(this);
        }
    }
}

