/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.ui.treetable;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.Iterator;
import oracle.bpm.geom.Point;
import oracle.bpm.ui.ColorProvider;
import oracle.bpm.ui.FontProvider;
import oracle.bpm.ui.LabelProvider;
import oracle.bpm.ui.UiContainer;
import oracle.bpm.ui.editors.CellEditor;
import oracle.bpm.ui.event.EditorListener;
import oracle.bpm.ui.event.ListSelectionListener;
import oracle.bpm.ui.event.TreeExpansionListener;
import oracle.bpm.ui.peer.Peer;
import oracle.bpm.ui.peer.TreeTablePeer;
import oracle.bpm.ui.table.AutoResizeMode;
import oracle.bpm.ui.table.editors.BooleanCheckBoxCellEditor;
import oracle.bpm.ui.table.editors.NumericFieldCellEditor;
import oracle.bpm.ui.table.editors.TextFieldCellEditor;
import oracle.bpm.ui.table.renderers.BooleanCheckBoxLabelProvider;
import oracle.bpm.ui.tree.TreePath;
import oracle.bpm.ui.treetable.TreeTableColumn;
import oracle.bpm.ui.treetable.TreeTableModel;

public class TreeTable
extends UiContainer {
    private ColumnManager columnManager;

    public TreeTable(UiContainer parent, TreeTableModel treeTableModel) {
        super(parent);
        this.getTreeTablePeer().setModel(treeTableModel);
        this.init();
    }

    public TreeTable(UiContainer parent, TreeTableModel treeTableModel, boolean showRoot) {
        super(parent);
        TreeTablePeer treeTablePeer = this.getTreeTablePeer();
        treeTablePeer.setRootVisible(showRoot);
        treeTablePeer.setModel(treeTableModel);
        this.init();
    }

    public void setAutoResizeMode(AutoResizeMode mode) {
        this.getTreeTablePeer().setAutoResizeMode(mode);
    }

    public boolean isCollapsed(TreePath path) {
        return this.getTreeTablePeer().isCollapsed(path);
    }

    public TreeTableColumn getColumn(int column) {
        return (TreeTableColumn)this.getColumnManager().getColumn(column);
    }

    public int getColumnCount() {
        return this.getTreeTablePeer().getColumnCount();
    }

    public void setDefaultEditor(Class<?> columnClass, CellEditor editor) {
        this.getTreeTablePeer().setDefaultEditor(columnClass, editor);
    }

    public boolean isEditing() {
        return this.getTreeTablePeer().isEditing();
    }

    public boolean isExpanded(TreePath path) {
        return this.getTreeTablePeer().isExpanded(path);
    }

    public Iterator getExpandedDescendants(TreePath path) {
        return this.getTreeTablePeer().getExpandedDescendants(path);
    }

    public void setDefaultFontProvider(Class<?> columnClass, FontProvider provider) {
        this.getTreeTablePeer().setDefaultFontProvider(columnClass, provider);
    }

    public void setDefaultLabelProvider(Class<?> columnClass, LabelProvider provider) {
        this.getTreeTablePeer().setDefaultLabelProvider(columnClass, provider);
    }

    public void setDefaultColorProvider(Class<?> columnClass, ColorProvider provider) {
        this.getTreeTablePeer().setDefaultColorProvider(columnClass, provider);
    }

    public Object getLastSelectedPathComponent() {
        return this.getTreeTablePeer().getLastSelectedPathComponent();
    }

    public void setModel(TreeTableModel model) {
        if (model == null) {
            throw new IllegalArgumentException("Cannot set a null TreeTableModel");
        }
        this.getColumnManager().clear();
        this.getTreeTablePeer().setModel(model);
    }

    public TreeTableModel getModel() {
        return this.getTreeTablePeer().getModel();
    }

    public TreePath getPathForRow(int row) {
        return this.getTreeTablePeer().getPathForRow(row);
    }

    public void setPreferredRows(int preferredRows) {
        this.getTreeTablePeer().setPreferredRows(preferredRows);
    }

    public void setRelativeSizes(double[] sizes) {
        this.getTreeTablePeer().setRelativeSizes(sizes);
    }

    public void setRootVisible(boolean visible) {
        this.getTreeTablePeer().setRootVisible(visible);
    }

    public int getRowCount() {
        return this.getTreeTablePeer().getRowCount();
    }

    public void setSelectionPath(TreePath path) {
        this.getTreeTablePeer().setSelectionPath(path);
    }

    public TreePath getSelectionPath() {
        return this.getTreeTablePeer().getSelectionPath();
    }

    public TreePath[] getSelectionPaths() {
        return this.getTreeTablePeer().getSelectionPaths();
    }

    public void setShowGrid(boolean showGrid) {
        this.getTreeTablePeer().setShowGrid(showGrid);
    }

    public final Object getValueAt(int row, int column) {
        return this.getTreeTablePeer().getValueAt(row, column);
    }

    public void addListSelectionListener(ListSelectionListener listener) {
        this.getTreeTablePeer().addListSelectionListener(listener);
    }

    public void addTreeExpansionListener(TreeExpansionListener listener) {
        this.getTreeTablePeer().addTreeExpansionListener(listener);
    }

    public void collapsePath(TreePath path) {
        this.getTreeTablePeer().collapsePath(path);
    }

    public int columnAtPoint(Point point) {
        return this.getTreeTablePeer().columnAtPoint(point);
    }

    public final void editCellAt(int row, int column) {
        this.getTreeTablePeer().editCellAt(row, column);
    }

    public int getEditingRow() {
        return this.getTreeTablePeer().getEditingRow();
    }

    public void addEditorListener(EditorListener listener) {
        this.getTreeTablePeer().addEditorListener(listener);
    }

    public void clearSelection() {
        this.getTreeTablePeer().clearSelection();
    }

    public void expandPath(TreePath path) {
        this.getTreeTablePeer().expandPath(path);
    }

    public void expandLevel(int level) {
        this.getTreeTablePeer().expandLevel(level);
    }

    public void expandAll() {
        this.getTreeTablePeer().expandAll();
    }

    public void removeEditorListener(EditorListener listener) {
        this.getTreeTablePeer().removeEditorListener(listener);
    }

    public int rowAtPoint(Point point) {
        return this.getTreeTablePeer().rowAtPoint(point);
    }

    public CellEditor getCellEditor() {
        return this.getTreeTablePeer().getCellEditor();
    }

    @Override
    protected Peer createPeer() {
        return this.getUiFactory().createTreeTable(this.getParentPeer());
    }

    protected void editCellAt(Object editable, int column) {
        this.getTreeTablePeer().editCellAt(editable, column);
    }

    private void init() {
        this.initDefaultProviders();
        this.initDefaultEditors();
    }

    private void initDefaultProviders() {
        this.setDefaultLabelProvider(Boolean.class, BooleanCheckBoxLabelProvider.getInstance());
    }

    private void initDefaultEditors() {
        this.setDefaultEditor(Object.class, new TextFieldCellEditor());
        this.setDefaultEditor(Integer.class, NumericFieldCellEditor.createIntegerCellEditor());
        this.setDefaultEditor(Long.class, NumericFieldCellEditor.createLongCellEditor());
        this.setDefaultEditor(Double.class, NumericFieldCellEditor.createDoubleCellEditor());
        this.setDefaultEditor(Float.class, NumericFieldCellEditor.createFloatCellEditor());
        this.setDefaultEditor(Short.class, NumericFieldCellEditor.createShortCellEditor());
        this.setDefaultEditor(BigDecimal.class, NumericFieldCellEditor.createBigDecimalCellEditor());
        this.setDefaultEditor(BigInteger.class, NumericFieldCellEditor.createBigIntegerCellEditor());
        this.setDefaultEditor(Boolean.class, new BooleanCheckBoxCellEditor());
    }

    private ColumnManager getColumnManager() {
        if (this.columnManager == null) {
            this.columnManager = new ColumnManager(this);
        }
        return this.columnManager;
    }

    private TreeTablePeer getTreeTablePeer() {
        return (TreeTablePeer)this.getPeer();
    }

    private static class ColumnManager
    extends oracle.bpm.ui.internal.ColumnManager<TreeTableColumn> {
        public ColumnManager(UiContainer parent) {
            super(parent);
        }

        @Override
        public TreeTableColumn create(UiContainer parent, int columnIndex) {
            assert (columnIndex >= 0) : columnIndex;
            return new TreeTableColumn(parent, columnIndex);
        }
    }
}

