/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.ui.text;

import java.text.ParseException;
import javax.swing.text.Segment;
import oracle.bpm.ui.text.BaseEditorDocument;
import oracle.bpm.ui.text.TextField;

public class StringDocument
extends BaseEditorDocument {
    public int length = 65536;
    static final long serialVersionUID = 6916956502120754208L;
    static final long serialCheck = 9192027938064764698L;

    public StringDocument(TextField comp) {
        super(comp);
    }

    @Override
    public int getMaximumLength() {
        return this.length;
    }

    public void setString(String v) {
        this.setValue(v);
    }

    public String getString() {
        return (String)this.getValue();
    }

    @Override
    public void setValue(Object v) {
        if (v != null && ((String)v).length() > this.length) {
            throw new IllegalArgumentException("string is longer than " + this.length + " characters");
        }
        super.setValue(v);
    }

    @Override
    public String format(Object v, boolean hasFocus) {
        return v == null ? "" : v.toString();
    }

    @Override
    public Object valueOf(Segment seg) throws ParseException {
        if (seg.count > this.length) {
            throw new ParseException("string is too long", this.length);
        }
        return String.valueOf(seg.array, seg.offset, seg.count);
    }
}

