/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.ui.text;

import oracle.bpm.lang.Interval;
import oracle.bpm.lang.IntervalUnit;
import oracle.bpm.ui.ComboBox;
import oracle.bpm.ui.Panel;
import oracle.bpm.ui.UiContainer;
import oracle.bpm.ui.UiFactory;
import oracle.bpm.ui.layout.FlowLayout;
import oracle.bpm.ui.text.NumericField;

public class SimpleIntervalField
extends Panel {
    private ComboBox<IntervalUnit> internalUnitComboBox;
    private NumericField<Integer> unitsNumericField;

    public SimpleIntervalField(UiContainer parent) {
        super(parent);
        this.init();
    }

    public void setIntervalUnit(IntervalUnit intervalUnit) {
        this.internalUnitComboBox.setSelectedItem(intervalUnit);
    }

    public void setUnits(int units) {
        this.unitsNumericField.setValue(units);
    }

    public Interval getInterval() {
        return Interval.valueOf(this.getIntervalUnit(), this.getUnits());
    }

    public int getUnits() {
        return this.unitsNumericField.getValue();
    }

    public IntervalUnit getIntervalUnit() {
        return this.internalUnitComboBox.getSelectedItem();
    }

    private void init() {
        this.setLayout(new FlowLayout(0, 1, 0));
        this.unitsNumericField = NumericField.createIntegerNumericField(this, false);
        this.unitsNumericField.setColumns(4);
        this.unitsNumericField.setMinimum(Integer.MIN_VALUE);
        IntervalUnit[] values = IntervalUnit.values();
        this.internalUnitComboBox = UiFactory.createComboBox((UiContainer)this, values);
        if (values.length > 0) {
            this.internalUnitComboBox.setSelectedIndex(0);
        }
        this.add(this.unitsNumericField);
        this.add(this.internalUnitComboBox);
    }
}

