/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.ui.text;

import java.util.Locale;
import oracle.bpm.event.ModificationEvent;
import oracle.bpm.event.ModificationListener;
import oracle.bpm.lang.Interval;
import oracle.bpm.lang.IntervalUnit;
import oracle.bpm.ui.UiContainer;
import oracle.bpm.ui.UiUtilities;
import oracle.bpm.ui.peer.IntervalFieldPeer;
import oracle.bpm.ui.peer.Peer;
import oracle.bpm.ui.table.Table;
import oracle.bpm.ui.text.TextComponent;
import oracle.bpm.ui.text.ValueChangedEvent;
import oracle.bpm.ui.text.ValueChangedListener;

public class IntervalField
extends TextComponent {
    private IntervalUnit from;
    private Locale locale;
    private String pattern;
    private IntervalUnit to;

    public IntervalField(UiContainer parent) {
        this(parent, IntervalUnit.MONTHS, IntervalUnit.SECONDS, null, Locale.getDefault());
    }

    public IntervalField(UiContainer parent, IntervalUnit from, IntervalUnit to) {
        this(parent, from, to, null, Locale.getDefault());
    }

    private IntervalField(UiContainer parent, IntervalUnit from, IntervalUnit to, String pattern, Locale locale) {
        super(parent);
        this.from = from;
        this.to = to;
        this.pattern = pattern;
        this.locale = locale;
        this.setInterval(Interval.ZERO);
        if (!(parent instanceof Table)) {
            UiUtilities.addToEditableContainer(this, parent);
        }
    }

    public static IntervalField createPositiveIntervalField(UiContainer parent) {
        return IntervalField.createPositiveIntervalField(parent, IntervalUnit.MONTHS, IntervalUnit.SECONDS);
    }

    public static IntervalField createPositiveIntervalField(UiContainer parent, IntervalUnit from, IntervalUnit to) {
        IntervalField result = new IntervalField(parent, from, to);
        result.setOnlyPositiveValues(true);
        return result;
    }

    public void setInterval(Interval interval) {
        this.getIntervalFieldPeer().setInterval(interval);
    }

    public Interval getInterval() {
        return this.getIntervalFieldPeer().getInterval();
    }

    public void addValueChangedListener(ValueChangedListener listener) {
        this.getIntervalFieldPeer().addValueChangedListener(listener);
    }

    @Override
    public void addModificationListener(final ModificationListener listener) {
        this.getIntervalFieldPeer().addValueChangedListener(new ValueChangedListener(){

            @Override
            public void valueChanged(ValueChangedEvent valuechangedevent) {
                listener.objectModified(new ModificationEvent<Object>(valuechangedevent.getSource(), null, valuechangedevent.getValue()));
            }
        });
    }

    @Override
    protected Peer createPeer() {
        return this.getUiFactory().createIntervalFieldPeer(this.getParentPeer(), this.from, this.to, this.pattern, this.locale);
    }

    protected IntervalFieldPeer getIntervalFieldPeer() {
        return (IntervalFieldPeer)this.getPeer();
    }

    private void setOnlyPositiveValues(boolean isOnlyPositiveValues) {
        this.getIntervalFieldPeer().setOnlyPositiveValues(isOnlyPositiveValues);
    }
}

