/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.ui.text;

import oracle.bpm.lang.IntervalUnit;
import oracle.bpm.lang.Time;
import oracle.bpm.ui.Button;
import oracle.bpm.ui.Label;
import oracle.bpm.ui.Panel;
import oracle.bpm.ui.UiContainer;
import oracle.bpm.ui.action.BaseAction;
import oracle.bpm.ui.layout.CardLayout;
import oracle.bpm.ui.layout.FlowLayout;
import oracle.bpm.ui.msg.UIMsg;
import oracle.bpm.ui.text.SimpleIntervalField;
import oracle.bpm.ui.text.TimeField;

public class DynamicTimeField
extends Panel {
    private CardLayout cardLayout;
    private SimpleIntervalField intervalField;
    private TimeField timeField;
    private TimeType timeType;

    public DynamicTimeField(UiContainer parent) {
        super(parent);
        this.init();
    }

    public void setTime(Time time) {
        this.timeField.setTime(time);
        this.setFormat(TimeType.ABSOLUTE);
    }

    public void setIntervalUnit(IntervalUnit intervalUnit) {
        this.intervalField.setIntervalUnit(intervalUnit);
        this.setFormat(TimeType.RELATIVE);
    }

    public void setUnits(int units) {
        this.intervalField.setUnits(units);
        this.setFormat(TimeType.RELATIVE);
    }

    public Time getTime() {
        return this.timeField.getTime();
    }

    public IntervalUnit getIntervalUnit() {
        return this.intervalField.getIntervalUnit();
    }

    public int getUnits() {
        return this.isRelative() ? this.intervalField.getUnits() : 0;
    }

    public boolean isRelative() {
        return TimeType.isRelative(this.getTimeType());
    }

    public TimeField createTimeField(UiContainer cardParent) {
        Panel panel = new Panel(cardParent);
        panel.setLayout(new FlowLayout(0, 5, 0));
        TimeField timeField = new TimeField(panel);
        timeField.setTime(Time.now());
        panel.add(this.createChangeButton(panel));
        cardParent.add(panel, TimeType.ABSOLUTE.toString());
        return timeField;
    }

    public SimpleIntervalField createIntervalField(UiContainer cardParent) {
        Panel panel = new Panel(cardParent);
        panel.setLayout(new FlowLayout(0, 5, 0));
        panel.add(Label.create((UiContainer)panel, UIMsg.NOW));
        SimpleIntervalField intervalField = new SimpleIntervalField(panel);
        panel.add(intervalField);
        panel.add(this.createChangeButton(panel));
        cardParent.add(panel, TimeType.RELATIVE.toString());
        return intervalField;
    }

    void setFormat(TimeType timeType) {
        if (this.timeType != timeType) {
            this.timeType = timeType;
            this.cardLayout.show(this, timeType.toString());
            this.timeField.setTime(this.timeField.getTime());
        }
    }

    private void init() {
        this.cardLayout = new CardLayout();
        this.setLayout(this.cardLayout);
        this.timeField = this.createTimeField(this);
        this.intervalField = this.createIntervalField(this);
        this.setTime(Time.now());
    }

    private void switchEditor() {
        this.setFormat(this.isRelative() ? TimeType.ABSOLUTE : TimeType.RELATIVE);
    }

    private TimeType getTimeType() {
        return this.timeType;
    }

    private Button createChangeButton(UiContainer parent) {
        BaseAction changeAction = new BaseAction(UIMsg.CHANGE_TIME){

            @Override
            public void run() {
                DynamicTimeField.this.switchEditor();
            }
        };
        return new Button(parent, changeAction, 10);
    }

    public static enum TimeType {
        ABSOLUTE,
        RELATIVE;


        public static boolean isRelative(TimeType type) {
            return RELATIVE.equals((Object)type);
        }
    }
}

