/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.ui.table;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import oracle.bpm.collections.lists.MsgList;
import oracle.bpm.resources.Msg;
import oracle.bpm.ui.table.AbstractTableModel;

public class TableObjectModel
extends AbstractTableModel
implements Serializable {
    private MsgList columnIdentifiers;
    private List<List<Object>> dataVector;
    private Set<Integer> editableColumns;
    private List<Object> objectVector;
    static final long serialCheck = 3644854903510015357L;
    static final long serialVersionUID = 2012138572881392933L;

    public TableObjectModel(Msg ... columnNames) {
        if (columnNames == null) {
            throw new IllegalArgumentException("columnNames");
        }
        this.columnIdentifiers = MsgList.create(columnNames);
        this.dataVector = new ArrayList<List<Object>>();
        this.objectVector = new ArrayList<Object>();
        this.fireTableStructureChanged();
    }

    @Override
    public boolean isCellEditable(int row, int column) {
        return this.editableColumns == null || this.editableColumns.contains(column);
    }

    @Override
    public Class getColumnClass(int column) {
        return this.dataVector.isEmpty() || this.getValueAt(0, column) == null ? Object.class : this.getValueAt(0, column).getClass();
    }

    @Override
    public final int getColumnCount() {
        return this.columnIdentifiers.size();
    }

    @Override
    public final String getColumnName(int column) {
        Msg id = null;
        if (column < this.columnIdentifiers.size()) {
            id = (Msg)this.columnIdentifiers.get(column);
        }
        return id == null ? super.getColumnName(column) : id.getString();
    }

    public final void setEditableColumns(int ... editableColumns) {
        if (this.editableColumns == null) {
            this.editableColumns = new HashSet<Integer>();
        } else {
            this.editableColumns.clear();
        }
        for (int c : editableColumns) {
            this.editableColumns.add(c);
        }
    }

    public final List<Object> getObjects() {
        return this.objectVector;
    }

    public final Object[] getObjects(int[] rows) {
        Object[] objects = new Object[rows.length];
        for (int i = 0; i < rows.length; ++i) {
            objects[i] = this.getObject(rows[i]);
        }
        return objects;
    }

    public final int getRow(Object o) {
        return this.objectVector.indexOf(o);
    }

    @Override
    public final int getRowCount() {
        return this.dataVector.size();
    }

    @Override
    public void setValueAt(Object value, int row, int column) {
        this.dataVector.get(row).set(column, value);
        this.fireTableCellUpdated(row, column);
    }

    @Override
    public final Object getValueAt(int row, int column) {
        return row >= this.dataVector.size() ? null : this.dataVector.get(row).get(column);
    }

    public final void addRow(Object object, Object ... rowData) {
        this.insertRow(this.getRowCount(), object, rowData);
    }

    public final void insertRow(int rowIndex, Object object, Object ... rowData) {
        this.dataVector.add(rowIndex, this.makeRow(rowData));
        this.objectVector.add(rowIndex, object);
        this.fireTableRowsInserted(rowIndex, rowIndex);
    }

    public void removeAllElements() {
        int rows = this.getRowCount();
        if (rows > 0) {
            this.dataVector.clear();
            this.objectVector.clear();
            this.fireTableRowsDeleted(0, rows - 1);
        }
    }

    public final void removeRow(int row) {
        this.dataVector.remove(row);
        this.objectVector.remove(row);
        this.fireTableRowsDeleted(row, row);
    }

    public final Object getObject(int row) {
        int column = this.getColumnCount();
        return column <= 0 ? null : this.objectVector.get(row);
    }

    private List<Object> makeRow(Object[] array) {
        int n = this.getColumnCount();
        ArrayList<Object> result = new ArrayList<Object>(n);
        for (int i = 0; i < n; ++i) {
            result.add(array == null || i >= array.length ? null : array[i]);
        }
        return result;
    }
}

