/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.ui.prop.impl;

import oracle.bpm.draw.Font;
import oracle.bpm.ui.Button;
import oracle.bpm.ui.FontChooser;
import oracle.bpm.ui.Panel;
import oracle.bpm.ui.UiComponent;
import oracle.bpm.ui.UiContainer;
import oracle.bpm.ui.action.BaseAction;
import oracle.bpm.ui.layout.AttributeConstraint;
import oracle.bpm.ui.layout.AttributeType;
import oracle.bpm.ui.layout.RelativeLayout;
import oracle.bpm.ui.prop.impl.AbstractEditor;
import oracle.bpm.ui.prop.impl.FontProperty;
import oracle.bpm.ui.text.TextField;

class FontPropertyEditor
extends AbstractEditor {
    private TextField field;
    private Font font;

    FontPropertyEditor() {
    }

    @Override
    public Object getCellEditorValue() {
        return this.font;
    }

    @Override
    protected UiComponent getEditor(UiContainer parent) {
        return this.createEditor(parent);
    }

    @Override
    protected FontProperty getProperty() {
        return (FontProperty)super.getProperty();
    }

    private Panel createEditor(final UiContainer parent) {
        Panel mainPanel = new Panel(parent);
        RelativeLayout layout = new RelativeLayout();
        mainPanel.setLayout(layout);
        mainPanel.setOpaque(false);
        mainPanel.setBorder(null);
        this.field = new TextField(mainPanel);
        this.field.setBorder(null);
        this.field.setEditable(false);
        this.field.setOpaque(false);
        Button triggerButton = new Button(mainPanel);
        triggerButton.setAction(new BaseAction("..."){

            @Override
            public void run() {
                FontPropertyEditor.this.startEdit(parent);
            }
        });
        triggerButton.setDefaultCapable(false);
        triggerButton.setFocusPainted(false);
        mainPanel.add(this.field, "field");
        mainPanel.add(triggerButton, "button");
        this.layoutComponents(layout);
        this.updateCurrentFont();
        return mainPanel;
    }

    private void layoutComponents(RelativeLayout layout) {
        layout.addConstraint("button", AttributeType.RIGHT, new AttributeConstraint("_container", AttributeType.RIGHT, -1));
        layout.addConstraint("button", AttributeType.TOP, new AttributeConstraint("_container", AttributeType.TOP));
        layout.addConstraint("button", AttributeType.BOTTOM, new AttributeConstraint("_container", AttributeType.BOTTOM));
        layout.addConstraint("button", AttributeType.WIDTH, new AttributeConstraint("_container", AttributeType.HEIGHT));
        layout.addConstraint("field", AttributeType.TOP, new AttributeConstraint("_container", AttributeType.TOP));
        layout.addConstraint("field", AttributeType.BOTTOM, new AttributeConstraint("_container", AttributeType.BOTTOM));
        layout.addConstraint("field", AttributeType.RIGHT, new AttributeConstraint("button", AttributeType.LEFT, -1));
        layout.addConstraint("field", AttributeType.LEFT, new AttributeConstraint("_container", AttributeType.LEFT, 1));
    }

    private void startEdit(UiContainer parent) {
        Font font = FontChooser.showDialog(parent.getOwnerWindow(), this.getProperty().getValue());
        if (font == null) {
            this.cancelCellEditing();
        } else {
            this.font = font;
            this.stopCellEditing();
        }
    }

    private void updateCurrentFont() {
        FontProperty property = this.getProperty();
        Font font = (Font)property.getValue();
        if (font != null && this.field != null) {
            this.field.setText(font.getFamily() + "," + font.getSize());
        }
    }
}

