/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.ui.pref;

import java.util.ArrayList;
import java.util.List;
import javax.swing.UIManager;
import oracle.bpm.draw.Color;
import oracle.bpm.lang.Str;
import oracle.bpm.resources.Msg;
import oracle.bpm.ui.LabelProvider;
import oracle.bpm.ui.OkCancelDialog;
import oracle.bpm.ui.Panel;
import oracle.bpm.ui.TitlePanel;
import oracle.bpm.ui.UiComponent;
import oracle.bpm.ui.UiContainer;
import oracle.bpm.ui.UiManager;
import oracle.bpm.ui.UiWindow;
import oracle.bpm.ui.border.Border;
import oracle.bpm.ui.border.BorderFactory;
import oracle.bpm.ui.event.TreeSelectionEvent;
import oracle.bpm.ui.event.TreeSelectionListener;
import oracle.bpm.ui.layout.AttributeAxis;
import oracle.bpm.ui.layout.AttributeConstraint;
import oracle.bpm.ui.layout.AttributeType;
import oracle.bpm.ui.layout.AxisConstraint;
import oracle.bpm.ui.layout.CardLayout;
import oracle.bpm.ui.layout.RelativeLayout;
import oracle.bpm.ui.msg.UIMsg;
import oracle.bpm.ui.pref.CategoriesTree;
import oracle.bpm.ui.pref.Category;
import oracle.bpm.ui.pref.CategoryNode;
import oracle.bpm.ui.tree.Tree;
import oracle.bpm.ui.tree.TreeNode;
import oracle.bpm.ui.tree.TreePath;

public class PreferencesDialog
extends OkCancelDialog {
    private CardLayout cardLayout;
    private Panel cardPanel;
    private List<Category> categories = new ArrayList<Category>();
    private CategoriesTree categoryTree;
    private Category rootCategory;
    private TitlePanel titlePanel;

    public PreferencesDialog() {
        this((UiWindow)null);
    }

    public PreferencesDialog(UiWindow parent) {
        this(parent, UIMsg.PREFERENCES, true);
    }

    public PreferencesDialog(UiWindow parent, Msg title, boolean modal) {
        super(parent, title, modal);
        RelativeLayout layout = new RelativeLayout();
        UiContainer contentPane = this.getContentPane();
        contentPane.setLayout(layout);
        this.rootCategory = new Category("root", null, null);
        this.cardLayout = new CardLayout();
        this.cardPanel = new Panel(contentPane);
        this.cardPanel.setLayout(this.cardLayout);
        this.titlePanel = new TitlePanel(contentPane);
        this.titlePanel.setTitle(UIMsg.CATEGORY);
        this.categoryTree = this.createTree(this.titlePanel);
        this.titlePanel.addContent(this.categoryTree);
        this.titlePanel.setBorder(BorderFactory.createBevelBorder(1));
        this.titlePanel.getTopPanel().setBorder(Border.get(UIManager.getBorder("TableHeader.cellBorder")));
        contentPane.add(this.titlePanel, "treePanel");
        contentPane.add(this.cardPanel, "cardPanel");
        this.layoutComponents(layout);
        this.loadDefaultCategories();
        this.setSize(600, 600);
        this.setLocationRelativeTo(parent);
        this.setResizable(false);
    }

    public CategoriesTree getCategoryTree() {
        return this.categoryTree;
    }

    public Category getRootCategory() {
        return this.rootCategory;
    }

    public void addCategory(Category childCategory) {
        this.addCategory(childCategory, (TitlePanel)null);
    }

    public void addCategory(Category childCategory, TitlePanel editorsParent) {
        CategoryNode root = this.getRootNode();
        CategoryNode child = new CategoryNode(childCategory);
        this.addCategory(root, child, editorsParent);
        this.getCategoryTree().setRoot(root);
        TreeNode firstChild = root.getFirstChild();
        firstChild.select();
    }

    public void addCategory(Category parent, Category child) {
        this.addCategory(parent, child, null);
    }

    public void addCategory(Category parent, Category child, TitlePanel editorsParent) {
        child.setParentCategory(parent);
        CategoryNode parentNode = this.findCategoryNode(parent.getId());
        CategoryNode childNode = new CategoryNode(child);
        this.addCategory(parentNode, childNode, editorsParent);
        this.getCategoryTree().setRoot(this.getRootNode());
    }

    public void addCategory(CategoryNode parent, CategoryNode child) {
        this.addCategory(parent, child, null);
    }

    public void addCategory(CategoryNode parent, CategoryNode child, TitlePanel editorsParent) {
        Category category = child.getCategory();
        if (parent != null) {
            String id = category.getId();
            if (editorsParent == null) {
                editorsParent = new TitlePanel(this.getCardPanel());
                editorsParent.setTitle(Str.replaceString(id, ".", ": "));
            }
            UiComponent childEditor = category.getEditor(editorsParent);
            editorsParent.addContent(childEditor);
            TitlePanel.TopPanel topPanel = editorsParent.getTopPanel();
            topPanel.setBackground(Color.FUEGO_LIGHT_BLUE);
            topPanel.setForeground(Color.GRAY);
            topPanel.setFont(UiManager.font("InternalFrame.titleFont"));
            CategoryNode childNode = new CategoryNode(category);
            parent.add(childNode);
            this.getCardPanel().add(editorsParent, id);
            this.getCategories().add(category);
            Category.Listener listener = category.getListener();
            if (listener != null) {
                listener.load();
            }
        }
    }

    public CategoryNode findCategoryNode(String categoryId) {
        CategoryNode root = this.getRootNode();
        CategoryNode node = this.findChild(root, categoryId);
        if (node != null) {
            return node;
        }
        return null;
    }

    @Override
    public void ok() {
        this.saveAll();
        this.setVisible(false);
        this.dispose();
    }

    protected void setCategoriesTitle(Msg msg) {
        this.titlePanel.setTitle(msg.getString());
    }

    protected void setSelectedCategory(Category category) {
        this.findCategoryNode(category.getId()).select();
    }

    protected void loadDefaultCategories() {
    }

    protected Panel getCardPanel() {
        return this.cardPanel;
    }

    private CardLayout getCardLayout() {
        return this.cardLayout;
    }

    private List<Category> getCategories() {
        return this.categories;
    }

    private CategoryNode getRootNode() {
        return (CategoryNode)this.getTree().getRoot();
    }

    private Tree getTree() {
        return this.categoryTree;
    }

    private CategoriesTree createTree(UiContainer parent) {
        CategoriesTree categoryTree = new CategoriesTree(parent);
        categoryTree.setRoot(new CategoryNode(this.rootCategory));
        categoryTree.setRootVisible(false);
        categoryTree.setShowsRootHandles(true);
        categoryTree.setLabelProvider(new LabelProvider.Default(){

            @Override
            public String getText(Object element) {
                return String.valueOf(element);
            }
        });
        categoryTree.addTreeSelectionListener(new TreeSelectionListener(){

            @Override
            public void valueChanged(TreeSelectionEvent e) {
                TreePath treePath = e.getNewLeadSelectionPath();
                if (treePath != null) {
                    CategoryNode categoryNode = (CategoryNode)treePath.getLastPathComponent();
                    Category category = categoryNode.getCategory();
                    PreferencesDialog.this.getCardLayout().show(PreferencesDialog.this.getCardPanel(), category.getId());
                }
            }
        });
        categoryTree.putClientProperty("Tree.lineStyle", "Angled");
        categoryTree.setMinimumSize(categoryTree.getPreferredSize());
        return categoryTree;
    }

    private CategoryNode findChild(CategoryNode node, String id) {
        if (node.getCategory().getId().equals(id)) {
            return node;
        }
        int childCount = node.getChildCount();
        CategoryNode found = null;
        for (int i = 0; i < childCount; ++i) {
            CategoryNode childCategoryNode = (CategoryNode)node.getChildAt(i);
            found = this.findChild(childCategoryNode, id);
            if (found == null) continue;
            return found;
        }
        return found;
    }

    private void layoutComponents(RelativeLayout layout) {
        layout.addConstraint("treePanel", AttributeType.TOP, new AttributeConstraint("_container", AttributeType.TOP, 5));
        layout.addConstraint("treePanel", AttributeType.LEFT, new AttributeConstraint("_container", AttributeType.LEFT, 5));
        layout.addConstraint("treePanel", AttributeType.RIGHT, new AxisConstraint("_container", AttributeAxis.HORIZONTAL, 0.25));
        layout.addConstraint("treePanel", AttributeType.BOTTOM, new AttributeConstraint("_container", AttributeType.BOTTOM, -5));
        layout.addConstraint("cardPanel", AttributeType.LEFT, new AttributeConstraint("treePanel", AttributeType.RIGHT, 5));
        layout.addConstraint("cardPanel", AttributeType.RIGHT, new AttributeConstraint("_container", AttributeType.RIGHT, -5));
        layout.addConstraint("cardPanel", AttributeType.TOP, new AttributeConstraint("treePanel", AttributeType.TOP));
        layout.addConstraint("cardPanel", AttributeType.BOTTOM, new AttributeConstraint("treePanel", AttributeType.BOTTOM));
    }

    private void saveAll() {
        for (Category category : this.categories) {
            Category.Listener listener = category.getListener();
            if (listener == null) continue;
            listener.save();
        }
    }
}

