/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.ui.peer.swing.interval;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.Serializable;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.SwingConstants;
import javax.swing.SwingUtilities;
import javax.swing.Timer;
import javax.swing.plaf.basic.BasicArrowButton;
import oracle.bpm.ui.peer.swing.interval.Spinner;

class SpinnerGUI
implements SwingConstants,
Serializable {
    protected transient ArrowButtonListener buttonListener;
    protected int caretPos;
    protected JButton decrButton;
    protected JButton incrButton;
    protected JPanel panel_d = new JPanel();
    protected transient SpinListener spinListener;
    protected Spinner spinner;
    protected transient Timer spinTimer;
    protected JTextField textField;
    private boolean timerEnabled = true;
    private static final long serialVersionUID = -2081824069454884431L;

    public SpinnerGUI(JComponent jcomponent) {
        this.spinner = (Spinner)jcomponent;
        this.initializeGUI();
    }

    public void setColumns(int i) {
        this.textField.setColumns(i);
    }

    public int getColumns() {
        return this.textField.getColumns();
    }

    public void setDecrButtonEnabled(boolean enable) {
        this.decrButton.setEnabled(enable);
    }

    public boolean isDecrButtonEnabled() {
        return this.decrButton.isEnabled();
    }

    public void setEnabled(boolean enable) {
        this.setTextFieldEnabled(enable);
        this.setIncrButtonEnabled(enable);
        this.setDecrButtonEnabled(enable);
    }

    public void setIncrButtonEnabled(boolean enable) {
        this.incrButton.setEnabled(enable);
    }

    public boolean isIncrButtonEnabled() {
        return this.incrButton.isEnabled();
    }

    public Dimension getMaximumSize(JComponent jcomponent) {
        Dimension dimension = this.getPreferredSize(jcomponent);
        dimension.width = Short.MAX_VALUE;
        return dimension;
    }

    public Dimension getMinimumSize(JComponent jcomponent) {
        Insets insets = this.spinner.getInsets();
        Dimension dimension = this.textField.getPreferredSize();
        int i = dimension.height;
        dimension.height += insets.top + insets.bottom;
        dimension.width += i + insets.left + insets.right;
        return dimension;
    }

    public Dimension getPreferredSize(JComponent jcomponent) {
        Dimension dimension = this.getMinimumSize(jcomponent);
        dimension.width += 4;
        return dimension;
    }

    public void setTextFieldEnabled(boolean enable) {
        this.textField.setEnabled(enable);
    }

    public boolean isTextFieldEnabled() {
        return this.textField.isEnabled();
    }

    public void setTimerEnabled(boolean timerEnabled) {
        this.timerEnabled = timerEnabled;
    }

    public boolean isTimerEnabled() {
        return this.timerEnabled;
    }

    public void addButtons() {
        this.panel_d.setLayout(new GridLayout(2, 1, 0, 0));
        this.panel_d.add(this.incrButton);
        this.panel_d.add(this.decrButton);
        this.spinner.add((Component)this.panel_d, "East");
    }

    public void addTextField() {
        this.spinner.add((Component)this.textField, "Center");
    }

    public void removeButtons() {
        this.spinner.remove(this.incrButton);
        this.spinner.remove(this.decrButton);
    }

    protected void addSubComponents() {
        this.addTextField();
        this.addButtons();
    }

    protected SpinListener createSpinListener() {
        return new SpinListener();
    }

    protected void initializeGUI() {
        this.incrButton = new BasicArrowButton(1);
        this.decrButton = new BasicArrowButton(5);
        this.textField = new JTextField(this.spinner.getColumns());
        this.spinner.setLayout(new BorderLayout());
        this.addSubComponents();
        this.buttonListener = new ArrowButtonListener();
        if (this.incrButton != null) {
            this.incrButton.addMouseListener(this.buttonListener);
        }
        if (this.decrButton != null) {
            this.decrButton.addMouseListener(this.buttonListener);
        }
        this.spinListener = this.createSpinListener();
        this.spinTimer = new Timer(100, this.spinListener);
        this.spinTimer.setInitialDelay(500);
    }

    private class SpinListener
    implements ActionListener,
    Serializable {
        int fDirection = 1;
        private static final long serialVersionUID = -8998866770715091076L;

        public void setDirection(int i) {
            this.fDirection = i;
        }

        @Override
        public void actionPerformed(ActionEvent actionevent) {
            if (!SpinnerGUI.this.textField.hasFocus()) {
                SpinnerGUI.this.textField.requestFocus();
            }
            SpinnerGUI.this.caretPos = SpinnerGUI.this.textField.getCaretPosition();
            if (this.fDirection > 0) {
                SpinnerGUI.this.spinner.scrollUp();
            } else {
                SpinnerGUI.this.spinner.scrollDown();
            }
        }
    }

    private class ArrowButtonListener
    extends MouseAdapter
    implements Serializable {
        private static final long serialVersionUID = -7300326911842579063L;

        ArrowButtonListener() {
        }

        @Override
        public void mousePressed(MouseEvent mouseevent) {
            if (!((Component)mouseevent.getSource()).isEnabled()) {
                return;
            }
            byte byte0 = (byte)(mouseevent.getSource() != SpinnerGUI.this.incrButton ? -1 : 1);
            SpinnerGUI.this.spinListener.setDirection(byte0);
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    SpinnerGUI.this.spinListener.actionPerformed(null);
                }
            });
            if (SpinnerGUI.this.isTimerEnabled()) {
                SpinnerGUI.this.spinTimer.start();
            }
        }

        @Override
        public void mouseReleased(MouseEvent mouseevent) {
            if (SpinnerGUI.this.isTimerEnabled()) {
                SpinnerGUI.this.spinTimer.stop();
            }
        }
    }
}

