/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.ui.peer.swing.interval;

import java.text.DateFormat;
import java.text.Format;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.Locale;
import java.util.TimeZone;
import oracle.bpm.lang.Any;
import oracle.bpm.lang.Str;
import oracle.bpm.lang.Time;
import oracle.bpm.ui.peer.swing.interval.TimeIntervalField;
import oracle.bpm.ui.text.TimeField;

public class ExtendedTimeField
extends TimeIntervalField {
    private transient GregorianCalendar calendar_d;
    private transient ArrayList<DateFormat> inputFormats_d;
    private boolean onlyPartial = true;
    private TimeField.Style style;
    private TimeZone timeZone_d;
    private static final long serialVersionUID = 0L;
    public static final String PROPERTY_VALUE_CHANGED = "value";
    private static final String patternChars = "GyMdkHmsSEDFwWahKz";
    private static final int[] PATTERN_INDEX_TO_CALENDAR_FIELD = new int[]{0, 1, 2, 5, 11, 11, 12, 13, 14, 7, 6, 8, 3, 4, 9, 10, 10, 15};

    ExtendedTimeField(TimeField.Style style, TimeField.Format format, String pattern, Locale locale) {
        this(style, format, pattern, locale, TimeZone.getDefault());
    }

    ExtendedTimeField(TimeField.Style style, TimeField.Format format, String pattern, Locale locale, TimeZone timeZone) {
        super(format, pattern, locale);
        this.style = style;
        this.timeZone_d = timeZone;
        this.init();
    }

    public Calendar getCalendar() {
        return this.calendar_d;
    }

    public void setFormatString(String pattern) {
        if (TimeField.Format.CUSTOM.equals((Object)this.format) && !Any.equals(this.formatString_d, pattern)) {
            this.formatString_d = pattern;
            this.init();
            this.firePropertyChange("formattingStyle", null, null);
        }
    }

    @Override
    public Object getDefault() {
        return this.default_d == null && this.isRequired() ? Time.now() : this.default_d;
    }

    public void setTime(Time time) {
        if (time != null || !this.isRequired()) {
            Time prev = this.getTime();
            this.setJavaDate(time == null ? null : time.dateValue());
            this.firePropertyChange(PROPERTY_VALUE_CHANGED, prev, time);
        }
    }

    public Time getTime() {
        return this.calendar_d == null ? null : Time.valueOf(this.calendar_d.getTime());
    }

    public void setTimeZone(TimeZone timeZone) {
        if (this.timeZone_d == null || !this.timeZone_d.getID().equals(timeZone.getID())) {
            this.timeZone_d = timeZone;
            this.init();
        }
    }

    public TimeZone getTimeZone() {
        return this.timeZone_d;
    }

    public void setType(TimeField.Style style) {
        if (!this.style.equals((Object)style)) {
            this.style = style;
            this.init();
        }
    }

    @Override
    public TimeField.Style getType() {
        return this.style;
    }

    @Override
    public void setValue(Object value) {
        this.setTime((Time)value);
    }

    @Override
    public Object getValue() {
        return this.getTime();
    }

    public void setFormat(TimeField.Format format) {
        this.format = format;
    }

    @Override
    protected Format buildFormat(String formatString) {
        return new SimpleDateFormat(formatString, this.locale_d);
    }

    @Override
    protected void init() {
        if (TimeField.Format.CUSTOM.equals((Object)this.format)) {
            this.format_d = new SimpleDateFormat(this.formatString_d, this.locale_d);
        } else {
            this.format_d = TimeField.getDateFormat(this.style, this.format, this.locale_d);
            this.formatString_d = ((SimpleDateFormat)this.format_d).toPattern();
        }
        ((SimpleDateFormat)this.format_d).setTimeZone(this.timeZone_d);
        Date date = this.calendar_d != null ? this.calendar_d.getTime() : (this.isRequired() ? ((Time)this.getDefault()).dateValue() : null);
        int len = (this.formatString_d.length() - Str.count(this.formatString_d, '\'')) * 85 / 100;
        if (date == null) {
            this.text_d = "";
        } else {
            this.calendar_d = new GregorianCalendar(this.timeZone_d, this.locale_d);
            this.calendar_d.setTime(date);
            this.text_d = this.format_d.format(this.calendar_d.getTime());
            len = Math.max(this.text_d.length(), len);
        }
        this.setColumns(len);
        super.init();
    }

    @Override
    protected void makeInputFormats() {
        this.inputFormats_d = new ArrayList();
        if (TimeField.Style.isDate(this.style)) {
            int beginMonth = this.formatString_d.indexOf(77);
            if (beginMonth != -1) {
                int endMonth;
                for (endMonth = beginMonth + 1; endMonth < this.formatString_d.length() && this.formatString_d.charAt(endMonth) == 'M'; ++endMonth) {
                }
                if (endMonth - beginMonth >= 3) {
                    String fmt = this.formatString_d.substring(0, beginMonth) + "MM" + this.formatString_d.substring(endMonth);
                    this.inputFormats_d.add(new SimpleDateFormat(fmt));
                }
            }
            SimpleDateFormat dateFmt = (SimpleDateFormat)DateFormat.getDateInstance(3, this.locale_d);
            String pattern = dateFmt.toPattern();
            int d = pattern.indexOf(100);
            int m = pattern.indexOf(77);
            int y = pattern.indexOf(121);
            if (TimeField.Style.DATE_TIME.equals((Object)this.style)) {
                if (d < m && m < y) {
                    this.inputFormats_d.add(new SimpleDateFormat("ddMMyy HHmmss"));
                    this.inputFormats_d.add(new SimpleDateFormat("ddMMyy HHmm"));
                } else if (m < d && d < y) {
                    this.inputFormats_d.add(new SimpleDateFormat("MMddyy HHmmss"));
                    this.inputFormats_d.add(new SimpleDateFormat("MMddyy HHmm"));
                } else {
                    this.inputFormats_d.add(new SimpleDateFormat("yyyyMMdd HHmmss"));
                    this.inputFormats_d.add(new SimpleDateFormat("yyyyMMdd HHmm"));
                    this.inputFormats_d.add(new SimpleDateFormat("yyMMdd HHmmss"));
                    this.inputFormats_d.add(new SimpleDateFormat("yyMMdd HHmm"));
                }
            }
            this.inputFormats_d.add(dateFmt);
            if (d < m && m < y) {
                this.inputFormats_d.add(new SimpleDateFormat("ddMMyy"));
            } else if (m < d && d < y) {
                this.inputFormats_d.add(new SimpleDateFormat("MMddyy"));
            } else {
                this.inputFormats_d.add(new SimpleDateFormat("yyyyMMdd"));
                this.inputFormats_d.add(new SimpleDateFormat("yyMMdd"));
            }
        } else if (TimeField.Style.TIME.equals((Object)this.style)) {
            this.inputFormats_d.add(new SimpleDateFormat("HHmmss"));
            this.inputFormats_d.add(new SimpleDateFormat("HHmm"));
            this.inputFormats_d.add(DateFormat.getTimeInstance(2, this.locale_d));
            this.inputFormats_d.add(DateFormat.getTimeInstance(3, this.locale_d));
        }
    }

    @Override
    protected Object parse(String text) {
        Time currentTIme = this.getTime();
        Date date = null;
        SimpleDateFormat usedFormat = null;
        try {
            date = ((SimpleDateFormat)this.format_d).parse(text);
            usedFormat = (SimpleDateFormat)this.format_d;
        }
        catch (ParseException ignore) {
            // empty catch block
        }
        for (int i = 0; date == null && i < this.inputFormats_d.size(); ++i) {
            try {
                SimpleDateFormat fmt = (SimpleDateFormat)this.inputFormats_d.get(i);
                date = fmt.parse(text);
                usedFormat = fmt;
                continue;
            }
            catch (ParseException ignore) {
                // empty catch block
            }
        }
        return this.getTimeValue(date, usedFormat, currentTIme);
    }

    @Override
    protected boolean rollField(String fmt, boolean up) {
        int index = patternChars.indexOf(fmt.charAt(0));
        if (index < 0 || index >= PATTERN_INDEX_TO_CALENDAR_FIELD.length) {
            return false;
        }
        int field = PATTERN_INDEX_TO_CALENDAR_FIELD[index];
        if (field == 9) {
            this.calendar_d.add(9, this.calendar_d.get(9) == 0 ? 1 : -1);
        } else if (field != 15) {
            this.calendar_d.roll(field, up);
        }
        this.setJavaDate(this.calendar_d.getTime());
        return true;
    }

    void setJavaDate(Date date) {
        if (date != null || !this.isRequired()) {
            if (date == null) {
                this.calendar_d = null;
                this.text_d = "";
            } else {
                if (this.calendar_d == null) {
                    this.calendar_d = new GregorianCalendar(this.timeZone_d, this.locale_d);
                }
                this.calendar_d.setTime(date);
                this.text_d = this.format_d.format(date);
            }
            this.findParsePositions();
            this.fireValueChangedEvent();
        }
    }

    private Time getTimeValue(Date d, SimpleDateFormat format, Time time) {
        Time result = Time.valueOf(d);
        if (d != null && this.onlyPartial) {
            Calendar date = Calendar.getInstance();
            date.setTime(d);
            Calendar oldDate = Calendar.getInstance();
            oldDate.setTime(time.dateValue());
            String pattern = format.toPattern();
            if (pattern.indexOf(121) != -1) {
                oldDate.set(1, date.get(1));
            }
            if (pattern.indexOf(77) != -1) {
                oldDate.set(2, date.get(2));
            }
            if (pattern.indexOf(100) != -1) {
                oldDate.set(5, date.get(5));
            }
            if (pattern.indexOf(72) != -1 || pattern.indexOf(104) != -1) {
                oldDate.set(11, date.get(11));
            }
            if (pattern.indexOf(109) != -1) {
                oldDate.set(12, date.get(12));
            }
            if (pattern.indexOf(115) != -1) {
                oldDate.set(13, date.get(13));
            }
            if (pattern.indexOf(122) != -1) {
                // empty if block
            }
            result = Time.valueOf(oldDate);
        }
        return result;
    }
}

