/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.ui.peer.swing;

import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.Rectangle;
import javax.swing.ActionMap;
import javax.swing.InputMap;
import javax.swing.JComponent;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTree;
import javax.swing.JViewport;
import javax.swing.KeyStroke;
import javax.swing.UIManager;
import javax.swing.plaf.basic.BasicTreeUI;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.tree.DefaultTreeCellRenderer;
import javax.swing.tree.TreePath;
import oracle.bpm.ui.UiComponent;
import oracle.bpm.ui.UiContainer;
import oracle.bpm.ui.action.BaseAction;
import oracle.bpm.ui.editors.AbstractCellEditor;
import oracle.bpm.ui.editors.CellEditor;
import oracle.bpm.ui.event.CellEditorListener;
import oracle.bpm.ui.event.ChangeEvent;
import oracle.bpm.ui.peer.TreeTablePropertyPeer;
import oracle.bpm.ui.peer.swing.ExtendedTreeTable;
import oracle.bpm.ui.peer.swing.SwingComponent;
import oracle.bpm.ui.peer.swing.SwingTreeTable;
import oracle.bpm.ui.prop.AbstractProperty;
import oracle.bpm.ui.prop.Property;
import oracle.bpm.ui.prop.PropertyEditor;
import oracle.bpm.ui.prop.PropertyGroup;
import oracle.bpm.ui.prop.PropertyRenderer;

public class SwingTreeTableProperty
extends SwingTreeTable
implements TreeTablePropertyPeer {
    public SwingTreeTableProperty(SwingComponent parent) {
        super(parent, new ExtendedTreeTableProperty());
        PropertyTableCellEditor editor = new PropertyTableCellEditor();
        this.setDefaultEditor((Class)Property.class, (CellEditor)editor);
    }

    private static class PropertyTableCellEditor
    extends AbstractCellEditor {
        private PropertyEditor cellEditor;

        private PropertyTableCellEditor() {
        }

        @Override
        public Object getCellEditorValue() {
            return this.cellEditor.getCellEditorValue();
        }

        @Override
        public UiComponent createEditor(UiContainer parent, Object value) {
            Property property = (Property)value;
            this.cellEditor = property.getPropertyEditor();
            UiComponent editor = this.cellEditor.createEditor(parent, property);
            this.cellEditor.addCellEditorListener(new CellEditorListener(){

                @Override
                public void editingCanceled(ChangeEvent e) {
                    PropertyTableCellEditor.this.cancelCellEditing();
                }

                @Override
                public void editingStopped(ChangeEvent e) {
                    PropertyTableCellEditor.this.stopCellEditing();
                }
            });
            return editor;
        }
    }

    private static class ExtendedTreeTableProperty
    extends ExtendedTreeTable {
        static final long serialVersionUID = 5947327042688536658L;
        static final long serialCheck = -7336721943478092035L;

        ExtendedTreeTableProperty() {
            JTree tree = this.getTree();
            this.setDefaultRenderer(Property.class, new PropertyTableCellRenderer());
            tree.setCellRenderer(new PropertyTreeCellRenderer());
            tree.setShowsRootHandles(true);
            tree.setRootVisible(false);
            tree.setUI(new PropertyTreeUI());
            Color color = UIManager.getColor("control");
            this.setGridColor(color);
            tree.setRowHeight(this.getRowHeight());
            InputMap inputMap = this.getInputMap(0);
            inputMap.put(KeyStroke.getKeyStroke("ENTER"), "expandcollapse");
            ActionMap actionMap = this.getActionMap();
            actionMap.put("expandcollapse", new BaseAction(){

                @Override
                public void run() {
                    Object node;
                    TreePath treePath;
                    int row = ExtendedTreeTableProperty.this.getSelectedRow();
                    int col = ExtendedTreeTableProperty.this.getSelectedColumn();
                    if (row != -1 && (treePath = ExtendedTreeTableProperty.this.getTree().getPathForRow(row)) != null && (node = treePath.getLastPathComponent()) instanceof PropertyGroup) {
                        if (ExtendedTreeTableProperty.this.getTree().isExpanded(row)) {
                            ExtendedTreeTableProperty.this.getTree().collapsePath(treePath);
                        } else {
                            ExtendedTreeTableProperty.this.getTree().expandPath(treePath);
                        }
                        ExtendedTreeTableProperty.this.changeSelection(row, col, false, false);
                    }
                }
            });
        }

        @Override
        protected void configureEnclosingScrollPane() {
            Container gp;
            Container p = this.getParent();
            if (p instanceof JViewport && (gp = p.getParent()) instanceof JScrollPane) {
                JScrollPane scrollPane = (JScrollPane)gp;
                JViewport viewport = scrollPane.getViewport();
                if (viewport == null || viewport.getView() != this) {
                    return;
                }
                scrollPane.getViewport().setScrollMode(2);
                scrollPane.setBorder(UIManager.getBorder("Table.scrollPaneBorder"));
            }
        }

        private static class PropertyTreeUI
        extends BasicTreeUI {
            private PropertyTreeUI() {
            }

            @Override
            protected void ensureRowsAreVisible(int beginRow, int endRow) {
                if (this.tree != null && beginRow >= 0 && endRow < this.getRowCount(this.tree)) {
                    Rectangle visRect = this.tree.getVisibleRect();
                    if (beginRow == endRow) {
                        Rectangle scrollBounds = this.getPathBounds(this.tree, this.getPathForRow(this.tree, beginRow));
                        if (scrollBounds != null) {
                            scrollBounds = new Rectangle(visRect.x, scrollBounds.y, visRect.width, scrollBounds.height);
                            this.tree.scrollRectToVisible(scrollBounds);
                        }
                    } else {
                        Rectangle beginRect;
                        Rectangle testRect = beginRect = this.getPathBounds(this.tree, this.getPathForRow(this.tree, beginRow));
                        int beginY = beginRect.y;
                        int maxY = beginY + visRect.height;
                        for (int counter = beginRow + 1; counter <= endRow; ++counter) {
                            testRect = this.getPathBounds(this.tree, this.getPathForRow(this.tree, counter));
                            if (!(testRect.getY() + testRect.getHeight() > (double)maxY)) continue;
                            counter = endRow;
                        }
                        Rectangle rectangle = new Rectangle(visRect.x, beginY, 1, testRect.y + testRect.height - beginY);
                        this.tree.scrollRectToVisible(rectangle);
                    }
                }
            }

            @Override
            protected void installDefaults() {
                super.installDefaults();
                Object leftChildIndentProperty = UIManager.get("PropTree.leftChildIndent");
                Object rightChildIndentProperty = UIManager.get("PropTree.rightChildIndent");
                int leftChildIndent = leftChildIndentProperty != null ? (Integer)leftChildIndentProperty : 5;
                int rightChildIndent = rightChildIndentProperty != null ? (Integer)rightChildIndentProperty : 10;
                this.setLeftChildIndent(leftChildIndent);
                this.setRightChildIndent(rightChildIndent);
            }

            @Override
            protected void paintHorizontalLine(Graphics g, JComponent c, int y, int left, int right) {
            }

            @Override
            protected void paintRow(Graphics g, Rectangle clipBounds, Insets insets, Rectangle bounds, TreePath path, int row, boolean isExpanded, boolean hasBeenExpanded, boolean isLeaf) {
                Color gColor = g.getColor();
                g.setColor(UIManager.getColor("control"));
                g.fillRect(0, bounds.y, this.totalChildIndent - 2, bounds.height);
                int width = clipBounds.width - bounds.x;
                if ((double)width > bounds.getWidth()) {
                    bounds = new Rectangle(bounds.x, bounds.y, width, bounds.height);
                }
                g.setColor(gColor);
                super.paintRow(g, clipBounds, insets, bounds, path, row, isExpanded, hasBeenExpanded, isLeaf);
                if (!isLeaf) {
                    super.paintExpandControl(g, clipBounds, insets, bounds, path, row, isExpanded, hasBeenExpanded, isLeaf);
                }
            }

            @Override
            protected void paintVerticalLine(Graphics g, JComponent c, int x, int top, int bottom) {
            }
        }

        private static class PropertyTreeCellRenderer
        extends DefaultTreeCellRenderer {
            private static final long serialVersionUID = 0L;

            private PropertyTreeCellRenderer() {
            }

            @Override
            public Component getTreeCellRendererComponent(JTree tree, Object value, boolean sel, boolean expanded, boolean leaf, int row, boolean hasFocus) {
                super.getTreeCellRendererComponent(tree, value, sel, expanded, leaf, row, hasFocus);
                if (!(value instanceof AbstractProperty)) {
                    return this;
                }
                AbstractProperty property = (AbstractProperty)value;
                boolean isGroup = value instanceof PropertyGroup;
                boolean isRootChild = false;
                if (isGroup) {
                    PropertyGroup group = (PropertyGroup)value;
                    boolean bl = isRootChild = group.getParentCount() == 1;
                }
                if (isGroup && isRootChild) {
                    if (row != -1 && property.getClientProperty("state").equals("initial")) {
                        property.putClientProperty("state", "");
                    }
                    if (row != -1 && property.getClientProperty("expand").equals("true")) {
                        tree.expandRow(row);
                    }
                    if (property.getStatus().getType() == 1) {
                        this.setForeground(Color.red);
                    }
                } else {
                    this.setFont(this.getFont().deriveFont(0));
                    if (property.getStatus().getType() == 1) {
                        this.setForeground(Color.red);
                    } else if (sel) {
                        this.setForeground(this.getTextSelectionColor());
                    } else {
                        this.setForeground(this.getTextNonSelectionColor());
                    }
                }
                this.setIcon(null);
                this.setIconTextGap(5);
                this.setText(property.getText());
                this.setEnabled(isGroup || property.isEditable() || sel);
                return this;
            }
        }

        private static class PropertyTableCellRenderer
        extends DefaultTableCellRenderer {
            static final long serialVersionUID = 7200668185737087253L;
            static final long serialCheck = -2278137705859514952L;

            @Override
            public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
                super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
                if (!(value instanceof Property)) {
                    return this;
                }
                Property property = (Property)value;
                PropertyRenderer propertyRenderer = property.getPropertyRenderer();
                Object propertyValue = property.getValue();
                if (propertyRenderer == null) {
                    if (propertyValue != null) {
                        this.setText(propertyValue.toString());
                        this.setToolTipText(propertyValue.toString());
                    }
                } else {
                    this.setText(propertyRenderer.getRenderer(property));
                    this.setToolTipText(propertyRenderer.getToolTip(property));
                }
                this.setEnabled(property instanceof PropertyGroup || property.isEditable() || isSelected);
                return this;
            }
        }
    }
}

