/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.ui.peer.swing;

import java.awt.Cursor;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import javax.swing.JLabel;
import oracle.bpm.ui.Image;
import oracle.bpm.ui.action.BaseAction;
import oracle.bpm.ui.peer.LinkPeer;
import oracle.bpm.ui.peer.swing.SwingComponent;

public class SwingLink
extends SwingComponent
implements LinkPeer {
    public SwingLink(SwingComponent parent) {
        super(parent, new JLinkLabel());
    }

    @Override
    public void setText(String text) {
        this.getLink().setText(text);
    }

    public String getText() {
        return this.getLink().getText();
    }

    @Override
    public void setAction(BaseAction action) {
        this.getLink().setAction(action);
    }

    @Override
    public void setIcon(Image icon) {
        this.getLink().setIcon(SwingLink.asSwingIcon(icon));
    }

    JLinkLabel getLink() {
        return (JLinkLabel)this.getComponent();
    }

    private static class JLinkLabel
    extends JLabel {
        private ActionListener action;
        private String text;
        private static final long serialVersionUID = 0L;

        public JLinkLabel() {
            this.setCursor(Cursor.getPredefinedCursor(12));
            this.enableEvents(16L);
        }

        @Override
        public void setEnabled(boolean enabled) {
            super.setEnabled(enabled);
            this.resetText();
        }

        @Override
        public void setText(String text) {
            this.text = text;
            this.resetText();
        }

        public String getNormalText() {
            return this.text;
        }

        public void setAction(ActionListener action) {
            this.action = action;
        }

        @Override
        protected void processMouseEvent(MouseEvent evt) {
            super.processMouseEvent(evt);
            if (this.isEnabled() && evt.getID() == 500) {
                this.fireActionPerformed(new ActionEvent(this, 1001, this.getNormalText()));
            }
        }

        protected void fireActionPerformed(ActionEvent evt) {
            if (this.action != null) {
                this.action.actionPerformed(evt);
            }
        }

        private void resetText() {
            String text = this.isEnabled() ? "<html><font color=\"#0000CF\"><u>" + this.getNormalText() + "</u></font></html>" : this.getNormalText();
            super.setText(text);
        }
    }
}

