/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.ui.peer.swing;

import java.awt.Component;
import java.awt.Container;
import java.awt.event.ActionEvent;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import javax.swing.AbstractAction;
import javax.swing.JFrame;
import javax.swing.JMenuBar;
import javax.swing.JRootPane;
import javax.swing.JToolBar;
import javax.swing.KeyStroke;
import oracle.bpm.ui.Frame;
import oracle.bpm.ui.Image;
import oracle.bpm.ui.MenuBar;
import oracle.bpm.ui.UiContainer;
import oracle.bpm.ui.peer.FramePeer;
import oracle.bpm.ui.peer.ImagePeer;
import oracle.bpm.ui.peer.Peer;
import oracle.bpm.ui.peer.ToolBarPeer;
import oracle.bpm.ui.peer.swing.SwingComponent;
import oracle.bpm.ui.peer.swing.SwingContainer;
import oracle.bpm.ui.peer.swing.SwingImage;
import oracle.bpm.ui.peer.swing.SwingWindow;
import oracle.bpm.ui.statusbar.StatusBar;

public class SwingFrame
extends SwingWindow
implements FramePeer {
    SwingFrame() {
        super(null);
        this.setComponent(new ExtendedFrame());
    }

    SwingFrame(SwingComponent parent, JFrame frame) {
        super(parent, frame);
    }

    @Override
    public int getExtendedState() {
        return this.getFrame().getExtendedState();
    }

    @Override
    public Image getIconImage() {
        return Image.create(this.getFrame().getIconImage());
    }

    @Override
    public UiContainer getRootPane() {
        return new RootPane();
    }

    @Override
    public int getState() {
        return this.getFrame().getState();
    }

    @Override
    public boolean isUndecorated() {
        return this.getFrame().isUndecorated();
    }

    @Override
    public void revalidate() {
        JFrame frame = this.getFrame();
        frame.invalidate();
        frame.validate();
    }

    @Override
    public void setDefaultCloseOperation(int op) {
        this.getFrame().setDefaultCloseOperation(op);
    }

    @Override
    public void setExtendedState(int state) {
        this.getFrame().setExtendedState(state);
    }

    @Override
    public void setIconImage(Image image) {
        this.getFrame().setIconImage(image.asAwtImage());
    }

    public void setImage(ImagePeer image) {
        SwingImage swingImage = (SwingImage)image;
        this.getFrame().setIconImage(swingImage.asAwtImage());
    }

    @Override
    public void setMenuBar(MenuBar menuBar) {
        this.getFrame().setJMenuBar((JMenuBar)SwingFrame.asSwing(menuBar));
    }

    @Override
    public void setResizable(boolean resizable) {
        this.getFrame().setResizable(resizable);
    }

    @Override
    public void setSize(int width, int height) {
        this.getFrame().setSize(width, height);
    }

    @Override
    public void setState(int state) {
        this.getFrame().setState(state);
    }

    @Override
    public void setStatusBar(StatusBar statusBar) {
        this.getContentPane().add(statusBar, "South");
    }

    @Override
    public void setTitle(String title) {
        this.getFrame().setTitle(title);
    }

    @Override
    public void setToolBar(ToolBarPeer peer) {
        SwingComponent component = (SwingComponent)((Object)peer);
        JToolBar toolBar = (JToolBar)component.getComponent();
        this.getFrame().getContentPane().add((Component)toolBar, "North");
    }

    @Override
    public void setUndecorated(boolean undecorated) {
        this.getFrame().setUndecorated(undecorated);
    }

    @Override
    protected Container getSwingContentPane() {
        return this.getFrame().getContentPane();
    }

    private JFrame getFrame() {
        return (JFrame)this.getComponent();
    }

    class RootPane
    extends UiContainer {
        RootPane() {
            super((UiContainer)null);
        }

        @Override
        protected Peer createPeer() {
            JRootPane rootPane = SwingFrame.this.getFrame().getRootPane();
            return new SwingContainer(SwingFrame.this, rootPane);
        }
    }

    class ExtendedFrame
    extends JFrame
    implements WindowListener {
        private static final long serialVersionUID = 0L;

        ExtendedFrame() {
            this.init();
        }

        @Override
        public void windowActivated(WindowEvent e) {
        }

        @Override
        public void windowClosed(WindowEvent e) {
        }

        @Override
        public void windowClosing(WindowEvent e) {
        }

        @Override
        public void windowDeactivated(WindowEvent e) {
        }

        @Override
        public void windowDeiconified(WindowEvent e) {
        }

        @Override
        public void windowIconified(WindowEvent e) {
        }

        @Override
        public void windowOpened(WindowEvent e) {
        }

        private void init() {
            this.addShowHelpByF1Key();
        }

        private void addShowHelpByF1Key() {
            KeyStroke f1 = KeyStroke.getKeyStroke(112, 0, false);
            AbstractAction helpAction = new AbstractAction(){
                private static final long serialVersionUID = 7833016144345667370L;

                @Override
                public void actionPerformed(ActionEvent e) {
                    ExtendedFrame.this.getUiFrame().showContextualHelp();
                }
            };
            this.getRootPane().getInputMap(2).put(f1, "f1");
            this.getRootPane().getActionMap().put("f1", helpAction);
        }

        private Frame getUiFrame() {
            return (Frame)SwingFrame.this.getUiComponent();
        }
    }
}

