/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.ui.peer.swing;

import java.awt.Cursor;
import java.awt.Toolkit;
import java.awt.dnd.DragSource;
import oracle.bpm.geom.Point;
import oracle.bpm.ui.Cursor;
import oracle.bpm.ui.Image;
import oracle.bpm.ui.peer.CursorPeer;
import oracle.bpm.ui.peer.swing.AwtConverter;

public class SwingCursor
implements CursorPeer {
    private Cursor cursor;
    public static final Cursor WE_RESIZE_CURSOR = Cursor.getPredefinedCursor(10);
    public static final Cursor NS_RESIZE_CURSOR = Cursor.getPredefinedCursor(9);
    public static final Cursor COPY_DROP = DragSource.DefaultCopyDrop;
    public static final Cursor LINK_DROP = DragSource.DefaultLinkDrop;
    public static final Cursor LINK_NO_DROP = DragSource.DefaultLinkNoDrop;
    public static final Cursor COPY_NO_DROP = DragSource.DefaultCopyNoDrop;
    public static final Cursor MOVE_DROP = DragSource.DefaultMoveDrop;
    public static final Cursor MOVE_NO_DROP = DragSource.DefaultMoveNoDrop;
    public static final Cursor WAIT_CURSOR = Cursor.getPredefinedCursor(3);
    public static final Cursor DEFAULT_CURSOR = Cursor.getPredefinedCursor(0);
    public static final Cursor HAND_CURSOR = Cursor.getPredefinedCursor(12);
    public static final Cursor E_RESIZE_CURSOR = Cursor.getPredefinedCursor(11);
    public static final Cursor TEXT_CURSOR = Cursor.getPredefinedCursor(2);
    public static final Cursor CROSSHAIR_CURSOR = Cursor.getPredefinedCursor(1);
    public static final Cursor S_RESIZE_CURSOR = Cursor.getPredefinedCursor(9);
    public static final Cursor CROSS_HAIR_CURSOR = Cursor.getPredefinedCursor(1);
    public static final Cursor MOVE_CURSOR = Cursor.getPredefinedCursor(13);
    public static final Cursor W_RESIZE_CURSOR = Cursor.getPredefinedCursor(10);
    public static final Cursor N_RESIZE_CURSOR = Cursor.getPredefinedCursor(8);
    public static final Cursor SW_RESIZE_CURSOR = Cursor.getPredefinedCursor(4);
    public static final Cursor SE_RESIZE_CURSOR = Cursor.getPredefinedCursor(5);
    public static final Cursor NW_RESIZE_CURSOR = Cursor.getPredefinedCursor(6);
    public static final Cursor NE_RESIZE_CURSOR = Cursor.getPredefinedCursor(7);

    public SwingCursor(Cursor cursor) {
        this.cursor = cursor;
    }

    public SwingCursor(Cursor.CursorType cursorType) {
        this.cursor = SwingCursor.toSwingCursor(cursorType);
    }

    public SwingCursor(Image image, Point hotSpot, String name) {
        this.cursor = Toolkit.getDefaultToolkit().createCustomCursor(image.asAwtImage(), AwtConverter.toAwt(hotSpot), name);
    }

    @Override
    public Object getNative() {
        return this.cursor;
    }

    @Override
    public Object getClientProperty(String key) {
        return null;
    }

    @Override
    public void putClientProperty(String key, Object value) {
    }

    @Override
    public boolean isDisposed() {
        return this.cursor == null;
    }

    @Override
    public void dispose() {
        this.cursor = null;
    }

    private static Cursor toSwingCursor(Cursor.CursorType cursorType) {
        switch (cursorType) {
            case COPY_DROP: {
                return COPY_DROP;
            }
            case COPY_NO_DROP: {
                return COPY_NO_DROP;
            }
            case WAIT_CURSOR: {
                return WAIT_CURSOR;
            }
            case DEFAULT_CURSOR: {
                return DEFAULT_CURSOR;
            }
            case HAND_CURSOR: {
                return HAND_CURSOR;
            }
            case E_RESIZE_CURSOR: {
                return E_RESIZE_CURSOR;
            }
            case TEXT_CURSOR: {
                return TEXT_CURSOR;
            }
            case CROSSHAIR_CURSOR: {
                return CROSS_HAIR_CURSOR;
            }
            case S_RESIZE_CURSOR: {
                return S_RESIZE_CURSOR;
            }
            case MOVE_CURSOR: {
                return MOVE_CURSOR;
            }
            case W_RESIZE_CURSOR: {
                return W_RESIZE_CURSOR;
            }
            case WE_RESIZE_CURSOR: {
                return WE_RESIZE_CURSOR;
            }
            case NS_RESIZE_CURSOR: {
                return NS_RESIZE_CURSOR;
            }
            case N_RESIZE_CURSOR: {
                return N_RESIZE_CURSOR;
            }
            case LINK_DROP: {
                return LINK_DROP;
            }
            case LINK_NO_DROP: {
                return LINK_NO_DROP;
            }
            case MOVE_DROP: {
                return MOVE_DROP;
            }
            case MOVE_NO_DROP: {
                return MOVE_NO_DROP;
            }
            case SW_RESIZE_CURSOR: {
                return SW_RESIZE_CURSOR;
            }
            case SE_RESIZE_CURSOR: {
                return SE_RESIZE_CURSOR;
            }
            case NW_RESIZE_CURSOR: {
                return NW_RESIZE_CURSOR;
            }
            case NE_RESIZE_CURSOR: {
                return NE_RESIZE_CURSOR;
            }
        }
        throw new IllegalArgumentException("Illegal cursor type: " + (Object)((Object)cursorType));
    }
}

