/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.ui.layout.form;

import java.io.IOException;
import java.io.ObjectOutputStream;
import java.io.PrintWriter;
import java.io.Serializable;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import oracle.bpm.geom.Dimension;
import oracle.bpm.ui.Margin;
import oracle.bpm.ui.Panel;
import oracle.bpm.ui.UiComponent;
import oracle.bpm.ui.UiContainer;
import oracle.bpm.ui.layout.Layout;
import oracle.bpm.ui.layout.form.CellConstraints;
import oracle.bpm.ui.layout.form.ColumnSpec;
import oracle.bpm.ui.layout.form.FormSpec;
import oracle.bpm.ui.layout.form.PanelBuilder;
import oracle.bpm.ui.layout.form.RowSpec;
import oracle.bpm.ui.layout.form.Sizes;
import org.jetbrains.annotations.NonNls;

public class FormLayout
implements Layout {
    private List<UiComponent>[] colComponents;
    private int[][] colGroupIndices;
    private final List<ColumnSpec> colSpecs;
    private final ComponentSizeCache componentSizeCache;
    private UiContainer container;
    private final Measure minimumHeightMeasure;
    private final Measure minimumWidthMeasure;
    private final Measure preferredHeightMeasure;
    private final Measure preferredWidthMeasure;
    private List<UiComponent>[] rowComponents;
    private int[][] rowGroupIndices;
    private final List<RowSpec> rowSpecs;

    public FormLayout(String encodedColumnSpecs) {
        this(encodedColumnSpecs, "");
    }

    public FormLayout(ColumnSpec[] colSpecs, RowSpec[] rowSpecs) {
        if (colSpecs == null) {
            throw new NullPointerException("The column specifications must not be null.");
        }
        if (rowSpecs == null) {
            throw new NullPointerException("The row specifications must not be null.");
        }
        this.colSpecs = new ArrayList<ColumnSpec>(Arrays.asList(colSpecs));
        this.rowSpecs = new ArrayList<RowSpec>(Arrays.asList(rowSpecs));
        this.colGroupIndices = new int[0][];
        this.rowGroupIndices = new int[0][];
        int initialCapacity = colSpecs.length * rowSpecs.length / 4;
        this.componentSizeCache = new ComponentSizeCache(initialCapacity);
        this.minimumWidthMeasure = new MinimumWidthMeasure(this.componentSizeCache);
        this.minimumHeightMeasure = new MinimumHeightMeasure(this.componentSizeCache);
        this.preferredWidthMeasure = new PreferredWidthMeasure(this.componentSizeCache);
        this.preferredHeightMeasure = new PreferredHeightMeasure(this.componentSizeCache);
    }

    public FormLayout(@NonNls String encodedColumnSpecs, @NonNls String encodedRowSpecs) {
        this(ColumnSpec.decodeSpecs(encodedColumnSpecs), RowSpec.decodeSpecs(encodedRowSpecs));
    }

    @Override
    public void validateAddedComponent(UiContainer c, UiComponent component, Object constraints) {
    }

    public void addGroupedColumn(int columnIndex) {
        Object newColGroups = this.getColumnGroups();
        if (((int[][])newColGroups).length == 0) {
            newColGroups = new int[][]{{columnIndex}};
        } else {
            int lastGroupIndex = ((int[][])newColGroups).length - 1;
            int[] lastGroup = newColGroups[lastGroupIndex];
            int groupSize = lastGroup.length;
            int[] newLastGroup = new int[groupSize + 1];
            System.arraycopy(lastGroup, 0, newLastGroup, 0, groupSize);
            newLastGroup[groupSize] = columnIndex;
            newColGroups[lastGroupIndex] = newLastGroup;
        }
        this.setColumnGroups((int[][])newColGroups);
    }

    public void addGroupedRow(int rowIndex) {
        Object newRowGroups = this.getRowGroups();
        if (((int[][])newRowGroups).length == 0) {
            newRowGroups = new int[][]{{rowIndex}};
        } else {
            int lastGroupIndex = ((int[][])newRowGroups).length - 1;
            int[] lastGroup = newRowGroups[lastGroupIndex];
            int groupSize = lastGroup.length;
            int[] newLastGroup = new int[groupSize + 1];
            System.arraycopy(lastGroup, 0, newLastGroup, 0, groupSize);
            newLastGroup[groupSize] = rowIndex;
            newRowGroups[lastGroupIndex] = newLastGroup;
        }
        this.setRowGroups((int[][])newRowGroups);
    }

    public void addLayoutComponent(String name, UiComponent component) {
        throw new UnsupportedOperationException("Use #addLayoutComponent(UiComponent, Object) instead.");
    }

    public void addLayoutComponent(UiComponent comp, Object constraints) {
        if (constraints instanceof String) {
            this.setConstraints(comp, new CellConstraints((String)constraints));
        } else if (constraints instanceof CellConstraints) {
            this.setConstraints(comp, (CellConstraints)constraints);
        } else {
            if (constraints == null) {
                throw new NullPointerException("The constraints must not be null.");
            }
            throw new IllegalArgumentException("Illegal constraint type " + constraints.getClass());
        }
    }

    public void appendColumn(ColumnSpec columnSpec) {
        if (columnSpec == null) {
            throw new NullPointerException("The column spec must not be null.");
        }
        this.colSpecs.add(columnSpec);
    }

    public void appendColumn(String columnSpec) {
        this.appendColumn(new ColumnSpec(columnSpec));
    }

    public void appendRow(RowSpec rowSpec) {
        if (rowSpec == null) {
            throw new NullPointerException("The row spec must not be null.");
        }
        this.rowSpecs.add(rowSpec);
    }

    public void appendRow(String rowSpec) {
        this.appendRow(new RowSpec(rowSpec));
    }

    public PanelBuilder createBuilder(Panel c) {
        return new PanelBuilder(this, c);
    }

    public PanelBuilder createBuilder(UiContainer c) {
        return new PanelBuilder(c, this);
    }

    public CellConstraints createCellConstraints() {
        return new CellConstraints();
    }

    public CellConstraints createCellConstraints(int columnCount, int rowCount) {
        return new CellConstraints(columnCount, rowCount);
    }

    public int getColumnCount() {
        return this.colSpecs.size();
    }

    public int[][] getColumnGroups() {
        return this.deepClone(this.colGroupIndices);
    }

    public ColumnSpec getColumnSpec(int columnIndex) {
        return this.colSpecs.get(columnIndex - 1);
    }

    public CellConstraints getConstraints(UiComponent component) {
        if (component == null) {
            throw new NullPointerException("The component must not be null.");
        }
        CellConstraints constraints = (CellConstraints)component.getLayoutData();
        if (constraints == null) {
            throw new NullPointerException("The component has not been added to the container.");
        }
        return constraints.clone();
    }

    @Override
    public float getLayoutAlignmentX(UiContainer parent) {
        return 0.5f;
    }

    @Override
    public float getLayoutAlignmentY(UiContainer parent) {
        return 0.5f;
    }

    public LayoutInfo getLayoutInfo(UiContainer parent) {
        this.initializeColAndRowComponentLists();
        Dimension size = parent.getSize();
        Margin insets = parent.getInsets();
        int totalWidth = size.getWidth() - insets.left - insets.right;
        int totalHeight = size.getHeight() - insets.top - insets.bottom;
        int[] x = this.computeGridOrigins(parent, totalWidth, insets.left, this.colSpecs, this.colComponents, this.colGroupIndices, this.minimumWidthMeasure, this.preferredWidthMeasure);
        int[] y = this.computeGridOrigins(parent, totalHeight, insets.top, this.rowSpecs, this.rowComponents, this.rowGroupIndices, this.minimumHeightMeasure, this.preferredHeightMeasure);
        return new LayoutInfo(x, y);
    }

    public int getRowCount() {
        return this.rowSpecs.size();
    }

    public int[][] getRowGroups() {
        return this.deepClone(this.rowGroupIndices);
    }

    public RowSpec getRowSpec(int rowIndex) {
        return this.rowSpecs.get(rowIndex - 1);
    }

    public void insertColumn(int columnIndex, ColumnSpec columnSpec) {
        if (columnIndex < 1 || columnIndex > this.getColumnCount()) {
            throw new IndexOutOfBoundsException("The column index " + columnIndex + "must be in the range [1, " + this.getColumnCount() + "].");
        }
        this.colSpecs.add(columnIndex - 1, columnSpec);
        this.shiftComponentsHorizontally(columnIndex, false);
        this.adjustGroupIndices(this.colGroupIndices, columnIndex, false);
    }

    public void insertRow(int rowIndex, RowSpec rowSpec) {
        if (rowIndex < 1 || rowIndex > this.getRowCount()) {
            throw new IndexOutOfBoundsException("The row index " + rowIndex + " must be in the range [1, " + this.getRowCount() + "].");
        }
        this.rowSpecs.add(rowIndex - 1, rowSpec);
        this.shiftComponentsVertically(rowIndex, false);
        this.adjustGroupIndices(this.rowGroupIndices, rowIndex, false);
    }

    @Override
    public void invalidateLayout(UiContainer target) {
        this.invalidateCaches();
    }

    @Override
    public void layoutContainer(UiContainer c) {
        this.setContainer(c);
        this.initializeColAndRowComponentLists();
        Dimension size = c.getSize();
        Margin insets = c.getInsets();
        int totalWidth = size.getWidth() - insets.left - insets.right;
        int totalHeight = size.getHeight() - insets.top - insets.bottom;
        int[] x = this.computeGridOrigins(c, totalWidth, insets.left, this.colSpecs, this.colComponents, this.colGroupIndices, this.minimumWidthMeasure, this.preferredWidthMeasure);
        int[] y = this.computeGridOrigins(c, totalHeight, insets.top, this.rowSpecs, this.rowComponents, this.rowGroupIndices, this.minimumHeightMeasure, this.preferredHeightMeasure);
        this.layoutComponents(x, y);
    }

    @Override
    public Dimension maximumLayoutSize(UiContainer target) {
        return Dimension.MAX_VALUE;
    }

    @Override
    public Dimension minimumLayoutSize(UiContainer parent) {
        return this.computeLayoutSize(parent, this.minimumWidthMeasure, this.minimumHeightMeasure);
    }

    @Override
    public Dimension preferredLayoutSize(UiContainer parent) {
        return this.computeLayoutSize(parent, this.preferredWidthMeasure, this.preferredHeightMeasure);
    }

    public void removeColumn(int columnIndex) {
        if (columnIndex < 1 || columnIndex > this.getColumnCount()) {
            throw new IndexOutOfBoundsException("The column index " + columnIndex + " must be in the range [1, " + this.getColumnCount() + "].");
        }
        this.colSpecs.remove(columnIndex - 1);
        this.shiftComponentsHorizontally(columnIndex, true);
        this.adjustGroupIndices(this.colGroupIndices, columnIndex, true);
    }

    @Override
    public void removeLayoutComponent(UiComponent comp) {
        this.removeConstraints(comp);
    }

    public void removeRow(int rowIndex) {
        if (rowIndex < 1 || rowIndex > this.getRowCount()) {
            throw new IndexOutOfBoundsException("The row index " + rowIndex + "must be in the range [1, " + this.getRowCount() + "].");
        }
        this.rowSpecs.remove(rowIndex - 1);
        this.shiftComponentsVertically(rowIndex, true);
        this.adjustGroupIndices(this.rowGroupIndices, rowIndex, true);
    }

    public void setColumnGroups(int[][] colGroupIndices) {
        int maxColumn = this.getColumnCount();
        boolean[] usedIndices = new boolean[maxColumn + 1];
        for (int group = 0; group < colGroupIndices.length; ++group) {
            for (int j = 0; j < colGroupIndices[group].length; ++j) {
                int colIndex = colGroupIndices[group][j];
                if (colIndex < 1 || colIndex > maxColumn) {
                    throw new IndexOutOfBoundsException("Invalid column group index " + colIndex + " in group " + (group + 1));
                }
                if (usedIndices[colIndex]) {
                    throw new IllegalArgumentException("Column index " + colIndex + " must not be used in multiple column groups.");
                }
                usedIndices[colIndex] = true;
            }
        }
        this.colGroupIndices = this.deepClone(colGroupIndices);
    }

    public void setColumnSpec(int columnIndex, ColumnSpec columnSpec) {
        if (columnSpec == null) {
            throw new NullPointerException("The column spec must not be null.");
        }
        this.colSpecs.set(columnIndex - 1, columnSpec);
    }

    public void setConstraints(UiComponent component, CellConstraints constraints) {
        if (component == null) {
            throw new NullPointerException("The component must not be null.");
        }
        if (constraints == null) {
            throw new NullPointerException("The constraints must not be null.");
        }
        constraints.ensureValidGridBounds(this.getColumnCount(), this.getRowCount());
        component.setLayoutData(constraints);
    }

    public void setRowGroups(int[][] rowGroupIndices) {
        int rowCount = this.getRowCount();
        boolean[] usedIndices = new boolean[rowCount + 1];
        for (int i = 0; i < rowGroupIndices.length; ++i) {
            for (int j = 0; j < rowGroupIndices[i].length; ++j) {
                int rowIndex = rowGroupIndices[i][j];
                if (rowIndex < 1 || rowIndex > rowCount) {
                    throw new IndexOutOfBoundsException("Invalid row group index " + rowIndex + " in group " + (i + 1));
                }
                if (usedIndices[rowIndex]) {
                    throw new IllegalArgumentException("Row index " + rowIndex + " must not be used in multiple row groups.");
                }
                usedIndices[rowIndex] = true;
            }
        }
        this.rowGroupIndices = this.deepClone(rowGroupIndices);
    }

    public void setRowSpec(int rowIndex, RowSpec rowSpec) {
        if (rowSpec == null) {
            throw new NullPointerException("The row spec must not be null.");
        }
        this.rowSpecs.set(rowIndex - 1, rowSpec);
    }

    void setContainer(UiContainer container) {
        this.container = container;
    }

    private void adjustGroupIndices(int[][] allGroupIndices, int modifiedIndex, boolean remove) {
        int offset = remove ? -1 : 1;
        for (int[] groupIndices : allGroupIndices) {
            for (int i = 0; i < groupIndices.length; ++i) {
                int index = groupIndices[i];
                if (index == modifiedIndex && remove) {
                    throw new IllegalStateException("The removed index " + modifiedIndex + " must not be grouped.");
                }
                if (index < modifiedIndex) continue;
                int n = i;
                groupIndices[n] = groupIndices[n] + offset;
            }
        }
    }

    private int[] compressedSizes(List formSpecs, int totalSize, int totalMinSize, int totalPrefSize, int[] minSizes, int[] prefSizes) {
        if (totalSize < totalMinSize) {
            return minSizes;
        }
        if (totalSize >= totalPrefSize) {
            return prefSizes;
        }
        int count = formSpecs.size();
        int[] sizes = new int[count];
        double totalCompressionSpace = totalPrefSize - totalSize;
        double maxCompressionSpace = totalPrefSize - totalMinSize;
        double compressionFactor = totalCompressionSpace / maxCompressionSpace;
        for (int i = 0; i < count; ++i) {
            FormSpec formSpec = (FormSpec)formSpecs.get(i);
            sizes[i] = prefSizes[i];
            if (formSpec.getSize() != Sizes.DEFAULT) continue;
            int n = i;
            sizes[n] = sizes[n] - (int)Math.round((double)(prefSizes[i] - minSizes[i]) * compressionFactor);
        }
        return sizes;
    }

    private int[] computeGridOrigins(UiContainer c, int totalSize, int offset, List formSpecs, List[] componentLists, int[][] groupIndices, Measure minMeasure, Measure prefMeasure) {
        int[] minSizes = this.maximumSizes(c, formSpecs, componentLists, minMeasure, prefMeasure, minMeasure);
        int[] prefSizes = this.maximumSizes(c, formSpecs, componentLists, minMeasure, prefMeasure, prefMeasure);
        int[] groupedMinSizes = this.groupedSizes(groupIndices, minSizes);
        int[] groupedPrefSizes = this.groupedSizes(groupIndices, prefSizes);
        int totalMinSize = this.sum(groupedMinSizes);
        int totalPrefSize = this.sum(groupedPrefSizes);
        int[] compressedSizes = this.compressedSizes(formSpecs, totalSize, totalMinSize, totalPrefSize, groupedMinSizes, prefSizes);
        int[] groupedSizes = this.groupedSizes(groupIndices, compressedSizes);
        int totalGroupedSize = this.sum(groupedSizes);
        int[] sizes = this.distributedSizes(formSpecs, totalSize, totalGroupedSize, groupedSizes);
        return this.computeOrigins(sizes, offset);
    }

    private Dimension computeLayoutSize(UiContainer parent, Measure defaultWidthMeasure, Measure defaultHeightMeasure) {
        this.setContainer(parent);
        this.initializeColAndRowComponentLists();
        int[] colWidths = this.maximumSizes(parent, this.colSpecs, this.colComponents, this.minimumWidthMeasure, this.preferredWidthMeasure, defaultWidthMeasure);
        int[] rowHeights = this.maximumSizes(parent, this.rowSpecs, this.rowComponents, this.minimumHeightMeasure, this.preferredHeightMeasure, defaultHeightMeasure);
        int[] groupedWidths = this.groupedSizes(this.colGroupIndices, colWidths);
        int[] groupedHeights = this.groupedSizes(this.rowGroupIndices, rowHeights);
        int[] xOrigins = this.computeOrigins(groupedWidths, 0);
        int[] yOrigins = this.computeOrigins(groupedHeights, 0);
        int width1 = this.sum(groupedWidths);
        int height1 = this.sum(groupedHeights);
        int maxWidth = width1;
        int maxHeight = height1;
        int[] maxFixedSizeColsTable = this.computeMaximumFixedSpanTable(this.colSpecs);
        int[] maxFixedSizeRowsTable = this.computeMaximumFixedSpanTable(this.rowSpecs);
        List<UiComponent> components = parent.getComponents();
        for (UiComponent component : components) {
            int gridY2;
            int compHeight;
            int gridY1;
            int myHeight;
            int trail;
            int lead;
            CellConstraints constraints = (CellConstraints)component.getLayoutData();
            if (constraints.gridWidth > 1 && constraints.gridWidth > maxFixedSizeColsTable[constraints.gridX - 1]) {
                int compWidth = defaultWidthMeasure.sizeOf(component);
                int gridX1 = constraints.gridX - 1;
                int gridX2 = gridX1 + constraints.gridWidth;
                if (gridX1 >= xOrigins.length || gridX2 >= xOrigins.length) {
                    throw new IndexOutOfBoundsException("Invalid layout data for component '" + component + "' and parent '" + parent + "': " + constraints + ". Parent contains this children: " + components);
                }
                lead = xOrigins[gridX1];
                trail = width1 - xOrigins[gridX2];
                int myWidth = lead + compWidth + trail;
                if (myWidth > maxWidth) {
                    maxWidth = myWidth;
                }
            }
            if (constraints.gridHeight <= 1 || constraints.gridHeight <= maxFixedSizeRowsTable[constraints.gridY - 1] || (myHeight = (lead = yOrigins[gridY1 = constraints.gridY - 1]) + (compHeight = defaultHeightMeasure.sizeOf(component)) + (trail = height1 - yOrigins[gridY2 = gridY1 + constraints.gridHeight])) <= maxHeight) continue;
            maxHeight = myHeight;
        }
        Margin insets = parent.getInsets();
        int width = maxWidth + insets.left + insets.right;
        int height = maxHeight + insets.top + insets.bottom;
        return Dimension.valueOf(width, height);
    }

    private int[] computeMaximumFixedSpanTable(List formSpecs) {
        int size = formSpecs.size();
        int[] table = new int[size];
        int maximumFixedSpan = Integer.MAX_VALUE;
        for (int i = size - 1; i >= 0; --i) {
            FormSpec spec = (FormSpec)formSpecs.get(i);
            if (spec.canGrow()) {
                maximumFixedSpan = 0;
            }
            table[i] = maximumFixedSpan;
            if (maximumFixedSpan >= Integer.MAX_VALUE) continue;
            ++maximumFixedSpan;
        }
        return table;
    }

    private int[] computeOrigins(int[] sizes, int offset) {
        int count = sizes.length;
        int[] origins = new int[count + 1];
        origins[0] = offset;
        for (int i = 1; i <= count; ++i) {
            origins[i] = origins[i - 1] + sizes[i - 1];
        }
        return origins;
    }

    private int[][] deepClone(int[][] array) {
        int[][] result = new int[array.length][];
        for (int i = 0; i < result.length; ++i) {
            result[i] = (int[])array[i].clone();
        }
        return result;
    }

    private int[] distributedSizes(List formSpecs, int totalSize, int totalPrefSize, int[] inputSizes) {
        double totalFreeSpace = totalSize - totalPrefSize;
        if (totalFreeSpace < 0.0) {
            return inputSizes;
        }
        int count = formSpecs.size();
        double totalWeight = 0.0;
        for (int i = 0; i < count; ++i) {
            FormSpec formSpec = (FormSpec)formSpecs.get(i);
            totalWeight += formSpec.getResizeWeight();
        }
        if (totalWeight == 0.0) {
            return inputSizes;
        }
        int[] sizes = new int[count];
        double restSpace = totalFreeSpace;
        int roundedRestSpace = (int)totalFreeSpace;
        for (int i = 0; i < count; ++i) {
            FormSpec formSpec = (FormSpec)formSpecs.get(i);
            double weight = formSpec.getResizeWeight();
            if (weight == 0.0) {
                sizes[i] = inputSizes[i];
                continue;
            }
            double roundingCorrection = restSpace - (double)roundedRestSpace;
            double extraSpace = totalFreeSpace * weight / totalWeight;
            double correctedExtraSpace = extraSpace - roundingCorrection;
            int roundedExtraSpace = (int)Math.round(correctedExtraSpace);
            sizes[i] = inputSizes[i] + roundedExtraSpace;
            restSpace -= extraSpace;
            roundedRestSpace -= roundedExtraSpace;
        }
        return sizes;
    }

    private UiContainer getContainer() {
        return this.container;
    }

    private int[] groupedSizes(int[][] groups, int[] rawSizes) {
        if (groups == null || groups.length == 0) {
            return rawSizes;
        }
        int[] sizes = new int[rawSizes.length];
        System.arraycopy(rawSizes, 0, sizes, 0, Math.min(rawSizes.length, sizes.length));
        for (int[] groupIndices : groups) {
            int index;
            int groupMaxSize = 0;
            for (int groupIndice : groupIndices) {
                index = groupIndice - 1;
                groupMaxSize = Math.max(groupMaxSize, sizes[index]);
            }
            for (int groupIndice : groupIndices) {
                index = groupIndice - 1;
                sizes[index] = groupMaxSize;
            }
        }
        return sizes;
    }

    private void initializeColAndRowComponentLists() {
        int i;
        this.colComponents = this.createListArray(this.getColumnCount());
        for (i = 0; i < this.getColumnCount(); ++i) {
            this.colComponents[i] = new LinkedList<UiComponent>();
        }
        this.rowComponents = this.createListArray(this.getRowCount());
        for (i = 0; i < this.getRowCount(); ++i) {
            this.rowComponents[i] = new LinkedList<UiComponent>();
        }
        List<UiComponent> components = this.getContainer().getComponents();
        for (UiComponent component : components) {
            CellConstraints constraints = (CellConstraints)component.getLayoutData();
            if (constraints == null) {
                StringWriter writer = new StringWriter();
                writer.write("Container '" + this.getContainer() + " columns=" + this.getColumnCount() + "rows=" + this.getRowCount() + "\n");
                writer.write("Component '" + component + "' (" + component.getClass().getName() + ") does " + "not have constraints.");
                writer.write("\n=== Panel Creation Stack Trace ===\n");
                PrintWriter printWriter = new PrintWriter(writer);
                component.stackTrace.printStackTrace(printWriter);
                printWriter.flush();
                writer.write("=== Panel Creation Stack Trace ===\n");
                throw new IllegalStateException(writer.toString());
            }
            if (constraints.gridWidth == 1) {
                this.colComponents[constraints.gridX - 1].add(component);
            }
            if (constraints.gridHeight != 1) continue;
            this.rowComponents[constraints.gridY - 1].add(component);
        }
    }

    private LinkedList<UiComponent>[] createListArray(int count) {
        return new LinkedList[count];
    }

    private void invalidateCaches() {
        this.componentSizeCache.invalidate();
    }

    private void layoutComponents(int[] x, int[] y) {
        Rectangle cellBounds = new Rectangle();
        List<UiComponent> components = this.getContainer().getComponents();
        for (UiComponent component : components) {
            CellConstraints constraints = (CellConstraints)component.getLayoutData();
            int gridX = constraints.gridX - 1;
            int gridY = constraints.gridY - 1;
            int gridWidth = constraints.gridWidth;
            int gridHeight = constraints.gridHeight;
            cellBounds.x = x[gridX];
            cellBounds.y = y[gridY];
            cellBounds.width = x[gridX + gridWidth] - cellBounds.x;
            cellBounds.height = y[gridY + gridHeight] - cellBounds.y;
            constraints.setBounds(component, this, cellBounds, this.minimumWidthMeasure, this.minimumHeightMeasure, this.preferredWidthMeasure, this.preferredHeightMeasure);
        }
    }

    private int[] maximumSizes(UiContainer c, List formSpecs, List[] componentLists, Measure minMeasure, Measure prefMeasure, Measure defaultMeasure) {
        int size = formSpecs.size();
        int[] result = new int[size];
        for (int i = 0; i < size; ++i) {
            FormSpec formSpec = (FormSpec)formSpecs.get(i);
            result[i] = formSpec.maximumSize(c, componentLists[i], minMeasure, prefMeasure, defaultMeasure);
        }
        return result;
    }

    private void removeConstraints(UiComponent component) {
        component.setLayoutData(null);
        this.componentSizeCache.removeEntry(component);
    }

    private void shiftComponentsHorizontally(int columnIndex, boolean remove) {
        int offset = remove ? -1 : 1;
        List<UiComponent> components = this.getContainer().getComponents();
        for (UiComponent component : components) {
            CellConstraints constraints = (CellConstraints)component.getLayoutData();
            int x1 = constraints.gridX;
            int w = constraints.gridWidth;
            int x2 = x1 + w - 1;
            if (x1 == columnIndex && remove) {
                throw new IllegalStateException("The removed column " + columnIndex + " must not contain component origins.\n" + "Illegal component=" + component);
            }
            if (x1 >= columnIndex) {
                constraints.gridX += offset;
                continue;
            }
            if (x2 < columnIndex) continue;
            constraints.gridWidth += offset;
        }
    }

    private void shiftComponentsVertically(int rowIndex, boolean remove) {
        int offset = remove ? -1 : 1;
        List<UiComponent> components = this.getContainer().getComponents();
        for (UiComponent component : components) {
            CellConstraints constraints = (CellConstraints)component.getLayoutData();
            int y1 = constraints.gridY;
            int h = constraints.gridHeight;
            int y2 = y1 + h - 1;
            if (y1 == rowIndex && remove) {
                throw new IllegalStateException("The removed row " + rowIndex + " must not contain component origins.\n" + "Illegal component=" + component);
            }
            if (y1 >= rowIndex) {
                constraints.gridY += offset;
                continue;
            }
            if (y2 < rowIndex) continue;
            constraints.gridHeight += offset;
        }
    }

    private int sum(int[] sizes) {
        int sum = 0;
        for (int i = sizes.length - 1; i >= 0; --i) {
            sum += sizes[i];
        }
        return sum;
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        this.invalidateCaches();
        out.defaultWriteObject();
    }

    private static class PreferredWidthMeasure
    extends CachingMeasure {
        private Dimension preferredSize;
        private static final long serialVersionUID = 879741650870378682L;

        private PreferredWidthMeasure(ComponentSizeCache cache) {
            super(cache);
        }

        @Override
        public int sizeOf(UiComponent c) {
            this.preferredSize = this.cache.getPreferredSize(c);
            return this.preferredSize.getWidth();
        }

        public String toString() {
            return "preferredSize = " + this.preferredSize + ", cache = " + this.cache;
        }
    }

    private static class PreferredHeightMeasure
    extends CachingMeasure {
        private static final long serialVersionUID = 4046685007045093900L;

        private PreferredHeightMeasure(ComponentSizeCache cache) {
            super(cache);
        }

        @Override
        public int sizeOf(UiComponent c) {
            return this.cache.getPreferredSize(c).getHeight();
        }
    }

    private static class MinimumWidthMeasure
    extends CachingMeasure {
        private Dimension minimumSize;
        private static final long serialVersionUID = -7274194030123327562L;

        private MinimumWidthMeasure(ComponentSizeCache cache) {
            super(cache);
        }

        @Override
        public int sizeOf(UiComponent c) {
            this.minimumSize = this.cache.getMinimumSize(c);
            return this.minimumSize.getWidth();
        }

        public String toString() {
            return "minimumSize = " + this.minimumSize + ", cache = " + this.cache;
        }
    }

    private static class MinimumHeightMeasure
    extends CachingMeasure {
        private static final long serialVersionUID = -6778201387493061626L;

        private MinimumHeightMeasure(ComponentSizeCache cache) {
            super(cache);
        }

        @Override
        public int sizeOf(UiComponent c) {
            return this.cache.getMinimumSize(c).getHeight();
        }
    }

    private static class ComponentSizeCache
    implements Serializable {
        private final Map<UiComponent, Dimension> minimumSizes;
        private final Map<UiComponent, Dimension> preferredSizes;
        private static final long serialVersionUID = 7403292335562613693L;

        private ComponentSizeCache(int initialCapacity) {
            this.minimumSizes = new HashMap<UiComponent, Dimension>(initialCapacity);
            this.preferredSizes = new HashMap<UiComponent, Dimension>(initialCapacity);
        }

        public String toString() {
            return "minimumSizes = " + this.minimumSizes + ", preferredSizes = " + this.preferredSizes;
        }

        Dimension getMinimumSize(UiComponent component) {
            Dimension size = this.minimumSizes.get(component);
            if (size == null) {
                size = component.getMinimumSize();
                this.minimumSizes.put(component, size);
            }
            return size;
        }

        Dimension getPreferredSize(UiComponent component) {
            Dimension size = this.preferredSizes.get(component);
            if (size == null) {
                size = component.getPreferredSize();
                this.preferredSizes.put(component, size);
            }
            return size;
        }

        void invalidate() {
            this.minimumSizes.clear();
            this.preferredSizes.clear();
        }

        void removeEntry(UiComponent component) {
            this.minimumSizes.remove(component);
            this.preferredSizes.remove(component);
        }
    }

    private static abstract class CachingMeasure
    implements Measure,
    Serializable {
        protected final ComponentSizeCache cache;

        private CachingMeasure(ComponentSizeCache cache) {
            this.cache = cache;
        }
    }

    public static class Rectangle {
        public int height = 0;
        public int width = 0;
        public int x = 0;
        public int y = 0;
    }

    public static final class LayoutInfo {
        public final int[] columnOrigins;
        public final int[] rowOrigins;

        private LayoutInfo(int[] xOrigins, int[] yOrigins) {
            this.columnOrigins = xOrigins;
            this.rowOrigins = yOrigins;
        }

        public int getHeight() {
            return this.rowOrigins[this.rowOrigins.length - 1] - this.rowOrigins[0];
        }

        public int getWidth() {
            return this.columnOrigins[this.columnOrigins.length - 1] - this.columnOrigins[0];
        }

        public int getX() {
            return this.columnOrigins[0];
        }

        public int getY() {
            return this.rowOrigins[0];
        }
    }

    static interface Measure {
        public int sizeOf(UiComponent var1);
    }
}

