/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.ui.event;

import java.util.Iterator;
import oracle.bpm.collections.iterator.AbstractIterator;
import oracle.bpm.ui.event.UiListener;

public class EventListenerList {
    protected Object[] list = EMPTY;
    private static final Object[] EMPTY = new Object[0];

    public int size() {
        return this.list.length / 2;
    }

    public final <T> Iterable<T> getListenersByType(Class<T> type) {
        return new TypeIterator<T>(type, this.list);
    }

    public synchronized void add(Class<? extends UiListener> type, UiListener listener) {
        if (listener != null) {
            this.checkType(type, listener);
            if (this.list == EMPTY) {
                this.list = new Object[]{type, listener};
            } else {
                int i = this.list.length;
                Object[] tmp = new Object[i + 2];
                System.arraycopy(this.list, 0, tmp, 0, i);
                tmp[i] = type;
                tmp[i + 1] = listener;
                this.list = tmp;
            }
        }
    }

    public synchronized void remove(Class<? extends UiListener> type, UiListener listener) {
        int index;
        if (listener != null && (index = this.find(type, listener)) != -1) {
            int newLength = this.list.length - 2;
            if (newLength == 0) {
                this.list = EMPTY;
            } else {
                Object[] tmp = new Object[newLength];
                System.arraycopy(this.list, 0, tmp, 0, index);
                if (index < newLength) {
                    System.arraycopy(this.list, index + 2, tmp, index, newLength - index);
                }
                this.list = tmp;
            }
        }
    }

    public String toString() {
        StringBuilder result = new StringBuilder("EventListenerList: [");
        for (int i = 0; i < this.list.length; i += 2) {
            if (i != 0) {
                result.append(", ");
            }
            result.append(((Class)this.list[i]).getName());
            result.append(" : ");
            result.append(this.list[i + 1]);
        }
        result.append("]");
        return result.toString();
    }

    private int find(Class<? extends UiListener> type, UiListener listener) {
        this.checkType(type, listener);
        int index = -1;
        for (int i = this.list.length - 2; i >= 0; i -= 2) {
            if (this.list[i] != type || !this.list[i + 1].equals(listener)) continue;
            index = i;
            break;
        }
        return index;
    }

    private void checkType(Class<? extends UiListener> type, UiListener listener) {
        if (!type.isInstance(listener)) {
            throw new IllegalArgumentException("Listener " + listener + " is not of type " + type);
        }
    }

    private static class TypeIterator<T>
    extends AbstractIterator<T>
    implements Iterable<T> {
        private int i;
        private Object[] list;
        private final Class<T> type;

        public TypeIterator(Class<T> type, Object[] list) {
            this.type = type;
            this.list = list;
            this.i = list.length - 2;
        }

        @Override
        public Iterator<T> iterator() {
            this.i = this.list.length - 2;
            return this;
        }

        @Override
        protected boolean advance() {
            boolean result = false;
            while (!result && this.i >= 0) {
                boolean bl = result = this.list[this.i] == this.type;
                if (result) {
                    this.next = this.type.cast(this.list[this.i + 1]);
                }
                this.i -= 2;
            }
            return result;
        }
    }
}

